<?php if (!defined('ABSPATH')) exit; // Exit if accessed directly

if (!class_exists('IMSVGPersian')) {

    require_once ABSPATH . 'wp-admin/includes/plugin.php';

    define('IMSVG_PERSIAN_VERSION', '1.4.3');
    define('IMSVG_PERSIAN_DIR', plugin_dir_path(__FILE__) );

    include plugin_dir_path(__FILE__) . '/includes/license/zhaket-license.php';
    include plugin_dir_path(__FILE__) . '/includes/functions.php';

    class IMSVGPersian
    {
        /**
         * Main Method
         */
        public static function main()
        {
            add_action('plugins_loaded', array(__CLASS__, 'textdomain'));
            add_action('init', array(__CLASS__, 'init'));
            add_action('init', array(__CLASS__, 'add_scripts'));
            add_action('admin_init', array(__CLASS__, 'admin_init'));
            add_action('admin_init', array(__CLASS__, 'admin_scripts'));

            add_action('admin_init', function() {
                if (get_user_locale() != 'fa_IR') return;
                global $submenu;
                $menu = $submenu['plugins.php'];

                foreach ($menu as $index=>$item) {
                    if (!is_array($item)) continue;
                    if (empty($item) || !isset($item[0])) continue;
                    $check = strpos($item[0], 'Image Map Pro');
                    if ($check === false) continue;
                    $submenu['plugins.php'][$index][0] = str_replace('Image Map Pro', 'نقشه تصویر پرو', $item[0]);
                }

            }, 999);
        }

        /**
         * Init plugin
         */
        public static function init()
        {

        }

        /**
         * Admin init plugin
         */
        public static function admin_init()
        {


        }


        /**
         * Scripts and Styles
         */
        public static function add_scripts()
        {
        }

        /**
         * Admin Scripts and Styles
         */
        public static function admin_scripts()
        {
            try{
                wp_enqueue_style('IMSVG-persian-admin', IMSVG_plugin_asset_url(__FILE__, 'css/imsvg-persian-admin.css'), false, IMSVG_PERSIAN_VERSION, 'all');
            }catch (Exception $e){

            }
        }


        /**
         * Load textdomain
         *
         * @return void
         */
        public static function textdomain()
        {
            load_plugin_textdomain('image-map-pro-wordpress', false, dirname(plugin_basename(__FILE__)) . '/languages/');
        }


    }

    IMSVGPersian::main();
}