<?php
/**
 * Get plugin dir name
 */
if (!function_exists('sbita_plugin_dir_name')) {
    function sbita_plugin_dir_name($file)
    {
        try {
            $start = "~plugins/";
            $end = '/~i';
            $split = '/';

            if (strpos($file, 'plugins\\') !== false) {
                $start = "~plugins\\\\";
                $end = '\\\\~i';
                $split = '\\';
            }

            preg_match("$start([^{]*)$end", $file, $match);
            if (count($match) < 2) throw new Exception('Not found!');
            $result = $match[1];

            if (strpos($file, $split) !== false) $result = explode($split, $result);

            return $result[0];
        } catch (Exception $e) {
            // todo
            return null;
        }
    }
}

/**
 * Get plugin path
 */
if (!function_exists('sbita_plugin_path')) {

    function sbita_plugin_path($file)
    {
        try {
            $dir_name = sbita_plugin_dir_name($file);
            if (!$dir_name) return null;
            return path_join(WP_PLUGIN_DIR, $dir_name);
        } catch (Exception $e) {
            return null;
        }
    }

}

/**
 * Get plugin asset url
 */
if (!function_exists('sbita_plugin_asset_url')) {
    function sbita_plugin_asset_url($file, $filename)
    {
        try {
            $path = sbita_plugin_path($file);
            $path = path_join($path, 'main.php');
            $path = path_join(plugin_dir_url($path), 'assets');
            return path_join($path, $filename);
        } catch (Exception $e) {
            return null;
        }
    }
}


/**
 * Get plugin asset url
 */
if (!function_exists('IMSVG_plugin_asset_url')) {
    function IMSVG_plugin_asset_url($file, $filename)
    {
        try {
            $path = sbita_plugin_path($file);
            $path = path_join($path, 'main.php');
            $path = path_join(plugin_dir_url($path), 'sbita/assets');
            return path_join($path, $filename);
        } catch (Exception $e) {
            return null;
        }
    }
}


/**
 * Get Zhaket license
 */
if (!function_exists('IMSVG_persian_get_license')) {
    function IMSVG_persian_get_license()
    {
        return get_option('_IMSVG_persian_license');
    }
}

/**
 * Check Zhaket license
 */
if (!function_exists('IMSVG_persian_check_license')) {
    function IMSVG_persian_check_license()
    {
        return !empty(get_option('_IMSVG_persian_license'));
    }
}

/**
 * Update Zhaket license
 */
if (!function_exists('IMSVG_persian_update_license')) {
    function IMSVG_persian_update_license($license)
    {
        return update_option('_IMSVG_persian_license', $license);
    }
}

/**
 * Install Zhaket license
 */
if (!function_exists('IMSVG_persian_install_license')) {
    function IMSVG_persian_install_license($new_license)
    {
        try {
            $token = '04cf5b2d-cffb-44a5-a190-50bd4beca9fc';
            $result = Zhaket_License::install($new_license, $token);

            if ($result->status != 'successful') {
                IMSVG_persian_update_license(null);

                // License not installed / show message
                if (!is_object($result->message)) {// License is Invalid
                    return $result->message;
                } else {
                    foreach ($result->message as $message) {
                        foreach ($message as $msg) {
                            return $msg;
                        }
                    }
                }
            }

            IMSVG_persian_update_license($new_license);
            return 'successful';
        } catch (Exception $e) {
            return null;
        }
    }
}


/**
 * Validate Zhaket license
 */
if (!function_exists('IMSVG_persian_validate_license')) {
    function IMSVG_persian_validate_license($new_license)
    {
        try {
            $token = '04cf5b2d-cffb-44a5-a190-50bd4beca9fc';
            $result = Zhaket_License::isValid($new_license);

            if ($result->status != 'successful') {
                IMSVG_persian_update_license(null);

                // License not installed / show message
                if (!is_object($result->message)) {// License is Invalid
                    return $result->message;
                } else {
                    foreach ($result->message as $message) {
                        foreach ($message as $msg) {
                            return $msg;
                        }
                    }
                }
            }

            IMSVG_persian_update_license($new_license);
            return 'successful';
        } catch (Exception $e) {
            return null;
        }
    }
}

