<?php
/**
 * tile.php
 * Template part for the WP Post Modules Plugin
 *
 * @since 1.0.0
 * @version 2.8.1
 *
 * All variables coming from parent file wp-post-modules.php
 */

 	$out = '';
	$count = 0;
	$protocol = is_ssl() ? 'https' : 'http';
	$id = 'wppm-ajax-posts-' . $GLOBALS['wppm_ajax_container_count'];
	if ( $sc_btn ) {
		$sc = wppm_vc_get_sc( $atts );
	}

	$out = sprintf( '%s%s<ul%s%s class="wppm wppm-tile clearfix%s%s%s%s%s%s%s%s">',
		$ajaxnav || $ajaxloadmore ? sprintf( '<div id="%s" class="wppm-ajax-posts%s" data-params=\'%s\' data-maxposts="%s">', $id, ' wppm_custom_css_' . $wppm_css_count, json_encode( $atts, JSON_FORCE_OBJECT ), $custom_query->found_posts ) : '',
		( $sc_btn && is_user_logged_in() && ( current_user_can( 'edit_pages' ) || current_user_can( 'edit_posts' ) ) ) ? '<a href="#" class="wppm-get-sc" data-val="' . esc_attr( $sc ) . '">' . esc_attr__( 'Get Shortcode', 'wppm' ) . '</a>' : '',
		$enable_schema ? ' itemscope="itemscope" itemtype="' . $protocol . '://schema.org/Blog"' : '',
		$ajaxnav ? ' id="' . $id . '-sub-1"' : '',
		' ' . esc_attr( $sub_type ),
		' gutter-' . esc_attr( $gutter_tile ),
		(int)$content_padding != 20 ? ' pad-' . esc_attr( $content_padding ) : '',
		(int)$viewport_width < 840 ? ' narrow-width' : '',
		$vc_class,
		! ( $ajaxnav || $ajaxloadmore ) ? ' wppm_custom_css_' . $wppm_css_count : '',
		'inherit' != $meta_align ? ' meta-' . esc_attr( $meta_align ) : '',
		$xclass ? ' ' . esc_attr( $xclass ) : ''
	);

	// Main loop
	while ( $custom_query->have_posts() ) :
		$custom_query->the_post();
		global $multipage;
		$multipage = 0;

		// Set post title
		$title = wppm_generate_title( $hsource, $h_cust_field_key, $h_length, $h_meta_box );

		// Post classes
		$post_id = get_the_ID();
		$post_class_obj = get_post_class( $post_id );
		$post_classes = 'wppm-post ';
		if ( isset( $post_class_obj ) && is_array( $post_class_obj ) ) {
			$post_classes .= implode( ' ', $post_class_obj );
		}
		if ( is_sticky( $post_id ) ) {
			$post_classes .= ' sticky';
		}

		/**
		 * Overlay content classes
		 * Overlay position, gradient type etc.
		 */
		$post_classes .= $content_pos != '' ? ' content-' . esc_attr( $content_pos ) : '';
		$post_classes .= $overlay_style != '' ? ' overlay-' . esc_attr( $overlay_style ) : '';
		$post_classes .= $show_overlay != '' ? ' show-' . esc_attr( $show_overlay ) : '';
		$post_classes .= $image_effect != '' || $image_effect != 'none' ? ' img-' . esc_attr( $image_effect ) : '';

		// Get excerpt based on chosen source
		$excerpt_text = wppm_generate_excerpt( $psource, $allowed_tags, $content_filter, $cust_field_key, $excerpt_length, $meta_box );

		$excerpt = ( $hide_excerpt == 'true' ) ? ''
					: sprintf( '<%1$s%2$s class="post-text%3$s">%4$s</%1$s>',
						$ptag,
						$enable_schema && $excerpt_prop != '' ? ' itemprop="' . esc_attr( $excerpt_prop ) . '"' : '',
						$psize ? ' fs-' . esc_attr( $psize ) : '',
						$excerpt_text
					);

		$sub = (int)$count > 0 ? '_sub' : '';

		// User defined post meta
		$user_meta = '';
		$rows = array( 'row_1' => '', 'row_2' => '', 'row_3' => '', 'row_4' => '' );
		$metas = wppm_custom_meta();
		if ( $custom_meta ) {
			$user_meta = sprintf( '<span class="entry-meta custom-format">' . rawurldecode( base64_decode( strip_tags( $meta_format ) ) ) . '</span>', $metas['author'], $metas['date'], $metas['date_modified'], $metas['categories'], $metas['comments'], $metas['permalink'] );
		}

		else { // Generate post meta
			$meta_args = array(
				'template'	=> 'grid',
				'date_format' => $date_format,
				'enable_schema' => $enable_schema,
				'hide_cats' => $hide_cats,
				'hide_reviews' => $hide_reviews,
				'hide_date' => $hide_date,
				'hide_author' => $hide_author,
				'show_avatar' => $show_avatar,
				'hide_views' => $hide_views,
				'hide_comments' => $hide_comments,
				'ext_link'	=> $ext_link,
				'readmore' => $readmore,
				'readmore_text' => $readmore_text,
				'readmore_link_src' 	=> $readmore_link_src,
				'readmore_cust_link' 	=> $readmore_cust_link,
				'readmore_target_blank' => $readmore_target_blank,
				'publisher_logo' => $publisher_logo,
				'excerpt_length' => $excerpt_length,
				'sharing' => $sharing,
				'share_style' => $share_style,
				'share_btns' => $share_btns,

				// Schema props
				'datecreated_prop'		=> $datecreated_prop,
				'datemodified_prop'		=> $datemodified_prop,
				'publisher_type'		=> $publisher_type,
				'publisher_prop'		=> $publisher_prop,
				'publisher_name'		=> $publisher_name,
				'publisher_logo'		=> $publisher_logo,
				'authorbox_type'		=> $authorbox_type,
				'authorbox_prop'		=> $authorbox_prop,
				'authorname_prop'		=> $authorname_prop,
				'authoravatar_prop'		=> $authoravatar_prop,
				'category_prop'			=> $category_prop,
				'commentcount_prop'		=> $commentcount_prop,
				'commenturl_prop'		=> $commenturl_prop
			);

			$rows = wppm_meta( $meta_args );
		}

		// Thumbnail images
		$thumbnail_big = '';
		$thumbnail_medium = '';
		$thumbnail_small = '';
		if ( has_post_thumbnail() ) {

			$src = wp_get_attachment_url( get_post_thumbnail_id() );

			// Get dominant color from image
			if ( 'autobg' == $overlay_style ) {
				$pallet = wppm_get_color_pallet( $src, array( 8, 4 ) );
				$dc = wppm_get_dominant_color( $pallet );
			}

			$thumbnail_big = $src;
			$thumbnail_small = $src;
			$aspect_ratio = floatval( $aspect_ratio );
			$gutter_tile = isset( $gutter_tile_c ) ? (int)$gutter_tile_c : $gutter_tile;

			if ( function_exists( 'bfi_thumb' ) ) {
				if ( 's2' == $sub_type || 's3' == $sub_type ) {
					if ( (int)$viewport_width < 840	) {
						$imgwidth_big = (int)$viewport_width;
						$imgheight_big = (int)( $imgwidth_big / $aspect_ratio );
						$imgheight_big = ( $imgheight_big % 2 == 0 ) ? $imgheight_big : $imgheight_big - 1;
					}
					else {
						$imgwidth_big = (int)( ( (int)$viewport_width - (int)$gutter_tile ) / 2 );
						$imgheight_big = (int)( $imgwidth_big * $aspect_ratio );
						if ( 's3' == $sub_type ) {
							$imgheight_big = (int)( $imgwidth_big / $aspect_ratio );
						}

						// Round off to even value if the height is odd
						// Needed for preventing pixel fraction value like .5px
						$imgheight_big = ( $imgheight_big % 2 == 0 ) ? $imgheight_big : $imgheight_big - 1;
					}

					$imgwidth_small = (int)( ( (int)$imgwidth_big - (int)$gutter_tile ) / 2 );
					$imgheight_small = (int)( ( $imgheight_big - 2 * (int)$gutter_tile ) / 3 );

					if ( 's3' == $sub_type ) {
						$imgwidth_small = (int)$imgwidth_big;
						$imgheight_small = (int)( ( $imgheight_big - (int)$gutter_tile ) / 2 );
					}
				}

				else {
					if ( (int)$viewport_width < 840	) {
						$imgwidth_big = (int)$viewport_width;
						$imgheight_big = (int)( $imgwidth_big / $aspect_ratio );
						$imgheight_big = ( $imgheight_big % 2 == 0 ) ? $imgheight_big : $imgheight_big - 1;
					}
					else {
						$imgwidth_big = (int)( ( (int)$viewport_width - (int)$gutter_tile ) / 2 );
						$imgheight_big = (int)( $imgwidth_big / $aspect_ratio );

						// Round off to even value if the height is odd
						// Needed for preventing pixel fraction value like .5px
						$imgheight_big = ( $imgheight_big % 2 == 0 ) ? $imgheight_big : $imgheight_big - 1;
					}

					$imgwidth_small = (int)( ( (int)$imgwidth_big - (int)$gutter_tile ) / 2 );
					$imgheight_small = (int)( ( $imgheight_big - (int)$gutter_tile ) / 2 );
				}

				$thumbnail_big = wppm_image_resize( $src, $imgwidth_big, $imgheight_big, true, $imgquality, $imgcolor, $imggrayscale );
				$thumbnail_small = wppm_image_resize( $src, $imgwidth_small, $imgheight_small, true, $imgquality, $imgcolor, $imggrayscale );
				$thumbnail_medium = wppm_image_resize( $src, $imgwidth_big, $imgheight_small, true, $imgquality, $imgcolor, $imggrayscale );


			} // function_exists bfi_thumb

		} // has post thumbnail

		$format_icon = '';

		if ( ( 'video' == get_post_format() || 'gallery' == get_post_format() ) && ! $hide_post_format_icon ) {
			$format_icon = '<div class="' . get_post_format() . '-overlay"></div>';
		}

		$thumblink_big = sprintf( apply_filters( 'wppm_tile_thumbnail_big','<div%6$s class="post-img"><a href="%1$s" title="%2$s"><img%7$s class="wppm-img%9$s" src="%3$s" alt="%2$s" title="%2$s"/>%4$s</a>%8$s</div>' ),
				esc_url( get_permalink() ),
				wp_strip_all_tags( $title ),
				$thumbnail_big,
				$format_icon,
				$featured_label ? '<span class="featured-title">' . esc_attr( $featured_label ) . '</span>' : '',
				$enable_schema ? ' itemprop="image" itemscope itemtype="' . $protocol . '://schema.org/ImageObject"' : '',
				$enable_schema ? ' itemprop="url"' : '',
				$enable_schema ? '<meta itemprop="width" content="' . $imgwidth . '"><meta itemprop="height" content="' . $imgheight . '">' : '',
				$img_xclass ? ' ' . esc_attr( $img_xclass ) : ''

		);

		$thumblink_small = sprintf( apply_filters( 'wppm_tile_thumbnail_small', '<div%5$s class="post-img"><a href="%1$s" title="%2$s"><img%6$s class="wppm-img%8$s" src="%3$s" alt="%2$s" title="%2$s"/>%4$s</a>%7$s</div>' ),
				esc_url( get_permalink() ),
				wp_strip_all_tags( $title ),
				$thumbnail_small,
				$format_icon,
				$enable_schema ? ' itemprop="image" itemscope itemtype="' . $protocol . '://schema.org/ImageObject"' : '',
				$enable_schema ? ' itemprop="url"' : '',
				$enable_schema ? '<meta itemprop="width" content="' . $imgwidth . '"><meta itemprop="height" content="' . $imgheight . '">' : '',
				$img_xclass ? ' ' . esc_attr( $img_xclass ) : ''
		);

		$thumblink_medium = sprintf( apply_filters( 'wppm_tile_thumbnail_medium', '<div%5$s class="post-img"><a href="%1$s" title="%2$s"><img%6$s class="wppm-img%8$s" src="%3$s" alt="%2$s" title="%2$s"/>%4$s</a>%7$s</div>' ),
				esc_url( get_permalink() ),
				wp_strip_all_tags( $title ),
				$thumbnail_medium,
				$format_icon,
				$enable_schema ? ' itemprop="image" itemscope itemtype="' . $protocol . '://schema.org/ImageObject"' : '',
				$enable_schema ? ' itemprop="url"' : '',
				$enable_schema ? '<meta itemprop="width" content="' . $imgwidth . '"><meta itemprop="height" content="' . $imgheight . '">' : '',
				$img_xclass ? ' ' . esc_attr( $img_xclass ) : ''
		);

		if ( $use_native_thumbs ) {
			$thumblink_big = $thumblink_medium = $thumblink_small = sprintf( apply_filters( 'wppm_tile_thumbnail_native', '<div%5$s class="post-img%7$s"><a href="%1$s" title="%2$s">%3$s%4$s</a>%6$s</div>' ),
				esc_url( get_permalink() ),
				wp_strip_all_tags( $title ),
				$enable_schema ? get_the_post_thumbnail( get_the_id(), $imgsize, array( 'itemprop' => 'url', 'class' => $img_xclass ? 'wppm-img ' . $img_xclass : 'wppm-img' ) ) : get_the_post_thumbnail( get_the_id(), $imgsize, array( 'class' => $img_xclass ? 'wppm-img ' . $img_xclass : 'wppm-img' ) ),
				$format_icon,
				$enable_schema ? ' itemprop="image" itemscope itemtype="' . $protocol . '://schema.org/ImageObject"' : '',
				$enable_captions && get_the_post_thumbnail_caption() ? '<p class="wp-caption-text">' . get_the_post_thumbnail_caption() . '</p>' : '',
				$enable_captions && get_the_post_thumbnail_caption() ? ' has-caption' : ''
			);
		}

		// Start list output
		if ( $sub_type == 's4' && has_post_thumbnail() ) {
			if ( $count == 0 ) {
				$format = apply_filters( 'wppm_tile_first_item_output', '<li%10$s%11$s class="tile-2x2%1$s"><div class="tile-wrap">%17$s%2$s<div class="tile-content%14$s"%15$s><div class="tile-overlay">%3$s<%9$s%12$s class="entry-title%13$s"><a href="%4$s" title="%5$s">%16$s</a></%9$s>%6$s%7$s%8$s</div></div></div></li>' );
				$out .= sprintf ( $format,
					' ' . $post_classes,
					$thumblink_big,
					( $custom_meta && $meta_pos == '1' ) ? $user_meta : $rows['row_1'],
					esc_url( get_permalink() ),
					wp_strip_all_tags( $title ),
					( $custom_meta && $meta_pos == '2' ) ? $user_meta : ( $readmore ? $rows['row_2'] : '' ),
					$excerpt,
					( $custom_meta && $meta_pos == '3' ) ? $user_meta : $rows['row_3'],
					sanitize_text_field( $htag ),
					$enable_schema && $container_type != '' ? ' itemscope itemtype="' . $protocol . '://schema.org/' . esc_attr( $container_type ) . '"' : '',
					$enable_schema && $container_prop != '' ? ' itemprop="' . esc_attr( $container_prop ) . '"' : '',
					$enable_schema && $heading_prop != '' ? ' itemprop="' . esc_attr( $heading_prop ) . '"' : '',
					$tile_hsize ? ' fs-' . esc_attr( $tile_hsize ) : '',
					( 'autobg' == $overlay_style && 'true' == $dc['dark_text'] ) ? ' text-dark' : '',
					( 'autobg' == $overlay_style ) ? ' style="background-color: rgba(' . $dc['rgb'] . ',.9);"' : '',
					$title,
					$clickable_tile ? sprintf( '<a href="%1$s" class="overlay-link" title="%2$s"><span class="screen-reader-text">%2$s</span></a>', esc_url( get_permalink() ), wp_strip_all_tags( $title ) ) : ''
				);
			}
			else {
				$format = apply_filters( 'wppm_tile_small_items_output', '<li%8$s%9$s class="%1$s%7$s"><div class="tile-wrap">%17$s%2$s<div class="tile-content%14$s"%15$s><div class="tile-overlay">%12$s<%6$s%10$s class="entry-title%11$s"><a href="%3$s" title="%4$s">%16$s</a></%6$s>%13$s%5$s</div></div></div></li>' );
				$out .= sprintf ( $format,
					$post_classes,
					$count == 1 ? $thumblink_medium : $thumblink_small,
					esc_url( get_permalink() ),
					wp_strip_all_tags( $title ),
					( $custom_meta && $meta_pos == '3' ) ? $user_meta : $rows['row_3'],
					sanitize_text_field( $htag ),
					$count == 1 ? ' tile-2x1' : ' tile-1x1',
					$enable_schema && $container_type != '' ? ' itemscope itemtype="' . $protocol . '://schema.org/' . esc_attr( $container_type ) . '"' : '',
					$enable_schema && $container_prop != '' ? ' itemprop="' . esc_attr( $container_prop ) . '"' : '',
					$enable_schema && $heading_prop != '' ? ' itemprop="' . esc_attr( $heading_prop ) . '"' : '',
					$hsize ? ' fs-' . esc_attr( $hsize ) : '',
					( $custom_meta && $meta_pos == '1' ) ? $user_meta : $rows['row_1'],
					( $custom_meta && $meta_pos == '2' ) ? $user_meta : ( $readmore ? $rows['row_2'] : '' ),
					( 'autobg' == $overlay_style && 'true' == $dc['dark_text'] ) ? ' text-dark' : '',
					( 'autobg' == $overlay_style ) ? ' style="background-color: rgba(' . $dc['rgb'] . ',.9);"' : '',
					$title,
					$clickable_tile ? sprintf( '<a href="%1$s" class="overlay-link" title="%2$s"><span class="screen-reader-text">%2$s</span></a>', esc_url( get_permalink() ), wp_strip_all_tags( $title ) ) : ''
				);
			}
			$count++;
		}
		else if ( has_post_thumbnail() ) {
			$tile_link = $clickable_tile ? '<a href="%4$s" class="overlay-link" title="%5$s"><span class="screen-reader-text">%5$s</span></a>' : '';
			if ( $count == 0 ) {
				$format = apply_filters( 'wppm_tile_first_item_output', '<li%10$s%11$s class="tile-2x2%1$s"><div class="tile-wrap">%18$s%2$s<div class="tile-content%15$s"%16$s><div class="tile-overlay">%3$s<%9$s%12$s class="entry-title%13$s%14$s"><a href="%4$s" title="%5$s">%17$s</a></%9$s>%6$s%7$s%8$s</div></div></div></li>' );
				$out .= sprintf ( $format,
					' ' . $post_classes,
					$thumblink_big,
					( $custom_meta && $meta_pos == '1' ) ? $user_meta : $rows['row_1'],
					esc_url( get_permalink() ),
					wp_strip_all_tags( $title ),
					( $custom_meta && $meta_pos == '2' ) ? $user_meta : ( $readmore ? $rows['row_2'] : '' ),
					$excerpt,
					( $custom_meta && $meta_pos == '3' ) ? $user_meta : $rows['row_3'],
					sanitize_text_field( $htag ),
					$enable_schema && $container_type != '' ? ' itemscope itemtype="' . $protocol . '://schema.org/' . esc_attr( $container_type ) . '"' : '',
					$enable_schema && $container_prop != '' ? ' itemprop="' . esc_attr( $container_prop ) . '"' : '',
					$enable_schema && $heading_prop != '' ? ' itemprop="' . esc_attr( $heading_prop ) . '"' : '',
					$tile_hsize ? ' fs-' . esc_attr( $tile_hsize ) : '',
					$hfontweight ? ' fw-' . esc_attr( $hfontweight ) : '',
					( 'autobg' == $overlay_style && 'true' == $dc['dark_text'] ) ? ' text-dark' : '',
					( 'autobg' == $overlay_style ) ? ' style="background-color: rgba(' . $dc['rgb'] . ',.9);"' : '',
					$title,
					$clickable_tile ? sprintf( '<a href="%1$s" class="overlay-link" title="%2$s"><span class="screen-reader-text">%2$s</span></a>', esc_url( get_permalink() ), wp_strip_all_tags( $title ) ) : ''
				);
			}
			else {
				$format = apply_filters( 'wppm_tile_small_items_output', '<li%8$s%9$s class="%1$s%7$s"><div class="tile-wrap">%18$s%2$s<div class="tile-content%15$s"%16$s><div class="tile-overlay">%13$s<%6$s%10$s class="entry-title%11$s%12$s"><a href="%3$s" title="%4$s">%17$s</a></%6$s>%14$s%5$s</div></div></div></li>' );
				$out .= sprintf ( $format,
					$post_classes,
					$thumblink_small,
					esc_url( get_permalink() ),
					wp_strip_all_tags( $title ),
					( $custom_meta && $meta_pos == '3' ) ? $user_meta : $rows['row_3'],
					sanitize_text_field( $htag ),
					's3' == $sub_type ? ' tile-2x1' : ' tile-1x1',
					$enable_schema && $container_type != '' ? ' itemscope itemtype="' . $protocol . '://schema.org/' . esc_attr( $container_type ) . '"' : '',
					$enable_schema && $container_prop != '' ? ' itemprop="' . esc_attr( $container_prop ) . '"' : '',
					$enable_schema && $heading_prop != '' ? ' itemprop="' . esc_attr( $heading_prop ) . '"' : '',
					$hsize ? ' fs-' . esc_attr( $hsize ) : '',
					$hfontweight ? ' fw-' . esc_attr( $hfontweight ) : '',
					( $custom_meta && $meta_pos == '1' ) ? $user_meta : $rows['row_1'],
					( $custom_meta && $meta_pos == '2' ) ? $user_meta : ( $readmore ? $rows['row_2'] : '' ),
					( 'autobg' == $overlay_style && 'true' == $dc['dark_text'] ) ? ' text-dark' : '',
					( 'autobg' == $overlay_style ) ? ' style="background-color: rgba(' . $dc['rgb'] . ',.9);"' : '',
					$title,
					$clickable_tile ? sprintf( '<a href="%1$s" class="overlay-link" title="%2$s"><span class="screen-reader-text">%2$s</span></a>', esc_url( get_permalink() ), wp_strip_all_tags( $title ) ) : ''
				);
			}
			$count++;
		}

	endwhile;

	if ( $ajaxnav ) {
		$out .= sprintf( '</ul><div class="wppm-loading-spinner"></div><div class="wppm-ajax-nav"><a class="prev-link disabled" href="#">%s</a> <a class="next-link" href="#">%s</a>%s</div></div>',
			__( 'Prev', 'wppm' ),
			__( 'Next', 'wppm' ),
			$nav_status ? '<span class="nav-status" data-format="' . esc_attr( $nav_status_text ) . '"></span>' : ''
		);
	}
	elseif ( $ajaxloadmore ) {
		$out .= sprintf( '</ul><div class="wppm-ajax-loadmore"><div class="wppm-loading-spinner"></div><a class="wppm-more-link" href="#">%s</a></div></div>',
			esc_attr( $loadmore_text )
		);
	}
	else {
		$out .= '</ul>';
	}

	echo $out;