<?php
/**
 * ticker.php
 * Template part for the WP Post Modules Plugin
 *
 * @since 1.0.0
 * @version 2.8.1
 *
 * All variables coming from parent file wp-post-modules.php
 */

	if ( $sc_btn ) {
		$sc = wppm_vc_get_sc( $atts );
	}

	$out = sprintf( '<div class="wppm-ticker-container%s%s%s">%s<div class="wppm-ticker" data-duration="%s"%s>%s',
		$vc_class,
		' wppm_custom_css_' . $wppm_css_count,
		$xclass ? ' ' . esc_attr( $xclass ) : '',
		$ticker_label ? sprintf( '<div class="ticker-label">%s</div>',
				esc_attr( $ticker_label )
			) : '',
		(int)$duration,
		is_rtl() ? ' data-direction="right" dir="ltr"' : '',
		( $sc_btn && is_user_logged_in() && ( current_user_can( 'edit_pages' ) || current_user_can( 'edit_posts' ) ) ) ? '<a href="#" class="wppm-get-sc" data-val="' . esc_attr( $sc ) . '">' . esc_attr__( 'Get Shortcode', 'wppm' ) . '</a>' : ''
	);

	while ( $custom_query->have_posts() ) :
		$custom_query->the_post();
		global $multipage;
		$multipage = 0;

		$permalink = get_permalink();

		// Set post title
		$title = wppm_generate_title( $hsource, $h_cust_field_key, $h_length, $h_meta_box );

		$post_id = get_the_ID();

		$post_class_obj = get_post_class( $post_id );
		$post_classes = 'wppm-post ';

		if ( isset( $post_class_obj ) && is_array( $post_class_obj ) ) {
			foreach( $post_class_obj as $post_class ) {
				$post_classes .= ' ' . $post_class;
			}
		}
		if ( is_sticky( $post_id ) ) {
			$post_classes .= ' sticky';
		}

		$format = apply_filters( 'wppm_ticker_list_output', '<span><a href="%1$s" title="%2$s">%2$s</a></span>' );
		$out .= sprintf ( $format, $permalink, $title );

	endwhile;
	$out .= '</div></div>';
	echo $out;