<?php
/**
 * Plugin Name: WP Post Modules
 * Author:      SaurabhSharma
 * Author URI: 	http://codecanyon.net/user/saurabhsharma
 * Version:     2.8.1
 * Text Domain: wppm
 * Domain Path: /languages/
 * Description: Create WordPress post modules and snippets in different styles
 */

// Exit if accessed directly
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

define( 'WPPM_DIR', plugin_dir_path( __FILE__ ) );

if ( ! class_exists( 'WP_Post_Modules' ) ) {

	class WP_Post_Modules {

		public $vct_prefix = 'wppm';

		function __construct() {

			// Include required files
			add_action( 'plugins_loaded', array( &$this, 'wppm_includes' ) );
			add_action( 'admin_enqueue_scripts', array( &$this, 'wppm_admin_scripts' ) );

			// Load translation, scripts and shortcodes
			add_action( 'init', array( &$this, 'wppm_init' ) );

			// Ajax actions for tabs
			add_action( 'wp_ajax_wppm_tabs_action', array( &$this,'wppm_tabs_action_callback' ) );
			add_action( 'wp_ajax_nopriv_wppm_tabs_action', array( &$this,'wppm_tabs_action_callback' ) );

			// Ajax actions for nav links
			add_action( 'wp_ajax_wppm_ajaxnav_action', array( &$this,'wppm_ajaxnav_action_callback' ) );
			add_action( 'wp_ajax_nopriv_wppm_ajaxnav_action', array( &$this,'wppm_ajaxnav_action_callback' ) );

			// Add to VC
			add_action( 'vc_before_init', array( &$this, 'wppm_map_shortcode_to_vc' ) );
			add_action( 'after_setup_theme', array( &$this, 'wppm_vctm_add_templates' ) );

			// Prompt to install VC
			add_action( 'admin_notices',  array( &$this, 'wppm_install_vc_notice' ) );

			// Custom CSS in head
			add_action( 'wp_head',  array( &$this, 'wppm_add_css_to_front' ) );

		} // construct

		function wppm_add_css_to_front() {
			global $post;
			$sc_atts = $title_atts = array();
			$css = '';
			$export = array (
				'wppm_css_count' => 1,
				'global_font' => '',
				'heading_font' => '',
				'hsize_c' => '',
				'halign' => '',
				'psize_c' => '',
				'palign' => '',
				'line_height_c' => '',
				'pline_height_c' => '',
				'cat_bg' => '',
				'cat_color' => '',
				'cat_bg_hover' => '',
				'cat_color_hover' => '',
				'heading_color' => '',
				'heading_color_hover' => '',
				'text_color' => '',
				'ticker_clr' => '',
				'ticker_bg' => '',
				'mq_list' => '',
				'gutter_grid_c' => '',
				'gutter_list_c' => '',
				'gutter_tile_c' => ''
			);
			$export2 = array (
				'wppm_title_count' => 1,
				'font_family' => '',
				'title_weight' => '',
				'title_color' => '',
				'hsize_c'	=> '',
				'hlineheight'	=> '',
				'stsize'	=> '',
				'stlineheight'	=> '',
				'stweight'	=> '',
				'stcolor'	=> ''
			);

			if ( isset( $post->post_content ) ) {
				preg_match_all('/\[wppm (.*?)\]/s', $post->post_content, $matches );
				preg_match_all('/\[wppm_title (.*?)\]/s', $post->post_content, $title_matches );
			}

			// CSS for [wppm] shortcode
			if ( isset( $matches ) && is_array( $matches ) && is_array( $matches[1] ) ) {
				$i = 1;
				foreach( $matches[1] as $match ) {
					$sc_atts = shortcode_parse_atts( $match );
					foreach( $export as $k => $v ) {
						$export[ $k ] = array_key_exists( $k, $sc_atts ) ? $sc_atts[ $k ] : '';
					}
					$export['wppm_css_count'] = $i;
					$css .= $this->wppm_make_css( $export, 'wppm_main' );
					$i++;
				}
			}

			// CSS for [wppm_title] shortcode
			if ( isset( $title_matches ) && is_array( $title_matches ) && is_array( $title_matches[1] ) ) {
				$j = 1;
				foreach( $title_matches[1] as $match ) {
					$title_atts = shortcode_parse_atts( $match );
					foreach( $export2 as $k => $v ) {
						$export2[ $k ] = array_key_exists( $k, $title_atts ) ? $title_atts[ $k ] : '';
					}
					$export2['wppm_title_count'] = $j;
					$css .= $this->wppm_make_css( $export2, 'wppm_title' );
					$j++;
				}
			}
			echo '<style type="text/css" id="wppm_custom_css">' . strip_tags( $css ) . '</style>';
		}

		function wppm_make_css( $vars = array(), $type = 'wppm_main' ) {
			extract( $vars );
			$css = '';

			if ( 'wppm_title' == $type ) {
				// wppm_title font family
				$title_css = '';
				$st_css = '';
				if ( '' != $font_family ) {
					wppm_enqueue_fonts( $font_family);
					$title_css .= wppm_create_font_style( $font_family );
				}

				// font size
				if ( '' != $hsize_c ) {
					$title_css .= 'font-size: ' . $hsize_c . ';';
				}

				// line height
				if ( '' != $hlineheight ) {
					$title_css .= 'line-height: ' . $hlineheight . ';';
				}

				// font weight
				if ( '' != $title_weight ) {
					$title_css .= 'font-weight: ' . $title_weight . ';';
				}

				// Color
				if ( '' != $title_color ) {
					$title_css .= 'color: ' . $title_color . ' !important;';
				}

				// Secondary text font size
				if ( '' != $stsize ) {
					$st_css .= 'font-size: ' . $stsize . ';';
				}

				// Secondary text line height
				if ( '' != $stlineheight ) {
					$st_css .= 'line-height: ' . $stlineheight . ';';
				}

				// Secondary text font weight
				if ( '' != $stweight ) {
					$st_css .= 'font-weight: ' . $stweight . ';';
				}

				// Secondary text Color
				if ( '' != $stcolor ) {
					$st_css .= 'color: ' . $stcolor . ' !important;';
				}

				// Title CSS
				$css .= '.wppm_custom_css_' . $wppm_title_count . '.wppm-title {' . $title_css . '}';

				// Secondary Text CSS
				$css .= '.wppm_custom_css_' . $wppm_title_count . '.wppm-title .sub-text {' . $st_css . '}';

			}

			if ( 'wppm_main' == $type ) {

				// Font CSS
				if ( '' != $global_font ) {
					wppm_enqueue_fonts( $global_font);
					$global_style = wppm_create_font_style( $global_font );
					$css .= '.wppm_custom_css_' . $wppm_css_count . '{' . $global_style . '}';
				}

				if ( '' != $heading_font || '' != $hsize_c || '' != $line_height_c || '' != $halign ) {
					$heading_style = '';
					if ( '' != $heading_font ) {
						wppm_enqueue_fonts( $heading_font );
						$heading_style = wppm_create_font_style( $heading_font );
					}

					$css .= sprintf( '.wppm_custom_css_%d .entry-title{%s%s%s%s}',
						$wppm_css_count,
						$heading_style ? $heading_style : '',
						$hsize_c ? 'font-size:' . esc_attr( $hsize_c ) . '!important;' : '',
						$line_height_c ? 'line-height:' . esc_attr( $line_height_c ) . '!important;' : '',
						$halign ? 'text-align:' . esc_attr( $halign ) : ''
					);
				}

				// Heading links CSS
				if ( '' != $heading_color ) {
					$css .= '.wppm_custom_css_' . $wppm_css_count . ' .entry-title a{color: ' . $heading_color . ' !important;}';
				}

				if ( '' != $heading_color_hover ) {
					$css .= '.wppm_custom_css_' . $wppm_css_count . ' .entry-title a:hover{color: ' . $heading_color_hover . ' !important;}';
				}

				if ( '' != $text_color || '' != $psize_c || '' != $palign ) {
					$css .= sprintf( '.wppm_custom_css_%d .post-text{%s%s%s%s}',
						$wppm_css_count,
						'' != $text_color ? 'color:' . $text_color . ' !important;' : '',
						$psize_c ? 'font-size:' . esc_attr( $psize_c ) . '!important;' : '',
						$pline_height_c ? 'line-height:' . esc_attr( $pline_height_c ) . '!important;' : '',
						$palign ? 'text-align:' . esc_attr( $palign ) : ''
					);
				}

				// Category links CSS
				if ( '' != $cat_bg || '' != $cat_color ) {
					$css .= '.wppm_custom_css_' . $wppm_css_count . ' .post-cats > li > a, .wppm_custom_css_' . $wppm_css_count . ' .tile-content .post-cats > li > a{opacity:1;';
					$css .= ( '' != $cat_bg ) ? 'background-color: ' . $cat_bg . ' !important;' : '';
					$css .= ( '' != $cat_color ) ? 'color: ' . $cat_color . ' !important;' : '';
					$css .= '}';
				}

				// Category links hover CSS
				if ( '' != $cat_bg_hover || '' != $cat_color_hover ) {
					$css .= '.wppm_custom_css_' . $wppm_css_count . ' .post-cats > li > a:hover,.wppm_custom_css_' . $wppm_css_count . ' .tile-content .post-cats > li > a:hover,.wppm_custom_css_' . $wppm_css_count . ' .post-cats > li > a.wppm-cat-toggle.active-link, .wppm_custom_css_' . $wppm_css_count . ' .tile-content .post-cats > li > a.wppm-cat-toggle.active-link{background-image: none;';
					$css .= ( '' != $cat_bg_hover ) ? 'background-color: ' . $cat_bg_hover . ' !important;' : '';
					$css .= ( '' != $cat_color_hover ) ? 'color: ' . $cat_color_hover . ' !important;' : '';
					$css .= '}';
				}

				// News Ticker CSS
				if ( '' != $ticker_clr || '' != $ticker_bg ) {
					$css .= '.wppm_custom_css_' . $wppm_css_count . ' .ticker-label {background:' . $ticker_bg . ' !important;color:' . $ticker_clr . ' !important;}';
				}

				// Gutter Grid CSS
				if ( '' != $gutter_grid_c ) {
					$css .= sprintf( '.wppm_custom_css_%d {margin: 0 -%dpx !important;}',
						$wppm_css_count,
						intval( round( (int)$gutter_grid_c/2 ) )
					);

					$css .= sprintf( '.wppm_custom_css_%d .wppm-post{margin-bottom: %dpx !important;padding: 0 %dpx !important;}',
						$wppm_css_count,
						(int)$gutter_grid_c,
						intval( round( (int)$gutter_grid_c/2 ) )
					);
				}

				// Gutter List CSS
				if ( '' != $gutter_list_c ) {
					$css .= sprintf( '.wppm_custom_css_%d .wppm-post{margin-bottom: %dpx !important;}',
						$wppm_css_count,
						(int)$gutter_list_c
					);

					if ( is_rtl() ) {
						$css .= sprintf( '.wppm_custom_css_%d .post-img-wrap{padding: 0 0 %dpx %dpx !important;}',
							$wppm_css_count,
							(int)$gutter_list_c,
							intval( round( (int)$gutter_list_c/2 ) )
						);

					} else {
						$css .= sprintf( '.wppm_custom_css_%1$d .post-img-wrap{padding: 0 %2$dpx %2$dpx 0 !important;}',
							$wppm_css_count,
							(int)$gutter_list_c
						);
					}
				}

				// Gutter Tile CSS
				if ( '' != $gutter_tile_c ) {
					$css .= sprintf( '.wppm_custom_css_%d {margin: -%dpx !important;}',
						$wppm_css_count,
						(int)$gutter_tile_c
					);

					$css .= sprintf( '.wppm_custom_css_%d .wppm-post{margin: 0 0 %dpx !important;padding: 0 %dpx !important;}',
						$wppm_css_count,
						(int)$gutter_tile_c,
						intval( round( (int)$gutter_tile_c/2 ) )
					);
				}

				// Media query CSS
				if ( '' != $mq_list ) {
					$mq = vc_param_group_parse_atts( $mq_list );

					if ( isset( $mq ) && is_array( $mq ) ) {
						foreach ( $mq as $q ) {
							if ( isset( $q['width'] ) && '' !== $q['width'] ) {
								$css .= sprintf( '@media only screen and (max-width:%spx){.wppm_custom_css_%d .post-img-wrap {%s%s%s%s%s}.wppm_custom_css_%d .post-content {%s}}',
									(int)$q['width'],
									(int)$wppm_css_count,
									( isset( $q['img_ratio'] ) && '' != $q['img_ratio'] && '0' != $q['img_ratio'] ) ? 'width:' . esc_attr( (int)$q['img_ratio'] ) . '%!important;' : '',
									( isset( $q['min_img_width'] ) && '0' != $q['min_img_width'] && '' != $q['min_img_width'] ) ? 'min-width:' . esc_attr( (int)$q['min_img_width'] ) . 'px!important;' : '',
									isset( $q['img_ratio'] ) && '100' != $q['img_ratio'] && '0' != $q['img_ratio'] ? 'display:table-cell!important;' : '',
									isset( $q['img_ratio'] ) && '100' == $q['img_ratio'] ? 'display:block!important;' : '',
									isset( $q['img_ratio'] ) && '0' == $q['img_ratio'] ? 'display:none!important;' : '',
									(int)$wppm_css_count,
									isset( $q['img_ratio'] ) && ( '0' == $q['img_ratio'] || '100' == $q['img_ratio'] ) ? 'display:block!important; width:100%!important;' : ''
								);
							}
						}
					}
				}
			}

			return $css;
		}

		// Enqueue admin scripts and styles
		function wppm_admin_scripts() {
			wp_enqueue_style( 'wppm-admin-css', plugin_dir_url( __FILE__ ) . 'assets/css/wppm.admin.css' );
		}

		// Show notice if Visual Composer not installed
		function wppm_install_vc_notice() {
			if ( ! class_exists( 'Vc_Manager' ) ) {
				printf( '<div class="error"><p>%s</p></div>', esc_attr__( 'WP Post Modules plugin requires Visual Composer plugin to work correctly. Kindly install and activate WPBakery Visual Composer plugin.', 'wppm' ) );
			}
			else {
				return;
			}
		}

		function wppm_vctm_add_templates() {
		    global $vct_prefix;

		    /** Optionally remove the default templates **/
		    add_filter( 'vc_load_default_templates', function( $templates ) use ( $vct_prefix ) {
		        if ( apply_filters( "{$vct_prefix}_disable_builtin_templates", false ) ) {
		            return array();
				}
		        else {
		            return $templates;
				}
		    }, 11 );

		    /** Add our templates **/
		    add_filter( 'vc_load_default_templates', function( $templates ) use ( $vct_prefix ) {

		        //Load templates from plugin /vc_templates directory
		        $templates = array_merge( $templates, WP_Post_Modules::wppm_vctm_load_templates( __DIR__ . "/vc_templates/*.php", 'vctm' ) );

		        //Load templates from theme
		        $templates = array_merge( $templates, WP_Post_Modules::wppm_vctm_load_templates( trailingslashit( get_stylesheet_directory() ) . 'vc_templates/*.php', 'theme' ) );

		        //Load additional templates from plugins or themes
		        foreach( apply_filters( "{$vct_prefix}_template_locations", array() ) as $additional_location ) {
		            $templates = array_merge($templates, WP_Post_Modules::wppm_vctm_load_templates( trailingslashit( $additional_location ) . '*.php', 'plugin' ) );
				}

		        return $templates;

		    }, 12 );
		}

		function wppm_vctm_load_templates( $folder = 'default_templates', $hook_prefix = 'vctm' ) {
		    global $vct_prefix;

		    $templates = array();

		    //Load default tempaltes
			if ( is_array( glob( $folder ) ) ) {
				foreach( glob( $folder ) as $filename ) {
					$filename_clean = basename( $filename, '.php' );

					$data = array();
					$data['name']       = __( apply_filters( "{$vct_prefix}_{$hook_prefix}_name_{$filename_clean}", WP_Post_Modules::vctm_prettify_name( $filename_clean ) ), apply_filters("{$vct_prefix}_textdomain", 'vc_template_manager') );
					$data['weight']     = apply_filters("{$vct_prefix}_{$hook_prefix}_weight_{$filename_clean}", apply_filters("{$vct_prefix}_default_weight", 0));
					$data['custom_class'] = apply_filters("{$vct_prefix}_{$hook_prefix}_class_{$filename_clean}", "vctm_{$hook_prefix}_{$filename_clean}");
					$data['content']    = apply_filters("{$vct_prefix}_{$hook_prefix}_content_{$filename_clean}", file_get_contents($filename));

					$templates[] = $data;
				}
			}

		    return $templates;
		}

		/**
		 * Prettifies an ugly file name
		 *
		 * @param $name
		 * @return string
		 */
		function vctm_prettify_name( $name ) {
		    global $vct_prefix;

		    //Normalize spaces
		    $name = str_replace( array('-', '_'), ' ', $name );

		    $ret = '';
		    foreach( explode(' ', $name) as $word ) {
		        $ret .= ucfirst( $word ) . ' ';
			}

		    return rtrim( $ret );
		}


		function wppm_includes() {
			$plugin_dir = trailingslashit( plugin_dir_path( __FILE__ ) );
			require_once( $plugin_dir . 'includes/BFI_Thumb.php' );
			require_once( $plugin_dir . 'includes/wppm.functions.php' );

			if ( class_exists ( 'Vc_Manager' ) ) {
				require_once( $plugin_dir . 'includes/wppm.vc.functions.php' );
			}
		}

		function wppm_init() {

			// Translation
			load_plugin_textdomain( 'wppm', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );

			if ( ! is_admin() ) {

				wp_enqueue_style( 'wppm-plugin-css', plugin_dir_url( __FILE__ ) . 'assets/css/wppm.frontend.css', array(), '2.8.1' );

				if ( is_rtl() ) {
					wp_register_style( 'wppm-plugin-rtl', plugin_dir_url( __FILE__ ) . 'assets/css/wppm.rtl.frontend.css', array(), '2.8.1' );
					wp_enqueue_style( 'wppm-plugin-rtl' );
				}

				// JavaScript files
				wp_enqueue_script( 'jquery-masonry' );
				wp_enqueue_script( 'wppm-plugin-functions', plugin_dir_url( __FILE__ ) . 'assets/js/wppm.frontend.js', array( 'jquery' ), '', true );
				wp_enqueue_script( 'wppm-jq-easing', plugin_dir_url( __FILE__ ) . 'assets/js/jquery.easing.min.js', array( 'jquery' ), '', true );
				wp_enqueue_script( 'wppm-jq-owl-carousel', plugin_dir_url( __FILE__ ) . 'assets/js/owl.carousel.min.js', array( 'jquery' ), '', true );
				wp_enqueue_script( 'wppm-jq-marquee', plugin_dir_url( __FILE__ ) . 'assets/js/jquery.marquee.min.js', array( 'jquery' ), '', true );

				// Check for intenet explorer browser
				$iecheck = false;
				$u = $_SERVER['HTTP_USER_AGENT'];
				$isIE7  = (bool)preg_match('/msie 7./i', $u );
				$isIE8  = (bool)preg_match('/msie 8./i', $u );
				$isIE9  = (bool)preg_match('/msie 9./i', $u );
				if ( $isIE7 || $isIE8 || $isIE9 ) {
					$iecheck = true;
				}

				// Localize text strings and variables used in wppm.plugin.js file
				$localization = array(
					'ajax_err' 		=> __( '<a href="%url%">The content</a> could not be loaded.' , 'wppm' ),
					'ajax_url' 		=> admin_url( 'admin-ajax.php' ),
					'iecheck'		=> $iecheck
				);

				wp_localize_script( 'wppm-plugin-functions', 'wppm_localize', $localization );

			}

			add_shortcode( 'wppm', array( $this, 'wppm_shortcode' ) );
			add_shortcode( 'wppm_row', array( $this, 'wppm_row' ) );
			add_shortcode( 'wppm_col', array( $this, 'wppm_col' ) );
			add_shortcode( 'wppm_tabs', array( $this, 'wppm_tabs' ) );
			add_shortcode( 'wppm_tab', array( $this, 'wppm_tab' ) );
			add_shortcode( 'wppm_title', array( $this, 'wppm_title' ) );

		}

		function wppm_map_shortcode_to_vc() {

			// Text domain for admin VC elements
			load_plugin_textdomain( 'wppm', false, dirname( plugin_basename( __FILE__ ) ) . '/languages/' );

			// Categories array
			$cat_arr = array();
			$categories = get_categories();
			foreach( $categories as $category ){
			  $cat_arr[ $category->name ] = $category->term_id;
			}

			// Post types
			$post_type_arr = array();
			foreach ( get_post_types( array( 'public' => true ) ) as $post_type ) {
				if ( ! in_array( $post_type, array( 'revision', 'attachment', 'nav_menu_item' ) ) ) {
			   		$post_type_arr[ $post_type ] = $post_type;
			  	}
			}
			global $sitepress;
			if ( isset( $sitepress ) ) {
				remove_filter( 'terms_clauses', array( $sitepress, 'terms_clauses' ), 10, 4 );
			}
			// Taxonomies
			$taxonomies = get_taxonomies( array( 'public' => true ) );
			$tax_arr = array();
			$terms_arr = array();
			$cat_limit = apply_filters( 'wppm_cat_limit', 999 );
			foreach ( $taxonomies as $taxonomy ) {
				if ( isset ( $taxonomy ) && is_array( $taxonomy ) ) {
					$taxonomy = array_keys( $taxonomy );
					$taxonomy = $taxonomy[0];
				}
				if ( isset ( $taxonomy ) && '' !== $taxonomy ) {
					$tax = get_taxonomy( $taxonomy );

					// Get terms for each taxonomy
					$term_arr = array();
					$terms = get_terms( array(
						'taxonomy' => $taxonomy,
						'hide_empty' => true,
						'number' => $cat_limit
					) );

					if ( ! empty( $terms ) && ! is_wp_error( $terms ) && is_array( $terms ) ){
						foreach ( $terms as $term ) {
							$term_arr[ $term->name ] = $term->slug;
						}
					}

					// Store taxonomies in array
					if ( ! in_array( $taxonomy, array( 'nav_menu', 'link_category', 'post_format', 'product_type', 'product_shipping_class' ) ) ) {
						$tax_arr[$tax->labels->name] = $taxonomy;
						$terms_arr[ $tax->labels->name ] = $term_arr;
					}
				}
			}

			if ( isset( $sitepress ) ) {
				add_filter( 'terms_clauses', array( $sitepress, 'terms_clauses' ), 10, 4 );
			}

			// Animation values
			$animate_in = wppm_animate_in_list();
			$animate_out = wppm_animate_out_list();
			$google_font_list = wppm_google_font_list();

			// Get registered image sizes
			if ( function_exists( 'wppm_get_image_sizes' ) ) {
				$image_sizes = wppm_get_image_sizes();
			} else {
				$image_sizes = array(
					__( 'Original', 'wppm' ) => 'full',
					__( 'Large', 'wppm' ) => 'large',
					__( 'Medium', 'wppm' ) => 'medium',
					__( 'Thumbnail', 'wppm' ) => 'thumbnail'
				);
			}

			// VC Map
			vc_map( array(
				'name' => __( 'WP Post Modules', 'wppm' ),
				'description' => __( 'Create WordPress post modules', 'wppm' ),
				'base' => 'wppm',
				'class' => '',
				'category' => __( 'Content', 'wppm'),
				'icon' => plugin_dir_url( __FILE__ ) . 'assets/images/wppm.svg',
				'params' => array(

						// Query params
						array(
							'type' => 'dropdown_multiple',
							'heading' => __( 'Show data from', 'wppm' ),
							'param_name' => 'post_type',
							'value' => $post_type_arr,
							'description' => __( 'Select post types. Use Ctrl + Select or Command + select for mutiple selection.', 'wppm' ),
							'std' => 'post',
							'group' => __( 'Query', 'wppm' )
						),

						array(
							'type' => 'dropdown_multiple',
							'heading' => __( 'Post Status', 'wppm' ),
							'param_name' => 'post_status',
							'value' => array(
								__( 'Publish', 'wppm' ) => 'publish',
								__( 'Pending Review', 'wppm' ) => 'pending',
								__( 'Draft', 'wppm' ) => 'draft',
								__( 'Auto Draft', 'wppm' ) => 'auto-draft',
								__( 'Future Scheduled', 'wppm' ) => 'future',
								__( 'Private', 'wppm' ) => 'private',
								__( 'Revision', 'wppm' ) => 'inherit',
								__( 'Trash', 'wppm' ) => 'trash',
								__( 'Any', 'wppm' ) => 'any',

							),
							'description' => __( 'Select post statuses. Use Ctrl + Select or Command + select for mutiple selection.', 'wppm' ),
							'std' => 'post',
							'group' => __( 'Query', 'wppm' )
						),

						array(
							'type' => 'textfield_num',
							'heading' => __( 'Number of Posts', 'wppm' ),
							'param_name' => 'num',
							'value' => '6',
							'min' => '1',
							'max' => '999',
							'std' => '6',
							'description' => __( 'Provide number of posts to show. E.g. 10', 'wppm' ),
							'group' => __( 'Query', 'wppm' )
						),

						array(
							'type' => 'dropdown_multiple',
							'heading' => __( 'Filter by Taxonomy', 'wppm' ),
							'param_name' => 'taxonomy',
							'value' => $tax_arr,
							'std' => 'category',
							'description' => __( 'Select taxonomy', 'wppm' ),
							'group' => __( 'Query', 'wppm' )
						),

						array(
							'type' => 'dropdown_multiple_optgroup',
							'heading' => __( 'Terms', 'wppm' ),
							'param_name' => 'terms',
							'std' => '',
							'value' => $terms_arr,
							'description' => __( 'Select Terms', 'wppm' ),
							'group' => __( 'Query', 'wppm' )
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Include only these Post/Page IDs', 'wppm' ),
							'param_name' => 'post__in',
							'value' => '',
							'description' => __( 'Provide numeric IDs of pages or posts, separated by comma. E.g. 12,34,156,259', 'wppm' ),
							'group' => __( 'Query', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Exclude these Post/Page IDs', 'wppm' ),
							'param_name' => 'post__not_in',
							'value' => '',
							'description' => __( 'Provide numeric IDs of pages or posts, separated by comma. E.g. 12,34,156,259. Important: Use either include or exclude feature. Both do not work together.', 'wppm' ),
							'group' => __( 'Query', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Show from Author IDs', 'wppm' ),
							'param_name' => 'author__in',
							'value' => '',
							'description' => __( 'Provide numeric IDs of Authors, separated by comma. E.g. 2,6', 'wppm' ),
							'group' => __( 'Query', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'textfield_num',
							'heading' => __( 'Offset', 'wppm' ),
							'param_name' => 'offset',
							'value' => '0',
							'min' => '0',
							'max' => '999',
							'description' => __( 'Provide an offset number. E.g. 2. Offset is used to skip a particular number of posts from loop.', 'wppm' ),
							'group' => __( 'Query', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'dropdown',
							'heading' => __( 'Order', 'wppm' ),
							'param_name' => 'order',
							'value' => array(
									esc_attr__( 'Descending', 'wppm' ) => 'DESC',
									esc_attr__( 'Ascending', 'wppm' ) => 'ASC'
							),
							'std' => 'DESC',
							'description' => __( 'Select posts order.', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Query', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'dropdown',
							'heading' => __( 'Order by', 'wppm' ),
							'param_name' => 'orderby',
							'value' => array(
									esc_attr__( 'None', 'wppm' ) => 'none',
									esc_attr__( 'ID', 'wppm' ) => 'ID',
									esc_attr__( 'Author', 'wppm' ) => 'author',
									esc_attr__( 'Title', 'wppm' ) => 'title',
									esc_attr__( 'Name', 'wppm' ) => 'name',
									esc_attr__( 'Post Type', 'wppm' ) => 'type',
									esc_attr__( 'Date', 'wppm' ) => 'date',
									esc_attr__( 'Meta Value', 'wppm' ) => 'meta_value',
									esc_attr__( 'Meta Value Num', 'wppm' ) => 'meta_value_num',
									esc_attr__( 'Last Modified', 'wppm' ) => 'modified',
									esc_attr__( 'Parent ID', 'wppm' ) => 'parent',
									esc_attr__( 'Random', 'wppm' ) => 'rand',
									esc_attr__( 'Comment Count', 'wppm' ) => 'comment_count',
									esc_attr__( 'Menu Order', 'wppm' ) => 'menu_order',
									esc_attr__( 'Post In', 'wppm' ) => 'post__in',
									esc_attr__( 'Post Views', 'wppm' ) => 'post_views'
							),
							'std' => 'date',
							'description' => __( 'Select posts orderby criteria.', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Query', 'wppm' )
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Show from specific meta key', 'wppm' ),
							'param_name' => 'meta_key',
							'value' => '',
							'description' => __( 'Provide a meta key for posts. E.g. price', 'wppm' ),
							'dependency' => array(
								'element' => 'orderby',
								'value' => array( 'meta_value', 'meta_value_num' )
							),
							'group' => __( 'Query', 'wppm' )
						),

						array(
							'type' => 'dropdown',
							'heading' => __( 'Multiple Taxonomy Relation', 'wppm' ),
							'param_name' => 'relation',
							'value' => array(
									esc_attr__( 'OR', 'wppm' ) => 'OR',
									esc_attr__( 'AND', 'wppm' ) => 'AND'
							),
							'std' => 'OR',
							'description' => __( 'Choose a taxonomy relation when multiple taxonomies are selected.', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Query', 'wppm' )
						),

						array(
							'type' => 'dropdown',
							'heading' => __( 'Operator relation for multiple terms', 'wppm' ),
							'param_name' => 'operator',
							'value' => array(
									esc_attr__( 'IN', 'wppm' ) => 'IN',
									esc_attr__( 'NOT IN', 'wppm' ) => 'NOT IN',
									esc_attr__( 'AND', 'wppm' ) => 'AND'
							),
							'std' => 'IN',
							'description' => __( 'Choose an operator relation between multiple terms of same taxonomy.', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Query', 'wppm' )
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Year', 'wppm' ),
							'param_name' => 'year',
							'description' => __( 'Filter posts by year. 4 digit year (e.g. 2011)', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Query', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Month', 'wppm' ),
							'param_name' => 'month',
							'description' => __( 'Filter posts by month number (from 1 to 12)', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Query', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Week', 'wppm' ),
							'param_name' => 'week',
							'description' => __( 'Filter posts by week of the year (from 0 to 53)', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Query', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Day', 'wppm' ),
							'param_name' => 'day',
							'description' => __( 'Filter posts by day of the month (from 1 to 31)', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Query', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Before (Date)', 'wppm' ),
							'param_name' => 'before',
							'description' => __( 'Date to retrieve posts before. E.g. January 1st, 2013', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Query', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'After (Date)', 'wppm' ),
							'param_name' => 'after',
							'description' => __( 'Date to retrieve posts after. E.g. January 1st, 2013', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Query', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Filter by Search term', 'wppm' ),
							'param_name' => 's',
							'description' => __( 'Filter posts by search term. Prepend with hyphen to exclude a term. E.g. Pillow -sofa will show all results for pillow but not sofa.', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Query', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
						),

						array(
							'type' => 'checkbox',
							'heading' => '',
							'param_name' => 'ignore_sticky_posts',
							'description' => '',
							'value' => array( __( 'Ignore sticky posts', 'wppm' ) => 'true' ),
							'group' => __( 'Query', 'wppm' )
						),

						array(
							'type' => 'checkbox',
							'heading' => '',
							'param_name' => 'single_cat_filter',
							'description' => '',
							'value' => array( __( 'Automatically show posts from similar terms on single post.', 'wppm' ) => 'true' ),
							'group' => __( 'Query', 'wppm' )
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Restrict to taxonomy (Optional)', 'wppm' ),
							'param_name' => 'taxonomy_optional',
							'description' => __( 'Provide taxonomy names, separated by comma; to which posts shall be restricted when on single post. E.g. category, product', 'wppm' ),
							'group' => __( 'Query', 'wppm' ),
							'dependency' => array(
								'element' => 'single_cat_filter',
								'value' => 'true'
							)
						),

						array(
							'type' => 'checkbox',
							'param_name' => 'single_cat_filter_append',
							'value' => array( __( 'Append/Merge taxonomy filter to the category filter', 'wppm' ) => 'false' ),
							'group' => __( 'Query', 'wppm' ),
							'dependency' => array(
								'element' => 'single_cat_filter',
								'value' => 'true'
							)
						),

						array(
							'type' => 'checkbox',
							'heading' => '',
							'param_name' => 'hide_current_post',
							'description' => '',
							'value' => array( __( 'Hide current post from post module when on single post', 'wppm' ) => 'true' ),
							'group' => __( 'Query', 'wppm' )
						),

						// Display Tab
						array(
							'type' => 'dropdown',
							'heading' => __( 'Template Style', 'wppm' ),
							'param_name' => 'template',
							'value' => array(
									esc_attr__( 'Grid', 'wppm' ) => 'grid',
									esc_attr__( 'List', 'wppm' ) => 'list',
									esc_attr__( 'Bullet List', 'wppm' ) => 'bullet-list',
									esc_attr__( 'Portfolio', 'wppm' ) => 'portfolio',
									esc_attr__( 'Tile', 'wppm' ) => 'tile',
									esc_attr__( 'Ticker (Marquee)', 'wppm' ) => 'ticker',
									esc_attr__( 'Card', 'wppm' ) => 'card',
									esc_attr__( 'Teaser', 'wppm' ) => 'teaser'
							),
							'std' => 'grid',
							'description' => __( 'Select a template style for displaying posts.', 'wppm' ),
							'group' => __( 'Display', 'wppm' )
						),

						array(
							'type' => 'checkbox',
							'heading' => '',
							'param_name' => 'enable_slider',
							'description' => '',
							'value' => array( __( 'Enable Slider for this template', 'wppm' ) => 'true' ),
							'group' => __( 'Display', 'wppm' ),
							'dependency' => array(
								'element' => 'template',
								'value' => array( 'grid', 'list', 'portfolio', 'card', 'bullet-list', 'teaser' )
							),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'checkbox',
							'heading' => '',
							'param_name' => 'card_equal_height',
							'description' => '',
							'value' => array( __( 'Equal height columns', 'wppm' ) => 'true' ),
							'group' => __( 'Display', 'wppm' ),
							'dependency' => array(
								'element' => 'template',
								'value' => array( 'card' )
							),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						// Slider parameters
						array(
							'type' => 'textfield_num',
							'heading' => __( 'Number of Slides per view', 'wppm' ),
							'param_name' => 'items',
							'value' => '1',
							'min' => '1',
							'max' => '10',
							'description' => __( 'Provide number of slides to show per viewport. E.g. 3', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Display', 'wppm' ),
							'dependency' => array(
								'element' => 'enable_slider',
								'value' => 'true'
							)
						),

						array(
							'type' => 'dropdown',
							'heading' => __( 'Loop Animation', 'wppm' ),
							'param_name' => 'loop',
							'value' => array(
									esc_attr__( 'No', 'wppm' ) => 'false',
									esc_attr__( 'Yes', 'wppm' ) => 'true'
							),
							'std' => 'false',
							'description' => __( 'Whether to loop slides infinitely?', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Display', 'wppm' ),
							'dependency' => array(
								'element' => 'enable_slider',
								'value' => 'true'
							)
						),

						array(
							'type' => 'dropdown',
							'heading' => __( 'Auto Play', 'wppm' ),
							'param_name' => 'autoplay',
							'value' => array(
									esc_attr__( 'Yes', 'wppm' ) => 'true',
									esc_attr__( 'No', 'wppm' ) => 'false'
							),
							'std' => 'true',
							'description' => __( 'Whether to start slider auotmatically?', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Display', 'wppm' ),
							'dependency' => array(
								'element' => 'enable_slider',
								'value' => 'true'
							)
						),

						array(
							'type' => 'textfield_num',
							'heading' => __( 'Autoplay Timeout', 'wppm' ),
							'param_name' => 'timeout',
							'value' => '5000',
							'min' => '1',
							'max' => '',
							'description' => __( 'Time (in miliseconds), for how long slides should stay visible.', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Display', 'wppm' ),
							'dependency' => array(
								'element' => 'enable_slider',
								'value' => 'true'
							)
						),

						array(
							'type' => 'dropdown',
							'heading' => __( 'Auto Height', 'wppm' ),
							'param_name' => 'autoheight',
							'value' => array(
									esc_attr__( 'No', 'wppm' ) => 'false',
									esc_attr__( 'Yes', 'wppm' ) => 'true'
							),
							'std' => 'false',
							'description' => __( 'Whether to enable dynamic smooth height for slider?', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Display', 'wppm' ),
							'dependency' => array(
								'element' => 'enable_slider',
								'value' => 'true'
							)
						),

						array(
							'type' => 'dropdown',
							'heading' => __( 'Show Prev/Next buttons', 'wppm' ),
							'param_name' => 'nav',
							'value' => array(
									esc_attr__( 'Yes', 'wppm' ) => 'true',
									esc_attr__( 'No', 'wppm' ) => 'false',
							),
							'std' => 'true',
							'description' => __( 'Whether to show prev/next buttons?', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Display', 'wppm' ),
							'dependency' => array(
								'element' => 'enable_slider',
								'value' => 'true'
							)
						),

						array(
							'type' => 'dropdown',
							'heading' => __( 'Show dots navigation', 'wppm' ),
							'param_name' => 'dots',
							'value' => array(
									esc_attr__( 'No', 'wppm' ) => 'false',
									esc_attr__( 'Yes', 'wppm' ) => 'true'
							),
							'std' => 'false',
							'description' => __( 'Whether to show dots navigation?', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Display', 'wppm' ),
							'dependency' => array(
								'element' => 'enable_slider',
								'value' => 'true'
							)
						),

						array(
							'type' => 'textfield_num',
							'heading' => __( 'Animation Speed', 'wppm' ),
							'param_name' => 'speed',
							'value' => '300',
							'min' => '1',
							'max' => '',
							'description' => __( 'Provide animation speed (in miliseconds). E.g. 300', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Display', 'wppm' ),
							'dependency' => array(
								'element' => 'enable_slider',
								'value' => 'true'
							)
						),

						array(
							'type' => 'dropdown_optgroup',
							'heading' => __( 'Animation In', 'wppm' ),
							'param_name' => 'animatein',
							'value' => $animate_in,
							'description' => __( 'Select animation for transition in. (Works only for 1 slide per view)', 'wppm' ),
							'group' => __( 'Display', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'dependency' => array(
								'element' => 'enable_slider',
								'value' => 'true'
							)
						),

						array(
							'type' => 'dropdown_optgroup',
							'heading' => __( 'Animation Out', 'wppm' ),
							'param_name' => 'animateout',
							'value' => $animate_out,
							'description' => __( 'Select animation for transition out. (Works only for 1 slide per view)', 'wppm' ),
							'group' => __( 'Display', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'dependency' => array(
								'element' => 'enable_slider',
								'value' => 'true'
							)
						),

						array(
							'type' => 'textfield_num',
							'heading' => __( 'Slide Margin', 'wppm' ),
							'param_name' => 'margin',
							'value' => '24',
							'min' => '0',
							'max' => '100',
							'description' => __( 'Margin between slides (in px, without unit). E.g. 20', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Display', 'wppm' ),
							'dependency' => array(
								'element' => 'enable_slider',
								'value' => 'true'
							)
						),

						array(
							'type' => 'textfield_num',
							'heading' => __( 'Slide Margin (Mobile)', 'wppm' ),
							'param_name' => 'margin_mobile',
							'value' => '16',
							'min' => '0',
							'max' => '40',
							'description' => __( 'Margin between slides for mobile devices (in px, without unit). E.g. 16', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Display', 'wppm' ),
							'dependency' => array(
								'element' => 'enable_slider',
								'value' => 'true'
							)
						),

						array(
							'type' => 'textfield_num',
							'heading' => __( 'Stage Padding', 'wppm' ),
							'param_name' => 'stagepadding',
							'value' => '0',
							'min' => '0',
							'max' => '999',
							'description' => __( 'The left and right padding style (in px) onto stage wrapper.', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Display', 'wppm' ),
							'dependency' => array(
								'element' => 'enable_slider',
								'value' => 'true'
							)
						),

						array(
							'type' => 'textfield_num',
							'heading' => __( 'Ticker title length', 'wppm' ),
							'param_name' => 'title_length',
							'value' => '10',
							'std' => '10',
							'min' => '1',
							'max' => '999',
							'description' => __( 'The length in words at which post titles shall be trimmed in ticker. E.g. 10', 'wppm' ),
							'group' => __( 'Display', 'wppm' ),
							'dependency' => array(
								'element' => 'template',
								'value' => 'ticker'
							),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'textfield_num',
							'heading' => __( 'Ticker animation duration', 'wppm' ),
							'param_name' => 'duration',
							'value' => '15000',
							'std' => '15000',
							'min' => '1',
							'max' => '999999',
							'description' => __( 'Animation duration (in ms) for ticker post titles.', 'wppm' ),
							'group' => __( 'Display', 'wppm' ),
							'dependency' => array(
								'element' => 'template',
								'value' => 'ticker'
							),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Ticker label', 'wppm' ),
							'param_name' => 'ticker_label',
							'value' => __( 'Breaking News', 'wppm' ),
							'description' => __( 'Provide a text label for the ticker. E.g. Latest Posts', 'wppm' ),
							'group' => __( 'Display', 'wppm' ),
							'dependency' => array(
								'element' => 'template',
								'value' => 'ticker'
							),
						),

						array(
							'type' => 'dropdown',
							'heading' => __( 'Grid Sub Style', 'wppm' ),
							'param_name' => 'sub_type_grid',
							'value' => array(
									esc_attr__( 'Big image + Title', 'wppm' ) => 's1',
									esc_attr__( 'Title + Big image', 'wppm' ) => 's2',
									esc_attr__( 'Title + Small image left', 'wppm' ) => 's3',
									esc_attr__( 'Title + Small image right', 'wppm' ) => 's4'
							),
							'description' => __( 'Select a sub style for grid temmplate.', 'wppm' ),
							'group' => __( 'Display', 'wppm' ),
							'std' => 's1',
							'dependency' => array(
								'element' => 'template',
								'value' => 'grid'
							)
						),

						array(
							'type' => 'textfield_num',
							'heading' => __( 'Grid Columns', 'wppm' ),
							'param_name' => 'columns',
							'value' => '3',
							'min' => '1',
							'max' => '10',
							'description' => __( 'Number of columns for the grid style posts. E.g. 3', 'wppm' ),
							'group' => __( 'Display', 'wppm' ),
							'dependency' => array(
								'element' => 'template',
								'value' => array( 'grid', 'portfolio', 'card', 'teaser' )
							),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'textfield_num',
							'heading' => __( 'List Columns', 'wppm' ),
							'param_name' => 'list_columns',
							'value' => '1',
							'min' => '1',
							'max' => '6',
							'description' => __( 'Number of columns for the list style posts. E.g. 3', 'wppm' ),
							'group' => __( 'Display', 'wppm' ),
							'dependency' => array(
								'element' => 'template',
								'value' => 'list'
							),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'dropdown',
							'heading' => __( 'Grid image and content ratio', 'wppm' ),
							'param_name' => 'grid_split',
							'value' => array(
									esc_attr__( '20:80', 'wppm' ) => '20-80',
									esc_attr__( '25:75', 'wppm' ) => '25-75',
									esc_attr__( '30:70', 'wppm' ) => '30-70',
									esc_attr__( '33:66', 'wppm' ) => '33-66',
									esc_attr__( '40:60', 'wppm' ) => '40-60',
									esc_attr__( '50:50', 'wppm' ) => '50-50'
							),
							'std' => '33-66',
							'description' => __( 'Select ratio for image + content in grid sub styles', 'wppm' ),
							'group' => __( 'Display', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'dependency' => array(
								'element' => 'template',
								'value' =>'grid'
							)
						),

						array(
							'type' => 'dropdown',
							'heading' => __( 'List image and content ratio', 'wppm' ),
							'param_name' => 'list_split',
							'value' => array(
									esc_attr__( '10:90', 'wppm' ) => '10-90',
									esc_attr__( '15:85', 'wppm' ) => '15-85',
									esc_attr__( '20:80', 'wppm' ) => '20-80',
									esc_attr__( '25:75', 'wppm' ) => '25-75',
									esc_attr__( '30:70', 'wppm' ) => '30-70',
									esc_attr__( '33:66', 'wppm' ) => '33-66',
									esc_attr__( '40:60', 'wppm' ) => '40-60',
									esc_attr__( '50:50', 'wppm' ) => '50-50',
									esc_attr__( '60:40', 'wppm' ) => '60-40'
							),
							'std' => '25-75',
							'description' => __( 'Select ratio for image + content in list items.', 'wppm' ),
							'group' => __( 'Display', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'dependency' => array(
								'element' => 'template',
								'value' => 'list'
							)
						),

						array(
							'type' => 'dropdown',
							'heading' => __( 'Separate list items by', 'wppm' ),
							'param_name' => 'list_sep',
							'value' => array(
									esc_attr__( 'Content Border', 'wppm' ) => 'content-border',
									esc_attr__( 'Full Border', 'wppm' ) => 'full-border',
									esc_attr__( 'No Border', 'wppm' ) => 'no-border'
							),
							'description' => __( 'Choose how to separate each list item.', 'wppm' ),
							'group' => __( 'Display', 'wppm' ),
							'std' => 'content-border',
							'dependency' => array(
								'element' => 'template',
								'value' => 'list'
							)
						),

						array(
							'type' => 'checkbox',
							'heading' => '',
							'param_name' => 'content_left',
							'description' => '',
							'value' => array( __( 'Swap image and content', 'wppm' ) => 'true' ),
							'group' => __( 'Display', 'wppm' ),
							'dependency' => array(
								'element' => 'template',
								'value' => 'list'
							)
						),

						array(
							'type' => 'dropdown',
							'heading' => __( 'Tile Sub Style', 'wppm' ),
							'param_name' => 'sub_type_tile',
							'value' => array(
									esc_attr__( '1 + 2x2', 'wppm' ) => 's1',
									esc_attr__( '1 + 2x3', 'wppm' ) => 's2',
									esc_attr__( '1 + 1x2', 'wppm' ) => 's3',
									esc_attr__( '1 + 1x1 + 2x1', 'wppm' ) => 's4'
							),
							'description' => __( 'Select a sub style for tile temmplate.', 'wppm' ),
							'group' => __( 'Display', 'wppm' ),
							'std' => 's1',
							'dependency' => array(
								'element' => 'template',
								'value' => 'tile'
							)
						),

						array(
							'type' => 'checkbox',
							'heading' => '',
							'param_name' => 'clickable_tile',
							'description' => __( 'Make entire post tile clickable.', 'wppm' ),
							'value' => array( __( 'Clickable Tile', 'wppm' ) => 'true' ),
							'group' => __( 'Display', 'wppm' ),
							'dependency' => array(
								'element' => 'template',
								'value' => array( 'tile', 'portfolio' )
							),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'dropdown',
							'heading' => __( 'Grid gutter width', 'wppm' ),
							'param_name' => 'gutter_grid',
							'value' => array(
										'2px' => '2',
										'4px' => '4',
										'6px' => '6',
										'8px' => '8',
										'10px' => '10',
										'12px' => '12',
										'16px' => '16',
										'20px' => '20',
										'24px' => '24',
										'30px' => '30',
										'32px' => '32',
										'40px' => '40',
										'50px' => '50',
										'60px' => '60',
										'70px' => '70',
										__( 'Custom', 'wppm' ) => 'custom'
									),
							'std' => '24',
							'description' => __( 'Select a gutter width between columns.', 'wppm' ),
							'group' => __( 'Display', 'wppm' ),
							'dependency' => array(
								'element' => 'template',
								'value_not_equal_to' => array( 'tile', 'ticker' )
							),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'textfield_num',
							'heading' => __( 'Grid gutter width (custom)', 'wppm' ),
							'param_name' => 'gutter_grid_c',
							'value' => '',
							'min' => '0',
							'max' => '200',
							'description' => __( 'Custom gutter width between columns (in px, without unit).  E.g. 30. Use even number for best results.', 'wppm' ),
							'group' => __( 'Display', 'wppm' ),
							'dependency' => array(
								'element' => 'gutter_grid',
								'value' => 'custom'
							),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'dropdown',
							'heading' => __( 'List gutter width (inner)', 'wppm' ),
							'param_name' => 'gutter_list',
							'value' => array(
										__( 'Inherit', 'wppm' ) => '',
										'2px' => '2',
										'4px' => '4',
										'6px' => '6',
										'8px' => '8',
										'10px' => '10',
										'12px' => '12',
										'16px' => '16',
										'20px' => '20',
										'24px' => '24',
										'30px' => '30',
										'32px' => '32',
										'40px' => '40',
										'50px' => '50',
										'60px' => '60',
										'70px' => '70',
										__( 'Custom', 'wppm' ) => 'custom'
									),
							'std' => '',
							'description' => __( 'Select a gutter width between image and content of list style posts.', 'wppm' ),
							'group' => __( 'Display', 'wppm' ),
							'dependency' => array(
								'element' => 'template',
								'value' => 'list'
							),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'textfield_num',
							'heading' => __( 'List gutter width inner (custom)', 'wppm' ),
							'param_name' => 'gutter_list_c',
							'value' => '',
							'min' => '0',
							'max' => '200',
							'description' => __( 'Custom gutter width between image and content of list style posts (in px, without unit).  E.g. 30. Use even number for best results.', 'wppm' ),
							'group' => __( 'Display', 'wppm' ),
							'dependency' => array(
								'element' => 'gutter_list',
								'value' => 'custom'
							),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'dropdown',
							'heading' => __( 'Gutter width', 'wppm' ),
							'param_name' => 'gutter_tile',
							'value' => array(
										'2px' => '2',
										'4px' => '4',
										'6px' => '6',
										'8px' => '8',
										'10px' => '10',
										'12px' => '12',
										'16px' => '16',
										'20px' => '20',
										'24px' => '24',
										'30px' => '30',
										'32px' => '32',
										'40px' => '40',
										'50px' => '50',
										'60px' => '60',
										'70px' => '70',
										__( 'Custom', 'wppm' ) => 'custom'
									),
							'std' => '4',
							'description' => __( 'Select a gutter width between tile grids.', 'wppm' ),
							'group' => __( 'Display', 'wppm' ),
							'dependency' => array(
								'element' => 'template',
								'value' => 'tile'
							),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'textfield_num',
							'heading' => __( 'Gutter width (custom)', 'wppm' ),
							'param_name' => 'gutter_tile_c',
							'value' => '',
							'min' => '0',
							'max' => '200',
							'description' => __( 'Provide custom gutter width between tile grids (in px, without unit).  E.g. 8. Use even number for best results.', 'wppm' ),
							'group' => __( 'Display', 'wppm' ),
							'dependency' => array(
								'element' => 'gutter_tile',
								'value' => 'custom'
							),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'textfield_num',
							'heading' => __( 'Tile viewport width', 'wppm' ),
							'param_name' => 'viewport_width',
							'value' => '1192',
							'min' => '100',
							'max' => '2000',
							'description' => __( 'Provide a viewport width for tile in px (without unit). E.g. 800. Image widths for tile will be calculated based on this width.', 'wppm' ),
							'group' => __( 'Display', 'wppm' ),
							'dependency' => array(
								'element' => 'template',
								'value' => 'tile'
							),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'textfield_num',
							'heading' => __( 'Aspect ratio for tile images', 'wppm' ),
							'param_name' => 'aspect_ratio',
							'value' => '1.3333',
							'min' => '0.1',
							'max' => '5',
							'description' => __( 'Provide aspect ratio in which tile images shall be generated. E.g. 1.3333 for 4:3. Or 1.5 for 3:2 ratio.', 'wppm' ),
							'group' => __( 'Display', 'wppm' ),
							'dependency' => array(
								'element' => 'template',
								'value' => 'tile'
							),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'textfield_num',
							'heading' => __( 'Image Width', 'wppm' ),
							'param_name' => 'imgwidth',
							'value' => '',
							'min' => '10',
							'max' => '1600',
							'description' => __( 'Image width in px (without unit). E.g. 600', 'wppm' ),
							'group' => __( 'Display', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'dependency' => array(
								'element' => 'template',
								'value_not_equal_to' => array( 'tile', 'ticker' )
							)
						),

						array(
							'type' => 'textfield_num',
							'heading' => __( 'Image Height', 'wppm' ),
							'param_name' => 'imgheight',
							'value' => '',
							'min' => '10',
							'max' => '1600',
							'description' => __( 'Image height in px (without unit). E.g. 400', 'wppm' ),
							'group' => __( 'Display', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'dependency' => array(
								'element' => 'template',
								'value_not_equal_to' => array( 'tile', 'ticker' )
							)
						),

						array(
							'type' => 'textfield_num',
							'heading' => __( 'Image Quality', 'wppm' ),
							'param_name' => 'imgquality',
							'value' => '80',
							'min' => '1',
							'max' => '100',
							'std' => '80',
							'description' => __( 'Image quality in range 1 to 100. E.g. 75', 'wppm' ),
							'group' => __( 'Display', 'wppm' ),
							'dependency' => array(
								'element' => 'template',
								'value_not_equal_to' => 'ticker'
							),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'checkbox',
							'heading' => '',
							'param_name' => 'imgcrop',
							'description' => '',
							'value' => array( __( 'Hard crop images', 'wppm' ) => 'true' ),
							'group' => __( 'Display', 'wppm' ),
							'std' => 'true',
							'dependency' => array(
								'element' => 'template',
								'value_not_equal_to' => array( 'tile', 'ticker' )
							),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'checkbox',
							'heading' => '',
							'param_name' => 'imggrayscale',
							'description' => '',
							'value' => array( __( 'Convert images to grayscale', 'wppm' ) => 'true' ),
							'group' => __( 'Display', 'wppm' ),
							'dependency' => array(
								'element' => 'template',
								'value_not_equal_to' => 'ticker'
							),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'checkbox',
							'param_name' => 'show_embed',
							'value' => array( __( 'Enable video embeds', 'wppm' ) => 'true' ),
							'description' => __( 'Check to enable video embeds in post thumbnail. The first video placed in post content will be shown.', 'wppm' ),
							'group' => __( 'Display', 'wppm' ),
							'dependency' => array(
								'element' => 'template',
								'value_not_equal_to' => array( 'bullet-list', 'portfolio', 'ticker', 'tile' )
							)
						),

						array(
							'type' => 'checkbox',
							'param_name' => 'use_native_thumbs',
							'value' => array( __( 'Enable native post thumbnails support', 'wppm' ) => 'true' ),
							'description' => __( 'Important: Do not use this option for Tile display style. Some image sizes may not work well for such style.', 'wppm' ),
							'group' => __( 'Display', 'wppm' )
						),

						array(
							'type' => 'dropdown',
							'heading' => __( 'Select image Size', 'wppm' ),
							'param_name' => 'imgsize',
							'value' => $image_sizes,
							'std' => 'full',
							'description' => __( 'Select an image size. This setting will override custom image sizes and hard cropping.', 'wppm' ),
							'group' => __( 'Display', 'wppm' ),
							'dependency' => array(
								'element' => 'use_native_thumbs',
								'value' => 'true'
							)
						),

						array(
							'type' => 'checkbox',
							'heading' => '',
							'param_name' => 'enable_captions',
							'description' => '',
							'value' => array( __( 'Enable post thumbnail captions', 'wppm' ) => 'true' ),
							'group' => __( 'Display', 'wppm' )
						),

						array(
							'type' => 'checkbox',
							'heading' => '',
							'param_name' => 'mobile_wide',
							'description' => '',
							'value' => array( __( 'Enable full width columns on mobile (below 480px)', 'wppm' ) => 'true' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Display', 'wppm' ),
							'dependency' => array(
								'element' => 'template',
								'value' => 'list'
							)
						),

						array(
							'type' => 'colorpicker',
							'class' => '',
							'heading' => __( 'Colorize image', 'wppm' ),
							'param_name' => 'imgcolor',
							'value' => '',
							'description' => __( 'Choose image color', 'wppm' ),
							'group' => __( 'Display', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'dependency' => array(
								'element' => 'template',
								'value_not_equal_to' => 'ticker'
							)
						),

						array(
							'type' => 'checkbox',
							'heading' => '',
							'param_name' => 'circle_img',
							'description' => '',
							'value' => array( __( 'Enable circular image thumbnails', 'wppm' ) => 'true' ),
							'group' => __( 'Display', 'wppm' ),
							'dependency' => array(
								'element' => 'template',
								'value' => 'list'
							),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'dropdown',
							'heading' => __( 'Content position', 'wppm' ),
							'param_name' => 'content_pos',
							'value' => array(
								esc_attr__( 'Bottom Left', 'wppm' ) => 'bl',
								esc_attr__( 'Top Left', 'wppm' ) => 'tl'
							),
							'std' => 'bl',
							'description' => __( 'Select overlay content position for tile and portfolio templates.', 'wppm' ),
							'group' => __( 'Display', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'dependency' => array(
								'element' => 'template',
								'value' => array( 'portfolio', 'tile' )
							)
						),

						array(
							'type' => 'dropdown',
							'heading' => __( 'Overlay content padding', 'wppm' ),
							'param_name' => 'content_padding',
							'value' => array(
										'4px' => '4',
										'8px' => '8',
										'12px' => '12',
										'16px' => '16',
										'20px' => '20',
										'24px' => '24',
										'32px' => '32',
										'40px' => '40'
									),
							'std' => '20',
							'description' => __( 'Select content padding for tile/portfolio overlays', 'wppm' ),
							'group' => __( 'Display', 'wppm' ),
							'dependency' => array(
								'element' => 'template',
								'value' => array( 'tile', 'portfolio' )
							),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
						),

						array(
							'type' => 'dropdown',
							'heading' => __( 'Overlay Background Style', 'wppm' ),
							'param_name' => 'overlay_style',
							'value' => array(
								esc_attr__( 'Black Scrim', 'wppm' ) => 'scrim',
								esc_attr__( 'Transparent', 'wppm' ) => 'transparent',
								esc_attr__( 'Auto Detect from Image', 'wppm' ) => 'autobg'
							),
							'std' => 'scrim',
							'description' => __( 'Select overlay background style for tile and portfolio templates.', 'wppm' ),
							'group' => __( 'Display', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'dependency' => array(
								'element' => 'template',
								'value' => array( 'portfolio', 'tile' )
							)
						),

						array(
							'type' => 'dropdown',
							'heading' => __( 'Show Overlay', 'wppm' ),
							'param_name' => 'show_overlay',
							'value' => array(
								esc_attr__( 'Always', 'wppm' ) => 'always',
								esc_attr__( 'On Hover', 'wppm' ) => 'onhover',
								esc_attr__( 'Never', 'wppm' ) => 'never'
							),
							'std' => 'always',
							'description' => __( 'Select overlay visibility.', 'wppm' ),
							'group' => __( 'Display', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'dependency' => array(
								'element' => 'template',
								'value' => array( 'portfolio', 'tile' )
							)
						),

						array(
							'type' => 'dropdown',
							'heading' => __( 'Image Effect', 'wppm' ),
							'param_name' => 'image_effect',
							'value' => array(
								esc_attr__( 'None', 'wppm' ) => 'none',
								esc_attr__( 'ZoomIn', 'wppm' ) => 'zoomin',
								esc_attr__( 'ZoomOut', 'wppm' ) => 'zoomout',
								esc_attr__( 'ZoomInRotate', 'wppm' ) => 'zoominrotate',
								esc_attr__( 'FadeOut', 'wppm' ) => 'fadeout'
							),
							'std' => 'none',
							'description' => __( 'Select image effect on hover.', 'wppm' ),
							'group' => __( 'Display', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'dependency' => array(
								'element' => 'template',
								'value' => array( 'portfolio', 'tile' )
							)
						),

						array(
							'type' => 'param_group',
							'heading' => __( 'Add responsive media query for list module', 'wppm' ),
							'value' => urlencode( json_encode( array(
											array(
												'width' => 600,
												'img_ratio' => "25",
												'min_img_width' => 0
												)
											)
										)
									),
							'param_name' => 'mq_list',
							// Sub params of a group item
							'params' => array(
								array(
									'type' => 'textfield_num',
									'heading' => __( 'Viewport width (in px)', 'wppm' ),
									'param_name' => 'width',
									'value' => '2000',
									'min' => '300',
									'max' => '15000',
									'std' => '2000',
									'description' => __( 'Set viewport width (in px) below which styles for the list module shall be changed.', 'wppm' ),
									'admin_label' => true
								),

								array(
									'type' => 'textfield_num',
									'heading' => __( 'Image width (in %)', 'wppm' ),
									'param_name' => 'img_ratio',
									'value' => '25',
									'min' => '0',
									'max' => '100',
									'std' => '25',
									'description' => __( 'Set image width (in %) for the list module. Use 0 for hiding the image.', 'wppm' ),
									'admin_label' => true
								),


								array(
									'type' => 'textfield_num',
									'heading' => __( 'Minimum image width (in px)', 'wppm' ),
									'param_name' => 'min_img_width',
									'value' => '0',
									'min' => '0',
									'max' => '9999',
									'std' => '0',
									'description' => __( 'Set a fixed minimum image width for the above set viewport width.', 'wppm' )
								)
							),
							'group' => __( 'Display', 'wppm' ),
							'dependency' => array(
								'element' => 'template',
								'value' => 'list'
							)
						),

						// AJAX parameters
						array(
							'type' => 'checkbox',
							'heading' => '',
							'param_name' => 'ajaxnav',
							'description' => '',
							'value' => array( __( 'Enable ajax navigation on post module', 'wppm' ) => 'true' ),
							'description' => __( 'This will add next/prev ajax navigation for loading more posts', 'wppm' ),
							'group' => __( 'Display', 'wppm' )
						),

						array(
							'type' => 'checkbox',
							'heading' => '',
							'param_name' => 'nav_status',
							'description' => '',
							'value' => array( __( 'Show ajax navigation status', 'wppm' ) => 'true' ),
							'group' => __( 'Display', 'wppm' ),
							'dependency' => array(
								'element' => 'ajaxnav',
								'value' => 'true'
							)
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Ajax navigation status text', 'wppm' ),
							'param_name' => 'nav_status_text',
							'value' => '%current% of %total%',
							'description' => __( 'Provide nav status text in format %current% of %total%. The %current% and %total% will be replaced by current page and total page number. E.g. Showing %current% out of %total% pages', 'wppm' ),
							'dependency' => array(
								'element' => 'nav_status',
								'value' => 'true'
							),
							'group' => __( 'Display', 'wppm' )
						),

						array(
							'type' => 'checkbox',
							'heading' => '',
							'param_name' => 'ajaxloadmore',
							'description' => '',
							'value' => array( __( 'Enable ajax loadmore on post module', 'wppm' ) => 'true' ),
							'description' => __( 'This will add a loadmore button at the end of posts. Important: Use this option only if ajax navigation is not enabled. Both options will not work together.', 'wppm' ),
							'group' => __( 'Display', 'wppm' )
						),

						array(
							'type' => 'checkbox',
							'heading' => '',
							'param_name' => 'counter',
							'description' => '',
							'value' => array( __( 'Enable post numbers', 'wppm' ) => 'true' ),
							'description' => __( 'This will add numbers before post snippet. Generally used to show trending posts.', 'wppm' ),
							'group' => __( 'Display', 'wppm' ),
							'dependency' => array(
								'element' => 'template',
								'value_not_equal_to' => array( 'tile', 'ticker' )
							)
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Loadmore button text', 'wppm' ),
							'param_name' => 'loadmore_text',
							'value' => __( 'Load more', 'wppm' ),
							'description' => __( 'Provide custom text for the loadmore button', 'wppm' ),
							'dependency' => array(
								'element' => 'ajaxloadmore',
								'value' => 'true'
							),
							'group' => __( 'Display', 'wppm' )
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Container extra class', 'wppm' ),
							'param_name' => 'xclass',
							'value' => '',
							'description' => __( 'Any extra class you wish to add to the post container. You can add multiple classes by separating them with one space. E.g. no-border', 'wppm' ),
							'group' => __( 'Display', 'wppm' )
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Image extra class', 'wppm' ),
							'param_name' => 'img_xclass',
							'value' => '',
							'description' => __( 'Any extra class you wish to add to the post image. You can add multiple classes by separating them with one space. E.g. my-image', 'wppm' ),
							'group' => __( 'Display', 'wppm' )
						),

						array(
							'type' => 'dropdown',
							'heading' => __( 'Global font family', 'wppm' ),
							'param_name' => 'global_font',
							'value' => $google_font_list,
							'std' => '',
							'description' => __( 'This font family will apply to the entire post module.', 'wppm' ),
							'group' => __( 'Content', 'wppm' )
						),

						array(
							'type' => 'dropdown',
							'heading' => __( 'Title font family', 'wppm' ),
							'param_name' => 'heading_font',
							'value' => $google_font_list,
							'std' => '',
							'description' => __( 'This font family will apply to the post title headings, overriding global font.', 'wppm' ),
							'group' => __( 'Content', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'dropdown',
							'heading' => __( 'Title tag', 'wppm' ),
							'param_name' => 'htag',
							'value' => array( 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'p' ),
							'std' => 'h2',
							'description' => __( 'Select html tag for post title.', 'wppm' ),
							'group' => __( 'Content', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
						),

						array(
							'type' => 'dropdown',
							'heading' => __( 'Main title font size', 'wppm' ),
							'param_name' => 'tile_hsize',
							'value' => array(
										'12px' => '12',
										'13px' => '13',
										'14px' => '14',
										'16px' => '16',
										'18px' => '18',
										'20px' => '20',
										'24px' => '24',
										'34px' => '34',
									),
							'std' => '24',
							'description' => __( 'Select a font size for main title of tile template.', 'wppm' ),
							'group' => __( 'Content', 'wppm' ),
							'dependency' => array(
								'element' => 'template',
								'value' => 'tile'
							),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
						),

						array(
							'type' => 'dropdown',
							'heading' => __( 'Title font size', 'wppm' ),
							'param_name' => 'hsize',
							'value' => array(
										'12px' => '12',
										'13px' => '13',
										'14px' => '14',
										'16px' => '16',
										'18px' => '18',
										'20px' => '20',
										'24px' => '24',
										'34px' => '34',
										__( 'Custom' ) => 'custom'
									),
							'std' => '24',
							'description' => __( 'Select a font size for post headings.', 'wppm' ),
							'group' => __( 'Content', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Title font size (custom)', 'wppm' ),
							'param_name' => 'hsize_c',
							'value' => '',
							'description' => __( 'Custom font size for post headings in px, em, rem, etc. E.g. 1.5em', 'wppm' ),
							'group' => __( 'Content', 'wppm' ),
							'dependency' => array(
								'element' => 'hsize',
								'value' => 'custom'
							),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Title line height (custom)', 'wppm' ),
							'param_name' => 'line_height_c',
							'value' => '',
							'description' => __( 'Line height for the custom font size. (Generally without unit). E.g. 1.5', 'wppm' ),
							'group' => __( 'Content', 'wppm' ),
							'dependency' => array(
								'element' => 'hsize',
								'value' => 'custom'
							),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'dropdown',
							'heading' => __( 'Title font weight', 'wppm' ),
							'param_name' => 'hfontweight',
							'value' => array( '100', '200', '300', '400', '500', '600', '700', '800', '900' ),
							'std' => '400',
							'description' => __( 'Select a font weight for post headings. Weight will be applied if available in your current theme font family.', 'wppm' ),
							'group' => __( 'Content', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'textfield_num',
							'heading' => __( 'Title length', 'wppm' ),
							'param_name' => 'h_length',
							'value' => '',
							'min' => '1',
							'max' => '999',
							'description' => __( 'Provide a word length to which the title shall be trimmed. E.g. 8', 'wppm' ),
							'group' => __( 'Content', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'dropdown',
							'heading' => __( 'Title text align', 'wppm' ),
							'param_name' => 'halign',
							'value' => array(
										__( 'Inherit', 'wppm' ) => 'inherit',
										__( 'Left', 'wppm' ) => 'left',
										__( 'Right', 'wppm' ) => 'right',
										__( 'Center', 'wppm' ) => 'center',
										__( 'Justify', 'wppm' ) => 'justify'
									),
							'std' => 'inherit',
							'description' => __( 'Select text alignment for post headings.', 'wppm' ),
							'group' => __( 'Content', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
						),

						array(
							'type' => 'dropdown',
							'heading' => __( 'Title source', 'wppm' ),
							'param_name' => 'hsource',
							'value' => array(
										__( 'Post Title', 'wppm' ) => 'title',
										__( 'Meta Box', 'wppm' ) => 'meta_box',
										__( 'Custom Field', 'wppm' ) => 'custom_field'
									),
							'std' => 'title',
							'description' => __( 'Select a source for post title.', 'wppm' ),
							'group' => __( 'Content', 'wppm' )
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Meta box key name', 'wppm' ),
							'param_name' => 'h_meta_box',
							'value' => '',
							'description' => __( 'Provide key name of meta box or options panel. E.g. my_theme_meta_box', 'wppm' ),
							'group' => __( 'Content', 'wppm' ),
							'dependency' => array(
								'element' => 'hsource',
								'value' => 'meta_box'
							)
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Custom field key name', 'wppm' ),
							'param_name' => 'h_cust_field_key',
							'value' => '',
							'description' => __( 'Provide custom field key name. E.g. my_title', 'wppm' ),
							'group' => __( 'Content', 'wppm' ),
							'dependency' => array(
								'element' => 'hsource',
								'value' => array( 'meta_box', 'custom_field' )
							)
						),

						array(
							'type' => 'dropdown',
							'heading' => __( 'Post text source', 'wppm' ),
							'param_name' => 'psource',
							'value' => array(
										__( 'Excerpt (trimmed)', 'wppm' ) => 'excerpt',
										__( 'Content (with allowed tags)', 'wppm' ) => 'content',
										__( 'Meta Box', 'wppm' ) => 'meta_box',
										__( 'Custom Field', 'wppm' ) => 'custom_field'
									),
							'std' => 'excerpt',
							'description' => __( 'Select a source for post text. If chosen Excerpt, text will be stripped from custom excerpt or content. If chosen as Content, text is trimmed from post content with allowed tags.', 'wppm' ),
							'group' => __( 'Content', 'wppm' )
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Allowed tags for post text', 'wppm' ),
							'param_name' => 'allowed_tags',
							'value' => 'p,br,a,em,i,strong,b',
							'description' => __( 'Provide allowed tags for post text when stripped from content.', 'wppm' ),
							'group' => __( 'Content', 'wppm' ),
							'dependency' => array(
								'element' => 'psource',
								'value' => 'content'
							)
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Meta box key name', 'wppm' ),
							'param_name' => 'meta_box',
							'value' => '',
							'description' => __( 'Provide key name of meta box or options panel. E.g. my_theme_meta_box', 'wppm' ),
							'group' => __( 'Content', 'wppm' ),
							'dependency' => array(
								'element' => 'psource',
								'value' => 'meta_box'
							)
						),

						array(
							'type' => 'checkbox',
							'heading' => '',
							'param_name' => 'content_filter',
							'description' => '',
							'value' => array( __( 'Retain content formatting from source', 'wppm' ) => 'true' ),
							'description' => __( 'Enabling this option will retain p and br tags coming from source.', 'wppm' ),
							'group' => __( 'Content', 'wppm' ),
							'dependency' => array(
								'element' => 'psource',
								'value' => array( 'custom_field', 'meta_box' )
							)
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Custom field key name', 'wppm' ),
							'param_name' => 'cust_field_key',
							'value' => '',
							'description' => __( 'Provide custom field key name. E.g. my_content', 'wppm' ),
							'group' => __( 'Content', 'wppm' ),
							'dependency' => array(
								'element' => 'psource',
								'value' => array( 'meta_box', 'custom_field' )
							)
						),

						array(
							'type' => 'dropdown',
							'heading' => __( 'Post text tag', 'wppm' ),
							'param_name' => 'ptag',
							'value' => array( 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'p', 'span', 'div' ),
							'std' => 'p',
							'description' => __( 'Select html tag for post text.', 'wppm' ),
							'group' => __( 'Content', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'dropdown',
							'heading' => __( 'Post text font size', 'wppm' ),
							'param_name' => 'psize',
							'value' => array(
										'11px' => '11',
										'12px' => '12',
										'13px' => '13',
										'14px' => '14',
										'16px' => '16',
										__( 'Custom', 'wppm' ) => 'custom'
									),
							'std' => '13',
							'description' => __( 'Select a font size for post text.', 'wppm' ),
							'group' => __( 'Content', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Post text font size (custom)', 'wppm' ),
							'param_name' => 'psize_c',
							'value' => '',
							'description' => __( 'Custom font size for post text in px, em, rem, etc. E.g. 1.5em', 'wppm' ),
							'group' => __( 'Content', 'wppm' ),
							'dependency' => array(
								'element' => 'psize',
								'value' => 'custom'
							),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Post text line height (custom)', 'wppm' ),
							'param_name' => 'pline_height_c',
							'value' => '',
							'description' => __( 'Line height for the custom post text font size. (Generally without unit). E.g. 1.5', 'wppm' ),
							'group' => __( 'Content', 'wppm' ),
							'dependency' => array(
								'element' => 'psize',
								'value' => 'custom'
							),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'dropdown',
							'heading' => __( 'Post text align', 'wppm' ),
							'param_name' => 'palign',
							'value' => array(
										__( 'Inherit', 'wppm' ) => 'inherit',
										__( 'Left', 'wppm' ) => 'left',
										__( 'Right', 'wppm' ) => 'right',
										__( 'Center', 'wppm' ) => 'center',
										__( 'Justify', 'wppm' ) => 'justify'
									),
							'std' => 'inherit',
							'description' => __( 'Select text alignment for post excerpt.', 'wppm' ),
							'group' => __( 'Content', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
						),

						array(
							'type' => 'textfield_num',
							'heading' => __( 'Post text length', 'wppm' ),
							'param_name' => 'excerpt_length',
							'value' => '10',
							'min' => '1',
							'max' => '500',
							'std' => '10',
							'description' => __( 'Post text length in words. E.g. 10', 'wppm' ),
							'group' => __( 'Content', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'dropdown',
							'heading' => __( 'Post meta align', 'wppm' ),
							'param_name' => 'meta_align',
							'value' => array(
										__( 'Inherit', 'wppm' ) => 'inherit',
										__( 'Left', 'wppm' ) => 'left',
										__( 'Right', 'wppm' ) => 'right',
										__( 'Center', 'wppm' ) => 'center',
										__( 'Reverse', 'wppm' ) => 'reverse'
									),
							'std' => 'inherit',
							'description' => __( 'Select alignment for category links and post meta (date, author, comments, etc.)', 'wppm' ),
							'group' => __( 'Content', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
						),

						array(
							'type' => 'checkbox',
							'heading' => '',
							'param_name' => 'masonry',
							'description' => '',
							'value' => array( __( 'Enable masonry layout', 'wppm' ) => 'true' ),
							'group' => __( 'Content', 'wppm' ),
							'dependency' => array(
								'element' => 'template',
								'value' => array( 'grid', 'portfolio', 'card', 'teaser' )
							),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'checkbox',
							'heading' => '',
							'param_name' => 'ext_link',
							'description' => __( 'Enabling this option will take external link from the post custom field \'wppm_custom_link\'', 'wppm' ),
							'value' => array( __( 'External link', 'wppm' ) => 'true' ),
							'group' => __( 'Content', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'checkbox',
							'heading' => '',
							'param_name' => 'readmore',
							'description' => '',
							'value' => array( __( 'Show readmore link', 'wppm' ) => 'true' ),
							'group' => __( 'Content', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Readmore text', 'wppm' ),
							'param_name' => 'readmore_text',
							'value' => 'Read more',
							'description' => __( 'Custom text for the readmore link.', 'wppm' ),
							'group' => __( 'Content', 'wppm' ),
							'dependency' => array(
								'element' => 'readmore',
								'value' => 'true'
							),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'dropdown',
							'heading' => __( 'Readmore link source', 'wppm' ),
							'param_name' => 'readmore_link_src',
							'value' => array(
									esc_attr__( 'Post Permalink', 'wppm' ) => 'permalink',
									esc_attr__( 'External link (Custom Field)', 'wppm' ) => 'ext',
									esc_attr__( 'Custom URL', 'wppm' ) => 'custom'
							),
							'std' => 'permalink',
							'description' => __( 'Choose a source for readmore link', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Content', 'wppm' ),
							'dependency' => array(
								'element' => 'readmore',
								'value' => 'true'
							)
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Custom link URL', 'wppm' ),
							'param_name' => 'readmore_cust_link',
							'value' => '',
							'description' => __( 'Custom URL for readmore link', 'wppm' ),
							'group' => __( 'Content', 'wppm' ),
							'dependency' => array(
								'element' => 'readmore_link_src',
								'value' => 'custom'
							),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'checkbox',
							'heading' => '',
							'param_name' => 'readmore_target_blank',
							'description' => '',
							'value' => array( __( 'Open link in new tab', 'wppm' ) => 'true' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Content', 'wppm' ),
							'dependency' => array(
								'element' => 'readmore',
								'value' => 'true'
							)
						),

						array(
							'type' => 'checkbox',
							'heading' => '',
							'param_name' => 'hide_cats',
							'description' => '',
							'value' => array( __( 'Hide category links', 'wppm' ) => 'true' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Content', 'wppm' )
						),

						array(
							'type' => 'checkbox',
							'heading' => '',
							'param_name' => 'hide_author',
							'description' => '',
							'value' => array( __( 'Hide author link', 'wppm' ) => 'true' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Content', 'wppm' ),
						),

						array(
							'type' => 'checkbox',
							'heading' => '',
							'param_name' => 'hide_date',
							'description' => '',
							'value' => array( __( 'Hide post date', 'wppm' ) => 'true' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Content', 'wppm' ),
						),

						array(
							'type' => 'checkbox',
							'heading' => '',
							'param_name' => 'hide_excerpt',
							'description' => '',
							'value' => array( __( 'Hide post excerpt', 'wppm' ) => 'true' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Content', 'wppm' ),
						),

						array(
							'type' => 'checkbox',
							'heading' => '',
							'param_name' => 'hide_comments',
							'description' => '',
							'value' => array( __( 'Hide comments link', 'wppm' ) => 'true' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Content', 'wppm' ),
						),

						array(
							'type' => 'checkbox',
							'heading' => '',
							'param_name' => 'hide_views',
							'description' => '',
							'value' => array( __( 'Hide number of views', 'wppm' ) => 'true' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Content', 'wppm' ),
						),

						array(
							'type' => 'checkbox',
							'heading' => '',
							'param_name' => 'hide_reviews',
							'description' => '',
							'value' => array( __( 'Hide review stars', 'wppm' ) => 'true' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Content', 'wppm' ),
						),

						// Show / hide in sub tiles
						array(
							'type' => 'checkbox',
							'heading' => '',
							'param_name' => 'readmore_sub',
							'description' => '',
							'value' => array( __( 'Show readmore link in sub tiles', 'wppm' ) => 'true' ),
							'group' => __( 'Content', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'dependency' => array(
								'element' => 'template',
								'value' => 'tile'
							)
						),

						array(
							'type' => 'checkbox',
							'heading' => '',
							'param_name' => 'hide_cats_sub',
							'description' => '',
							'value' => array( __( 'Hide category links in sub tiles', 'wppm' ) => 'true' ),
							'std' => 'true',
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Content', 'wppm' ),
							'dependency' => array(
								'element' => 'template',
								'value' => 'tile'
							)
						),

						array(
							'type' => 'checkbox',
							'heading' => '',
							'param_name' => 'hide_author_sub',
							'description' => '',
							'value' => array( __( 'Hide author link in sub tiles', 'wppm' ) => 'true' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Content', 'wppm' ),
							'dependency' => array(
								'element' => 'template',
								'value' => 'tile'
							)
						),

						array(
							'type' => 'checkbox',
							'heading' => '',
							'param_name' => 'hide_date_sub',
							'description' => '',
							'value' => array( __( 'Hide post date in sub tiles', 'wppm' ) => 'true' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Content', 'wppm' ),
							'dependency' => array(
								'element' => 'template',
								'value' => 'tile'
							)
						),

						array(
							'type' => 'checkbox',
							'heading' => '',
							'param_name' => 'hide_comments_sub',
							'description' => '',
							'value' => array( __( 'Hide comments link in sub tiles', 'wppm' ) => 'true' ),
							'std' => 'true',
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Content', 'wppm' ),
							'dependency' => array(
								'element' => 'template',
								'value' => 'tile'
							)
						),

						array(
							'type' => 'checkbox',
							'heading' => '',
							'param_name' => 'hide_views_sub',
							'description' => '',
							'value' => array( __( 'Hide number of views in sub tiles', 'wppm' ) => 'true' ),
							'std' => 'true',
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Content', 'wppm' ),
							'dependency' => array(
								'element' => 'template',
								'value' => 'tile'
							)
						),

						array(
							'type' => 'checkbox',
							'heading' => '',
							'param_name' => 'hide_reviews_sub',
							'description' => '',
							'value' => array( __( 'Hide review stars in sub tiles', 'wppm' ) => 'true' ),
							'std' => 'true',
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Content', 'wppm' ),
							'dependency' => array(
								'element' => 'template',
								'value' => 'tile'
							)
						),

						array(
							'type' => 'checkbox',
							'heading' => '',
							'param_name' => 'hide_thumbnail',
							'description' => '',
							'value' => array( __( 'Hide thumbnail', 'wppm' ) => 'true' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Content', 'wppm' ),
							'dependency' => array(
								'element' => 'template',
								'value_not_equal_to' => array( 'portfolio', 'tile' )
							)
						),

						array(
							'type' => 'checkbox',
							'heading' => '',
							'param_name' => 'hide_post_format_icon',
							'description' => '',
							'value' => array( __( 'Hide post format icon', 'wppm' ) => 'true' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Content', 'wppm' ),
						),

						array(
							'type' => 'checkbox',
							'heading' => '',
							'param_name' => 'show_avatar',
							'description' => '',
							'value' => array( __( 'Show author avatar in meta', 'wppm' ) => 'true' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Content', 'wppm' ),
							'dependency' => array(
								'element' => 'template',
								'value_not_equal_to' => array( 'portfolio', 'tile' )
							)
						),

						array(
							'type' => 'checkbox',
							'param_name' => 'custom_meta',
							'value' => array( __( 'Use custom post meta format', 'wppm' ) => 'true' ),
							'group' => __( 'Display', 'wppm' ),
							'group' => __( 'Content', 'wppm' ),
							'dependency' => array(
								'element' => 'template',
								'value_not_equal_to' => array( 'ticker' )
							)
						),

						array(
							'type' => 'textarea_raw_html',
							'heading' => __( 'Custom meta format', 'wppm' ),
							'param_name' => 'meta_format',
							'value' => '',
							'description' => __( 'Use %1$s, %2$s, %3$s, %4$s, %5$s and %6$s for Author, Date, Updated date, Categories, Comment Count, and Permalink respectively. E.g. Posted by %1$s on %2$s in %4$s', 'wppm' ),
							'group' => __( 'Content', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'dependency' => array(
								'element' => 'custom_meta',
								'value' => 'true'
							)
						),

						array(
							'type' => 'dropdown',
							'heading' => __( 'Custom Meta Position', 'wppm' ),
							'param_name' => 'meta_pos',
							'value' => array(
									esc_attr__( 'Before Title', 'wppm' ) => '1',
									esc_attr__( 'After Title', 'wppm' ) => '2',
									esc_attr__( 'After Excerpt', 'wppm' ) => '3'
							),
							'std' => '1',
							'description' => __( 'Select position for meta placement.', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Content', 'wppm' ),
							'dependency' => array(
								'element' => 'custom_meta',
								'value' => 'true'
							)
						),

						// Colors
						array(
							'type' => 'colorpicker',
							'class' => '',
							'heading' => __( 'Title heading color', 'wppm' ),
							'param_name' => 'heading_color',
							'value' => '',
							'description' => __( 'Choose color for title heading', 'wppm' ),
							'group' => __( 'Colors', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'colorpicker',
							'class' => '',
							'heading' => __( 'Title heading hover color', 'wppm' ),
							'param_name' => 'heading_color_hover',
							'value' => '',
							'description' => __( 'Choose hover color for title heading', 'wppm' ),
							'group' => __( 'Colors', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'colorpicker',
							'class' => '',
							'heading' => __( 'Post excerpt color', 'wppm' ),
							'param_name' => 'text_color',
							'value' => '',
							'description' => __( 'Choose color for post excerpt', 'wppm' ),
							'group' => __( 'Colors', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'colorpicker',
							'class' => '',
							'heading' => __( 'Category links color', 'wppm' ),
							'param_name' => 'cat_color',
							'value' => '',
							'description' => __( 'Choose foreground color for category links', 'wppm' ),
							'group' => __( 'Colors', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'colorpicker',
							'class' => '',
							'heading' => __( 'Category links background', 'wppm' ),
							'param_name' => 'cat_bg',
							'value' => '',
							'description' => __( 'Choose background color for category links', 'wppm' ),
							'group' => __( 'Colors', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'colorpicker',
							'class' => '',
							'heading' => __( 'Category links hover color', 'wppm' ),
							'param_name' => 'cat_color_hover',
							'value' => '',
							'description' => __( 'Choose foreground hover color for category links', 'wppm' ),
							'group' => __( 'Colors', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'colorpicker',
							'class' => '',
							'heading' => __( 'Category links hover background', 'wppm' ),
							'param_name' => 'cat_bg_hover',
							'value' => '',
							'description' => __( 'Choose hover background color for category links', 'wppm' ),
							'group' => __( 'Colors', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'colorpicker',
							'class' => '',
							'heading' => __( 'Ticker label background', 'wppm' ),
							'param_name' => 'ticker_bg',
							'value' => '',
							'description' => __( 'Choose background color for ticker label.', 'wppm' ),
							'group' => __( 'Colors', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'colorpicker',
							'class' => '',
							'heading' => __( 'Ticker label foreground color', 'wppm' ),
							'param_name' => 'ticker_clr',
							'value' => '',
							'description' => __( 'Choose foreground color for ticker label.', 'wppm' ),
							'group' => __( 'Colors', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						// Schema Options
						array(
							'type' => 'checkbox',
							'heading' => __( 'Enable Schema', 'wppm' ),
							'param_name' => 'enable_schema',
							'description' => __( 'Upon enabling this option, you can set schema type and properties for post elements. Schema properties can be found on schema.org website.', 'wppm' ),
							'value' => array( __( 'Enable schema markup on generated posts', 'wppm' ) => 'true' ),
							'group' => __( 'Schema', 'wppm' )
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Post item container type', 'wppm' ),
							'param_name' => 'container_type',
							'value' => 'BlogPosting',
							'description' => __( 'The parent schema type of post item. E.g. Recipe, or NutritionInformation', 'wppm' ),
							'group' => __( 'Schema', 'wppm' ),
							'dependency' => array(
								'element' => 'enable_schema',
								'value' => 'true'
							)
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Post item container property', 'wppm' ),
							'param_name' => 'container_prop',
							'value' => 'blogPost',
							'description' => __( 'The parent schema property of post item. E.g. nutrition', 'wppm' ),
							'group' => __( 'Schema', 'wppm' ),
							'dependency' => array(
								'element' => 'enable_schema',
								'value' => 'true'
							)
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Post title property', 'wppm' ),
							'param_name' => 'heading_prop',
							'value' => 'headline mainEntityOfPage',
							'description' => __( 'The schema property of post title. E.g. name', 'wppm' ),
							'group' => __( 'Schema', 'wppm' ),
							'dependency' => array(
								'element' => 'enable_schema',
								'value' => 'true'
							)
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Post excerpt property', 'wppm' ),
							'param_name' => 'excerpt_prop',
							'value' => 'text',
							'description' => __( 'The schema property of post excerpt. E.g. description', 'wppm' ),
							'group' => __( 'Schema', 'wppm' ),
							'dependency' => array(
								'element' => 'enable_schema',
								'value' => 'true'
							)
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Post creation date property', 'wppm' ),
							'param_name' => 'datecreated_prop',
							'value' => 'datePublished',
							'description' => __( 'The schema property of post creation date. E.g. productionDate', 'wppm' ),
							'group' => __( 'Schema', 'wppm' ),
							'dependency' => array(
								'element' => 'enable_schema',
								'value' => 'true'
							)
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Post modified date property', 'wppm' ),
							'param_name' => 'datemodified_prop',
							'value' => 'dateModified',
							'description' => __( 'The schema property of post creation date. E.g. releaseDate', 'wppm' ),
							'group' => __( 'Schema', 'wppm' ),
							'dependency' => array(
								'element' => 'enable_schema',
								'value' => 'true'
							)
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Post publisher type', 'wppm' ),
							'param_name' => 'publisher_type',
							'value' => 'Organization',
							'description' => __( 'The schema type of publisher. E.g. Person, or Organization', 'wppm' ),
							'group' => __( 'Schema', 'wppm' ),
							'dependency' => array(
								'element' => 'enable_schema',
								'value' => 'true'
							)
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Post Publisher property', 'wppm' ),
							'param_name' => 'publisher_prop',
							'value' => 'publisher',
							'description' => __( 'The schema property of publisher. E.g. parent, or funder', 'wppm' ),
							'group' => __( 'Schema', 'wppm' ),
							'dependency' => array(
								'element' => 'enable_schema',
								'value' => 'true'
							)
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Post Publisher name', 'wppm' ),
							'param_name' => 'publisher_name',
							'value' => esc_attr( get_bloginfo( 'name' ) ),
							'description' => __( 'The name of post publisher. If Organization, your site name is taken as default value. E.g. John Doe', 'wppm' ),
							'group' => __( 'Schema', 'wppm' ),
							'dependency' => array(
								'element' => 'enable_schema',
								'value' => 'true'
							)
						),

						array(
							'type' => 'attach_image',
							'heading' => __( 'Post Publisher logo', 'wppm' ),
							'param_name' => 'publisher_logo',
							'std' => plugin_dir_url( __FILE__ ) . 'assets/images/wppm.svg',
							'description' => __( 'The logo of publisher. In most cases, it will be your site logo, or can be a custom logo of your Organizatin.', 'wppm' ),
							'group' => __( 'Schema', 'wppm' ),
							'dependency' => array(
								'element' => 'enable_schema',
								'value' => 'true'
							)
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Author container type', 'wppm' ),
							'param_name' => 'authorbox_type',
							'value' => 'Person',
							'description' => __( 'The schema type of post Author. E.g. Person, or Brand', 'wppm' ),
							'group' => __( 'Schema', 'wppm' ),
							'dependency' => array(
								'element' => 'enable_schema',
								'value' => 'true'
							)
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Author container property', 'wppm' ),
							'param_name' => 'authorbox_prop',
							'value' => 'author',
							'description' => __( 'The schema property of post Author. E.g. alumni', 'wppm' ),
							'group' => __( 'Schema', 'wppm' ),
							'dependency' => array(
								'element' => 'enable_schema',
								'value' => 'true'
							)
						),


						array(
							'type' => 'textfield',
							'heading' => __( 'Author name property', 'wppm' ),
							'param_name' => 'authorname_prop',
							'value' => 'name',
							'description' => __( 'The schema property of post Author. E.g. alternateName', 'wppm' ),
							'group' => __( 'Schema', 'wppm' ),
							'dependency' => array(
								'element' => 'enable_schema',
								'value' => 'true'
							)
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Author avatar property', 'wppm' ),
							'param_name' => 'authoravatar_prop',
							'value' => 'image',
							'description' => __( 'The schema property of Author avatar. E.g. image', 'wppm' ),
							'group' => __( 'Schema', 'wppm' ),
							'dependency' => array(
								'element' => 'enable_schema',
								'value' => 'true'
							)
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Post categories property', 'wppm' ),
							'param_name' => 'category_prop',
							'value' => 'about',
							'description' => __( 'The schema property of post categories. E.g. genre', 'wppm' ),
							'group' => __( 'Schema', 'wppm' ),
							'dependency' => array(
								'element' => 'enable_schema',
								'value' => 'true'
							)
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Post comments count property', 'wppm' ),
							'param_name' => 'commentcount_prop',
							'value' => 'commentCount',
							'description' => __( 'The schema property of comment count. E.g. upvoteCount', 'wppm' ),
							'group' => __( 'Schema', 'wppm' ),
							'dependency' => array(
								'element' => 'enable_schema',
								'value' => 'true'
							)
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Post comments URL property', 'wppm' ),
							'param_name' => 'commenturl_prop',
							'value' => 'discussionUrl',
							'description' => __( 'The schema property of comments URL. E.g. replyToUrl', 'wppm' ),
							'group' => __( 'Schema', 'wppm' ),
							'dependency' => array(
								'element' => 'enable_schema',
								'value' => 'true'
							)
						),

						array(
							'type' => 'checkbox',
							'heading' => '',
							'param_name' => 'sharing',
							'description' => '',
							'value' => array( __( 'Enable social sharing for post modules', 'wppm' ) => 'true' ),
							'group' => __( 'Social', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'dropdown',
							'heading' => __( 'Share style', 'wppm' ),
							'param_name' => 'share_style',
							'value' => array(
								__( 'Popup', 'wppm' ) => 'popup',
								__( 'Inline', 'wppm' ) => 'inline'
							),
							'std' => '',
							'description' => __( 'Select a style for social sharing buttons', 'wppm' ),
							'group' => __( 'Social', 'wppm' ),
							'dependency' => array(
								'element' => 'sharing',
								'value' => 'true'
							),
						),

						array(
							'type' => 'dropdown_multiple',
							'heading' => __( 'Social sharing buttons', 'wppm' ),
							'param_name' => 'share_btns',
							'value' => array(
								__( 'Twitter', 'wppm' ) => 'twitter',
								__( 'Facebook', 'wppm' ) => 'facebook',
								__( 'Whatsapp', 'wppm' ) => 'whatsapp',
								__( 'Google Plus', 'wppm' ) => 'googleplus',
								__( 'LinkedIn', 'wppm' ) => 'linkedin',
								__( 'Pinterest', 'wppm' ) => 'pinterest',
								__( 'VK Ontakte', 'wppm' ) => 'vkontakte',
								__( 'Line', 'wppm' ) => 'line',
								__( 'Reddit', 'wppm' ) => 'reddit',
								__( 'E Mail', 'wppm' ) => 'email',

							),
							'description' => __( 'Select social share buttons. Use Ctrl + Select or Command + select for mutiple selection.', 'wppm' ),
							'std' => '',
							'dependency' => array(
								'element' => 'sharing',
								'value' => 'true'
							),
							'group' => __( 'Social', 'wppm' )
						),

						array(
							'type' => 'checkbox',
							'heading' => '',
							'param_name' => 'sc_btn',
							'description' => __( 'Enabling this option will display a button on front end for logged in users. Clicking on the button will show generated shortcode for this post module.', 'wppm' ),
							'value' => array( __( 'Enable "Get Shortcode" button on front end', 'wppm' ) => 'true' ),
							'group' => __( 'Shortcode', 'wppm' )
						),

						array(
							'type' => 'textfield_num',
							'heading' => __( 'Show advertisement after every xx posts', 'wppm' ),
							'param_name' => 'ad_offset',
							'value' => '3',
							'min' => '1',
							'max' => '999',
							'description' => __( 'For example, if this number is 3, advertisements will be inserted after every multiple of 3 posts -- 3,6,9,12 and so on.', 'wppm' ),
							'group' => __( 'Advertisements', 'wppm' )
						),

						// Advertisements Tab
						array(
							'type' => 'param_group',
							'heading' => __( 'Add advertisements', 'wppm' ),
							'value' => urlencode( json_encode( array(
											array(
												'ad_code' => ''
												)
											)
										)
									),
							'param_name' => 'ad_list',
							// Sub params of a group item
							'params' => array(
								array(
									'type' => 'textarea',
									'heading' => __( 'Advertisement Code', 'wppm' ),
									'param_name' => 'ad_code',
									'value' => '',
									'description' => __( 'Provide advertisement code. It can be Google ad code or any similar code for advertisements.', 'wppm' )
								)
							),
							'group' => __( 'Advertisements', 'wppm' ),
							'description' => __( 'Add advertisements to be inserted between posts. You can add any number of advertisements. The markup can contain HTML, iframe code, Google ad code, YouTube video embed, etc.', 'wppm' ),
							'dependency' => array(
								'element' => 'template',
								'value' => array( 'grid', 'list', 'portfolio', 'card', 'teaser' )
							)
						),

						array(
							'type' => 'css_editor',
							'heading' => __( 'Css', 'wppm' ),
							'param_name' => 'css',
							'group' => __( 'Design options', 'wppm' ),
						),
					) // params
				) // vc_map array
			); // vc_map

			vc_map(
				array(
					'name' => __( 'WPPM Tabs', 'wppm' ),
					'base' => 'wppm_tabs',
					'icon' =>  plugin_dir_url( __FILE__ ) . 'assets/images/wppm_tabs.svg',
					'is_container' => true,
					'show_settings_on_create' => false,
					'as_parent' => array(
						'only' => 'wppm_tab',
					),
					'content_element' => true,
					'category' => __( 'Content', 'wppm' ),
					'description' => __( 'Create tabbed content with ajax loading', 'wppm' ),
					'params' => array(

						// General Tab
						array(
							'type' => 'checkbox',
							'heading' => '',
							'param_name' => 'center',
							'description' => '',
							'value' => array( __( 'Enable center aligned tab items', 'wppm' ) => 'true' ),
							'group' => __( 'General', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Extra CSS Class', 'wppm' ),
							'param_name' => 'xclass',
							'value' => '',
							'description' => __( 'Any extra class you wish to add to the tabs container. You can add multiple classes by separating them with one space. E.g. no-border', 'wppm' ),
							'group' => __( 'General', 'wppm' )
						)
					),
					'js_view' => 'VcColumnView'
				) // wppm_tabs
			); // vc_map

			vc_map( array(
					'name' => __( 'WPPM Tab', 'wppm' ),
					'base' => 'wppm_tab',
					'icon' =>  plugin_dir_url( __FILE__ ) . 'assets/images/wppm_tab.svg',
					'description' => __( 'Create tab item for the tabs container', 'wppm' ),
					'content_element' => true,
					'is_container' => true,
					'show_settings_on_create' => false,
					'as_parent' => array(
						'except' => 'wppm_tabs',
					),
					'as_child' => array( 'only' => 'wppm_tabs' ),
					'show_settings_on_create' => true,
					'params' => array(
						array(
							'type' => 'textfield',
							'heading' => __( 'Tab Title', 'wppm' ),
							'param_name' => 'title',
							'description' => __( 'Provide a tab title', 'wppm' ),
							'group' => __( 'General', 'wppm' )
						),

						array(
							'type' => 'checkbox',
							'heading' => '',
							'param_name' => 'ajax',
							'description' => '',
							'value' => array( __( 'Enable ajax loading on tab content', 'wppm' ) => 'true' ),
							'group' => __( 'General', 'wppm' )
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Extra CSS Class', 'wppm' ),
							'param_name' => 'xclass',
							'value' => '',
							'description' => __( 'Any extra class you wish to add to the tabs container. You can add multiple classes by separating them with one space. E.g. no-border', 'wppm' ),
							'group' => __( 'General', 'wppm' )
						)
					),
					'js_view' => 'VcColumnView'
				) // wppm_tab
			);	// vc_map

			vc_map( array(
					'name' => __( 'WPPM Title', 'wppm' ),
					'base' => 'wppm_title',
					'icon' =>  plugin_dir_url( __FILE__ ) . 'assets/images/wppm_title.svg',
					'description' => __( 'Content title headings in style', 'wppm' ),
					'params' => array(
						array(
							'type' => 'textfield',
							'heading' => __( 'Title Text', 'wppm' ),
							'param_name' => 'text',
							'description' => __( 'Provide title text', 'wppm' ),
							'group' => __( 'General', 'wppm' )
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Link URL', 'wppm' ),
							'param_name' => 'link',
							'description' => __( 'Provide a link URL for the text', 'wppm' ),
							'group' => __( 'General', 'wppm' )
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Link title attribute', 'wppm' ),
							'param_name' => 'link_title',
							'description' => __( 'Provide a title attribute for the link', 'wppm' ),
							'group' => __( 'General', 'wppm' )
						),

						array(
							'type' => 'checkbox',
							'heading' => '',
							'param_name' => 'target',
							'description' => '',
							'value' => array( __( 'Open link in new tab', 'wppm' ) => 'true' ),
							'group' => __( 'General', 'wppm' )
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Secondary Text', 'wppm' ),
							'param_name' => 'sub_text',
							'description' => __( 'Provide a secondary text for the main text', 'wppm' ),
							'group' => __( 'General', 'wppm' )
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Secondary Link URL', 'wppm' ),
							'param_name' => 'sub_link',
							'description' => __( 'Provide a link URL for the text', 'wppm' ),
							'group' => __( 'General', 'wppm' )
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Sub Link title attribute', 'wppm' ),
							'param_name' => 'sub_link_title',
							'description' => __( 'Provide a title attribute for the secondary link', 'wppm' ),
							'group' => __( 'General', 'wppm' )
						),

						array(
							'type' => 'checkbox',
							'heading' => '',
							'param_name' => 'sub_target',
							'description' => '',
							'value' => array( __( 'Open secondary link in new tab', 'wppm' ) => 'true' ),
							'group' => __( 'General', 'wppm' )
						),

						array(
							'type' => 'dropdown',
							'heading' => __( 'Font Family', 'wppm' ),
							'param_name' => 'font_family',
							'value' => $google_font_list,
							'std' => '',
							'description' => __( 'Select font family for the title', 'wppm' ),
							'group' => __( 'Display', 'wppm' )
						),

						array(
							'type' => 'dropdown',
							'heading' => __( 'Title Tag', 'wppm' ),
							'param_name' => 'htag',
							'value' => array( 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'p', 'span', 'div' ),
							'std' => 'h2',
							'description' => __( 'Select a tag for title container', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Display', 'wppm' )
						),

						array(
							'type' => 'dropdown',
							'heading' => __( 'Font Size', 'wppm' ),
							'param_name' => 'hsize',
							'value' => array(
									'12px' => '12',
									'13px' => '13',
									'14px' => '14',
									'16px' => '16',
									'18px' => '18',
									'20px' => '20',
									'24px' => '24',
									'Custom' => 'custom'
								),
							'std' => '14',
							'description' => __( 'Select a font size for the title', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Display', 'wppm' )
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Title font size (custom)', 'wppm' ),
							'param_name' => 'hsize_c',
							'value' => '',
							'description' => __( 'Custom font size for title in px, em, rem, etc. E.g. 1.5em', 'wppm' ),
							'group' => __( 'Display', 'wppm' ),
							'dependency' => array(
								'element' => 'hsize',
								'value' => 'custom'
							),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Title Line Height', 'wppm' ),
							'param_name' => 'hlineheight',
							'value' => '',
							'description' => __( 'Line height for the title.', 'wppm' ),
							'group' => __( 'Display', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Font Weight', 'wppm' ),
							'param_name' => 'title_weight',
							'description' => __( 'The font weight. E.g. 300, or Bold', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Display', 'wppm' )
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Secondary Text Font Size', 'wppm' ),
							'param_name' => 'stsize',
							'value' => '',
							'description' => __( 'Font size for secondary text in px, em, rem, etc. E.g. 1.5em', 'wppm' ),
							'group' => __( 'Display', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Secondary Text Line Height', 'wppm' ),
							'param_name' => 'stlineheight',
							'value' => '',
							'description' => __( 'Line height for the secondary Text.', 'wppm' ),
							'group' => __( 'Display', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Secondary Text Font Weight', 'wppm' ),
							'param_name' => 'stweight',
							'description' => __( 'The font weight. E.g. 300, or Bold', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Display', 'wppm' )
						),

						array(
							'type' => 'colorpicker',
							'class' => '',
							'heading' => __( 'Title Color', 'wppm' ),
							'param_name' => 'title_color',
							'value' => '',
							'description' => __( 'Choose color', 'wppm' ),
							'group' => __( 'Display', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'colorpicker',
							'class' => '',
							'heading' => __( 'Secondary Text Color', 'wppm' ),
							'param_name' => 'stcolor',
							'value' => '',
							'description' => __( 'Choose color', 'wppm' ),
							'group' => __( 'Display', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column'
						),

						array(
							'type' => 'dropdown',
							'heading' => __( 'Bottom Margin', 'wppm' ),
							'param_name' => 'margin_btm',
							'value' => array(
									__( 'Theme Defined', 'wppm' ) => 'theme_defined',
									'0px' => '0',
									'2px' => '2',
									'4px' => '4',
									'6px' => '6',
									'8px' => '8',
									'10px' => '10',
									'12px' => '12',
									'16px' => '16',
									'20px' => '20',
									'24px' => '24',
									'30px' => '30',
									'32px' => '32',
									'36px' => '36',
									'40px' => '40',
									'50px' => '50',
									'60px' => '60',
									'70px' => '70'
								),
							'std' => 'theme_defined',
							'description' => __( 'Select a bottom margin for the heading', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Display', 'wppm' )
						),

						array(
							'type' => 'dropdown',
							'heading' => __( 'Title Style', 'wppm' ),
							'param_name' => 'style',
							'value' => array(
										__( 'Plain', 'wppm' ) => 'plain',
										__( 'Flag', 'wppm' ) => 'flag',
										__( 'Label', 'wppm' ) => 'label',
										__( 'Bordered', 'wppm' ) => 'bordered',
										__( 'Bar', 'wppm' ) => 'bar',
									),
							'std' => 'plain',
							'description' => __( 'Select a display style for title', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Display', 'wppm' )
						),

						array(
							'type' => 'dropdown',
							'heading' => __( 'Title Background Color', 'wppm' ),
							'param_name' => 'color',
							'value' => array(
										__( 'Default', 'wppm' ) => 'default',
										__( 'Aqua', 'wppm' ) => 'aqua',
										__( 'Blue', 'wppm' ) => 'blue',
										__( 'Brown', 'wppm' ) => 'brown',
										__( 'Cyan', 'wppm' ) => 'cyan',
										__( 'Dark Blue', 'wppm' ) => 'dark-blue',
										__( 'Deep Orange', 'wppm' ) => 'deep-orange',
										__( 'Green', 'wppm' ) => 'green',
										__( 'Grey', 'wppm' ) => 'grey',
										__( 'Indigo', 'wppm' ) => 'indigo',
										__( 'Orange', 'wppm' ) => 'orange',
										__( 'Pink', 'wppm' ) => 'pink',
										__( 'Red', 'wppm' ) => 'red',
										__( 'Teal', 'wppm' ) => 'teal'
									),
							'std' => 'flag',
							'description' => __( 'Select a display style for title', 'wppm' ),
							'edit_field_class' => 'vc_col-sm-6 vc_column',
							'group' => __( 'Display', 'wppm' )
						),

						array(
							'type' => 'checkbox',
							'heading' => '',
							'param_name' => 'round_corner',
							'description' => '',
							'value' => array( __( 'Enable round corners on the heading', 'wppm' ) => 'true' ),
							'group' => __( 'Display', 'wppm' )
						),

						array(
							'type' => 'textfield',
							'heading' => __( 'Extra CSS class', 'wppm' ),
							'param_name' => 'xclass',
							'description' => __( 'Any extra class you wish to add to the heading container', 'wppm' ),
							'group' => __( 'Display', 'wppm' )
						)
					)
				) // wppm_title
			);	// vc_map
		}

		// Return ajax tab content
		function wppm_tabs_action_callback() {
			$content = isset( $_POST ) && $_POST['wppm_tab_content'] ? $_POST['wppm_tab_content'] : '';
			//WPBMap::addAllMappedShortcodes();
			echo do_shortcode( stripslashes( $content ) );
			wp_die();
		}

		// Return ajax next/prev content
		function wppm_ajaxnav_action_callback() {
			$content = isset( $_POST ) && $_POST['wppm_ajaxnav_content'] ? $_POST['wppm_ajaxnav_content'] : '';
			echo do_shortcode( stripslashes( $content ) );
			wp_die();
		}

		// Row Shortcode
		function wppm_row( $atts, $content = null ) {
			extract( shortcode_atts( array(
				'xclass'	=> false
			), $atts ) );

			return sprintf( '<div class="wppm-row clearfix%s">%s</div>',
				$xclass ? ' ' . esc_attr( $xclass ) : '',
				wppm_clean( $content )
			);
		}

		// Row Shortcode
		function wppm_col( $atts, $content = null ) {
			extract( shortcode_atts( array(
				'type'		=> '100',
				'xclass'	=> false
			), $atts ) );

			return sprintf( '<div class="wppm-col wppm-col-%s%s">%s</div>',
				$type ? esc_attr( $type ) : '',
				$xclass ? ' ' . esc_attr( $xclass ) : '',
				wppm_clean( $content )
			);
		}

		// Posts Shortcode
		function wppm_shortcode( $atts ) {
			extract( shortcode_atts( array(
				// WP Query Specific
				'author_name' 			=> null,
				'author__in' 			=> null,
				'cat' 					=> null,
				'category_name' 		=> null,
				'tag' 					=> null,
				'tag_id' 				=> null,
				'taxonomy' 				=> 'category',
				'relation'				=> 'OR',
				'operator'				=> 'IN',
				'terms'					=> '',
				'p' 					=> null,
				'name' 					=> null,
				'page_id' 				=> null,
				'pagename' 				=> null,
				'post__in' 				=> null,
				'post__not_in' 			=> null,
				'post_type' 			=> 'post',
				'post_status' 			=> 'publish',
				'num' 					=> 6,
				'offset' 				=> 0,
				'ignore_sticky_posts' 	=> false,
				'order' 				=> 'DESC',
				'orderby' 				=> 'date',
				'year' 					=> null,
				'monthnum' 				=> null,
				'w' 					=> null,
				'day'					=> null,
				'meta_key' 				=> null,
				'meta_value'			=> null,
				'meta_value_num' 		=> null,
				'meta_compare' 			=> '=',
				's' 					=> null,

				// Date parameters
				'year'					=> '',
				'month'					=> '',
				'week'					=> '',
				'day'					=> '',
				'before'				=> '', // Date before
				'after'					=> '', // Date after
				'date_query'			=> null,


				'single_cat_filter'		=> false,

				// Should append or override the single cat filter
				// Override by default (false)
				'single_cat_filter_append'		=> false,
				'single_tag_filter'		=> false,
				'hide_current_post'		=> false,
				'taxonomy_optional'		=> '',
				'blog_id'				=> null,
				'template'				=> 'grid',
				'masonry'				=> false,
				'sub_type'				=> 's1',
				'sub_type_grid'			=> 's1',
				'list_split'			=> '25-75',    //10-90, 20-80, 25-75, 30-70, 33-66, 40-60, 50-50, 60-40
				'grid_split'			=> '33-66',    //10-90, 20-80, 25-75, 30-70, 33-66, 40-60, 50-50
				'list_sep'				=> 'content-border',	// no-border, full-border
				'content_left'			=> false,
				'counter'				=> false,
				'mobile_wide'			=> false,
				'circle_img'			=> false,
				'sub_type_tile'			=> 's1',
				'columns'				=> '3',
				'list_columns'			=> '1',
				'excerpt_length'		=> '10',
				'h_length'				=> '',
				'readmore'				=> false,
				'readmore_text'			=> __( 'Read more', 'wppm' ),
				'hide_cats'				=> false,
				'hide_author'			=> false,
				'hide_date'				=> false,
				'hide_excerpt'			=> false,
				'hide_comments'			=> false,
				'hide_views'			=> false,
				'hide_reviews'			=> false,
				'hide_thumbnail'		=> false,
				'hide_post_format_icon'	=> false,
				'show_avatar'			=> false,
				'use_native_thumbs'		=> false,
				'enable_captions'		=> false,
				'imgsize'				=> 'full',
				'imgwidth'				=> '',
				'imgheight'				=> '',
				'imgcrop'				=> 'true',
				'imgquality'			=> '80',
				'imgcolor'				=> null,
				'imggrayscale'			=> false,
				'xclass'				=> false,
				'img_xclass'			=> false,
				'query'					=> false,
				'date_format'			=> '',
				'viewport_width'		=> 1192,
				'gutter_tile'			=> 4,
				'gutter_tile_c'			=> '',
				'gutter_grid'			=> 24,
				'gutter_grid_c'			=> '',
				'gutter_list'			=> '',
				'gutter_list_c'			=> '',
				'aspect_ratio'			=> 1.3333,
				'featured_label'		=> false,
				'htag'					=> 'h2',
				'ptag'					=> 'p',
				'hsize'					=> '',
				'hsize_c'				=> '',
				'halign'				=> 'inherit',
				'line_height_c'			=> '',
				'hfontweight'			=> '400',
				'psize'					=> '',
				'psize_c'				=> '',
				'pline_height_c'		=> '',
				'palign'				=> 'inherit',
				'tile_hsize'			=> false,
				'content_pos'			=> 'bl', 				// bl for bottom-left, tl for top-left
				'content_padding'		=> 20,					// Content padding for portfolio/tile layout
				'overlay_style'			=> 'scrim', 			// scrim, transparent, autobg
				'show_overlay'			=> 'always',			// always, never, onhover
				'image_effect'			=> 'none',				// none, zoomin, zoomout, zoominrotate

				// For sub tiles
				'hide_cats_sub' 		=> 'true',
				'hide_reviews_sub'		=> 'true',
				'hide_date_sub' 		=> false,
				'hide_author_sub' 		=> false,
				'show_avatar_sub' 		=> false,
				'hide_views_sub' 		=> 'true',
				'hide_comments_sub' 	=> 'true',
				'readmore_sub' 			=> false,
				'clickable_tile' 		=> false,

				// Slider params
				'slider_type'			=> 'grid',
				'enable_slider'			=> '',
				'card_equal_height'		=> '',
				'items'					=> '1',
				'loop'					=> 'false',
				'speed'					=> '300',
				'margin'				=> '24',
				'margin_mobile'			=> '16',
				'autoplay'				=> 'true',
				'timeout'				=> '5000',
				'autoheight'			=> 'false',
				'nav'					=> 'true',
				'dots'					=> 'false',
				'animatein'				=> false,
				'animateout'			=> false,
				'stagepadding'			=> 0,
				'data_props'			=> false,

				// Schema Params
				'enable_schema'			=> false,
				'container_type'		=> 'BlogPosting',
				'container_prop'		=> 'blogPost',
				'heading_prop'			=> 'headline mainEntityOfPage',
				'excerpt_prop'			=> 'text',
				'datecreated_prop'		=> 'datePublished',
				'datemodified_prop'		=> 'dateModified',
				'publisher_type'		=> 'Organization',
				'publisher_prop'		=> 'publisher',
				'publisher_name'		=> esc_attr( get_bloginfo( 'name' ) ),
				'publisher_logo'		=> plugin_dir_url( __FILE__ ) . 'assets/images/wppm.svg',
				'authorbox_type'		=> 'Person',
				'authorbox_prop'		=> 'author',
				'authorname_prop'		=> 'name',
				'authoravatar_prop'		=> 'image',
				'category_prop'			=> 'about',
				'commentcount_prop'		=> 'commentCount',
				'commenturl_prop'		=> 'discussionUrl',
				'ratingbox_type'		=> 'Rating',
				'rating_prop'			=> 'ratingValue',

				// Misc
				'ext_link'				=> false,
				'readmore_link_src' 	=> 'permalink',
				'readmore_cust_link' 	=> '',
				'readmore_target_blank'	=> false,
				'ajaxnav'				=> false,
				'nav_status'			=> false,
				'nav_status_text'		=> '%current% of %total%',
				'ajaxloadmore'			=> false,
				'loadmore_text'			=> __( 'Load more', 'wppm' ),
				'sharing'				=> false,
				'share_btns'			=> '',
				'share_style'			=> 'popup',
				'global_font'			=> '',
				'heading_font'			=> '',
				'css'					=> '',
				'cat_bg'				=> '',
				'cat_color'				=> '',
				'cat_bg_hover'			=> '',
				'cat_color_hover'		=> '',
				'heading_color'			=> '',
				'heading_color_hover'	=> '',
				'text_color'			=> '',
				'show_embed'			=> false,
				'custom_meta'			=> false,
				'meta_format'			=> '',
				'meta_pos'				=> 1,
				'sc_btn'				=> false,
				'mq_list'				=> '',
				'psource'				=> 'excerpt',
				'meta_box'				=> '',
				'h_meta_box'			=> '',
				'cust_field_key'		=> '',
				'hsource'				=> 'title',
				'h_cust_field_key'		=> '',
				'allowed_tags'			=> 'p,br,a,em,i,strong,b',
				'content_filter'		=> false,
				'ad_list'				=> '',
				'ad_offset'				=> '3',
				'meta_align'			=> 'inherit',

				// News Ticker
				'title_length'		=> '10',
				'ticker_label'		=> __( 'Breaking News', 'wppm' ),
				'duration'			=> 15000,
				'ticker_clr'		=> '',
				'ticker_bg'			=> ''
			), $atts ) );

			$extra_tax_query = '';
			$extra_taxonomy = array();
			$extra_terms = '';

			// Filter tags and categories for single posts
			if ( is_singular() ) {
				if ( $single_cat_filter || $single_tag_filter ) {
					global $post;

					if ( ! $single_cat_filter_append ) {
						// Force only single cat filter
						$taxonomy = isset( $taxonomy_optional ) && '' != $taxonomy_optional ? explode( ',', $taxonomy_optional ) : ( isset( $taxonomy ) && '' != $taxonomy ? explode( ',', $taxonomy ) : '');

						if ( isset( $taxonomy ) && is_array( $taxonomy ) ) {
							$terms .= ',';
							foreach ( $taxonomy as $tax ) {
								$post_terms = get_the_terms( $post->id, $tax );
								if ( isset( $post_terms ) && is_array( $post_terms ) ) {
									foreach ( $post_terms as $t ) {
										$terms .= $t->slug . ',';
									}
								}
							}
							$taxonomy = implode( ',', $taxonomy );
						}

					} else {
						// Make single cat filter an additional condition
						$extra_taxonomy = isset( $taxonomy_optional ) && '' != $taxonomy_optional ? explode( ',', $taxonomy_optional ) : '';

						if ( isset( $extra_taxonomy ) && is_array( $extra_taxonomy ) ) {
							foreach ( $extra_taxonomy as $tax ) {
								$post_terms = get_the_terms( $post->id, $tax );
								if ( isset( $post_terms ) && is_array( $post_terms ) ) {
									foreach ( $post_terms as $t ) {
										$extra_terms .= $t->slug . ',';
									}
								}
							}
						}
					}

					// Unset other params
					//$post_type = '';

					if ( $hide_current_post ) {
						if ( '' != $post__not_in ) {
							$post__not_in .= ',' . get_the_id();
						} else {
							$post__not_in = get_the_id();
						}
						$atts['post__not_in'] = $post__not_in;
					}
				}
			}

			// Sanitize WP Query args
			$author__in 				= $author__in ? explode( ',', $author__in ) : null;
			$post__in 					= $post__in ? explode( ',', $post__in ) : null;
			$post__not_in 				= $post__not_in ? explode( ',', $post__not_in ) : null;
			$terms 						= ( $terms ) ? explode( ',', $terms ) : null;
			$post_type					= ( $post_type ) ? explode( ',', $post_type ) : null;
			$post_status				= ( $post_status ) ? explode( ',', $post_status ) : 'publish';
			$taxonomy					= ( $taxonomy ) ? explode( ',', $taxonomy ) : null;
			$tax_query 					= null;

			if ( $taxonomy && $terms ) {
				$tax_query = array( 'relation' => $relation );

				if ( is_array( $taxonomy ) ) {
					foreach( $taxonomy as $tax ) {
						$tax_query[] = array(
							'taxonomy'	=> $tax,
							'field'		=> 'slug',
							'terms'		=> $terms,
							'operator' 	=> $operator // Allowed values AND, IN, NOT IN
						);
					}
				}
			}

			if ( is_array( $extra_taxonomy ) && count( $extra_taxonomy ) > 0 && $extra_terms ) {
				$extra_tax_query = array( 'relation' => $relation );

				foreach( $extra_taxonomy as $tax ) {
					$extra_tax_query[] = array(
						'taxonomy'	=> $tax,
						'field'		=> 'slug',
						'terms'		=> $extra_terms,
						'operator' 	=> 'IN'
					);
				}
			}

			// Date Params
			if ( $year || $month || $week || $day || $before || $after ) {
				$date_arr = array();
				if ( $year ) {
					$date_arr['year'] = $year;
				}

				if ( $month ) {
					$date_arr['month'] = $month;
				}

				if ( $week ) {
					$date_arr['week'] = $week;
				}

				if ( $day ) {
					$date_arr['day'] = $day;
				}

				if ( $before ) {
					$date_arr['before'] = $before;
				}

				if ( $after ) {
					$date_arr['after'] = $after;
				}

				$date_query = array( $date_arr	);
			}

			$tax_query_cmd = array( 'relation' => 'AND', $tax_query, $extra_tax_query );

			// Allowed args in WP Query
			$custom_args = array(
				'author_name' 			=> $author_name,
				'author__in' 			=> $author__in,
				'cat' 					=> $cat,
				'category_name' 		=> $category_name,
				'tag' 					=> $tag,
				'tag_id' 				=> $tag_id,
				'tax_query' 			=> $tax_query_cmd,
				'p' 					=> $p,
				'name' 					=> $name,
				'page_id' 				=> $page_id,
				'pagename' 				=> $pagename,
				'post__in' 				=> $post__in,
				'post__not_in' 			=> $post__not_in,
				'post_type' 			=> $post_type,
				'post_status' 			=> $post_status,
				'posts_per_page' 		=> $num,
				'offset' 				=> $offset,
				'ignore_sticky_posts' 	=> $ignore_sticky_posts,
				'order' 				=> $order,
				'orderby' 				=> $orderby,
				'meta_key' 				=> $meta_key,
				'meta_value'			=> $meta_value,
				'meta_value_num' 		=> $meta_value_num,
				's' 					=> $s,
				'date_query'			=> $date_query
			);

			$new_args = array();

			// Set args which are provided by user
			foreach ( $custom_args as $key => $value ) {
				if ( isset( $value ) )
					$new_args[ $key ] = $value;
			}

			// Switch to blog id if multisite
			if ( is_multisite() ) {
				switch_to_blog( $blog_id );
			}

			// Parse extra query args added using query="xx"
			if ( $query ) {
				$set_arr = array();
				$new_arr = array();
				$set = explode( '&amp;', wp_filter_nohtml_kses( $query ) );
				if ( is_array( $set ) ) {
					foreach ( $set as $set_item ) {
						$set_arr[] = explode( '=', $set_item );
					}
				}

				if ( isset( $set_arr ) && is_array( $set_arr ) ) {
					foreach ( $set_arr as $key => $value ) {
						if ( isset( $value[0] ) && isset( $value[1] ) ) {
							$new_arr[ $value[0] ] = $value[1];
						}
					}

					// Union of old and new args
					$user_args = $new_arr + $new_args;
					$custom_query = new WP_Query( $user_args );
				}

			}

			else {
				$custom_query = new WP_Query( $new_args );
			}

			// Set global count for ajax post container ID
			if ( isset( $GLOBALS['wppm_ajax_container_count'] ) ) {
				$GLOBALS['wppm_ajax_container_count']++;
			}
			else {
				$GLOBALS['wppm_ajax_container_count'] = 0;
			}

			// Get VC class for custom CSS via Design Options tab
			$vc_class = '';
			if ( class_exists( 'Vc_Manager' ) ) {
				$vc_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, vc_shortcode_custom_css_class( $css, ' ' ), 'wppm', $atts );
			}

			// Static vars for custom CSS class
			static $wppm_css_count = 0;
			$wppm_css_count++;

			// Start the loop
			if ( $custom_query->have_posts() ) :

				// Limit image dimensions between 4px to 2000px
				$imgwidth = (int)$imgwidth < 4 ? '' : $imgwidth;
				$imgwidth = (int)$imgwidth > 2000 ? 2000 : $imgwidth;
				$imgheight = (int)$imgheight < 4 ? '' : $imgheight;
				$imgheight = (int)$imgheight > 2000 ? 2000 : $imgheight;

				// Publisher logo
				$publisher_logo = wp_get_attachment_image_src ( $publisher_logo );
				$publisher_logo = $publisher_logo[0];

				// Set default template
				if ( '' == $template ) {
					$template = 'grid';
				}

				// Set default heading and p tags
				$htag = $htag == '' ? 'h2' : $htag;
				$ptag = $ptag == '' ? 'p' : $ptag;

				// Set sub template value
				if ( ( $template != 'portfolio' && $template != 'slider' ) && isset( ${ 'sub_type_' . $template } ) ) {
					$sub_type = ${ 'sub_type_' . $template };
				}

				if ( $allowed_tags ) {
					$tags_arr = explode( ',', $allowed_tags );
					if ( isset( $tags_arr ) && is_array( $tags_arr ) ) {
						$allowed_tags = '';
						foreach( $tags_arr as $tag ) {
							$allowed_tags .= '<' . $tag . '>';
						}
					}
				}

				ob_start();

				$template_path = apply_filters( 'wppm_template_path',  '/wppm-templates/' );

				// Load slider template
				if ( $enable_slider ) {
					if ( locate_template( $template_path . 'slider.php' ) ) {
						require( get_stylesheet_directory() . $template_path . 'slider.php' );
					}
					else {
						require( dirname( __FILE__ ) . $template_path . 'slider.php' );
					}
				}

				else {	// Load other templates
					if ( locate_template( $template_path . esc_attr( $template ) . '.php' ) ) {
						require( get_stylesheet_directory() . $template_path . esc_attr( $template ) . '.php' );
					}

					else {
						require( dirname( __FILE__ ) . $template_path . esc_attr( $template ) . '.php' );
					}
				}

				$out = ob_get_contents();

				ob_end_clean();

				wp_reset_query();
				wp_reset_postdata();

				if ( is_multisite() ) {
					restore_current_blog();
				}
				return $out;
			endif;
		}

		function wppm_tabs( $atts, $content = null ) {
			extract( shortcode_atts( array(
				'active'			=> '0',
				'collapsible'		=> false,
				'center'			=> false,
				'xclass'			=> false,
				'data'				=> false
			), $atts ) );

			if( isset( $GLOBALS['wppm_tabber_count'] ) )
				$GLOBALS['wppm_tabber_count']++;
			else
				$GLOBALS['wppm_tabber_count'] = 0;

			$ul_class  = sprintf( 'wppm-tabs%s clearfix', ( $center ? ' text-center' : '' ) );

			$div_class = 'wppm-tabbed';

			$id = 'wppm-tabs-'. $GLOBALS['wppm_tabber_count'];

			$atts_map = wppm_parse_nested_atts( $content );
			$data_props = $this->parse_data_attributes( $data );

			$tabs = array();
			if ( $atts_map ) {
				$i = 0;
				foreach( $atts_map as $tab ) {
					$title = isset( $tab["wppm_tab"]["title"] ) ? $tab["wppm_tab"]["title"] : 'Tab ' . ( $i + 1 );
					$tabs[] = sprintf(
						'<li><a href="#%s">%s</a></li>',
						'wppm-tab-' . $GLOBALS['wppm_tabber_count'] . '-' . $i,
						$title
					);
					$i++;
				}
			}

			// Reset global tab count
			$GLOBALS['wppm_tab_count'] = -1;

			return sprintf(
				'<div class="wppm-tabber%s"%s><ul class="%s" id="%s">%s</ul>%s</div>',
				( $xclass ) ? ' ' . esc_attr( $xclass ) : '',
				( $data_props ) ? ' ' . esc_attr( $data_props ) : '',
				esc_attr( $ul_class ),
				esc_attr( $id ),
				( $tabs )  ? implode( $tabs ) : '',
				do_shortcode( stripslashes( $content ) )
			);
		}

		function wppm_tab( $atts, $content = null ) {
			extract( shortcode_atts( array(
				'title' 			=> false,
				'ajax'				=> false,
				'xclass'			=> false,
				'data'				=> false
			), $atts ) );

			$data_props = $this->parse_data_attributes( $data );

			if( isset( $GLOBALS['wppm_tab_count'] ) ) {
				$GLOBALS['wppm_tab_count']++;
			}
			else {
				$GLOBALS['wppm_tab_count'] = 0;
			}

			$id = 'wppm-tab-'. $GLOBALS['wppm_tabber_count'] . '-'. $GLOBALS['wppm_tab_count'];

			return sprintf(
				'<div id="%s" class="wppm-tabbed%s"%s><div class="rendered-content">%s</div>%s<div class="wppm-loading-spinner"></div></div>',
				esc_attr( $id ),
				( $xclass ) ? ' ' . esc_attr( $xclass ) : '',
				( $data_props ) ? ' ' . esc_attr( $data_props ) : '',
				! $ajax ? do_shortcode( stripslashes( $content ) ) : '',
				$ajax ? '<div class="to-render">' . $content . '</div>' : ''
			);
		}

		// Title Shortcode
		function wppm_title( $atts, $content = null ) {
			extract( shortcode_atts( array(
				'font_family'		=> '',
				'title_weight'		=> '',
				'title_color'		=> '',
				'htag' 				=> 'h2',
				'hsize'				=> '14',
				'hsize_c'			=> '',
				'hlineheight'		=> '',
				'stsize'			=> '',
				'stlineheight'		=> '',
				'stweight'			=> '',
				'stcolor'			=> '',
				'style'				=> 'plain',
				'margin_btm'		=> 'theme_defined',
				'color'				=> '',
				'text'				=> '',
				'link'				=> '',
				'link_title'		=> '',
				'target'			=> false,
				'sub_text'			=> '',
				'sub_link'			=> '',
				'sub_link_title'	=> '',
				'sub_target'		=> false,
				'round_corner'		=> false,
				'xclass'			=> ''
			), $atts ) );

			$main = '' !== $text ? '<span class="main-text">' . esc_attr( $text ) . '</span>' : '';
			$sub = '' !== $sub_text ? '<span class="sub-text">' . esc_attr( $sub_text ) . '</span>' : '';

			static $wppm_css_count = 0;
			$wppm_css_count++;

			if ( '' !== $link && '' !== $text ) {
				$main = sprintf( '<a class="main-text" href="%s"%s%s>%s</a>',
							esc_url( $link ),
							$target ? ' target="_blank"' : '',
							$link_title ? ' title="' . esc_attr( $link_title ) . '"' : '',
							esc_attr( $text )
						);
			}

			if ( $sub_link && $sub_text ) {
				$sub = sprintf( '<a class="sub-text" href="%s"%s%s>%s</a>',
							esc_url( $sub_link ),
							$sub_target ? ' target="_blank"' : '',
							$sub_link_title ? ' title="' . esc_attr( $sub_link_title ) . '"' : '',
							esc_attr( $sub_text )
						);
			}

			return sprintf( '<%1$s class="wppm-title%2$s%3$s%4$s%5$s%6$s%7$s%10$s">%8$s%9$s</%1$s>',
						$htag,
						' st-' . esc_attr( $style ),
						$color ? ' ' . esc_attr( $color ) : '',
						$hsize ? ' fs-' . esc_attr( $hsize ) : '',
						$round_corner ? ' rounded' : '',
						$xclass ? ' ' . esc_attr( $xclass ) : '',
						'theme_defined' !== $margin_btm ? ' btm-' . esc_attr( $margin_btm ) : '',
						$main,
						$sub,
						'' != $font_family ? ' wppm_custom_css_' . $wppm_css_count : ''
					);
		}

		function parse_data_attributes( $data ) {
			$data_props = '';
			if( $data ) {
				$data = explode( '|', $data );

				foreach( $data as $d ) {
					$d = explode( ',', $d );
					$data_props .= sprintf( 'data-%s="%s" ', esc_html( preg_replace('/\s+/', '', $d[0] ) ), esc_attr( trim( $d[1] ) ) );
				}
			}
			else {
				$data_props = false;
			}
			return $data_props;
		}

	}
	$wp_post_modules = new WP_Post_Modules();
} // If not class exists