<?php
/**
 * Visual Composer specific functions
 */

// Let shortcodes inherit class properties of WPBakeryShortCodesContainer
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
	class WPBakeryShortCode_Wppm_Tabs extends WPBakeryShortCodesContainer {}
}

if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
	class WPBakeryShortCode_Wppm_Tab extends WPBakeryShortCodesContainer {}
}

if ( class_exists( 'WPBakeryShortCode' ) ) {
	class WPBakeryShortCode_Wppm extends WPBakeryShortCode {}
}

function wppm_vc_textfield_form_field_number( $settings, $value ) {
	$value = htmlspecialchars( $value );

	return '<input name="' . $settings['param_name']
	       . '" class="wpb_vc_param_value wpb-textinput '
	       . $settings['param_name'] . ' ' . $settings['type']
	       . '" type="number" value="' . $value . '" min="' . $settings['min'] . '" max="' . $settings['max'] . '"/>';
}

vc_add_shortcode_param( 'textfield_num', 'wppm_vc_textfield_form_field_number' );

function wppm_vc_dropdown_form_field_multiple( $settings, $value ) {
	$output = '';
	$css_option = str_replace( '#', 'hash-', vc_get_dropdown_option( $settings, $value ) );
	$output .= '<select name="'
	           . $settings['param_name']
	           . '" class="wpb_vc_param_value wpb-input wpb-select '
	           . $settings['param_name']
	           . ' ' . $settings['type']
	           . ' ' . $css_option
	           . '" data-option="' . $css_option . '" multiple size="5">';
	$value_arr = explode( ',', $value );
	if ( ! empty( $settings['value'] ) ) {

		foreach ( $settings['value'] as $index => $data ) {

			if ( is_numeric( $index ) && ( is_string( $data ) || is_numeric( $data ) ) ) {
				$option_label = $data;
				$option_value = $data;
			} elseif ( is_numeric( $index ) && is_array( $data ) ) {
				$option_label = isset( $data['label'] ) ? $data['label'] : array_pop( $data );
				$option_value = isset( $data['value'] ) ? $data['value'] : array_pop( $data );
			} else {
				$option_value = $data;
				$option_label = $index;
			}
			$selected = '';
			$option_value_string = (string) $option_value;
			$value_string = (string) $value;
			if ( in_array( $data, $value_arr ) ) {
				$selected = ' selected="selected"';
			}
			$option_class = str_replace( '#', 'hash-', $option_value );
			$output .= '<option value="' . esc_attr( $option_value ) . '"' . $selected . '>'
			           . htmlspecialchars( $option_label ) . '</option>';
		}
	}
	$output .= '</select>';
	return $output;
}

function wppm_vc_dropdown_form_field_multiple_optgroup( $settings, $value ) {
	$output = '';
	$css_option = str_replace( '#', 'hash-', vc_get_dropdown_option( $settings, $value ) );
	$output .= '<select name="'
	           . $settings['param_name']
	           . '" class="wpb_vc_param_value wpb-input wpb-select '
	           . $settings['param_name']
	           . ' ' . $settings['type']
	           . ' ' . $css_option
	           . '" data-option="' . $css_option . '" multiple size="5">';
	if ( is_array( $value ) ) {
		$value = isset( $value['value'] ) ? $value['value'] : array_shift( $value );
	}

	$value_arr = explode( ',', $value );

	if ( ! empty( $settings['value'] ) ) {

		foreach ( $settings['value'] as $index => $data ) {
			$selected = '';

			if ( is_numeric( $index ) && ( is_string( $data ) || is_numeric( $data ) ) ) {
				$option_label = $data;
				$option_value = $data;
			} elseif ( is_numeric( $index ) && is_array( $data ) ) {
				$option_label = isset( $data['label'] ) ? $data['label'] : array_pop( $data );
				$option_value = isset( $data['value'] ) ? $data['value'] : array_pop( $data );
			} else {
				$option_value = $data;
				$option_label = $index;
			}

			//$option_value_string = $option_value;
			//$value_string = $value;
			$option_class = str_replace( '#', 'hash-', $option_value );
			$output .= '<optgroup label="' . esc_attr( $index ) . '">';
			foreach ( $data as $d=>$v ) {
				$selected = '';
				if ( in_array( $v, $value_arr ) ) {
					$selected = ' selected="selected"';
				}
				$output .= '<option value="' . esc_attr( $v ) . '"' . $selected . '>'
			           . htmlspecialchars( $d ) . '</option>';
			}
			$output .= '</optgroup>';
		}
	}
	$output .= '</select>';
	return $output;
}

function wppm_vc_dropdown_form_field_optgroup( $settings, $value ) {
	$output = '';
	$css_option = str_replace( '#', 'hash-', vc_get_dropdown_option( $settings, $value ) );
	$output .= '<select name="'
	           . $settings['param_name']
	           . '" class="wpb_vc_param_value wpb-input wpb-select '
	           . $settings['param_name']
	           . ' ' . $settings['type']
	           . ' ' . $css_option
	           . '" data-option="' . $css_option . '">';
	if ( is_array( $value ) ) {
		$value = isset( $value['value'] ) ? $value['value'] : array_shift( $value );
	}

	$value_arr = explode(',', $value);

	if ( ! empty( $settings['value'] ) ) {

		foreach ( $settings['value'] as $index => $data ) {

			$output .= '<optgroup label="' . esc_attr( $index ) . '">';
			foreach ( $data as $d=>$v ) {

				if ( is_numeric( $d ) && ( is_string( $v ) || is_numeric( $v ) ) ) {
					$option_label = $v;
					$option_value = $v;
				} else {
					$option_value = $v;
					$option_label = $d;
				}
				$selected = '';
				if ( $value == $v ) {
					$selected = ' selected="selected"';
				}
				$output .= '<option value="' . esc_attr( $option_value ) . '"' . $selected . '>'
			           . htmlspecialchars( $option_label ) . '</option>';
			}
			$output .= '</optgroup>';
		}
	}
	$output .= '</select>';
	return $output;
}

function wppm_vc_get_sc( $atts ) {
	if ( isset( $atts ) && is_array( $atts ) ) {
		$atts2 = vc_map_get_attributes( 'wppm', $atts );
		array_unique( array_merge( $atts, $atts2 ) );
		$val = '[wppm';
		foreach( $atts as $key => $v ) {
			$val .= ' ' . $key . '="' . $v . '"';
		}
		$val .= ']';
		return $val;
	}
}

vc_add_shortcode_param( 'dropdown_multiple', 'wppm_vc_dropdown_form_field_multiple' );
vc_add_shortcode_param( 'dropdown_optgroup', 'wppm_vc_dropdown_form_field_optgroup' );
vc_add_shortcode_param( 'dropdown_multiple_optgroup', 'wppm_vc_dropdown_form_field_multiple_optgroup' );
?>