<?php

/**
 * @author    ThemePunch <info@themepunch.com>
 * @link      http://www.themepunch.com/
 * @copyright 2024 ThemePunch
 */

if( !defined( 'ABSPATH') ) exit();

class RevAddOnWeatherOWM {

	public function __construct() {
	}

	/**
	 * Connects to Open Weather Map API with certain parameters
	 * @since    1.0.0
	 */
	public static function get_weather_infos($location, $unit, $key, $refresh = 0){

		$city = is_numeric($location) ? 'city_id' : 'city';

		$url = 'https://api.weatherbit.io/v2.0/forecast/daily?' . $city . '=' . $location . '&key=' . $key . '&units=' . $unit;
		$transient_name = 'revslider_' . md5($url);
		if (false === ( $weather = get_transient( $transient_name) ) ){
			$weather = wp_remote_fopen($url);
			set_transient( $transient_name, $weather, 3600 * 12);
		}
		$weather = json_decode($weather);

		$url = 'https://api.weatherbit.io/v2.0/current?' . $city . '=' . $location . '&key=' . $key . '&units=' . $unit;
		$transient_name = 'revslider_' . md5($url);
		if ($refresh || false === ( $current = get_transient( $transient_name) ) ){
			$current = wp_remote_fopen($url);
			set_transient( $transient_name, $current, 3600 * 3);
		}
		$current = json_decode($current);

		if (is_object($weather) && isset($weather->data) && is_object($current) && isset($current->data)) {
			foreach ($weather->data as $key => $data) {
				if ($data->ts < $current->data[0]->ts) {
					unset($weather->data[$key]);
				}
			}
			$weather->data = array_values($weather->data);
			$currentWeather = (object)array_merge((array)$weather->data[0], (array)$current->data[0]);
			if (date('Y-m-d', $weather->data[0]->ts) == date('Y-m-d', $current->data[0]->ts)) {
				$weather->data[0] = $currentWeather;
			} else {
				array_unshift($weather->data, $currentWeather);
			}
		}

		return $weather;
	}

}