<?php
/**
 * The public-facing functionality of the plugin.
 *
 * @package    Revslider_Sharing_Addon
 * @subpackage Revslider_Sharing_Addon/public
 * @author     ThemePunch <info@themepunch.com>
 */
class Revslider_Sharing_Addon_Public extends SrSharingFunctions{

	/**
	 * The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 */
	private $version;

	public $layer_actions = array();
	
	/**
	 * Initialize the class and set its properties.
	 */
	public function __construct( $plugin_name, $version ) {
		$this->plugin_name = $plugin_name;
		$this->version = $version;
	}

	/**
	 * Register the stylesheets for the public-facing side of the site.
	 */
	public function enqueue_styles() {
		
	}

	/**
	 * Register the JavaScript for the public-facing side of the site.
	 */
	public function enqueue_scripts() {
		wp_enqueue_script( $this->plugin_name, plugin_dir_url( __FILE__ ) . 'js/revslider-sharing-addon-public.js', array( 'jquery' ), $this->version, false );
		add_filter('revslider_modify_waiting_scripts', array($this, 'add_waiting_script_slugs'), 10, 1);
		wp_localize_script( $this->plugin_name, 'revslider_sharing_addon', array(
				'revslider_sharing_addon_sizes' => unserialize(get_option('revslider_sharing_addon_sizes')),
				'ajax_url' => admin_url( 'admin-ajax.php' )
			)
		);

	}

	public function add_waiting_script_slugs($wait){
		$wait[] = 'sharing';
		return $wait;
	}
	
	private function isSocialLink($action) {
		return in_array($action, array('share_facebook', 'share_twitter', 'share_linkedin', 'share_pinterest'), true);
	}
	
	/**
	 * Convert Action tag
	 *
	 * @since    2.0.0
	 */
	public function rs_action_type($action) {
		return $this->isSocialLink($action) ? 'link' : $action;
	}
	
	/**
	 * Convert Action link_type
	 *
	 * @since    2.0.0
	 */
	public function rs_action_link_type($action) {
		return $this->isSocialLink($action) ? 'a' : $action;
	}

	/**
	 * will handle only v6 data if no v6 data are present (actions.action on layer)
	 * v7 variant is saved on slides and already present as it should be
	 **/
	public function rs_action_modify_layer_v6($slider){
		
		$slides = $slider->get_slides();

		if(empty($slides)) return $slider;

		foreach($slides as $_sk => $slide){
			$update = false;
			$layers = $slide->get_layers();
			if(empty($layers)) continue;

			foreach($layers as $_lk => $layer){
				//v6 variant
				$actions = $this->get_val($layer, array('actions', 'action'), array());
				if(empty($actions)) continue;
				$layer_update = false;

				foreach($actions as $index => $action){
					$url = $this->rs_action_get_layer_link($action, $slide, $slider);

					if(empty($url)) continue;
					
					$actions[$index]['action'] = 'link';
					$actions[$index]['link_open_in'] = '_blank';
					$actions[$index]['link_type'] = 'a';
					$actions[$index]['link'] = $url;
					$actions[$index]['image_link'] = $url;
					
					$update = true;
					$layer_update = true;
				}

				if($layer_update === false) continue;

				$layers[$_lk]['actions']['action'] = $actions;

			}
			
			if($update === false) continue;

			$slide->set_layers_raw($layers);

			$slides[$_sk] = $slide;
		}

		if($update === true){
			$slider->slides = $slides;
		}

		return $slider;
	}

	public function rs_action_get_layer_link($action, $slide, $slider){
		$caller_url	= RS_SHARING_PLUGIN_URL.'public/revslider-sharing-addon-call.php';
		$actionType	= $this->get_val($action, 'action', '');
		$slide_id	= $slide->get_id();
		$source		= $slider->get_param('sourcetype');
		$url		= $source == "post" ? urlencode(get_permalink($slide_id)) : $slide_id;

		switch($actionType){
			case 'share_twitter':
				$sharetext = $this->get_val($action, 'twitter_text', '');
				$sharelink = $this->get_val($action, 'twitter_link', '');

				if($sharelink === '%site_url%') $sharelink = $this->curPageURL();
				if($sharelink === '%post_url%') $sharelink = 'tp_revslider_sharing_get_permalink';

				$sharetext = empty($sharetext) ? '&url='.$sharelink : $sharetext.'&url='.$sharelink;
				return $caller_url.'?tpurl='.$url.'&share=https://twitter.com/intent/tweet?text='.urlencode(str_replace("'","%27",$sharetext)).'&slider='.$slide->get_slider_id().'&source='.$source;
			break;
			case 'share_facebook':
				$sharelink = $this->get_val($action, 'facebook_link', '');

				if($sharelink === '%site_url%') $sharelink = $this->curPageURL();
				if($sharelink === '%post_url%') $sharelink = 'tp_revslider_sharing_get_permalink';
				
				return $caller_url.'?tpurl='.$url.'&share=https://www.facebook.com/sharer/sharer.php?u='.urlencode($sharelink).'&slider='.$slide->get_slider_id().'&source='.$source;
			break;
			case 'share_pinterest':
				$sharelink = $this->get_val($action, 'pinterest_link', '');
				$shareimage = $this->get_val($action, 'pinterest_image', '');
				$sharedesc = $this->get_val($action, 'pinterest_link_description', '');

				if($sharelink === '%site_url%') $sharelink = $this->curPageURL();
				if($sharelink === '%post_url%') $sharelink = 'tp_revslider_sharing_get_permalink';
				if($shareimage === '%background_image%') $shareimage = $slide->image_url;
				
				return $caller_url.'?tpurl='.$url.'&share=https://pinterest.com/pin/create/button/?url='.urlencode($sharelink).',media='.urlencode($shareimage).',description='.urlencode(str_replace("'","%27",$sharedesc)).'&slider='.$slide->get_slider_id().'&source='.$source;
			break;
			case 'share_linkedin':
				$sharelink = $this->get_val($action, 'linkedin_link', '');
				$sharetitle = $this->get_val($action, 'linkedin_link_title', '');
				$sharesummary = $this->get_val($action, 'linkedin_link_summary', '');

				if($sharelink === '%site_url%') $sharelink = $this->curPageURL();
				if($sharelink === '%post_url%') $sharelink = 'tp_revslider_sharing_get_permalink';
				
				return $caller_url.'?tpurl='.$url.'&share=https://www.linkedin.com/shareArticle?mini=true,url='.urlencode($sharelink).',title='.urlencode($sharetitle).',summary='.urlencode(str_replace("'","%27",$sharesummary)).'&slider='.$slide->get_slider_id().'&source='.$source;
			break;
		}

		return false;
	}

	/**
	 * Add Sharing Actions in Output
	 */
	public function rs_action_output_layer_simple_link( $html_simple_link="", $action="", $all_actions="", $num="", $slide="", $slider="", $a_events="", $ouput_obj=''){
		
		$url = $this->rs_action_get_layer_link($action, $slide, $slider);
		$tabs = "\t\t\t\t\t\t\t\t";

		if(!empty($url)) $html_simple_link = 'target="_blank" ' . "\n" . $tabs . 'href="'.$url.'"';
		
		return $html_simple_link;
	}
}
