/**
 * @preserve
 * @author    ThemePunch <info@themepunch.com>
 * @link      http://www.themepunch.com/
 * @copyright 2018 ThemePunch
 * @version 6.7.0
 */
/*
╔══════════════════════════════════════════════════════════════════════════════╗
║                                                                              ║
║  PLUGIN:      SLIDER REVOLUTION 7.0                                          ║
║  MODULE:      SHARING ADDON                                         		   ║
║  VERSION:     1.0.0                                                          ║
║  DATE:        2023-03-10                                                     ║
║  AUTHOR:      Krisztian H. 												   ║
║  COMPANY:     ThemePunch OHG.                                                ║
║                                                                              ║
╠══════════════════════════════════════════════════════════════════════════════╣
║                                                                              ║
║  UPDATES & DOCS:  https://www.themepunch.com/support-center                  ║
║  GET LICENSE:    https://www.themepunch.com/links/slider_revolution_wordpre  ║
║                               ss_regular_license                             ║
║                                                                              ║
╠══════════════════════════════════════════════════════════════════════════════╣
║                                                                              ║
║  LICENSE:                                                                    ║
║  Copyright (c) 2023, ThemePunch. All rights reserved.                        ║
║  This work is subject to the terms at:                                       ║
║  https://www.themepunch.com/links/slider_revolution_wordpress_regular_licen  ║
║                               se (Regular / Extended)                        ║
║                                                                              ║
╚══════════════════════════════════════════════════════════════════════════════╝
*/
(function() {
	"use strict";

	window.SR7 ??=  {};
	window._tpt ??= {};
	SR7.A ??= {};
	SR7.F ??= {};
	SR7.D ??= {};

	//Check if File already has been loaded, and if so, quit...
	if (SR7.A.sharing !== undefined) return;

	// Update Required Setings
	let get = {
		pI : (v) => parseInt(v),
		pF : (v) => parseFloat(v),
		s : (v) => String(v),
		b : (v) => v === 'on' || v === true || v===1? true : v === 'off' || v === false || v===0 ? false : v,
		k : (v) => v,
	}
		
	SR7.A.sharing = {		

		style : '',		
		
		/**
		 * @param {object} o - addon options on module level
		 * @returns {object} options in SR7 format
		 */
		getModuleBasics: (o = {},type) => {		
			console.log(o);	
			let r =  {			
				u: type=="compare" ? undefined : (o.u ?? o.enable ?? true),					
			}			
			return r;
		},

		postProcessLayer : (id,layer,c,skey) => {			
			let link = SR7.D.hasActionLike(id,skey,c.lkey,"link");
			if (link!==false && !link.link.includes("&share=https://")) {
				c.el.href = link.link = SR7.A.sharing.updateSocialShare(link,id, skey, SR7.M[id].settings.source.type);				
			}
		},

		/**
		 * @param {string} id - module ID
		 */
		init : (id) => {
			let M = SR7.M[id];			
			for (let slidekey in M.slides) {
				if (!_tpt.hop(M.slides,slidekey)) continue;
				let slide = M.slides[slidekey].slide;
				if (slide?.actions??false) {					
					for (let a of slide.actions) {
						if (a.a!=="link" || a.shr===undefined) continue;						
						for (let layer in M.slides[slidekey].layers) {
							if (!_tpt.hop(M.slides[slidekey].layers,layer)) continue;
							M.slides[slidekey].layers[layer].addOns ??={};
							M.slides[slidekey].layers[layer].addOns.sharing={u:true};
						}						
					}
				}
			}			
		},	

		updateSocialShare : (_, id, skey, source="gallery") => {						
			if(!(_.shr??false)) return _;
			let M = SR7.M[id];
			let sharelink = _.shrlink;			
			let url	= source=="post" ? (urlEncode(SR7.F.getFeed(M, (M.slides[skey].slide.order-1),"link"))) : id;
			
			if(sharelink === '%site_url%') sharelink = window.location.href;
			if(sharelink === '%post_url%') sharelink = 'tp_revslider_sharing_get_permalink';
			let caller_url	=  SR7.E.resources.sharingURL+ 'public/revslider-sharing-addon-call.php';

			_.converted = true;
			return caller_url + '?tpurl='+ url + (
				_.shr == "pinterest" ? '&share=https://pinterest.com/pin/create/button/?url=' + urlEncode(sharelink) + ',media='+ urlEncode(_.image) + ',description=' + urlEncode(_.description.replaceAll("'","%27"))+ '&slider=' +id + '&source=' + source :
				_.shr == "facebook" ? '&share=https://www.facebook.com/sharer/sharer.php?u=' + urlEncode(sharelink)+ '&slider='+ id + '&source='+source :
				_.shr == "twitter" ? '&share=https://twitter.com/intent/tweet?text='+ urlEncode((_.text=="" ||  _.text==undefined  ? '&url=' + sharelink :  _.text + '&url='+ sharelink).replaceAll("'","%27")) + '&slider='+ id + '&source='+source :
				_.shr.includes("linked") ? '&share=https://www.linkedin.com/shareArticle?mini=true,url=' + urlEncode(sharelink) + ',title=' + urlEncode(_.title) + ',summary='+ urlEncode(_.sum.replaceAll("'","%27")) + '&slider='+ id + '&source=' + source :
				'&share=https://www.tumblr.com/share/link?url=' + urlEncode(sharelink) + '&slider='+ id + '&source='+source
				)			
		}		
	}

	function urlEncode(str) {
		return encodeURIComponent(str).replace(/%20/g, '+');
	}

	// Update Required Settings	
	_tpt.R ??= {};
	_tpt.R.sharing =  _tpt.extend ?  _tpt.extend(_tpt.R.sharing, { status: 2, version: '1.0'}) : { status: 2, version: '1.0'};
	window.dispatchEvent(new CustomEvent('SR7sharingReady'));
})();