<?php
/**
 * The core plugin class.
 *
 * @since      1.0.0
 * @package    Revslider_Sharing_Addon
 * @subpackage Revslider_Sharing_Addon/includes
 * @author     ThemePunch <info@themepunch.com>
 */
class Revslider_Sharing_Addon {

	/**
	 * The unique identifier of this plugin.
	 */
	protected $plugin_name;

	/**
	 * The current version of the plugin.
	 */
	protected $version;

	/**
	 * Define the core functionality of the plugin.
	 */
	public function __construct() {

		$this->plugin_name = 'sharing';
		$this->version = REV_ADDON_SHARING_VERSION;

		$this->load_dependencies();
		$this->set_locale();
		$this->define_admin_hooks();
		$this->define_public_hooks();

	}

	/**
	 * Load the required dependencies for this plugin.
	 */
	private function load_dependencies() {
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-revslider-sharing-addon-admin.php';
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-revslider-sharing-addon-update.php';
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-revslider-sharing-addon-functions.php';

		//v7, load always as things are needed in overview page
		require_once(plugin_dir_path( dirname( __FILE__ ) )  . 'public/includes/front.class.php');

		global $SR_GLOBALS;
    	if(!isset($SR_GLOBALS['front_version']) || $SR_GLOBALS['front_version'] !== 7){
			require_once plugin_dir_path( dirname( __FILE__ ) ) . 'sr6/class-revslider-sharing-addon-public.php';
		}
	}

	/**
	 * Define the locale for this plugin for internationalization.
	 */
	private function set_locale() {
		add_action('after_setup_theme', array($this, 'load_plugin_textdomain'), 10, 1);
	}

	public function load_plugin_textdomain() {
		load_plugin_textdomain($this->get_plugin_name(), false, dirname( dirname( plugin_basename( __FILE__ ) ) ) . '/languages/');
	}

	/**
	 * Register all of the hooks related to the admin area functionality of the plugin.
	 */
	private function define_admin_hooks() {

		$plugin_admin = new Revslider_Sharing_Addon_Admin( $this->get_plugin_name(), $this->get_version() );
		$update_admin = new RevAddOnSharingUpdate(REV_ADDON_SHARING_VERSION);
		
		add_action('admin_enqueue_scripts', array($plugin_admin, 'enqueue_scripts'), 10, 1);

		//updates
		add_filter('pre_set_site_transient_update_plugins', array($update_admin, 'set_update_transient'), 10, 1);
		add_filter('plugins_api', array($update_admin, 'set_updates_api_results'), 10, 3);

		//ajax call
		add_action('revslider_do_ajax', array($plugin_admin, 'do_ajax'), 10, 2);

		//build js global var for activation
		add_action('revslider_activate_addon', array($plugin_admin, 'get_var'), 10, 2);

	}

	/**
	 * Register all of the hooks related to the public-facing functionality of the plugin.
	 */
	private function define_public_hooks() {

		global $SR_GLOBALS;
		$SrSharingFront = new SrSharingFront( $this->get_plugin_name());
    	if(isset($SR_GLOBALS['front_version']) && $SR_GLOBALS['front_version'] === 7){
			add_filter('revslider_putLayer_pre', array($SrSharingFront, 'rs_action_modify_layer_v7'), 10, 5);
		}else{
			$plugin_public = new Revslider_Sharing_Addon_Public( $this->get_plugin_name(), $this->get_version() );

			// Add actions to output
			add_filter('rs_action_output_layer_simple_link', array($plugin_public, 'rs_action_output_layer_simple_link'), 10, 8);
			//add_filter('revslider_slider_init_by_data_post', array($plugin_public, 'rs_action_modify_layer_v6'), 10, 1);
			
			// Force Layer tag to be an "<a>" (both hooks needed)
			add_filter('rs_action_type', array($plugin_public, 'rs_action_type'), 10, 1);
			add_filter('rs_action_link_type', array($plugin_public, 'rs_action_link_type'), 10, 1);
		}
	}

	/**
	 * The name of the plugin used to uniquely identify it within the context of
	 * WordPress and to define internationalization functionality.
	 */
	public function get_plugin_name() {
		return $this->plugin_name;
	}

	/**
	 * Retrieve the version number of the plugin.
	 */
	public function get_version() {
		return $this->version;
	}

}
