<?php

class SrSharingFunctions extends RevSliderFunctions {

	/**
	 * Returns Current URL
	 */
	public function curPageURL() {
		$pageURL = (isset($_SERVER["HTTPS"]) && $_SERVER["HTTPS"] == "on") ? 'https://' : 'http://';
		$pageURL .= $_SERVER["SERVER_NAME"];
		$pageURL .= ($_SERVER["SERVER_PORT"] != "80") ? ":".$_SERVER["SERVER_PORT"] : '';
		$pageURL .= $_SERVER["REQUEST_URI"];
	
		return esc_url($pageURL);
	}

	public static function mediaid_to_shortcode($mediaid){

	    if(strpos($mediaid, '_') !== false){
	        $pieces = explode('_', $mediaid);
	        $mediaid = $pieces[0];
	        $userid = $pieces[1];
	    }

	    $alphabet = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-_';
	    $shortcode = '';
	    while($mediaid > 0){
	        $remainder = $mediaid % 64;
	        $mediaid = ($mediaid - $remainder) / 64;
	        $shortcode = $alphabet[$remainder] . $shortcode;
	    };
	    return $shortcode;
	}

}

?>