<?php

/**
 * The file that defines the core plugin class
 *
 * A class definition that includes attributes and functions used across both the
 * public-facing side of the site and the admin area.
 *
 * @link       http://www.themepunch.com
 * @since      1.0.0
 *
 * @package    Rev_addon_prevnext_posts
 * @subpackage Rev_addon_prevnext_posts/includes
 */

class Rev_addon_prevnext_posts {

	protected $plugin_name;
	protected $version;

	public function __construct() {

		$this->plugin_name = 'rev_addon_prevnext_posts';
		$this->version = REV_ADDON_PREVNEXT_POSTS_VERSION;

		$this->load_dependencies();
		$this->set_locale();
		
		if(is_admin()) {
			$this->define_admin_hooks();
		}else{
			$enabled = get_option('revslider_prevnext_posts_enabled');
			if(!empty($enabled)) $this->define_public_hooks();
		}

	}

	/**
	 * Load the required dependencies for this plugin.
	 * @since    1.0.0
	 * @access   private
	 */
	private function load_dependencies() {
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-rev_addon_prevnext_posts-admin.php';
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-rev_addon_prevnext_posts-update.php';
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/class-rev_addon_prevnext_posts-public.php';
	}

	private function set_locale() {
		add_action('after_setup_theme', array($this, 'load_plugin_textdomain'), 10, 1);
	}

	public function load_plugin_textdomain() {
		load_plugin_textdomain($this->get_plugin_name(), false, dirname( dirname( plugin_basename( __FILE__ ) ) ) . '/languages/');
	}

	private function define_admin_hooks() {

		$plugin_admin = new Rev_addon_prevnext_posts_Admin( $this->get_plugin_name(), $this->get_version() );
		$update_admin = new RevAddOnPrevNextPostsUpdate(REV_ADDON_PREVNEXT_POSTS_VERSION);

		//option page
		add_action('admin_enqueue_scripts', array($plugin_admin, 'enqueue_scripts'), 10, 1);
		
		//updates
		add_filter('pre_set_site_transient_update_plugins', array($update_admin, 'set_update_transient'), 10, 1);
		add_filter('plugins_api', array($update_admin, 'set_updates_api_results'), 10, 3);

		add_action('revslider_do_ajax', array($plugin_admin, 'do_ajax'), 10, 2);

		//build js global var for activation
		add_action('revslider_activate_addon', array($plugin_admin, 'get_var'), 10, 2);
	}

	/**
	 * Register all of the hooks related to the public-facing functionality
	 * of the plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function define_public_hooks() {

		$plugin_public = new Rev_addon_prevnext_posts_Public( $this->get_plugin_name(), $this->get_version() );

		//print previous next slider
		add_filter('the_content', array($plugin_public, 'filter_print_posts'), 10, 1);
		add_action('revslider_gallery_set_placeholders', array($plugin_public, 'rev_addon_insert_meta'), 10, 2);
		add_action('revslider_set_layers_by_stream_post', array($plugin_public, 'rev_addon_insert_meta_v7'), 10, 3);
		//add_action('sr_streamline_post_data_post', array($plugin_public, 'rev_addon_insert_meta_values_v7'), 10, 3);
	}

	public function get_plugin_name() {
		return $this->plugin_name;
	}

	public function get_version() {
		return $this->version;
	}

}
