<?php
/**
 * The public-facing functionality of the plugin.
 * @link       http://www.themepunch.com
 * @since      1.0.0
 *
 * @package    Rev_addon_gal
 * @subpackage Rev_addon_gal/public
 */

class Rev_addon_gal_Public {

	private $plugin_name;
	private $version;

	public function __construct( $plugin_name, $version ) {
		$this->plugin_name = $plugin_name;
		$this->version = $version;

		//exchange gallery shortcode
		remove_shortcode('gallery', 'gallery_shortcode');
		add_shortcode('gallery', array($this,'rev_addon_gallery'),10,2);
	}


	public function enqueue_styles() { }

	public function enqueue_scripts() {	}
	
	/**
	 * Shortcode to wrap around the original gallery shortcode
	 *
	 * @since    2.0.0
	 */
	public function gutenberg_block_content_fitler( $block_content, $block ) {
		if(!class_exists( 'RevSliderFunctions' )) return $block_content;
		
		$f = new RevSliderFunctions();
		if($f->get_val($block, 'blockName', '') !== 'core/gallery') return $block_content;
			
		$ids = $f->get_val($block, array('attrs', 'ids'), array());
		$class = $f->get_val($block, array('attrs', 'className'), '');
		$slider_alias = $f->get_val($block, array('attrs', 'slider'), '');

		if(empty($slider_alias) && empty($slider_alias)){
			$slider_alias = get_option("revslider_gallery_addon");
			if(strpos($slider_alias,'gallery-addon-slider='))	$slider_alias = str_replace('revslider-gallery-addon-slider=', 'revslider-gallery-', $slider_alias);
		}

		//new block setup since WP 5.9
		if(empty($ids)){
			$ids = array();	
			foreach($block['innerBlocks'] ?? [] as $image){	
				$ids[] = $f->get_val($image, array('attrs', 'id'));
			}
		}

		if(is_array($ids) && !empty($ids) && is_string($slider_alias) && !empty($slider_alias)){
			$alias = str_replace('revslider-gallery-', '', $slider_alias);
			if($alias === 'none' || empty($alias)) return $block_content;

			$ids = implode(',', $ids);
			
			return '[gallery rev_addon_gal_slider="' . $alias . '" ids="' . $ids . '"][/gallery]';
		}
		
		return $block_content;
	}

	/**
	 * Shortcode to wrap around the original gallery shortcode
	 *
	 * @since    1.0.0
	 * @version  1.0.1 : Exits when other revslider_function
	 * @version  2.0.1 : checks for slider alias as attribute
	 */
	public function rev_addon_gallery($output, $attr){
		$return = array();
		foreach($output ?? [] as $attr_key => $attr_value){
			$return[] = $attr_key.'="'.$attr_value.'"';
		}
		
		//exits if other RevSlider functionality captures the gallery functionality
		if(isset($output["revslider_function"]) && $output["revslider_function"] !== 'gallery') return false;

		$slider = isset($output["rev_addon_gal_slider"]) ? $output["rev_addon_gal_slider"] : get_option("revslider_gallery_addon");

		//2.0.1
		if(strpos($slider,'gallery-addon-slider='))	$slider = str_replace('revslider-gallery-addon-slider=', '', $slider);

		return (!empty($slider)) ? do_shortcode('[sr7 alias="'.$slider.'"][gallery '.implode(" ", $return).'][/sr7]') : false;
	}

	/**
	 * Filters the custom meta placeholders and replaces them
	 *
	 * @since    1.0.0
	 */
	public function rev_addon_insert_meta($text,$post_id){
		$text = str_replace(
			array('%caption%', '{{caption}}', '%description%', '{{description}}', '%uploaded%', '{{uploaded}}'),
			array('{{excerpt}}', '{{excerpt}}', '{{content}}', '{{content}}', '{{date}}', '{{date}}'),
			$text
		);

		$avail_image_sizes = get_intermediate_image_sizes();
		$avail_image_sizes[] = 'full';

		foreach($avail_image_sizes as $image_size){
			$image_array = wp_get_attachment_image_src($post_id,$image_size);
			$image = (!empty($image_array) && $image_array !== false) ? $image_array[0] : '';
			$text = str_replace(array('%image_'.$image_size.'_url%', '{{image_'.$image_size.'_url}}'), $image, $text);
			$text = str_replace(array('%image_'.$image_size.'_html%', '{{image_'.$image_size.'_html}}'), wp_get_attachment_image($post_id,$image_size), $text);
		}
		
		return $text;
	}

	/**
	 * adds the custom meta placeholders
	 * @since    1.0.0
	 */
	public function rev_addon_insert_meta_v7($post_data, $data, $metas, $slider){
		$avail_image_sizes = get_intermediate_image_sizes();
		$avail_image_sizes[] = 'full';

		foreach($post_data ?? [] as $key => $post){
			$post_data[$key]['caption']		= @$post['excerpt'];
			$post_data[$key]['description']	= @$post['content']['content'];
			$post_data[$key]['uploaded']	= @$post['publish'];

			foreach($avail_image_sizes as $image_size){
				$image_array = wp_get_attachment_image_src($post['id'], $image_size);
				$image = (!empty($image_array) && $image_array !== false) ? $image_array[0] : '';
				$post_data[$key]['image_'.$image_size.'_url']	= $image;
				$post_data[$key]['image_'.$image_size.'_html']	= wp_get_attachment_image($post['id'], $image_size);
			}
		}

		return $post_data;
	}

}
