<?php
/**
 * The core plugin class.
 *
 * This is used to define internationalization, admin-specific hooks, and
 * public-facing site hooks.
 *
 * Also maintains the unique identifier of this plugin as well as the current
 * version of the plugin.
 *
 * @since      1.0.0
 * @package    Rev_addon_gal
 * @subpackage Rev_addon_gal/includes
 * @author     ThemePunch <info@themepunch.com>
 */
class Rev_addon_gal {

	protected $plugin_name;
	protected $version;

	public function __construct() {

		$this->plugin_name = 'rev_addon_gal';
		$this->version = REV_ADDON_GAL_VERSION;

		$this->load_dependencies();
		$this->set_locale();
		
		$enabled = get_option('revslider_gallery_enabled');
		
		if(is_admin()) {
			$this->define_admin_hooks($enabled);
		}
		else {
			if(!empty($enabled)) $this->define_public_hooks();
		}

	}

	private function load_dependencies() {
		/**
		 * The class responsible for defining all actions that occur in the admin area.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-rev_addon_gal-admin.php';

		/**
		 * The class responsible for the update process.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-rev_addon_gal-update.php';

		/**
		 * The class responsible for defining all actions that occur in the public-facing
		 * side of the site.
		 */
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/class-rev_addon_gal-public.php';
	}

	/**
	 * Define the locale for this plugin for internationalization.
	 */
	private function set_locale() {
		add_action('after_setup_theme', array($this, 'load_plugin_textdomain'), 10, 1);
	}

	public function load_plugin_textdomain() {
		load_plugin_textdomain($this->get_plugin_name(), false, dirname( dirname( plugin_basename( __FILE__ ) ) ) . '/languages/');
	}

	/**
	 * Register all of the hooks related to the admin area functionality
	 * of the plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function define_admin_hooks($enabled) {

		$plugin_admin = new Rev_addon_gal_Admin( $this->get_plugin_name(), $this->get_version() );
		$update_admin = new RevAddOnGalUpdate(REV_ADDON_GAL_VERSION);

		add_action('admin_enqueue_scripts', array($plugin_admin, 'enqueue_scripts'), 10, 1);
		add_action('revslider_do_ajax', array($plugin_admin, 'do_ajax'), 10, 2);
		
		//add media form fields
		add_action('print_media_templates', array($plugin_admin, 'rev_addon_media_form'), 10, 1);
		
		//updates
		add_action('pre_set_site_transient_update_plugins', array($update_admin, 'set_update_transient'), 10, 1);
		add_action('plugins_api', array($update_admin, 'set_updates_api_results'), 10, 3);
		
		//build js global var for activation
		add_action('revslider_activate_addon', array($plugin_admin, 'get_var'), 10, 2);
		
		// gutenberg extension
		// don't enqueue if the development plugin is activated
		if($enabled && !function_exists('revslider_gallery_addon_gutenberg_extension')) {
			add_action('enqueue_block_editor_assets', array($plugin_admin, 'gutenberg_enqueue_scripts'), 10, 1);
		}
		
	}


	/**
	 * Register all of the hooks related to the public-facing functionality
	 * of the plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function define_public_hooks() {
		$plugin_public = new Rev_addon_gal_Public( $this->get_plugin_name(), $this->get_version() );

		//insert layer meta data
		add_filter('rev_slider_insert_meta', array($plugin_public, 'rev_addon_insert_meta'), 10, 2);
		add_filter('sr_streamline_post_data_post', array($plugin_public, 'rev_addon_insert_meta_v7'), 10, 4);
		
		// gutenberg extension
		// don't enqueue if the development plugin is activated
		if(!function_exists('revslider_gallery_addon_gutenberg_extension')) {
			add_filter('render_block', array($plugin_public, 'gutenberg_block_content_fitler'), 10, 2);
		}

	}

	/**
	 * The name of the plugin used to uniquely identify it within the context of
	 * WordPress and to define internationalization functionality.
	 *
	 * @since     1.0.0
	 * @return    string    The name of the plugin.
	 */
	public function get_plugin_name() {
		return $this->plugin_name;
	}

	/**
	 * Retrieve the version number of the plugin.
	 *
	 * @since     1.0.0
	 * @return    string    The version number of the plugin.
	 */
	public function get_version() {
		return $this->version;
	}

}
