<?php
/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the admin-specific stylesheet and JavaScript.
 *
 * @package    Revslider_Featured_Addon
 * @subpackage Revslider_Featured_Addon/public
 * @author     ThemePunch <info@themepunch.com>
 */
class Revslider_Featured_Addon_Public extends RevSliderFunctions {

	private $plugin_name;
	private $version;

	public function __construct($plugin_name, $version){

		$this->plugin_name = $plugin_name;
		$this->version = $version;

		add_shortcode('featured_revslider', array($this,'featured_revslider_shortcode'));
	}

	public function enqueue_styles(){
	}

	public function enqueue_scripts(){
	}

	/**
	 * Action to display the featured slider set in the options instead the featured image
	 * if featured image is included by the_thumbnail into the theme templates
	 *
	 * @since    1.0.0
	 */
	public function post_thumbnail_replace($html, $post_id, $post_thumbnail_id, $size, $attr){
		return $this->create_slider($html, $post_id, $post_thumbnail_id);
	}

	/**
	 * Shortcode to display the featured slider anywhere
	 *
	 * @since    1.0.0
	 */
	public function featured_revslider_shortcode($atts , $content = ''){
		global $post;
		$post_thumbnail_id = get_post_thumbnail_id($post->ID);
		return $this->create_slider($content, $post->ID, $post_thumbnail_id);
	}

	/**
	 * Build the return value for either shortcode or WP filter
	 *
	 * @since    1.0.0
	 * @changed  2.0.1 removed inside gallery with one item
	 */
	private function create_slider($html, $post_id , $post_thumbnail_id = 0){
		//saved values
		$values = array();
		parse_str(get_option('revslider_featured_addon'), $values);

		$post_revslider_id = get_post_meta($post_id, 'revslider_featured_slider_id', true);

		//defaults in case no saved values
		$values['revslider-featured-addon-type'] = $this->get_val($values, 'revslider-featured-addon-type', 'single');
		$values['revslider-featured-addon-slider'] = $this->get_val($values, 'revslider-featured-addon-slider', '');

		//defaults for display logic
		$values['revslider-featured-addon-overwrite-featured-image'] = $this->get_val($values, 'revslider-featured-addon-overwrite-featured-image', 'off');
		$values['revslider-featured-addon-overwrite-featured-slider'] = $this->get_val($values, 'revslider-featured-addon-overwrite-featured-slider', 'off');
		$values['revslider-featured-addon-write-when-no-featured-image'] = $this->get_val($values, 'revslider-featured-addon-write-when-no-featured-image', 'off');

		//auto display
		if($values['revslider-featured-addon-type'] == 'auto' && !empty($values['revslider-featured-addon-slider'])){
			//Option: Overwrite featured image off
			if($values['revslider-featured-addon-overwrite-featured-image'] == "off" && $post_thumbnail_id>0) return $html;
			//Option: Overwrite featured slider off
			if($values['revslider-featured-addon-overwrite-featured-slider'] == "off" && !empty($post_revslider_id)){
				//Set Slider to local post saved slider
				$values['revslider-featured-addon-slider'] = $post_revslider_id;
			}else{
				//Option: No featured Image = No slider also
				if($values['revslider-featured-addon-write-when-no-featured-image'] == "off" && $post_thumbnail_id < 0) return $html;
			}
			//Add RevSlider Shortcode with current post as only content
			$html = do_shortcode('[rev_slider alias="'.$values['revslider-featured-addon-slider'].'"][/rev_slider]');
		}else{
			if(!empty($post_revslider_id)){
				$html = do_shortcode('[rev_slider alias="'.$post_revslider_id.'"][/rev_slider]');
			}
		}

		return $html;
	}

	/**
	 * Mostly the same as `get_metadata()` makes sure any postthumbnail function gets checked at
	 * the deepest level possible.
	 *
	 */
	function set_revslider_addon_meta_key($null = null, $object_id = '', $meta_key = '', $single = ''){
		// only affect thumbnails on the frontend, do allow ajax calls
		
		if((is_admin() && (! defined('DOING_AJAX') || ! DOING_AJAX)) || '_thumbnail_id' != $meta_key)
			return $null;

		$meta_cache = wp_cache_get($object_id, 'post' . '_meta');

		if(!$meta_cache){
			$meta_cache = update_meta_cache('post', array($object_id));
			$meta_cache = $meta_cache[$object_id];
		}

		if(!$meta_key) return $meta_cache;

		if(isset($meta_cache[$meta_key])){
			return ($single) ? maybe_unserialize($meta_cache[$meta_key][0]) : array_map('maybe_unserialize', $meta_cache[$meta_key]);
		}

		// allow to set an other ID
		return ($single) ? apply_filters('revslider_featured_image_thumbnail_id', -3 , $object_id) : array();
	}

	public function filter_get_posts($query, $slider_id){
	}


}
