<?php
/**
 * @since      1.0.0
 * @package    Revslider_Featured_Addon
 * @subpackage Revslider_Featured_Addon/includes
 * @author     ThemePunch <info@themepunch.com>
 */
class Revslider_Featured_Addon {

	protected $plugin_name;
	protected $version;

	public function __construct() {

		$this->plugin_name = 'revslider-featured-addon';
		$this->version = REV_ADDON_FEATURED_VERSION;

		$this->load_dependencies();
		$this->set_locale();
		
		$enabled = get_option('revslider_featured_enabled');
		
		if(is_admin()) {
			$this->define_admin_hooks($enabled);
		} else {
			if(!empty($enabled)) $this->define_public_hooks();
		}

	}

	private function load_dependencies() {
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-revslider-featured-addon-admin.php';
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'public/class-revslider-featured-addon-public.php';
		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-revslider-featured-addon-update.php';
	}

	private function set_locale() {
		add_action('after_setup_theme', array($this, 'load_plugin_textdomain'), 10, 1);
	}

	public function load_plugin_textdomain() {
		load_plugin_textdomain($this->get_plugin_name(), false, dirname( dirname( plugin_basename( __FILE__ ) ) ) . '/languages/');
	}

	/**
	 * Register all of the hooks related to the admin area functionality
	 * of the plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 */
	private function define_admin_hooks($enabled) {

		$plugin_admin = new Revslider_Featured_Addon_Admin( $this->get_plugin_name(), $this->get_version() );
		$update_admin = new RevAddOnFeaturedUpdate(REV_ADDON_FEATURED_VERSION);

		add_action('admin_enqueue_scripts', array($plugin_admin, 'enqueue_styles'), 10, 1);
		add_action('admin_enqueue_scripts', array($plugin_admin, 'enqueue_scripts'), 10, 1);

		//updates
		add_filter('pre_set_site_transient_update_plugins', array($update_admin, 'set_update_transient'), 10, 1);
		add_filter('plugins_api', array($update_admin, 'set_updates_api_results'), 10, 3);

		add_action('revslider_do_ajax', array($plugin_admin, 'do_ajax'), 10, 2);

		//build js global var for activation
		add_action('revslider_activate_addon', array($plugin_admin, 'get_var'), 10, 2);

		//meta box
		if($enabled) {
			add_action('add_meta_boxes', array($plugin_admin, 'featured_slider_add_metabox'), 10, 1);
			add_action('save_post', array($plugin_admin, 'featured_slider_save'), 10, 1);
		}

	}
	
	private function define_public_hooks() {
		$plugin_public = new Revslider_Featured_Addon_Public( $this->get_plugin_name(), $this->get_version() );

		add_filter('post_thumbnail_html', array($plugin_public, 'post_thumbnail_replace'), 20, 5);
		add_filter('get_post_metadata', array($plugin_public, 'set_revslider_addon_meta_key'), 10, 4);
	}

	public function get_plugin_name() {
		return $this->plugin_name;
	}

	public function get_version() {
		return $this->version;
	}

}
