<?php
/**
 * Team Met Pro Widget (اسلایدر تیم ما – ویجت دیستو)
 *
 * @since 1.0.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! did_action( 'elementor/loaded' ) ) {
	return;
}

/**
 * Elementor Team Met Pro Widget – ویجت اسلایدر تیم ما در دسته ویجت‌های دیستو.
 */
class Disto_Team_Met_Pro_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'team_met_pro';
	}

	public function get_title() {
		return esc_html__( 'اسلایدر تیم ما', 'disto' );
	}

	public function get_icon() {
		return 'eicon-person';
	}

	public function get_categories() {
		return array( 'disto-elements' );
	}

	public function get_style_depends() {
		return array( 'disto-child-team-met-pro' );
	}

	public function get_script_depends() {
		return array( 'disto-child-team-met-pro', 'disto-child-swiper' );
	}

	public function get_keywords() {
		return array( 'team', 'member', 'slider', 'grid', 'staff', 'person' );
	}

	protected function register_controls() {
		$this->start_controls_section(
			'content_display_section',
			array(
				'label' => esc_html__( 'Display Settings', 'disto' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'layout_type',
			array(
				'label'   => esc_html__( 'Layout Type', 'disto' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'slider',
				'options' => array(
					'slider' => esc_html__( 'Slider', 'disto' ),
					'grid'   => esc_html__( 'Grid', 'disto' ),
				),
			)
		);

		$this->add_control(
			'grid_columns',
			array(
				'label'     => esc_html__( 'Columns', 'disto' ),
				'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => '3',
				'options'   => array( '1' => '1', '2' => '2', '3' => '3', '4' => '4' ),
				'condition' => array( 'layout_type' => 'grid' ),
				'selectors' => array( '{{WRAPPER}} .team-met-pro-grid' => 'grid-template-columns: repeat({{VALUE}}, 1fr);' ),
			)
		);

		$this->add_control(
			'grid_gap',
			array(
				'label'     => esc_html__( 'Gap', 'disto' ),
				'type'      => \Elementor\Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'     => array( 'px' => array( 'min' => 0, 'max' => 100 ) ),
				'default'   => array( 'unit' => 'px', 'size' => 30 ),
				'condition' => array( 'layout_type' => 'grid' ),
				'selectors' => array( '{{WRAPPER}} .team-met-pro-grid' => 'gap: {{SIZE}}{{UNIT}};' ),
			)
		);

		$this->add_control(
			'slider_autoplay',
			array(
				'label'     => esc_html__( 'اتوماتیک (تعویض خودکار اسلاید)', 'disto' ),
				'type'      => \Elementor\Controls_Manager::SWITCHER,
				'label_on'  => esc_html__( 'بله', 'disto' ),
				'label_off' => esc_html__( 'خیر', 'disto' ),
				'return_value' => 'yes',
				'default'   => 'yes',
				'condition' => array( 'layout_type' => 'slider' ),
			)
		);

		$this->add_control(
			'slider_autoplay_delay',
			array(
				'label'     => esc_html__( 'زمان تأخیر اتوپلی (میلی‌ثانیه)', 'disto' ),
				'type'      => \Elementor\Controls_Manager::NUMBER,
				'default'   => 3000,
				'condition' => array( 'layout_type' => 'slider', 'slider_autoplay' => 'yes' ),
			)
		);

		$this->add_control(
			'slider_loop',
			array(
				'label'     => esc_html__( 'Loop', 'disto' ),
				'type'      => \Elementor\Controls_Manager::SWITCHER,
				'label_on'  => esc_html__( 'Yes', 'disto' ),
				'label_off' => esc_html__( 'No', 'disto' ),
				'return_value' => 'yes',
				'default'   => 'yes',
				'condition' => array( 'layout_type' => 'slider' ),
			)
		);

		$this->add_control(
			'slider_pause_on_hover',
			array(
				'label'     => esc_html__( 'با موس روی اسلایدر: توقف اتوپلی و غیرفعال کردن افکت/انیمیشن', 'disto' ),
				'type'      => \Elementor\Controls_Manager::SWITCHER,
				'label_on'  => esc_html__( 'بله', 'disto' ),
				'label_off' => esc_html__( 'خیر', 'disto' ),
				'return_value' => 'yes',
				'default'   => 'yes',
				'condition' => array( 'layout_type' => 'slider', 'slider_autoplay' => 'yes' ),
			)
		);

		$this->add_control(
			'slider_speed',
			array(
				'label'     => esc_html__( 'Speed (ms)', 'disto' ),
				'type'      => \Elementor\Controls_Manager::NUMBER,
				'default'   => 500,
				'condition' => array( 'layout_type' => 'slider' ),
			)
		);

		$this->add_control(
			'slider_arrows',
			array(
				'label'     => esc_html__( 'Show Arrows', 'disto' ),
				'type'      => \Elementor\Controls_Manager::SWITCHER,
				'label_on'  => esc_html__( 'Yes', 'disto' ),
				'label_off' => esc_html__( 'No', 'disto' ),
				'return_value' => 'yes',
				'default'   => 'yes',
				'condition' => array( 'layout_type' => 'slider' ),
			)
		);

		$this->add_control(
			'slider_dots',
			array(
				'label'     => esc_html__( 'Show Dots', 'disto' ),
				'type'      => \Elementor\Controls_Manager::SWITCHER,
				'label_on'  => esc_html__( 'Yes', 'disto' ),
				'label_off' => esc_html__( 'No', 'disto' ),
				'return_value' => 'yes',
				'default'   => 'yes',
				'condition' => array( 'layout_type' => 'slider' ),
			)
		);

		$this->add_control(
			'slides_per_view',
			array(
				'label'     => esc_html__( 'Slides Per View', 'disto' ),
				'type'      => \Elementor\Controls_Manager::NUMBER,
				'default'   => 3,
				'min'       => 1,
				'max'       => 6,
				'condition' => array( 'layout_type' => 'slider' ),
			)
		);

		$this->add_control(
			'slides_per_view_tablet',
			array(
				'label'     => esc_html__( 'Slides Per View (Tablet)', 'disto' ),
				'type'      => \Elementor\Controls_Manager::NUMBER,
				'default'   => 2,
				'min'       => 1,
				'max'       => 4,
				'condition' => array( 'layout_type' => 'slider' ),
			)
		);

		$this->add_control(
			'slides_per_view_mobile',
			array(
				'label'     => esc_html__( 'Slides Per View (Mobile)', 'disto' ),
				'type'      => \Elementor\Controls_Manager::NUMBER,
				'default'   => 1,
				'min'       => 1,
				'max'       => 2,
				'condition' => array( 'layout_type' => 'slider' ),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'content_layout_section',
			array(
				'label' => esc_html__( 'Layout Style', 'disto' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'layout_style',
			array(
				'label'   => esc_html__( 'Layout Style', 'disto' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'style1',
				'options' => array(
					'style1' => esc_html__( 'Style 1 - Classic Side Image', 'disto' ),
					'style2' => esc_html__( 'Style 2 - Card Centered', 'disto' ),
					'style3' => esc_html__( 'Style 3 - Overlay on Image', 'disto' ),
					'style4' => esc_html__( 'Style 4 - Minimal Clean Split', 'disto' ),
					'style5' => esc_html__( 'Style 5 - Modern Glass Effect', 'disto' ),
				),
			)
		);

		$this->add_control(
			'image_position',
			array(
				'label'     => esc_html__( 'جایگاه عکس', 'disto' ),
				'type'      => \Elementor\Controls_Manager::CHOOSE,
				'default'   => is_rtl() ? 'right' : 'left',
				'options'   => array(
					'left'  => array( 'title' => esc_html__( 'چپ', 'disto' ), 'icon' => 'eicon-h-align-left' ),
					'right' => array( 'title' => esc_html__( 'راست', 'disto' ), 'icon' => 'eicon-h-align-right' ),
				),
				'toggle'    => false,
				'condition' => array( 'layout_style' => 'style1' ),
			)
		);

		$this->add_control(
			'show_separator',
			array(
				'label'     => esc_html__( 'خط جداکننده زیر نام', 'disto' ),
				'type'      => \Elementor\Controls_Manager::SWITCHER,
				'label_on'  => esc_html__( 'بله', 'disto' ),
				'label_off' => esc_html__( 'خیر', 'disto' ),
				'return_value' => 'yes',
				'default'   => 'yes',
				'condition' => array( 'layout_style' => 'style1' ),
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'content_team_section',
			array(
				'label' => esc_html__( 'Team Members', 'disto' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			)
		);

		$repeater = new \Elementor\Repeater();
		$repeater->add_control( 'profile_image', array(
			'label' => esc_html__( 'Profile Image', 'disto' ),
			'type'  => \Elementor\Controls_Manager::MEDIA,
			'default' => array( 'url' => \Elementor\Utils::get_placeholder_image_src() ),
			'dynamic' => array( 'active' => true ),
		) );
		$repeater->add_control( 'name', array(
			'label' => esc_html__( 'نام پروفایل', 'disto' ),
			'type'  => \Elementor\Controls_Manager::TEXT,
			'default' => esc_html__( 'Profile Name', 'disto' ),
			'placeholder' => esc_html__( 'نام عضو', 'disto' ),
			'dynamic' => array( 'active' => true ),
		) );
		$repeater->add_control( 'position', array(
			'label' => esc_html__( 'پوزیشن شغلی', 'disto' ),
			'type'  => \Elementor\Controls_Manager::TEXT,
			'default' => esc_html__( 'سمت', 'disto' ),
			'placeholder' => esc_html__( 'مثلاً مدیر، طراح', 'disto' ),
			'dynamic' => array( 'active' => true ),
		) );
		$repeater->add_control( 'position_label', array(
			'label' => esc_html__( 'برچسب پوزیشن (اختیاری)', 'disto' ),
			'type'  => \Elementor\Controls_Manager::TEXT,
			'default' => 'POSITION',
			'placeholder' => 'POSITION',
			'description' => esc_html__( 'مثلاً POSITION بالای سمت شغلی', 'disto' ),
		) );
		$repeater->add_control( 'description', array(
			'label' => esc_html__( 'توضیحات پروفایل عضو', 'disto' ),
			'type'  => \Elementor\Controls_Manager::WYSIWYG,
			'default' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.',
			'placeholder' => esc_html__( 'توضیحات', 'disto' ),
			'dynamic' => array( 'active' => true ),
		) );
		$repeater->add_control( 'button_text', array(
			'label' => esc_html__( 'Button Text', 'disto' ),
			'type'  => \Elementor\Controls_Manager::TEXT,
			'default' => esc_html__( 'بیشتر', 'disto' ),
			'placeholder' => esc_html__( 'متن دکمه', 'disto' ),
		) );
		$repeater->add_control( 'button_url', array(
			'label' => esc_html__( 'Button URL', 'disto' ),
			'type'  => \Elementor\Controls_Manager::URL,
			'placeholder' => esc_html__( 'https://your-link.com', 'disto' ),
			'show_external' => true,
			'default' => array( 'url' => '', 'is_external' => true, 'nofollow' => true ),
			'dynamic' => array( 'active' => true ),
		) );

		/* شبکه مجازی: اسلات‌های ثابت (بدون ریپیتر تو در تو) — دکمه «افزودن مورد» فقط عضو تیم اضافه می‌کند */
		$repeater->add_control( 'social_heading', array(
			'label' => esc_html__( 'شبکه مجازی (آیکن‌ها)', 'disto' ),
			'type'  => \Elementor\Controls_Manager::HEADING,
			'separator' => 'before',
		) );
		$repeater->add_control( 'social_heading_note', array(
			'type'            => \Elementor\Controls_Manager::RAW_HTML,
			'raw'             => '<small style="color:#888;">' . esc_html__( 'برای این عضو تا ۸ آیکن در زیر تنظیم کنید. دکمه «افزودن مورد» در بالا فقط برای اضافه کردن عضو جدید به تیم است، نه آیکن.', 'disto' ) . '</small>',
			'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',
		) );
		for ( $n = 1; $n <= 8; $n++ ) {
			$repeater->add_control( 'social_' . $n . '_icon', array(
				'label' => sprintf( esc_html__( 'آیکن %d', 'disto' ), $n ),
				'type'  => \Elementor\Controls_Manager::ICONS,
				'default' => $n === 1 ? array( 'value' => 'fab fa-facebook', 'library' => 'fa-brands' ) : array(),
			) );
			$repeater->add_control( 'social_' . $n . '_url', array(
				'label' => sprintf( esc_html__( 'لینک آیکن %d', 'disto' ), $n ),
				'type'  => \Elementor\Controls_Manager::URL,
				'placeholder' => 'https://',
				'show_external' => true,
				'default' => array( 'url' => '', 'is_external' => true, 'nofollow' => true ),
				'dynamic' => array( 'active' => true ),
			) );
		}

		$this->add_control(
			'team_members',
			array(
				'label'   => esc_html__( 'Team Members', 'disto' ),
				'type'    => \Elementor\Controls_Manager::REPEATER,
				'fields'  => $repeater->get_controls(),
				'default' => array(
					array(
						'name' => esc_html__( 'عضو اول', 'disto' ),
						'position' => esc_html__( 'مدیر', 'disto' ),
						'position_label' => 'POSITION',
						'social_1_icon' => array( 'value' => 'fab fa-facebook', 'library' => 'fa-brands' ),
						'social_1_url' => array( 'url' => '#' ),
						'social_2_icon' => array( 'value' => 'fab fa-twitter', 'library' => 'fa-brands' ),
						'social_2_url' => array( 'url' => '#' ),
						'social_3_icon' => array( 'value' => 'fab fa-instagram', 'library' => 'fa-brands' ),
						'social_3_url' => array( 'url' => '#' ),
					),
					array(
						'name' => esc_html__( 'عضو دوم', 'disto' ),
						'position' => esc_html__( 'طراح', 'disto' ),
						'position_label' => 'POSITION',
						'social_1_icon' => array( 'value' => 'fab fa-facebook', 'library' => 'fa-brands' ),
						'social_1_url' => array( 'url' => '#' ),
						'social_2_icon' => array( 'value' => 'fab fa-linkedin', 'library' => 'fa-brands' ),
						'social_2_url' => array( 'url' => '#' ),
					),
				),
				'title_field' => '{{{ name }}}',
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'content_animation_section',
			array(
				'label' => esc_html__( 'Animations', 'disto' ),
				'tab'   => \Elementor\Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control( 'enable_animation', array(
			'label' => esc_html__( 'Enable Animation', 'disto' ),
			'type'  => \Elementor\Controls_Manager::SWITCHER,
			'label_on' => esc_html__( 'Yes', 'disto' ),
			'label_off' => esc_html__( 'No', 'disto' ),
			'return_value' => 'yes',
			'default' => 'yes',
		) );
		$this->add_control( 'animation_type', array(
			'label'     => esc_html__( 'Animation Type', 'disto' ),
			'type'      => \Elementor\Controls_Manager::SELECT,
			'default'   => 'fade',
			'options'   => array(
				'fade'       => esc_html__( 'Fade', 'disto' ),
				'slide-up'   => esc_html__( 'Slide Up', 'disto' ),
				'slide-right'=> esc_html__( 'Slide Right', 'disto' ),
				'zoom-in'    => esc_html__( 'Zoom In', 'disto' ),
				'flip'       => esc_html__( 'Flip', 'disto' ),
				'parallax'   => esc_html__( 'Parallax', 'disto' ),
			),
			'condition' => array( 'enable_animation' => 'yes' ),
		) );
		$this->add_control( 'animation_delay', array(
			'label'     => esc_html__( 'Animation Delay (ms)', 'disto' ),
			'type'      => \Elementor\Controls_Manager::NUMBER,
			'default'   => 100,
			'min'       => 0,
			'max'       => 2000,
			'condition' => array( 'enable_animation' => 'yes' ),
		) );
		$this->add_control( 'animation_duration', array(
			'label'     => esc_html__( 'Animation Duration (ms)', 'disto' ),
			'type'      => \Elementor\Controls_Manager::NUMBER,
			'default'   => 800,
			'min'       => 100,
			'max'       => 3000,
			'condition' => array( 'enable_animation' => 'yes' ),
		) );
		$this->add_control( 'stagger_animation', array(
			'label'     => esc_html__( 'Stagger Animation (Grid)', 'disto' ),
			'type'      => \Elementor\Controls_Manager::SWITCHER,
			'label_on' => esc_html__( 'Yes', 'disto' ),
			'label_off' => esc_html__( 'No', 'disto' ),
			'return_value' => 'yes',
			'default'   => 'yes',
			'condition' => array( 'enable_animation' => 'yes', 'layout_type' => 'grid' ),
		) );
		$this->add_control( 'hover_image_zoom', array(
			'label' => esc_html__( 'Image Zoom on Hover', 'disto' ),
			'type'  => \Elementor\Controls_Manager::SWITCHER,
			'label_on' => esc_html__( 'Yes', 'disto' ),
			'label_off' => esc_html__( 'No', 'disto' ),
			'return_value' => 'yes',
			'default' => 'yes',
		) );
		$this->add_control( 'hover_card_lift', array(
			'label' => esc_html__( 'Card Lift on Hover', 'disto' ),
			'type'  => \Elementor\Controls_Manager::SWITCHER,
			'label_on' => esc_html__( 'Yes', 'disto' ),
			'label_off' => esc_html__( 'No', 'disto' ),
			'return_value' => 'yes',
			'default' => 'yes',
		) );
		$this->add_control( 'hover_glow', array(
			'label' => esc_html__( 'Glow Effect on Hover', 'disto' ),
			'type'  => \Elementor\Controls_Manager::SWITCHER,
			'label_on' => esc_html__( 'Yes', 'disto' ),
			'label_off' => esc_html__( 'No', 'disto' ),
			'return_value' => 'yes',
			'default' => 'no',
		) );
		$this->add_control( 'hover_rotate_icon', array(
			'label' => esc_html__( 'Rotate Icon on Hover', 'disto' ),
			'type'  => \Elementor\Controls_Manager::SWITCHER,
			'label_on' => esc_html__( 'Yes', 'disto' ),
			'label_off' => esc_html__( 'No', 'disto' ),
			'return_value' => 'yes',
			'default' => 'yes',
		) );

		$this->end_controls_section();

		// Style sections – wrapper, card, image, name, position, description, button, social, slider
		$this->start_controls_section( 'style_wrapper_section', array(
			'label' => esc_html__( 'Wrapper', 'disto' ),
			'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
		) );
		$this->add_group_control( \Elementor\Group_Control_Background::get_type(), array(
			'name'     => 'wrapper_background',
			'label'    => esc_html__( 'بک‌گراند (مثلاً کرم)', 'disto' ),
			'types'    => array( 'classic', 'gradient', 'image' ),
			'selector' => '{{WRAPPER}} .team-met-pro-wrapper',
			'fields_options' => array(
				'background' => array(
					'default' => 'classic',
				),
				'color' => array(
					'default' => '#f5f0e8',
				),
			),
		) );
		$this->add_responsive_control( 'wrapper_padding', array(
			'label'      => esc_html__( 'Padding', 'disto' ),
			'type'       => \Elementor\Controls_Manager::DIMENSIONS,
			'size_units' => array( 'px', 'em', '%' ),
			'selectors'  => array( '{{WRAPPER}} .team-met-pro-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ),
		) );
		$this->add_control( 'wrapper_border_radius', array(
			'label'      => esc_html__( 'Border Radius', 'disto' ),
			'type'       => \Elementor\Controls_Manager::DIMENSIONS,
			'size_units' => array( 'px', '%' ),
			'selectors'  => array( '{{WRAPPER}} .team-met-pro-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ),
		) );
		$this->add_group_control( \Elementor\Group_Control_Box_Shadow::get_type(), array(
			'name'     => 'wrapper_box_shadow',
			'label'    => esc_html__( 'Box Shadow', 'disto' ),
			'selector' => '{{WRAPPER}} .team-met-pro-wrapper',
		) );
		$this->end_controls_section();

		$this->start_controls_section( 'style_card_section', array(
			'label' => esc_html__( 'باکس عضو (Card)', 'disto' ),
			'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
		) );
		$this->add_group_control( \Elementor\Group_Control_Background::get_type(), array(
			'name'     => 'card_background',
			'label'    => esc_html__( 'Background', 'disto' ),
			'types'    => array( 'classic', 'gradient' ),
			'selector' => '{{WRAPPER}} .team-met-pro-item',
		) );
		$this->add_group_control( \Elementor\Group_Control_Border::get_type(), array(
			'name'     => 'card_border',
			'label'    => esc_html__( 'Border', 'disto' ),
			'selector' => '{{WRAPPER}} .team-met-pro-item',
		) );
		$this->add_control( 'card_border_radius', array(
			'label'      => esc_html__( 'گردی باکس عضو', 'disto' ),
			'type'       => \Elementor\Controls_Manager::DIMENSIONS,
			'size_units' => array( 'px', '%' ),
			'selectors'  => array( '{{WRAPPER}} .team-met-pro-item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ),
		) );
		$this->add_control( 'card_hover_background', array(
			'label'    => esc_html__( 'Hover Background', 'disto' ),
			'type'     => \Elementor\Controls_Manager::COLOR,
			'selectors' => array( '{{WRAPPER}} .team-met-pro-item:hover' => 'background-color: {{VALUE}};' ),
		) );
		$this->add_group_control( \Elementor\Group_Control_Box_Shadow::get_type(), array(
			'name'     => 'card_hover_shadow',
			'label'    => esc_html__( 'Hover Shadow', 'disto' ),
			'selector' => '{{WRAPPER}} .team-met-pro-item:hover',
		) );
		$this->add_control( 'card_transition_duration', array(
			'label'    => esc_html__( 'Transition Duration (ms)', 'disto' ),
			'type'     => \Elementor\Controls_Manager::SLIDER,
			'range'    => array( 'px' => array( 'min' => 0, 'max' => 3000 ) ),
			'default'  => array( 'size' => 300 ),
			'selectors' => array( '{{WRAPPER}} .team-met-pro-item' => 'transition-duration: {{SIZE}}ms;' ),
		) );
		$this->end_controls_section();

		$this->start_controls_section( 'style_image_section', array(
			'label' => esc_html__( 'عکس پروفایل', 'disto' ),
			'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
		) );
		$this->add_responsive_control( 'image_width', array(
			'label'      => esc_html__( 'Width', 'disto' ),
			'type'       => \Elementor\Controls_Manager::SLIDER,
			'size_units' => array( 'px', '%' ),
			'range'      => array( 'px' => array( 'min' => 0, 'max' => 1000 ), '%' => array( 'min' => 0, 'max' => 100 ) ),
			'selectors'  => array( '{{WRAPPER}} .team-met-pro-image img' => 'width: {{SIZE}}{{UNIT}};' ),
		) );
		$this->add_responsive_control( 'image_height', array(
			'label'      => esc_html__( 'Height', 'disto' ),
			'type'       => \Elementor\Controls_Manager::SLIDER,
			'size_units' => array( 'px', '%' ),
			'range'      => array( 'px' => array( 'min' => 0, 'max' => 1000 ), '%' => array( 'min' => 0, 'max' => 100 ) ),
			'selectors'  => array( '{{WRAPPER}} .team-met-pro-image img' => 'height: {{SIZE}}{{UNIT}};' ),
		) );
		$this->add_control( 'image_object_fit', array(
			'label'   => esc_html__( 'Object Fit', 'disto' ),
			'type'    => \Elementor\Controls_Manager::SELECT,
			'default' => 'cover',
			'options' => array( 'cover' => esc_html__( 'Cover', 'disto' ), 'contain' => esc_html__( 'Contain', 'disto' ), 'fill' => esc_html__( 'Fill', 'disto' ), 'none' => esc_html__( 'None', 'disto' ) ),
			'selectors' => array( '{{WRAPPER}} .team-met-pro-image img' => 'object-fit: {{VALUE}};' ),
		) );
		$this->add_group_control( \Elementor\Group_Control_Border::get_type(), array(
			'name'     => 'image_border',
			'label'    => esc_html__( 'Border', 'disto' ),
			'selector' => '{{WRAPPER}} .team-met-pro-image img',
		) );
		$this->add_control( 'image_border_radius', array(
			'label'      => esc_html__( 'گردی عکس', 'disto' ),
			'type'       => \Elementor\Controls_Manager::DIMENSIONS,
			'size_units' => array( 'px', '%' ),
			'selectors'  => array( '{{WRAPPER}} .team-met-pro-image img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ),
		) );
		$this->add_control( 'image_overlay_color', array(
			'label'     => esc_html__( 'Overlay Color', 'disto' ),
			'type'      => \Elementor\Controls_Manager::COLOR,
			'selectors' => array( '{{WRAPPER}} .team-met-pro-image::after' => 'background-color: {{VALUE}};' ),
			'condition' => array( 'layout_style' => 'style3' ),
		) );
		$this->end_controls_section();

		$this->start_controls_section( 'style_name_section', array(
			'label' => esc_html__( 'Name', 'disto' ),
			'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
		) );
		$this->add_group_control( \Elementor\Group_Control_Typography::get_type(), array(
			'name'     => 'name_typography',
			'label'    => esc_html__( 'Typography', 'disto' ),
			'selector' => '{{WRAPPER}} .team-met-pro-name',
		) );
		$this->add_control( 'name_color', array(
			'label'    => esc_html__( 'Color', 'disto' ),
			'type'     => \Elementor\Controls_Manager::COLOR,
			'selectors' => array( '{{WRAPPER}} .team-met-pro-name' => 'color: {{VALUE}};' ),
		) );
		$this->add_control( 'name_hover_color', array(
			'label'    => esc_html__( 'Hover Color', 'disto' ),
			'type'     => \Elementor\Controls_Manager::COLOR,
			'selectors' => array( '{{WRAPPER}} .team-met-pro-item:hover .team-met-pro-name' => 'color: {{VALUE}};' ),
		) );
		$this->add_responsive_control( 'name_margin', array(
			'label'      => esc_html__( 'Margin', 'disto' ),
			'type'       => \Elementor\Controls_Manager::DIMENSIONS,
			'size_units' => array( 'px', 'em', '%' ),
			'selectors'  => array( '{{WRAPPER}} .team-met-pro-name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ),
		) );
		$this->add_control( 'name_background_heading', array(
			'label'     => esc_html__( 'پس‌زمینه بلوک نام', 'disto' ),
			'type'      => \Elementor\Controls_Manager::HEADING,
			'separator' => 'before',
		) );
		$this->add_control( 'name_background', array(
			'label'    => esc_html__( 'رنگ پس‌زمینه نام', 'disto' ),
			'type'     => \Elementor\Controls_Manager::COLOR,
			'default'  => '#ffffff',
			'selectors' => array( '{{WRAPPER}} .team-met-pro-name-inner' => 'background-color: {{VALUE}};' ),
		) );
		$this->add_responsive_control( 'name_inner_padding', array(
			'label'      => esc_html__( 'فاصله داخلی بلوک نام', 'disto' ),
			'type'       => \Elementor\Controls_Manager::DIMENSIONS,
			'size_units' => array( 'px', 'em', '%' ),
			'default'    => array( 'top' => '8', 'right' => '16', 'bottom' => '8', 'left' => '16' ),
			'selectors'  => array( '{{WRAPPER}} .team-met-pro-name-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ),
		) );
		$this->end_controls_section();

		$this->start_controls_section( 'style_position_section', array(
			'label' => esc_html__( 'Position', 'disto' ),
			'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
		) );
		$this->add_group_control( \Elementor\Group_Control_Typography::get_type(), array(
			'name'     => 'position_typography',
			'label'    => esc_html__( 'Typography', 'disto' ),
			'selector' => '{{WRAPPER}} .team-met-pro-position',
		) );
		$this->add_control( 'position_color', array(
			'label'    => esc_html__( 'Color', 'disto' ),
			'type'     => \Elementor\Controls_Manager::COLOR,
			'selectors' => array( '{{WRAPPER}} .team-met-pro-position' => 'color: {{VALUE}};' ),
		) );
		$this->add_responsive_control( 'position_spacing', array(
			'label'      => esc_html__( 'Spacing', 'disto' ),
			'type'       => \Elementor\Controls_Manager::SLIDER,
			'size_units' => array( 'px', 'em' ),
			'range'      => array( 'px' => array( 'min' => 0, 'max' => 100 ) ),
			'selectors'  => array( '{{WRAPPER}} .team-met-pro-position-wrap' => 'margin-bottom: {{SIZE}}{{UNIT}};' ),
		) );
		$this->add_control( 'position_label_typography_heading', array(
			'label'     => esc_html__( 'برچسب پوزیشن (مثلاً POSITION)', 'disto' ),
			'type'      => \Elementor\Controls_Manager::HEADING,
			'separator' => 'before',
		) );
		$this->add_group_control( \Elementor\Group_Control_Typography::get_type(), array(
			'name'     => 'position_label_typography',
			'label'    => esc_html__( 'Typography برچسب', 'disto' ),
			'selector' => '{{WRAPPER}} .team-met-pro-position-label',
		) );
		$this->add_control( 'position_label_color', array(
			'label'    => esc_html__( 'رنگ برچسب', 'disto' ),
			'type'     => \Elementor\Controls_Manager::COLOR,
			'selectors' => array( '{{WRAPPER}} .team-met-pro-position-label' => 'color: {{VALUE}};' ),
		) );
		$this->end_controls_section();

		$this->start_controls_section( 'style_separator_section', array(
			'label' => esc_html__( 'خط جداکننده زیر نام', 'disto' ),
			'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
		) );
		$this->add_control( 'separator_color', array(
			'label'    => esc_html__( 'رنگ خط', 'disto' ),
			'type'     => \Elementor\Controls_Manager::COLOR,
			'default'  => 'rgba(0,0,0,0.15)',
			'selectors' => array( '{{WRAPPER}} .team-met-pro-separator' => 'background-color: {{VALUE}};' ),
		) );
		$this->add_control( 'separator_width', array(
			'label'      => esc_html__( 'عرض خط (px یا %)', 'disto' ),
			'type'       => \Elementor\Controls_Manager::SLIDER,
			'size_units' => array( 'px', '%' ),
			'range'      => array( 'px' => array( 'min' => 0, 'max' => 500 ), '%' => array( 'min' => 0, 'max' => 100 ) ),
			'default'    => array( 'unit' => 'px', 'size' => 60 ),
			'selectors'  => array( '{{WRAPPER}} .team-met-pro-separator' => 'width: {{SIZE}}{{UNIT}};' ),
		) );
		$this->add_control( 'separator_height', array(
			'label'      => esc_html__( 'ضخامت خط (px)', 'disto' ),
			'type'       => \Elementor\Controls_Manager::SLIDER,
			'size_units' => array( 'px' ),
			'range'      => array( 'px' => array( 'min' => 1, 'max' => 20 ) ),
			'default'    => array( 'size' => 2 ),
			'selectors'  => array( '{{WRAPPER}} .team-met-pro-separator' => 'height: {{SIZE}}{{UNIT}};' ),
		) );
		$this->add_responsive_control( 'separator_spacing', array(
			'label'      => esc_html__( 'فاصله بالا و پایین', 'disto' ),
			'type'       => \Elementor\Controls_Manager::DIMENSIONS,
			'size_units' => array( 'px', 'em' ),
			'selectors'  => array( '{{WRAPPER}} .team-met-pro-separator' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ),
		) );
		$this->end_controls_section();

		$this->start_controls_section( 'style_description_section', array(
			'label' => esc_html__( 'Description', 'disto' ),
			'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
		) );
		$this->add_group_control( \Elementor\Group_Control_Typography::get_type(), array(
			'name'     => 'description_typography',
			'label'    => esc_html__( 'Typography', 'disto' ),
			'selector' => '{{WRAPPER}} .team-met-pro-description',
		) );
		$this->add_control( 'description_color', array(
			'label'    => esc_html__( 'Color', 'disto' ),
			'type'     => \Elementor\Controls_Manager::COLOR,
			'selectors' => array( '{{WRAPPER}} .team-met-pro-description' => 'color: {{VALUE}};' ),
		) );
		$this->add_control( 'description_line_height', array(
			'label'      => esc_html__( 'Line Height', 'disto' ),
			'type'       => \Elementor\Controls_Manager::SLIDER,
			'size_units' => array( 'px', 'em' ),
			'range'      => array( 'px' => array( 'min' => 0, 'max' => 100 ) ),
			'selectors'  => array( '{{WRAPPER}} .team-met-pro-description' => 'line-height: {{SIZE}}{{UNIT}};' ),
		) );
		$this->end_controls_section();

		$this->start_controls_section( 'style_button_section', array(
			'label' => esc_html__( 'Button', 'disto' ),
			'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
		) );
		$this->add_group_control( \Elementor\Group_Control_Typography::get_type(), array(
			'name'     => 'button_typography',
			'label'    => esc_html__( 'Typography', 'disto' ),
			'selector' => '{{WRAPPER}} .team-met-pro-button',
		) );
		$this->add_responsive_control( 'button_padding', array(
			'label'      => esc_html__( 'Padding', 'disto' ),
			'type'       => \Elementor\Controls_Manager::DIMENSIONS,
			'size_units' => array( 'px', 'em', '%' ),
			'selectors'  => array( '{{WRAPPER}} .team-met-pro-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ),
		) );
		$this->add_control( 'button_border_radius', array(
			'label'      => esc_html__( 'Border Radius', 'disto' ),
			'type'       => \Elementor\Controls_Manager::DIMENSIONS,
			'size_units' => array( 'px', '%' ),
			'selectors'  => array( '{{WRAPPER}} .team-met-pro-button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ),
		) );
		$this->start_controls_tabs( 'button_tabs' );
		$this->start_controls_tab( 'button_normal_tab', array( 'label' => esc_html__( 'Normal', 'disto' ) ) );
		$this->add_control( 'button_color', array(
			'label'    => esc_html__( 'Color', 'disto' ),
			'type'     => \Elementor\Controls_Manager::COLOR,
			'selectors' => array( '{{WRAPPER}} .team-met-pro-button' => 'color: {{VALUE}};' ),
		) );
		$this->add_control( 'button_background', array(
			'label'    => esc_html__( 'Background', 'disto' ),
			'type'     => \Elementor\Controls_Manager::COLOR,
			'selectors' => array( '{{WRAPPER}} .team-met-pro-button' => 'background-color: {{VALUE}};' ),
		) );
		$this->add_group_control( \Elementor\Group_Control_Border::get_type(), array(
			'name'     => 'button_border',
			'label'    => esc_html__( 'Border', 'disto' ),
			'selector' => '{{WRAPPER}} .team-met-pro-button',
		) );
		$this->end_controls_tab();
		$this->start_controls_tab( 'button_hover_tab', array( 'label' => esc_html__( 'Hover', 'disto' ) ) );
		$this->add_control( 'button_hover_color', array(
			'label'    => esc_html__( 'Color', 'disto' ),
			'type'     => \Elementor\Controls_Manager::COLOR,
			'selectors' => array( '{{WRAPPER}} .team-met-pro-button:hover' => 'color: {{VALUE}};' ),
		) );
		$this->add_control( 'button_hover_background', array(
			'label'    => esc_html__( 'Background', 'disto' ),
			'type'     => \Elementor\Controls_Manager::COLOR,
			'selectors' => array( '{{WRAPPER}} .team-met-pro-button:hover' => 'background-color: {{VALUE}};' ),
		) );
		$this->add_group_control( \Elementor\Group_Control_Border::get_type(), array(
			'name'     => 'button_hover_border',
			'label'    => esc_html__( 'Border', 'disto' ),
			'selector' => '{{WRAPPER}} .team-met-pro-button:hover',
		) );
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();

		$this->start_controls_section( 'style_social_section', array(
			'label' => esc_html__( 'Social Icons', 'disto' ),
			'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
		) );
		$this->add_control( 'social_icon_size', array(
			'label'      => esc_html__( 'Icon Size', 'disto' ),
			'type'       => \Elementor\Controls_Manager::SLIDER,
			'size_units' => array( 'px', 'em' ),
			'range'      => array( 'px' => array( 'min' => 10, 'max' => 100 ) ),
			'selectors'  => array( '{{WRAPPER}} .team-met-pro-social a' => 'font-size: {{SIZE}}{{UNIT}};' ),
		) );
		$this->add_control( 'social_icon_gap', array(
			'label'      => esc_html__( 'Gap', 'disto' ),
			'type'       => \Elementor\Controls_Manager::SLIDER,
			'size_units' => array( 'px', 'em' ),
			'range'      => array( 'px' => array( 'min' => 0, 'max' => 50 ) ),
			'selectors'  => array( '{{WRAPPER}} .team-met-pro-social a' => 'margin-left: {{SIZE}}{{UNIT}};', '{{WRAPPER}} .team-met-pro-social a:first-child' => 'margin-left: 0;' ),
		) );
		$this->add_control( 'social_alignment', array(
			'label'   => esc_html__( 'Alignment', 'disto' ),
			'type'    => \Elementor\Controls_Manager::CHOOSE,
			'options' => array(
				'left'   => array( 'title' => esc_html__( 'Left', 'disto' ), 'icon' => 'eicon-text-align-left' ),
				'center' => array( 'title' => esc_html__( 'Center', 'disto' ), 'icon' => 'eicon-text-align-center' ),
				'right'  => array( 'title' => esc_html__( 'Right', 'disto' ), 'icon' => 'eicon-text-align-right' ),
			),
			'default' => is_rtl() ? 'right' : 'left',
			'toggle'  => true,
			'selectors' => array( '{{WRAPPER}} .team-met-pro-social' => 'text-align: {{VALUE}};' ),
		) );
		$this->start_controls_tabs( 'social_tabs' );
		$this->start_controls_tab( 'social_normal_tab', array( 'label' => esc_html__( 'Normal', 'disto' ) ) );
		$this->add_control( 'social_color', array(
			'label'    => esc_html__( 'Color', 'disto' ),
			'type'     => \Elementor\Controls_Manager::COLOR,
			'selectors' => array( '{{WRAPPER}} .team-met-pro-social a' => 'color: {{VALUE}};' ),
		) );
		$this->add_control( 'social_background', array(
			'label'    => esc_html__( 'Background', 'disto' ),
			'type'     => \Elementor\Controls_Manager::COLOR,
			'selectors' => array( '{{WRAPPER}} .team-met-pro-social a' => 'background-color: {{VALUE}};' ),
		) );
		$this->add_control( 'social_border_radius', array(
			'label'      => esc_html__( 'Border Radius', 'disto' ),
			'type'       => \Elementor\Controls_Manager::DIMENSIONS,
			'size_units' => array( 'px', '%' ),
			'selectors'  => array( '{{WRAPPER}} .team-met-pro-social a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};' ),
		) );
		$this->end_controls_tab();
		$this->start_controls_tab( 'social_hover_tab', array( 'label' => esc_html__( 'Hover', 'disto' ) ) );
		$this->add_control( 'social_hover_color', array(
			'label'    => esc_html__( 'Color', 'disto' ),
			'type'     => \Elementor\Controls_Manager::COLOR,
			'selectors' => array( '{{WRAPPER}} .team-met-pro-social a:hover' => 'color: {{VALUE}};' ),
		) );
		$this->add_control( 'social_hover_background', array(
			'label'    => esc_html__( 'Background', 'disto' ),
			'type'     => \Elementor\Controls_Manager::COLOR,
			'selectors' => array( '{{WRAPPER}} .team-met-pro-social a:hover' => 'background-color: {{VALUE}};' ),
		) );
		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();

		$this->start_controls_section( 'style_slider_section', array(
			'label'     => esc_html__( 'Slider', 'disto' ),
			'tab'       => \Elementor\Controls_Manager::TAB_STYLE,
			'condition' => array( 'layout_type' => 'slider' ),
		) );
		$this->add_control( 'arrow_size', array(
			'label'      => esc_html__( 'Arrow Size', 'disto' ),
			'type'       => \Elementor\Controls_Manager::SLIDER,
			'size_units' => array( 'px', 'em' ),
			'range'      => array( 'px' => array( 'min' => 10, 'max' => 100 ) ),
			'selectors'  => array( '{{WRAPPER}} .team-met-pro-arrow' => 'font-size: {{SIZE}}{{UNIT}};' ),
		) );
		$this->add_control( 'arrow_color', array(
			'label'    => esc_html__( 'Arrow Color', 'disto' ),
			'type'     => \Elementor\Controls_Manager::COLOR,
			'selectors' => array( '{{WRAPPER}} .team-met-pro-arrow' => 'color: {{VALUE}};' ),
		) );
		$this->add_control( 'arrow_background', array(
			'label'    => esc_html__( 'Arrow Background', 'disto' ),
			'type'     => \Elementor\Controls_Manager::COLOR,
			'selectors' => array( '{{WRAPPER}} .team-met-pro-arrow' => 'background-color: {{VALUE}};' ),
		) );
		$this->add_control( 'dots_size', array(
			'label'      => esc_html__( 'Dots Size', 'disto' ),
			'type'       => \Elementor\Controls_Manager::SLIDER,
			'size_units' => array( 'px' ),
			'range'      => array( 'px' => array( 'min' => 5, 'max' => 30 ) ),
			'selectors'  => array( '{{WRAPPER}} .swiper-pagination-bullet' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};' ),
		) );
		$this->add_control( 'dots_color', array(
			'label'    => esc_html__( 'Dots Color', 'disto' ),
			'type'     => \Elementor\Controls_Manager::COLOR,
			'selectors' => array( '{{WRAPPER}} .swiper-pagination-bullet' => 'background-color: {{VALUE}};' ),
		) );
		$this->add_control( 'dots_active_color', array(
			'label'    => esc_html__( 'Active Dot Color', 'disto' ),
			'type'     => \Elementor\Controls_Manager::COLOR,
			'selectors' => array( '{{WRAPPER}} .swiper-pagination-bullet-active' => 'background-color: {{VALUE}};' ),
		) );
		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		if ( empty( $settings['team_members'] ) ) {
			return;
		}
		$layout_type  = $settings['layout_type'];
		$layout_style = $settings['layout_style'];
		$is_rtl       = is_rtl();
		$animation_class = ( ! empty( $settings['enable_animation'] ) && $settings['enable_animation'] === 'yes' )
			? 'team-met-pro-animate-' . $settings['animation_type'] : '';
		$wrapper_classes = array(
			'team-met-pro-wrapper',
			'team-met-pro-layout-' . $layout_type,
			'team-met-pro-style-' . $layout_style,
		);
		if ( $layout_style === 'style1' ) {
			$img_pos = isset( $settings['image_position'] ) ? $settings['image_position'] : ( is_rtl() ? 'right' : 'left' );
			$wrapper_classes[] = 'team-met-pro-image-' . $img_pos;
			if ( ! empty( $settings['show_separator'] ) && $settings['show_separator'] === 'yes' ) {
				$wrapper_classes[] = 'team-met-pro-has-separator';
			}
		}
		if ( $animation_class ) {
			$wrapper_classes[] = $animation_class;
		}
		if ( ! empty( $settings['hover_image_zoom'] ) && $settings['hover_image_zoom'] === 'yes' ) {
			$wrapper_classes[] = 'team-met-pro-hover-zoom';
		}
		if ( ! empty( $settings['hover_card_lift'] ) && $settings['hover_card_lift'] === 'yes' ) {
			$wrapper_classes[] = 'team-met-pro-hover-lift';
		}
		if ( ! empty( $settings['hover_glow'] ) && $settings['hover_glow'] === 'yes' ) {
			$wrapper_classes[] = 'team-met-pro-hover-glow';
		}
		if ( ! empty( $settings['hover_rotate_icon'] ) && $settings['hover_rotate_icon'] === 'yes' ) {
			$wrapper_classes[] = 'team-met-pro-hover-rotate-icon';
		}
		$this->add_render_attribute( 'wrapper', 'class', $wrapper_classes );
		if ( ! empty( $settings['enable_animation'] ) && $settings['enable_animation'] === 'yes' ) {
			$this->add_render_attribute( 'wrapper', 'data-animation-duration', (string) ( isset( $settings['animation_duration'] ) ? $settings['animation_duration'] : 800 ) );
			$this->add_render_attribute( 'wrapper', 'data-animation-delay', (string) ( isset( $settings['animation_delay'] ) ? $settings['animation_delay'] : 100 ) );
			if ( ! empty( $settings['stagger_animation'] ) && $settings['stagger_animation'] === 'yes' && $layout_type === 'grid' ) {
				$this->add_render_attribute( 'wrapper', 'data-stagger', 'yes' );
			}
		}
		if ( $layout_type === 'slider' && ! empty( $settings['slider_pause_on_hover'] ) && $settings['slider_pause_on_hover'] === 'yes' ) {
			$this->add_render_attribute( 'wrapper', 'data-pause-effects-on-hover', 'yes' );
		}
		$slider_settings = $layout_type === 'slider' ? $this->get_slider_settings( $settings ) : array();
		?>
		<div <?php echo $this->get_render_attribute_string( 'wrapper' ); ?>>
			<?php if ( $layout_type === 'slider' ) : ?>
				<div class="team-met-pro-slider swiper" data-settings='<?php echo wp_json_encode( $slider_settings ); ?>'>
					<div class="swiper-wrapper">
						<?php foreach ( $settings['team_members'] as $index => $item ) : ?>
							<div class="swiper-slide">
								<?php $this->render_team_item( $item, $layout_style, $index ); ?>
							</div>
						<?php endforeach; ?>
					</div>
					<?php if ( ! empty( $settings['slider_arrows'] ) && $settings['slider_arrows'] === 'yes' ) : ?>
						<div class="team-met-pro-arrow team-met-pro-arrow-prev"><i class="eicon-chevron-<?php echo $is_rtl ? 'right' : 'left'; ?>"></i></div>
						<div class="team-met-pro-arrow team-met-pro-arrow-next"><i class="eicon-chevron-<?php echo $is_rtl ? 'left' : 'right'; ?>"></i></div>
					<?php endif; ?>
					<?php if ( ! empty( $settings['slider_dots'] ) && $settings['slider_dots'] === 'yes' ) : ?>
						<div class="swiper-pagination"></div>
					<?php endif; ?>
				</div>
			<?php else : ?>
				<div class="team-met-pro-grid">
					<?php foreach ( $settings['team_members'] as $index => $item ) : ?>
						<div class="team-met-pro-item-wrapper" data-index="<?php echo esc_attr( (string) $index ); ?>">
							<?php $this->render_team_item( $item, $layout_style, $index ); ?>
						</div>
					<?php endforeach; ?>
				</div>
			<?php endif; ?>
		</div>
		<?php
	}

	protected function render_team_item( $item, $layout_style, $index ) {
		$item_classes = array( 'team-met-pro-item', 'team-met-pro-item-' . $layout_style );
		?>
		<div class="<?php echo esc_attr( implode( ' ', $item_classes ) ); ?>">
			<?php
			$show_separator = ! empty( $this->get_settings_for_display( 'show_separator' ) ) && $this->get_settings_for_display( 'show_separator' ) === 'yes';
			switch ( $layout_style ) {
				case 'style2':
					$this->render_style2( $item );
					break;
				case 'style3':
					$this->render_style3( $item );
					break;
				case 'style4':
					$this->render_style4( $item );
					break;
				case 'style5':
					$this->render_style5( $item );
					break;
				default:
					$this->render_style1( $item, $show_separator );
			}
			?>
		</div>
		<?php
	}

	protected function render_style1( $item, $show_separator = true ) {
		?>
		<div class="team-met-pro-content">
			<?php if ( ! empty( $item['profile_image']['url'] ) ) : ?>
				<div class="team-met-pro-image"><?php echo \Elementor\Group_Control_Image_Size::get_attachment_image_html( $item, 'profile_image', 'profile_image' ); ?></div>
			<?php endif; ?>
			<div class="team-met-pro-info">
				<?php
				// پوزیشن شغلی (برچسب + مقدار) — بالای نام
				if ( ! empty( $item['position_label'] ) || ! empty( $item['position'] ) ) :
					?>
					<div class="team-met-pro-position-wrap">
						<?php if ( ! empty( $item['position_label'] ) ) : ?>
							<span class="team-met-pro-position-label"><?php echo esc_html( $item['position_label'] ); ?></span>
						<?php endif; ?>
						<?php if ( ! empty( $item['position'] ) ) : ?>
							<span class="team-met-pro-position"><?php echo esc_html( $item['position'] ); ?></span>
						<?php endif; ?>
					</div>
				<?php endif; ?>
				<?php if ( ! empty( $item['name'] ) ) : ?>
					<h3 class="team-met-pro-name"><span class="team-met-pro-name-inner"><?php echo esc_html( $item['name'] ); ?></span></h3>
				<?php endif; ?>
				<?php if ( $show_separator ) : ?>
					<div class="team-met-pro-separator"></div>
				<?php endif; ?>
				<?php if ( ! empty( $item['description'] ) ) : ?><div class="team-met-pro-description"><?php echo wp_kses_post( $item['description'] ); ?></div><?php endif; ?>
				<?php $this->render_social_icons( $item ); ?>
				<?php if ( ! empty( $item['button_text'] ) && ! empty( $item['button_url']['url'] ) ) : ?>
					<a href="<?php echo esc_url( $item['button_url']['url'] ); ?>" class="team-met-pro-button" <?php echo ! empty( $item['button_url']['is_external'] ) ? 'target="_blank"' : ''; ?> <?php echo ! empty( $item['button_url']['nofollow'] ) ? 'rel="nofollow"' : ''; ?>><?php echo esc_html( $item['button_text'] ); ?></a>
				<?php endif; ?>
			</div>
		</div>
		<?php
	}

	protected function render_style2( $item ) {
		?>
		<?php if ( ! empty( $item['profile_image']['url'] ) ) : ?>
			<div class="team-met-pro-image"><?php echo \Elementor\Group_Control_Image_Size::get_attachment_image_html( $item, 'profile_image', 'profile_image' ); ?></div>
		<?php endif; ?>
		<div class="team-met-pro-info">
			<?php if ( ! empty( $item['name'] ) ) : ?><h3 class="team-met-pro-name"><?php echo esc_html( $item['name'] ); ?></h3><?php endif; ?>
			<?php if ( ! empty( $item['position'] ) ) : ?><div class="team-met-pro-position"><?php echo esc_html( $item['position'] ); ?></div><?php endif; ?>
			<?php if ( ! empty( $item['description'] ) ) : ?><div class="team-met-pro-description"><?php echo wp_kses_post( $item['description'] ); ?></div><?php endif; ?>
			<?php $this->render_social_icons( $item ); ?>
			<?php if ( ! empty( $item['button_text'] ) && ! empty( $item['button_url']['url'] ) ) : ?>
				<a href="<?php echo esc_url( $item['button_url']['url'] ); ?>" class="team-met-pro-button" <?php echo ! empty( $item['button_url']['is_external'] ) ? 'target="_blank"' : ''; ?> <?php echo ! empty( $item['button_url']['nofollow'] ) ? 'rel="nofollow"' : ''; ?>><?php echo esc_html( $item['button_text'] ); ?></a>
			<?php endif; ?>
		</div>
		<?php
	}

	protected function render_style3( $item ) {
		?>
		<div class="team-met-pro-image-wrapper">
			<?php if ( ! empty( $item['profile_image']['url'] ) ) : ?>
				<div class="team-met-pro-image"><?php echo \Elementor\Group_Control_Image_Size::get_attachment_image_html( $item, 'profile_image', 'profile_image' ); ?></div>
			<?php endif; ?>
			<div class="team-met-pro-overlay">
				<div class="team-met-pro-info">
					<?php if ( ! empty( $item['name'] ) ) : ?><h3 class="team-met-pro-name"><?php echo esc_html( $item['name'] ); ?></h3><?php endif; ?>
					<?php if ( ! empty( $item['position'] ) ) : ?><div class="team-met-pro-position"><?php echo esc_html( $item['position'] ); ?></div><?php endif; ?>
					<?php if ( ! empty( $item['description'] ) ) : ?><div class="team-met-pro-description"><?php echo wp_kses_post( $item['description'] ); ?></div><?php endif; ?>
					<?php $this->render_social_icons( $item ); ?>
					<?php if ( ! empty( $item['button_text'] ) && ! empty( $item['button_url']['url'] ) ) : ?>
						<a href="<?php echo esc_url( $item['button_url']['url'] ); ?>" class="team-met-pro-button" <?php echo ! empty( $item['button_url']['is_external'] ) ? 'target="_blank"' : ''; ?> <?php echo ! empty( $item['button_url']['nofollow'] ) ? 'rel="nofollow"' : ''; ?>><?php echo esc_html( $item['button_text'] ); ?></a>
					<?php endif; ?>
				</div>
			</div>
		</div>
		<?php
	}

	protected function render_style4( $item ) {
		?>
		<div class="team-met-pro-content">
			<?php if ( ! empty( $item['profile_image']['url'] ) ) : ?>
				<div class="team-met-pro-image"><?php echo \Elementor\Group_Control_Image_Size::get_attachment_image_html( $item, 'profile_image', 'profile_image' ); ?></div>
			<?php endif; ?>
			<div class="team-met-pro-info">
				<?php if ( ! empty( $item['name'] ) ) : ?><h3 class="team-met-pro-name"><?php echo esc_html( $item['name'] ); ?></h3><?php endif; ?>
				<?php if ( ! empty( $item['position'] ) ) : ?><div class="team-met-pro-position"><?php echo esc_html( $item['position'] ); ?></div><?php endif; ?>
				<?php if ( ! empty( $item['description'] ) ) : ?><div class="team-met-pro-description"><?php echo wp_kses_post( $item['description'] ); ?></div><?php endif; ?>
			</div>
			<div class="team-met-pro-footer">
				<?php $this->render_social_icons( $item ); ?>
				<?php if ( ! empty( $item['button_text'] ) && ! empty( $item['button_url']['url'] ) ) : ?>
					<a href="<?php echo esc_url( $item['button_url']['url'] ); ?>" class="team-met-pro-button" <?php echo ! empty( $item['button_url']['is_external'] ) ? 'target="_blank"' : ''; ?> <?php echo ! empty( $item['button_url']['nofollow'] ) ? 'rel="nofollow"' : ''; ?>><?php echo esc_html( $item['button_text'] ); ?></a>
				<?php endif; ?>
			</div>
		</div>
		<?php
	}

	protected function render_style5( $item ) {
		?>
		<?php if ( ! empty( $item['profile_image']['url'] ) ) : ?>
			<div class="team-met-pro-image"><?php echo \Elementor\Group_Control_Image_Size::get_attachment_image_html( $item, 'profile_image', 'profile_image' ); ?></div>
		<?php endif; ?>
		<div class="team-met-pro-glass">
			<div class="team-met-pro-info">
				<?php if ( ! empty( $item['name'] ) ) : ?><h3 class="team-met-pro-name"><?php echo esc_html( $item['name'] ); ?></h3><?php endif; ?>
				<?php if ( ! empty( $item['position'] ) ) : ?><div class="team-met-pro-position"><?php echo esc_html( $item['position'] ); ?></div><?php endif; ?>
				<?php if ( ! empty( $item['description'] ) ) : ?><div class="team-met-pro-description"><?php echo wp_kses_post( $item['description'] ); ?></div><?php endif; ?>
				<?php $this->render_social_icons( $item ); ?>
				<?php if ( ! empty( $item['button_text'] ) && ! empty( $item['button_url']['url'] ) ) : ?>
					<a href="<?php echo esc_url( $item['button_url']['url'] ); ?>" class="team-met-pro-button" <?php echo ! empty( $item['button_url']['is_external'] ) ? 'target="_blank"' : ''; ?> <?php echo ! empty( $item['button_url']['nofollow'] ) ? 'rel="nofollow"' : ''; ?>><?php echo esc_html( $item['button_text'] ); ?></a>
				<?php endif; ?>
			</div>
		</div>
		<?php
	}

	protected function render_social_icons( $item ) {
		$links = array();
		for ( $n = 1; $n <= 8; $n++ ) {
			$url = isset( $item[ 'social_' . $n . '_url' ]['url'] ) ? $item[ 'social_' . $n . '_url' ]['url'] : '';
			if ( $url === '' ) {
				continue;
			}
			$icon = isset( $item[ 'social_' . $n . '_icon' ] ) ? $item[ 'social_' . $n . '_icon' ] : array();
			if ( ! empty( $icon['value'] ) ) {
				$links[] = array(
					'url'    => $item[ 'social_' . $n . '_url' ],
					'icon'   => $icon,
				);
			}
		}
		if ( empty( $links ) ) {
			return;
		}
		?>
		<div class="team-met-pro-social">
			<?php foreach ( $links as $social ) : ?>
				<a href="<?php echo esc_url( $social['url']['url'] ); ?>" <?php echo ! empty( $social['url']['is_external'] ) ? 'target="_blank"' : ''; ?> <?php echo ! empty( $social['url']['nofollow'] ) ? 'rel="nofollow"' : ''; ?>>
					<?php \Elementor\Icons_Manager::render_icon( $social['icon'], array( 'aria-hidden' => 'true' ) ); ?>
				</a>
			<?php endforeach; ?>
		</div>
		<?php
	}

	protected function get_slider_settings( $settings ) {
		$slider_settings = array(
			'autoplay'       => ( ! empty( $settings['slider_autoplay'] ) && $settings['slider_autoplay'] === 'yes' )
				? array(
					'delay'             => isset( $settings['slider_autoplay_delay'] ) ? (int) $settings['slider_autoplay_delay'] : 3000,
					'pauseOnMouseEnter' => ! empty( $settings['slider_pause_on_hover'] ) && $settings['slider_pause_on_hover'] === 'yes',
				)
				: false,
			'loop'           => ! empty( $settings['slider_loop'] ) && $settings['slider_loop'] === 'yes',
			'speed'          => isset( $settings['slider_speed'] ) ? (int) $settings['slider_speed'] : 500,
			'slidesPerView'  => isset( $settings['slides_per_view'] ) ? (int) $settings['slides_per_view'] : 3,
			'spaceBetween'   => 30,
			'navigation'     => ( ! empty( $settings['slider_arrows'] ) && $settings['slider_arrows'] === 'yes' )
				? array( 'nextEl' => '.team-met-pro-arrow-next', 'prevEl' => '.team-met-pro-arrow-prev' )
				: false,
			'pagination'     => ( ! empty( $settings['slider_dots'] ) && $settings['slider_dots'] === 'yes' )
				? array( 'el' => '.swiper-pagination', 'clickable' => true )
				: false,
			'breakpoints'    => array(
				768 => array( 'slidesPerView' => isset( $settings['slides_per_view_tablet'] ) ? (int) $settings['slides_per_view_tablet'] : 2 ),
				480 => array( 'slidesPerView' => isset( $settings['slides_per_view_mobile'] ) ? (int) $settings['slides_per_view_mobile'] : 1 ),
			),
		);
		if ( is_rtl() ) {
			$slider_settings['direction'] = 'rtl';
		}
		return $slider_settings;
	}
}
