<?php
/**
 * Elementor Team Box Widget – ابزارک باکس تیم ما
 *
 * @package Disto_Child
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! did_action( 'elementor/loaded' ) ) {
	return;
}

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Repeater;

class Disto_Team_Box_Widget extends Widget_Base {

	public function get_name() {
		return 'disto_team_box';
	}

	public function get_title() {
		return esc_html__( 'ابزارک باکس تیم ما', 'disto' );
	}

	public function get_icon() {
		return 'eicon-gallery-grid';
	}

	public function get_categories() {
		return array( 'disto-elements' );
	}

	public function get_style_depends() {
		return array( 'disto-child-team-box' );
	}

	public function get_script_depends() {
		return array( 'disto-child-team-box' );
	}

	public function get_keywords() {
		return array( 'team', 'member', 'box', 'staff', 'person', 'تیم' );
	}

	protected function register_controls() {
		$this->register_content_section();
		$this->register_team_members_section();
		$this->register_colors_section();
		$this->register_images_section();
		$this->register_responsive_section();
	}

	protected function register_content_section() {
		$this->start_controls_section(
			'content_section',
			array(
				'label' => esc_html__( 'محتوا', 'disto' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'title',
			array(
				'label'       => esc_html__( 'عنوان سکشن', 'disto' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'متخصصان ما', 'disto' ),
				'placeholder' => esc_html__( 'عنوان', 'disto' ),
			)
		);

		$this->add_control(
			'description',
			array(
				'label'       => esc_html__( 'توضیحات سکشن', 'disto' ),
				'type'        => Controls_Manager::WYSIWYG,
				'default'     => esc_html__( 'لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.', 'disto' ),
				'placeholder' => esc_html__( 'متن توضیحات', 'disto' ),
			)
		);

		$this->add_control(
			'default_image',
			array(
				'label'   => esc_html__( 'تصویر پیش‌فرض بخش اصلی', 'disto' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => array( 'url' => \Elementor\Utils::get_placeholder_image_src() ),
			)
		);

		$this->add_control(
			'show_decorative_bg1',
			array(
				'label'        => esc_html__( 'نمایش شکل تزیینی بالا', 'disto' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'بله', 'disto' ),
				'label_off'    => esc_html__( 'خیر', 'disto' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			)
		);

		$this->add_control(
			'decorative_bg1',
			array(
				'label'     => esc_html__( 'شکل تزیینی بالا (SVG/تصویر)', 'disto' ),
				'type'      => Controls_Manager::MEDIA,
				'condition' => array( 'show_decorative_bg1' => 'yes' ),
			)
		);

		$this->add_control(
			'show_decorative_bg2',
			array(
				'label'        => esc_html__( 'نمایش شکل تزیینی پایین', 'disto' ),
				'type'         => Controls_Manager::SWITCHER,
				'label_on'     => esc_html__( 'بله', 'disto' ),
				'label_off'    => esc_html__( 'خیر', 'disto' ),
				'return_value' => 'yes',
				'default'      => 'yes',
			)
		);

		$this->add_control(
			'decorative_bg2',
			array(
				'label'     => esc_html__( 'شکل تزیینی پایین (SVG/تصویر)', 'disto' ),
				'type'      => Controls_Manager::MEDIA,
				'condition' => array( 'show_decorative_bg2' => 'yes' ),
			)
		);

		$this->end_controls_section();
	}

	protected function register_team_members_section() {
		$this->start_controls_section(
			'team_members_section',
			array(
				'label' => esc_html__( 'لیست اعضا', 'disto' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'image',
			array(
				'label'   => esc_html__( 'تصویر عضو', 'disto' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => array( 'url' => \Elementor\Utils::get_placeholder_image_src() ),
			)
		);

		$repeater->add_control(
			'name',
			array(
				'label'       => esc_html__( 'نام عضو', 'disto' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'پرستو مرادی', 'disto' ),
				'placeholder' => esc_html__( 'نام', 'disto' ),
			)
		);

		$repeater->add_control(
			'position',
			array(
				'label'       => esc_html__( 'سمت عضو', 'disto' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'Project Manager', 'disto' ),
				'placeholder' => esc_html__( 'سمت', 'disto' ),
			)
		);

		$this->add_control(
			'members',
			array(
				'label'       => esc_html__( 'اعضای تیم', 'disto' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'default'     => array(
					array( 'name' => esc_html__( 'پرستو مرادی', 'disto' ), 'position' => 'Project Manager' ),
					array( 'name' => esc_html__( 'کاوه نیک‌پی', 'disto' ), 'position' => 'SEO Expert' ),
					array( 'name' => esc_html__( 'سامان امیری', 'disto' ), 'position' => 'Digital Marketer' ),
					array( 'name' => esc_html__( 'الهه حسینی', 'disto' ), 'position' => 'Content Strategist' ),
					array( 'name' => esc_html__( 'مهسا کریمی', 'disto' ), 'position' => 'CEO & Founder' ),
					array( 'name' => esc_html__( 'شایان محمدی', 'disto' ), 'position' => 'Graphics Designer' ),
				),
				'title_field' => '{{{ name }}}',
			)
		);

		$this->end_controls_section();
	}

	protected function register_colors_section() {
		$this->start_controls_section(
			'colors_section',
			array(
				'label' => esc_html__( 'رنگ‌ها', 'disto' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'dot_color',
			array(
				'label'     => esc_html__( 'رنگ نقطه کنار نام', 'disto' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#fea000',
				'selectors' => array(
					'{{WRAPPER}} .dtbw-detail-name span:before' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'title_underline_color',
			array(
				'label'     => esc_html__( 'رنگ خط زیر عنوان', 'disto' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#fea000',
				'selectors' => array(
					'{{WRAPPER}} .dtbw-heading-title h2:after' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'title_line_color',
			array(
				'label'     => esc_html__( 'رنگ خط خاکستری زیر عنوان', 'disto' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#e4e4e4',
				'selectors' => array(
					'{{WRAPPER}} .dtbw-heading-title h2:before' => 'background: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'info_box_bg',
			array(
				'label'     => esc_html__( 'رنگ پس‌زمینه باکس اطلاعات', 'disto' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#DBE3EA',
				'selectors' => array(
					'{{WRAPPER}} .dtbw-detail-info-box' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'section_bg',
			array(
				'label'     => esc_html__( 'پس‌زمینه کلی سکشن', 'disto' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#F5F7FA',
				'selectors' => array(
					'{{WRAPPER}} .dtbw-wrapper' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->end_controls_section();
	}

	protected function register_images_section() {
		$this->start_controls_section(
			'images_section',
			array(
				'label' => esc_html__( 'سایز تصاویر', 'disto' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_responsive_control(
			'main_image_height',
			array(
				'label'      => esc_html__( 'ارتفاع تصویر اصلی (px)', 'disto' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array( 'px' => array( 'min' => 100, 'max' => 600 ) ),
				'default'    => array( 'unit' => 'px', 'size' => 270 ),
				'selectors'  => array(
					'{{WRAPPER}} .dtbw-detail-image img' => 'height: {{SIZE}}{{UNIT}}; object-fit: cover;',
				),
			)
		);

		$this->add_responsive_control(
			'thumbnail_size',
			array(
				'label'      => esc_html__( 'عرض تامبنیل (px)', 'disto' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array( 'px' => array( 'min' => 40, 'max' => 200 ) ),
				'default'    => array( 'unit' => 'px', 'size' => 115 ),
				'selectors'  => array(
					'{{WRAPPER}} .dtbw-slide-img img' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}; object-fit: cover;',
				),
			)
		);

		$this->add_control(
			'border_radius',
			array(
				'label'      => esc_html__( 'گردی گوشه تصاویر (px)', 'disto' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array( 'px' => array( 'min' => 0, 'max' => 50 ) ),
				'default'    => array( 'unit' => 'px', 'size' => 10 ),
				'selectors'  => array(
					'{{WRAPPER}} .dtbw-detail-image img'  => 'border-radius: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .dtbw-slide-img img'     => 'border-radius: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .dtbw-detail-info-box'   => 'border-radius: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();
	}

	protected function register_responsive_section() {
		$this->start_controls_section(
			'responsive_section',
			array(
				'label' => esc_html__( 'تنظیمات ریسپانسیو', 'disto' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'responsive_note',
			array(
				'type'            => Controls_Manager::RAW_HTML,
				'raw'             => esc_html__( 'ارتفاع تصویر اصلی و عرض تامبنیل در تب «سایز تصاویر» برای دسکتاپ، تبلت و موبایل قابل تنظیم است.', 'disto' ),
				'content_classes' => 'elementor-panel-alert elementor-panel-alert-info',
			)
		);

		$this->add_responsive_control(
			'section_padding',
			array(
				'label'      => esc_html__( 'فاصله داخلی سکشن', 'disto' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', 'em', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .dtbw-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'title_typography',
				'label'    => esc_html__( 'تایپوگرافی عنوان', 'disto' ),
				'selector' => '{{WRAPPER}} .dtbw-heading-title h2',
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'description_typography',
				'label'    => esc_html__( 'تایپوگرافی توضیحات', 'disto' ),
				'selector' => '{{WRAPPER}} .dtbw-description-text',
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'name_typography',
				'label'    => esc_html__( 'تایپوگرافی نام عضو', 'disto' ),
				'selector' => '{{WRAPPER}} .dtbw-detail-name span',
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'position_typography',
				'label'    => esc_html__( 'تایپوگرافی سمت', 'disto' ),
				'selector' => '{{WRAPPER}} .dtbw-detail-position span',
			)
		);

		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();
		$members  = $settings['members'] ?? array();

		if ( empty( $members ) ) {
			return;
		}

		$default_image = $settings['default_image']['url'] ?? '';
		$first_member  = $members[0];
		$first_img     = ! empty( $first_member['image']['url'] ) ? $first_member['image']['url'] : $default_image;
		$first_name    = $first_member['name'] ?? '';
		$first_pos     = $first_member['position'] ?? '';

		if ( empty( $first_img ) ) {
			$first_img = \Elementor\Utils::get_placeholder_image_src();
		}

		$this->add_render_attribute( 'wrapper', 'class', 'dtbw-wrapper' );
		?>
		<div <?php echo $this->get_render_attribute_string( 'wrapper' ); ?>>
			<div class="dtbw-inner">
				<div class="dtbw-content-col">
					<?php if ( ! empty( $settings['show_decorative_bg1'] ) && $settings['show_decorative_bg1'] === 'yes' && ! empty( $settings['decorative_bg1']['url'] ) ) : ?>
						<div class="dtbw-deco dtbw-deco-1">
							<img src="<?php echo esc_url( $settings['decorative_bg1']['url'] ); ?>" alt="" />
						</div>
					<?php endif; ?>
					<?php if ( ! empty( $settings['title'] ) ) : ?>
						<div class="dtbw-heading-title"><h2><?php echo esc_html( $settings['title'] ); ?></h2></div>
					<?php endif; ?>
					<?php if ( ! empty( $settings['description'] ) ) : ?>
						<div class="dtbw-description-text"><?php echo wp_kses_post( $settings['description'] ); ?></div>
					<?php endif; ?>
					<?php if ( ! empty( $settings['show_decorative_bg2'] ) && $settings['show_decorative_bg2'] === 'yes' && ! empty( $settings['decorative_bg2']['url'] ) ) : ?>
						<div class="dtbw-deco dtbw-deco-2 sigmaweb-bg2">
							<img src="<?php echo esc_url( $settings['decorative_bg2']['url'] ); ?>" alt="" />
						</div>
					<?php endif; ?>
				</div>
				<div class="dtbw-team-col">
					<div class="dtbw-detail-block">
						<div class="dtbw-detail-image">
							<img src="<?php echo esc_url( $first_img ); ?>" alt="<?php echo esc_attr( $first_name ); ?>" />
						</div>
						<div class="dtbw-detail-info-box">
							<div class="dtbw-detail-name"><span><?php echo esc_html( $first_name ); ?></span></div>
							<div class="dtbw-detail-position"><span><?php echo esc_html( $first_pos ); ?></span></div>
						</div>
					</div>
					<div class="dtbw-thumbnails-grid">
						<?php
						foreach ( $members as $index => $member ) :
							$img_url = ! empty( $member['image']['url'] ) ? $member['image']['url'] : \Elementor\Utils::get_placeholder_image_src();
							$active  = 0 === $index ? ' active' : '';
							?>
							<div class="dtbw-slide-img" data-src="<?php echo esc_url( $img_url ); ?>" data-name="<?php echo esc_attr( $member['name'] ?? '' ); ?>" data-position="<?php echo esc_attr( $member['position'] ?? '' ); ?>">
								<img src="<?php echo esc_url( $img_url ); ?>" alt="<?php echo esc_attr( $member['name'] ?? '' ); ?>"<?php echo $active ? ' class="active"' : ''; ?> />
							</div>
						<?php endforeach; ?>
					</div>
				</div>
			</div>
		</div>
		<?php
	}
}
