<?php
/**
 * Coming Soon (بزودی) – Advanced Elementor Widget
 * Persian News Website – RTL, responsive, 3 design styles.
 *
 * @package Disto_Child
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! did_action( 'elementor/loaded' ) ) {
	return;
}

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Repeater;

class Disto_Coming_Soon_Widget extends Widget_Base {

	public function get_name() {
		return 'disto_coming_soon';
	}

	public function get_title() {
		return esc_html__( 'بزودی', 'disto' );
	}

	public function get_icon() {
		return 'eicon-countdown';
	}

	public function get_categories() {
		return array( 'disto-elements' );
	}

	public function get_style_depends() {
		return array( 'disto-child-coming-soon' );
	}

	public function get_script_depends() {
		return array( 'disto-child-coming-soon' );
	}

	protected function register_controls() {

		// ─── Style Selector ─────────────────────────────────────────────────
		$this->start_controls_section(
			'section_style_selector',
			array(
				'label' => esc_html__( 'سبک طراحی', 'disto' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'design_style',
			array(
				'label'   => esc_html__( 'سبک قالب', 'disto' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'modern',
				'options' => array(
					'modern'    => esc_html__( '🔥 مدرن استارتاپ مدیا', 'disto' ),
					'formal'    => esc_html__( '🏛 رسمی خبرگزاری', 'disto' ),
					'analytical' => esc_html__( '🎙 تحلیلی آنلاین مجله', 'disto' ),
				),
			)
		);

		$this->add_control(
			'dark_mode',
			array(
				'label'        => esc_html__( 'حالت تاریک', 'disto' ),
				'type'         => Controls_Manager::SWITCHER,
				'default'      => '',
				'return_value' => 'yes',
			)
		);

		$this->end_controls_section();

		// ─── Text Controls ──────────────────────────────────────────────────
		$this->start_controls_section(
			'section_text',
			array(
				'label' => esc_html__( 'متون', 'disto' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'headline',
			array(
				'label'       => esc_html__( 'عنوان اصلی', 'disto' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'به زودی با رسانه‌ای متفاوت همراه شما هستیم', 'disto' ),
				'placeholder' => esc_html__( 'عنوان اصلی', 'disto' ),
			)
		);

		$this->add_control(
			'subheadline',
			array(
				'label'       => esc_html__( 'زیرعنوان', 'disto' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'پوشش سریع، دقیق و بی‌طرفانه اخبار ایران و جهان', 'disto' ),
				'placeholder' => esc_html__( 'زیرعنوان', 'disto' ),
			)
		);

		$this->add_control(
			'description',
			array(
				'label'       => esc_html__( 'توضیحات (پاراگراف)', 'disto' ),
				'type'        => Controls_Manager::WYSIWYG,
				'default'     => '',
				'placeholder' => esc_html__( 'متن توضیحات...', 'disto' ),
			)
		);

		$this->add_control(
			'cta_text',
			array(
				'label'       => esc_html__( 'متن دکمه CTA', 'disto' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'عضویت برای اطلاع‌رسانی', 'disto' ),
				'placeholder' => esc_html__( 'عضویت برای اطلاع‌رسانی', 'disto' ),
			)
		);

		$this->add_control(
			'footer_text',
			array(
				'label'       => esc_html__( 'متن فوتر', 'disto' ),
				'type'        => Controls_Manager::TEXTAREA,
				'default'     => '',
				'rows'        => 2,
				'placeholder' => esc_html__( '© 2024 نام سایت. تمامی حقوق محفوظ است.', 'disto' ),
			)
		);

		// Badge repeater
		$badge_repeater = new Repeater();
		$badge_repeater->add_control(
			'badge_text',
			array(
				'label'       => esc_html__( 'متن برچسب', 'disto' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => '',
				'placeholder' => esc_html__( 'برچسب', 'disto' ),
			)
		);

		$this->add_control(
			'badges',
			array(
				'label'       => esc_html__( 'برچسب‌ها / دسته‌بندی‌ها', 'disto' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $badge_repeater->get_controls(),
				'default'     => array(),
				'title_field' => '{{{ badge_text }}}',
			)
		);

		$this->end_controls_section();

		// ─── Countdown ──────────────────────────────────────────────────────
		$this->start_controls_section(
			'section_countdown',
			array(
				'label' => esc_html__( 'شمارش معکوس', 'disto' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'countdown_enable',
			array(
				'label'        => esc_html__( 'فعال‌سازی شمارش معکوس', 'disto' ),
				'type'         => Controls_Manager::SWITCHER,
				'default'      => 'yes',
				'return_value' => 'yes',
			)
		);

		$this->add_control(
			'launch_datetime',
			array(
				'label'     => esc_html__( 'تاریخ و زمان شروع', 'disto' ),
				'type'      => Controls_Manager::DATE_TIME,
				'default'   => gmdate( 'Y-m-d H:i', strtotime( '+30 days' ) ),
				'condition' => array( 'countdown_enable' => 'yes' ),
			)
		);

		$this->add_control(
			'timezone',
			array(
				'label'     => esc_html__( 'منطقه زمانی', 'disto' ),
				'type'      => Controls_Manager::TEXT,
				'default'   => 'Asia/Tehran',
				'condition' => array( 'countdown_enable' => 'yes' ),
			)
		);

		$this->add_control(
			'label_days',
			array(
				'label'     => esc_html__( 'برچسب روزها', 'disto' ),
				'type'      => Controls_Manager::TEXT,
				'default'   => esc_html__( 'روز', 'disto' ),
				'condition' => array( 'countdown_enable' => 'yes' ),
			)
		);

		$this->add_control(
			'label_hours',
			array(
				'label'     => esc_html__( 'برچسب ساعت', 'disto' ),
				'type'      => Controls_Manager::TEXT,
				'default'   => esc_html__( 'ساعت', 'disto' ),
				'condition' => array( 'countdown_enable' => 'yes' ),
			)
		);

		$this->add_control(
			'label_minutes',
			array(
				'label'     => esc_html__( 'برچسب دقیقه', 'disto' ),
				'type'      => Controls_Manager::TEXT,
				'default'   => esc_html__( 'دقیقه', 'disto' ),
				'condition' => array( 'countdown_enable' => 'yes' ),
			)
		);

		$this->add_control(
			'label_seconds',
			array(
				'label'     => esc_html__( 'برچسب ثانیه', 'disto' ),
				'type'      => Controls_Manager::TEXT,
				'default'   => esc_html__( 'ثانیه', 'disto' ),
				'condition' => array( 'countdown_enable' => 'yes' ),
			)
		);

		$this->add_control(
			'expiry_action',
			array(
				'label'     => esc_html__( 'عملیات پس از انقضا', 'disto' ),
				'type'      => Controls_Manager::SELECT,
				'default'   => 'message',
				'options'   => array(
					'hide'     => esc_html__( 'مخفی کردن شمارش معکوس', 'disto' ),
					'message'  => esc_html__( 'نمایش پیام', 'disto' ),
					'redirect' => esc_html__( 'تغییر مسیر به URL', 'disto' ),
				),
				'condition' => array( 'countdown_enable' => 'yes' ),
			)
		);

		$this->add_control(
			'expiry_message',
			array(
				'label'     => esc_html__( 'پیام انقضا', 'disto' ),
				'type'      => Controls_Manager::TEXTAREA,
				'default'   => esc_html__( 'به زودی…', 'disto' ),
				'condition' => array(
					'countdown_enable' => 'yes',
					'expiry_action'    => 'message',
				),
			)
		);

		$this->add_control(
			'expiry_redirect_url',
			array(
				'label'     => esc_html__( 'URL تغییر مسیر', 'disto' ),
				'type'      => Controls_Manager::URL,
				'condition' => array(
					'countdown_enable' => 'yes',
					'expiry_action'    => 'redirect',
				),
			)
		);

		$this->end_controls_section();

		// ─── Subscription ───────────────────────────────────────────────────
		$this->start_controls_section(
			'section_subscription',
			array(
				'label' => esc_html__( 'فرم عضویت', 'disto' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'show_email_form',
			array(
				'label'        => esc_html__( 'نمایش فرم ایمیل', 'disto' ),
				'type'         => Controls_Manager::SWITCHER,
				'default'      => 'yes',
				'return_value' => 'yes',
			)
		);

		$this->add_control(
			'email_placeholder',
			array(
				'label'     => esc_html__( 'متن Placeholder ایمیل', 'disto' ),
				'type'      => Controls_Manager::TEXT,
				'default'   => esc_html__( 'آدرس ایمیل شما', 'disto' ),
				'condition' => array( 'show_email_form' => 'yes' ),
			)
		);

		$this->add_control(
			'success_message',
			array(
				'label'     => esc_html__( 'پیام موفقیت', 'disto' ),
				'type'      => Controls_Manager::TEXT,
				'default'   => esc_html__( 'با موفقیت ثبت شد. ممنون!', 'disto' ),
				'condition' => array( 'show_email_form' => 'yes' ),
			)
		);

		$this->add_control(
			'error_message',
			array(
				'label'     => esc_html__( 'پیام خطا', 'disto' ),
				'type'      => Controls_Manager::TEXT,
				'default'   => esc_html__( 'لطفاً یک ایمیل معتبر وارد کنید.', 'disto' ),
				'condition' => array( 'show_email_form' => 'yes' ),
			)
		);

		$this->add_control(
			'form_shortcode',
			array(
				'label'       => esc_html__( 'کد کوتاه فرم (اختیاری)', 'disto' ),
				'type'        => Controls_Manager::TEXT,
				'description' => esc_html__( 'برای استفاده از Contact Form 7 یا سایر پلاگین‌ها، shortcode را وارد کنید.', 'disto' ),
				'default'     => '',
				'condition'   => array( 'show_email_form' => 'yes' ),
			)
		);

		$this->end_controls_section();

		// ─── Social Media ───────────────────────────────────────────────────
		$this->start_controls_section(
			'section_social',
			array(
				'label' => esc_html__( 'شبکه‌های اجتماعی', 'disto' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'show_social',
			array(
				'label'        => esc_html__( 'نمایش شبکه‌های اجتماعی', 'disto' ),
				'type'         => Controls_Manager::SWITCHER,
				'default'      => 'yes',
				'return_value' => 'yes',
			)
		);

		$social_repeater = new Repeater();
		$social_repeater->add_control(
			'social_icon',
			array(
				'label'   => esc_html__( 'آیکن', 'disto' ),
				'type'    => Controls_Manager::ICONS,
				'default' => array(
					'value'   => 'fab fa-telegram-plane',
					'library' => 'fa-brands',
				),
			)
		);
		$social_repeater->add_control(
			'social_url',
			array(
				'label'       => esc_html__( 'URL', 'disto' ),
				'type'        => Controls_Manager::URL,
				'placeholder' => 'https://',
				'default'     => array(
					'url'         => '#',
					'is_external' => true,
					'nofollow'    => false,
				),
			)
		);
		$social_repeater->add_control(
			'open_new_tab',
			array(
				'label'        => esc_html__( 'باز شدن در تب جدید', 'disto' ),
				'type'         => Controls_Manager::SWITCHER,
				'default'      => 'yes',
				'return_value' => 'yes',
			)
		);

		$this->add_control(
			'social_items',
			array(
				'label'       => esc_html__( 'آیکن‌های اجتماعی', 'disto' ),
				'type'        => Controls_Manager::REPEATER,
				'condition'   => array( 'show_social' => 'yes' ),
				'fields'      => $social_repeater->get_controls(),
				'default'     => array(
					array(
						'social_icon' => array( 'value' => 'fab fa-telegram-plane', 'library' => 'fa-brands' ),
						'social_url'  => array( 'url' => '#' ),
						'open_new_tab' => 'yes',
					),
					array(
						'social_icon' => array( 'value' => 'fab fa-instagram', 'library' => 'fa-brands' ),
						'social_url'  => array( 'url' => '#' ),
						'open_new_tab' => 'yes',
					),
					array(
						'social_icon' => array( 'value' => 'fab fa-twitter', 'library' => 'fa-brands' ),
						'social_url'  => array( 'url' => '#' ),
						'open_new_tab' => 'yes',
					),
				),
				'title_field' => '{{{ social_icon.value }}}',
			)
		);

		$this->end_controls_section();

		// ─── Style: Layout ───────────────────────────────────────────────────
		$this->start_controls_section(
			'section_style_layout',
			array(
				'label' => esc_html__( 'چیدمان', 'disto' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'section_width',
			array(
				'label'   => esc_html__( 'عرض بخش', 'disto' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'boxed',
				'options' => array(
					'boxed'     => esc_html__( 'جعبه‌ای (Boxed)', 'disto' ),
					'fullwidth' => esc_html__( 'تمام عرض', 'disto' ),
				),
			)
		);

		$this->add_responsive_control(
			'content_align',
			array(
				'label'     => esc_html__( 'تراز کلی محتوا', 'disto' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => array(
					'right'  => array(
						'title' => esc_html__( 'راست', 'disto' ),
						'icon'  => 'eicon-text-align-right',
					),
					'center' => array(
						'title' => esc_html__( 'وسط', 'disto' ),
						'icon'  => 'eicon-text-align-center',
					),
					'left'   => array(
						'title' => esc_html__( 'چپ', 'disto' ),
						'icon'  => 'eicon-text-align-left',
					),
				),
				'default'   => 'center',
				'selectors' => array(
					'{{WRAPPER}} .dsoon-inner' => 'text-align: {{VALUE}};',
				),
			)
		);

		$this->add_responsive_control(
			'headline_align',
			array(
				'label'     => esc_html__( 'تراز عنوان اصلی', 'disto' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => array(
					'right'  => array(
						'title' => esc_html__( 'راست‌چین', 'disto' ),
						'icon'  => 'eicon-text-align-right',
					),
					'center' => array(
						'title' => esc_html__( 'وسط‌چین', 'disto' ),
						'icon'  => 'eicon-text-align-center',
					),
					'left'   => array(
						'title' => esc_html__( 'چپ‌چین', 'disto' ),
						'icon'  => 'eicon-text-align-left',
					),
				),
				'default'   => 'center',
				'selectors' => array(
					'{{WRAPPER}} .dsoon-headline' => 'text-align: {{VALUE}};',
				),
			)
		);

		$this->add_responsive_control(
			'subheadline_align',
			array(
				'label'     => esc_html__( 'تراز زیرعنوان', 'disto' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => array(
					'right'  => array(
						'title' => esc_html__( 'راست‌چین', 'disto' ),
						'icon'  => 'eicon-text-align-right',
					),
					'center' => array(
						'title' => esc_html__( 'وسط‌چین', 'disto' ),
						'icon'  => 'eicon-text-align-center',
					),
					'left'   => array(
						'title' => esc_html__( 'چپ‌چین', 'disto' ),
						'icon'  => 'eicon-text-align-left',
					),
				),
				'default'   => 'center',
				'selectors' => array(
					'{{WRAPPER}} .dsoon-subheadline' => 'text-align: {{VALUE}};',
				),
			)
		);

		$this->add_responsive_control(
			'description_align',
			array(
				'label'     => esc_html__( 'تراز توضیحات', 'disto' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => array(
					'right'  => array(
						'title' => esc_html__( 'راست‌چین', 'disto' ),
						'icon'  => 'eicon-text-align-right',
					),
					'center' => array(
						'title' => esc_html__( 'وسط‌چین', 'disto' ),
						'icon'  => 'eicon-text-align-center',
					),
					'left'   => array(
						'title' => esc_html__( 'چپ‌چین', 'disto' ),
						'icon'  => 'eicon-text-align-left',
					),
				),
				'default'   => 'center',
				'selectors' => array(
					'{{WRAPPER}} .dsoon-desc' => 'text-align: {{VALUE}};',
				),
			)
		);

		$this->add_responsive_control(
			'form_align',
			array(
				'label'     => esc_html__( 'جهت نمایش فرم (راست / وسط / چپ)', 'disto' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => array(
					'flex-start' => array(
						'title' => esc_html__( 'راست', 'disto' ),
						'icon'  => 'eicon-text-align-right',
					),
					'center'     => array(
						'title' => esc_html__( 'وسط', 'disto' ),
						'icon'  => 'eicon-text-align-center',
					),
					'flex-end'   => array(
						'title' => esc_html__( 'چپ', 'disto' ),
						'icon'  => 'eicon-text-align-left',
					),
				),
				'default'   => 'center',
				'selectors' => array(
					'{{WRAPPER}} .dsoon-form-wrap' => 'justify-content: {{VALUE}}; width: 100%; display: flex;',
				),
			)
		);

		$this->add_responsive_control(
			'vertical_align',
			array(
				'label'     => esc_html__( 'تراز عمودی', 'disto' ),
				'type'      => Controls_Manager::CHOOSE,
				'options'   => array(
					'flex-start' => array(
						'title' => esc_html__( 'بالا', 'disto' ),
						'icon'  => 'eicon-v-align-top',
					),
					'center'     => array(
						'title' => esc_html__( 'وسط', 'disto' ),
						'icon'  => 'eicon-v-align-middle',
					),
					'flex-end'   => array(
						'title' => esc_html__( 'پایین', 'disto' ),
						'icon'  => 'eicon-v-align-bottom',
					),
				),
				'default'   => 'center',
				'selectors' => array(
					'{{WRAPPER}} .dsoon-wrapper' => 'justify-content: {{VALUE}};',
				),
			)
		);

		$this->add_responsive_control(
			'section_padding',
			array(
				'label'      => esc_html__( 'پدینگ', 'disto' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .dsoon-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'section_margin',
			array(
				'label'      => esc_html__( 'مارجین', 'disto' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .dsoon-wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_control(
			'border_radius',
			array(
				'label'      => esc_html__( 'گردی گوشه‌ها', 'disto' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'selectors'  => array(
					'{{WRAPPER}} .dsoon-wrapper' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			array(
				'name'     => 'box_shadow',
				'label'    => esc_html__( 'سایه جعبه', 'disto' ),
				'selector' => '{{WRAPPER}} .dsoon-wrapper',
			)
		);

		$this->add_control(
			'glass_effect',
			array(
				'label'        => esc_html__( 'افکت شیشه‌ای', 'disto' ),
				'type'         => Controls_Manager::SWITCHER,
				'default'      => '',
				'return_value' => 'yes',
			)
		);

		$this->end_controls_section();

		// ─── Style: Form & Button sizes ──────────────────────────────────────
		$this->start_controls_section(
			'section_style_form',
			array(
				'label' => esc_html__( 'فرم و دکمه', 'disto' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_responsive_control(
			'input_width',
			array(
				'label'      => esc_html__( 'عرض فیلد ایمیل', 'disto' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px', '%' ),
				'range'      => array(
					'px' => array( 'min' => 150, 'max' => 600, 'step' => 10 ),
					'%'  => array( 'min' => 20, 'max' => 100, 'step' => 5 ),
				),
				'default'    => array( 'unit' => 'px', 'size' => 280 ),
				'selectors'  => array(
					'{{WRAPPER}} .dsoon-input' => 'min-width: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'input_padding',
			array(
				'label'      => esc_html__( 'پدینگ فیلد ایمیل', 'disto' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .dsoon-input' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'input_font_size',
			array(
				'label'      => esc_html__( 'اندازه فونت فیلد ایمیل', 'disto' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array( 'px' => array( 'min' => 12, 'max' => 24, 'step' => 1 ) ),
				'selectors'  => array(
					'{{WRAPPER}} .dsoon-input' => 'font-size: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'button_padding',
			array(
				'label'      => esc_html__( 'پدینگ دکمه', 'disto' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', 'em' ),
				'selectors'  => array(
					'{{WRAPPER}} .dsoon-cta' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->add_responsive_control(
			'button_font_size',
			array(
				'label'      => esc_html__( 'اندازه فونت دکمه', 'disto' ),
				'type'       => Controls_Manager::SLIDER,
				'size_units' => array( 'px' ),
				'range'      => array( 'px' => array( 'min' => 12, 'max' => 24, 'step' => 1 ) ),
				'selectors'  => array(
					'{{WRAPPER}} .dsoon-cta' => 'font-size: {{SIZE}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();

		// ─── Style: Background ───────────────────────────────────────────────
		$this->start_controls_section(
			'section_style_bg',
			array(
				'label' => esc_html__( 'پس‌زمینه', 'disto' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'bg_color',
			array(
				'label'     => esc_html__( 'رنگ پس‌زمینه', 'disto' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#f8f8f8',
				'selectors' => array(
					'{{WRAPPER}} .dsoon-wrapper' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'bg_gradient_enable',
			array(
				'label'        => esc_html__( 'گرادیانت', 'disto' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
			)
		);

		$this->add_control(
			'bg_gradient',
			array(
				'label'       => esc_html__( 'گرادیانت پس‌زمینه', 'disto' ),
				'type'        => Controls_Manager::TEXTAREA,
				'default'     => 'linear-gradient(135deg, #667eea 0%, #764ba2 100%)',
				'placeholder' => 'linear-gradient(135deg, #667eea 0%, #764ba2 100%)',
				'description' => esc_html__( 'مثال: linear-gradient(135deg, #667eea 0%, #764ba2 100%)', 'disto' ),
				'condition'   => array( 'bg_gradient_enable' => 'yes' ),
			)
		);

		$this->add_control(
			'bg_image',
			array(
				'label' => esc_html__( 'تصویر پس‌زمینه', 'disto' ),
				'type'  => Controls_Manager::MEDIA,
			)
		);

		$this->add_control(
			'overlay_color',
			array(
				'label'     => esc_html__( 'رنگ overlay', 'disto' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => 'rgba(0,0,0,0.3)',
				'selectors' => array(
					'{{WRAPPER}} .dsoon-overlay' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'overlay_opacity',
			array(
				'label'     => esc_html__( 'شفافیت overlay', 'disto' ),
				'type'      => Controls_Manager::SLIDER,
				'range'     => array(
					'px' => array( 'min' => 0, 'max' => 1, 'step' => 0.05 ),
				),
				'default'   => array( 'size' => 0.3 ),
				'selectors' => array(
					'{{WRAPPER}} .dsoon-overlay' => 'opacity: {{SIZE}};',
				),
			)
		);

		$this->add_control(
			'animated_bg',
			array(
				'label'        => esc_html__( 'پس‌زمینه متحرک', 'disto' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
			)
		);

		$this->end_controls_section();

		// ─── Style: Colors ───────────────────────────────────────────────────
		$this->start_controls_section(
			'section_style_colors',
			array(
				'label' => esc_html__( 'رنگ‌ها', 'disto' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'primary_color',
			array(
				'label'     => esc_html__( 'رنگ اصلی', 'disto' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#6b3fa0',
				'selectors' => array(
					'{{WRAPPER}} .dsoon-headline'     => 'color: {{VALUE}};',
					'{{WRAPPER}} .dsoon-count-num'    => 'color: {{VALUE}};',
					'{{WRAPPER}} .dsoon-badge'        => 'border-color: {{VALUE}}; color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'accent_color',
			array(
				'label'     => esc_html__( 'رنگ تاکید', 'disto' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#8a2be2',
				'selectors' => array(
					'{{WRAPPER}} .dsoon-cta'         => 'background-color: {{VALUE}}; border-color: {{VALUE}};',
					'{{WRAPPER}} .dsoon-social a:hover' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'text_color',
			array(
				'label'     => esc_html__( 'رنگ متن', 'disto' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#1a1a1a',
				'selectors' => array(
					'{{WRAPPER}} .dsoon-inner' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'secondary_text_color',
			array(
				'label'     => esc_html__( 'رنگ متن ثانویه', 'disto' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#666666',
				'selectors' => array(
					'{{WRAPPER}} .dsoon-subheadline'    => 'color: {{VALUE}};',
					'{{WRAPPER}} .dsoon-desc'           => 'color: {{VALUE}};',
					'{{WRAPPER}} .dsoon-count-label'    => 'color: {{VALUE}};',
					'{{WRAPPER}} .dsoon-footer'         => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'countdown_color',
			array(
				'label'     => esc_html__( 'رنگ شمارش معکوس', 'disto' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#6b3fa0',
				'selectors' => array(
					'{{WRAPPER}} .dsoon-count-num' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'button_color',
			array(
				'label'     => esc_html__( 'رنگ دکمه (عادی)', 'disto' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#6b3fa0',
				'selectors' => array(
					'{{WRAPPER}} .dsoon-cta' => 'background-color: {{VALUE}}; border-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'button_hover_color',
			array(
				'label'     => esc_html__( 'رنگ دکمه (هاور)', 'disto' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#5a3490',
				'selectors' => array(
					'{{WRAPPER}} .dsoon-cta:hover' => 'background-color: {{VALUE}}; border-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'social_color',
			array(
				'label'     => esc_html__( 'رنگ آیکن‌های اجتماعی', 'disto' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#6b3fa0',
				'selectors' => array(
					'{{WRAPPER}} .dsoon-social a' => 'color: {{VALUE}};',
				),
			)
		);

		$this->end_controls_section();

		// ─── Typography ──────────────────────────────────────────────────────
		$this->start_controls_section(
			'section_typography',
			array(
				'label' => esc_html__( 'تایپوگرافی عنوان اصلی', 'disto' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'headline_typography',
				'label'    => esc_html__( 'عنوان اصلی', 'disto' ),
				'selector' => '{{WRAPPER}} .dsoon-headline',
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_typography_sub',
			array(
				'label' => esc_html__( 'تایپوگرافی زیرعنوان', 'disto' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'subheadline_typography',
				'selector' => '{{WRAPPER}} .dsoon-subheadline',
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_typography_desc',
			array(
				'label' => esc_html__( 'تایپوگرافی توضیحات', 'disto' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'description_typography',
				'selector' => '{{WRAPPER}} .dsoon-desc',
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_typography_count',
			array(
				'label' => esc_html__( 'تایپوگرافی شمارش معکوس', 'disto' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'countdown_typography',
				'selector' => '{{WRAPPER}} .dsoon-count-num',
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'countdown_label_typography',
				'label'    => esc_html__( 'برچسب‌ها', 'disto' ),
				'selector' => '{{WRAPPER}} .dsoon-count-label',
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_typography_btn',
			array(
				'label' => esc_html__( 'تایپوگرافی دکمه', 'disto' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'button_typography',
				'selector' => '{{WRAPPER}} .dsoon-cta',
			)
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_typography_footer',
			array(
				'label' => esc_html__( 'تایپوگرافی فوتر', 'disto' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'footer_typography',
				'selector' => '{{WRAPPER}} .dsoon-footer',
			)
		);

		$this->end_controls_section();

		// ─── Advanced: Animation ─────────────────────────────────────────────
		$this->start_controls_section(
			'section_advanced',
			array(
				'label' => esc_html__( 'پیشرفته', 'disto' ),
				'tab'   => Controls_Manager::TAB_ADVANCED,
			)
		);

		$this->add_control(
			'entrance_animation',
			array(
				'label'   => esc_html__( 'انیمیشن ورود', 'disto' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'fadeUp',
				'options' => array(
					''          => esc_html__( 'بدون', 'disto' ),
					'fadeUp'    => esc_html__( 'محو به بالا', 'disto' ),
					'fadeDown'  => esc_html__( 'محو به پایین', 'disto' ),
					'fadeIn'    => esc_html__( 'محو', 'disto' ),
					'zoomIn'    => esc_html__( 'بزرگنمایی', 'disto' ),
				),
			)
		);

		$this->add_control(
			'animation_duration',
			array(
				'label'   => esc_html__( 'مدت انیمیشن (ms)', 'disto' ),
				'type'    => Controls_Manager::NUMBER,
				'default' => 800,
				'min'     => 200,
				'max'     => 3000,
				'condition' => array( 'entrance_animation!' => '' ),
			)
		);

		$this->add_control(
			'hover_animation',
			array(
				'label'   => esc_html__( 'انیمیشن هاور دکمه', 'disto' ),
				'type'    => Controls_Manager::HOVER_ANIMATION,
				'default' => '',
			)
		);

		$this->add_control(
			'smooth_fade',
			array(
				'label'        => esc_html__( 'محو نرم', 'disto' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
				'default'      => 'yes',
			)
		);

		$this->add_control(
			'parallax_bg',
			array(
				'label'        => esc_html__( 'پارالاکس پس‌زمینه', 'disto' ),
				'type'         => Controls_Manager::SWITCHER,
				'return_value' => 'yes',
			)
		);

		$this->add_control(
			'custom_css',
			array(
				'label'       => esc_html__( 'CSS سفارشی', 'disto' ),
				'type'        => Controls_Manager::CODE,
				'language'    => 'css',
				'rows'        => 5,
				'placeholder' => '.dsoon-wrapper { }',
			)
		);

		$this->end_controls_section();
	}

	protected function render() {
		$s = $this->get_settings_for_display();
		$style = $s['design_style'];
		$id    = 'dsoon-' . $this->get_id();
		$dark  = $s['dark_mode'] === 'yes' ? ' dsoon-dark' : '';
		$glass = $s['glass_effect'] === 'yes' ? ' dsoon-glass' : '';
		$width = $s['section_width'] === 'fullwidth' ? ' dsoon-full' : '';
		$anim  = ! empty( $s['entrance_animation'] ) ? ' dsoon-anim-' . esc_attr( $s['entrance_animation'] ) : '';
		$anim_dur = ! empty( $s['animation_duration'] ) ? (int) $s['animation_duration'] : 800;

		$wrapper_style = '';
		if ( $s['bg_gradient_enable'] === 'yes' && ! empty( $s['bg_gradient'] ) ) {
			$wrapper_style .= 'background: ' . esc_attr( $s['bg_gradient'] ) . ';';
		}
		if ( ! empty( $s['bg_image']['url'] ) ) {
			$wrapper_style .= ' background-image: url(' . esc_url( $s['bg_image']['url'] ) . '); background-size: cover; background-position: center;';
		}

		$countdown_data = array();
		if ( $s['countdown_enable'] === 'yes' ) {
			$countdown_data = array(
				'datetime' => $s['launch_datetime'],
				'tz'       => $s['timezone'],
				'days'     => $s['label_days'],
				'hours'    => $s['label_hours'],
				'mins'     => $s['label_minutes'],
				'secs'     => $s['label_seconds'],
				'expiry'   => $s['expiry_action'],
				'message'  => $s['expiry_message'],
				'redirect' => ! empty( $s['expiry_redirect_url']['url'] ) ? $s['expiry_redirect_url']['url'] : '',
			);
		}

		?>
		<div id="<?php echo esc_attr( $id ); ?>" class="dsoon-wrapper dsoon-style-<?php echo esc_attr( $style ); ?><?php echo esc_attr( $dark . $glass . $width . $anim ); ?>" dir="rtl" data-anim-dur="<?php echo esc_attr( $anim_dur ); ?>" <?php echo $wrapper_style ? ' style="' . esc_attr( $wrapper_style ) . '"' : ''; ?> <?php echo $countdown_data ? ' data-countdown="' . esc_attr( wp_json_encode( $countdown_data ) ) . '"' : ''; ?>>
			<?php if ( ! empty( $s['bg_image']['url'] ) ) : ?>
				<div class="dsoon-overlay"></div>
			<?php endif; ?>
			<div class="dsoon-inner">
				<?php if ( ! empty( $s['badges'] ) ) : ?>
					<div class="dsoon-badges">
						<?php foreach ( $s['badges'] as $b ) : ?>
							<?php if ( ! empty( $b['badge_text'] ) ) : ?>
								<span class="dsoon-badge"><?php echo esc_html( $b['badge_text'] ); ?></span>
							<?php endif; ?>
						<?php endforeach; ?>
					</div>
				<?php endif; ?>

				<?php if ( $s['headline'] ) : ?>
					<h2 class="dsoon-headline"><?php echo esc_html( $s['headline'] ); ?></h2>
				<?php endif; ?>

				<?php if ( $s['subheadline'] ) : ?>
					<p class="dsoon-subheadline"><?php echo esc_html( $s['subheadline'] ); ?></p>
				<?php endif; ?>

				<?php if ( $s['description'] ) : ?>
					<div class="dsoon-desc"><?php echo wp_kses_post( $s['description'] ); ?></div>
				<?php endif; ?>

				<?php if ( $s['countdown_enable'] === 'yes' ) : ?>
					<div class="dsoon-countdown" aria-live="polite">
						<div class="dsoon-count-item">
							<span class="dsoon-count-num" data-unit="days">00</span>
							<span class="dsoon-count-label"><?php echo esc_html( $s['label_days'] ); ?></span>
						</div>
						<div class="dsoon-count-item">
							<span class="dsoon-count-num" data-unit="hours">00</span>
							<span class="dsoon-count-label"><?php echo esc_html( $s['label_hours'] ); ?></span>
						</div>
						<div class="dsoon-count-item">
							<span class="dsoon-count-num" data-unit="minutes">00</span>
							<span class="dsoon-count-label"><?php echo esc_html( $s['label_minutes'] ); ?></span>
						</div>
						<div class="dsoon-count-item">
							<span class="dsoon-count-num" data-unit="seconds">00</span>
							<span class="dsoon-count-label"><?php echo esc_html( $s['label_seconds'] ); ?></span>
						</div>
					</div>
					<div class="dsoon-expiry-message" style="display:none;"></div>
				<?php endif; ?>

				<?php if ( $s['show_email_form'] === 'yes' ) : ?>
					<div class="dsoon-form-wrap">
						<?php if ( ! empty( $s['form_shortcode'] ) ) : ?>
							<div class="dsoon-form-shortcode"><?php echo do_shortcode( $s['form_shortcode'] ); ?></div>
						<?php else : ?>
							<form class="dsoon-form" data-success="<?php echo esc_attr( $s['success_message'] ); ?>" data-error="<?php echo esc_attr( $s['error_message'] ); ?>">
								<input type="email" name="email" class="dsoon-input" placeholder="<?php echo esc_attr( $s['email_placeholder'] ); ?>" required>
								<button type="submit" class="dsoon-cta<?php echo ! empty( $s['hover_animation'] ) ? ' elementor-animation-' . esc_attr( $s['hover_animation'] ) : ''; ?>"><?php echo esc_html( $s['cta_text'] ); ?></button>
							</form>
							<p class="dsoon-form-feedback" style="display:none;"></p>
						<?php endif; ?>
					</div>
				<?php endif; ?>

				<?php if ( ( ! isset( $s['show_social'] ) || $s['show_social'] === 'yes' ) && ! empty( $s['social_items'] ) ) : ?>
					<div class="dsoon-social">
						<?php foreach ( $s['social_items'] as $item ) : ?>
							<?php
							$url   = ! empty( $item['social_url']['url'] ) ? $item['social_url']['url'] : '#';
							$target = ! empty( $item['open_new_tab'] ) && $item['open_new_tab'] === 'yes' ? '_blank' : '_self';
							$rel   = $target === '_blank' ? ' rel="noopener noreferrer"' : '';
							$icon  = ! empty( $item['social_icon'] ) ? $item['social_icon'] : array();
							?>
							<a href="<?php echo esc_url( $url ); ?>" target="<?php echo esc_attr( $target ); ?>"<?php echo $rel; ?> aria-label="<?php echo esc_attr( $icon['value'] ?? 'social' ); ?>">
								<?php \Elementor\Icons_Manager::render_icon( $icon, array( 'aria-hidden' => 'true' ) ); ?>
							</a>
						<?php endforeach; ?>
					</div>
				<?php endif; ?>

				<?php if ( $s['footer_text'] ) : ?>
					<p class="dsoon-footer"><?php echo esc_html( $s['footer_text'] ); ?></p>
				<?php endif; ?>
			</div>
		</div>
		<?php

		if ( ! empty( $s['custom_css'] ) ) {
			echo '<style>' . wp_strip_all_tags( $s['custom_css'] ) . '</style>';
		}
	}
}
