<?php
/**
 * About Us (Elementor Widget)
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! did_action( 'elementor/loaded' ) ) {
	return;
}

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Repeater;

// Use a unique class name to avoid conflicts with the classic "About Us" sidebar widget in the parent theme.
class Disto_About_Us_Section_Widget extends Widget_Base {

	public function get_name() {
		return 'disto_about_us_section';
	}

	public function get_title() {
		return esc_html__( 'درباره ما – مدرن', 'disto' );
	}

	public function get_icon() {
		return 'eicon-person';
	}

	public function get_categories() {
		return array( 'disto-elements' );
	}

	public function get_style_depends() {
		return array( 'disto-child-about-us' );
	}

	protected function register_controls() {

		// Content: main texts & images.
		$this->start_controls_section(
			'section_content',
			array(
				'label' => esc_html__( 'محتوا', 'disto' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$this->add_control(
			'stat_number',
			array(
				'label'       => esc_html__( 'عدد شاخص (بالا)', 'disto' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => '12K+',
				'placeholder' => '12K+',
			)
		);

		$this->add_control(
			'stat_subtitle',
			array(
				'label'       => esc_html__( 'زیرنویس عدد شاخص', 'disto' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'Member Has Success', 'disto' ),
				'placeholder' => esc_html__( 'Member Has Success', 'disto' ),
			)
		);

		$this->add_control(
			'main_image',
			array(
				'label'   => esc_html__( 'تصویر اصلی (دایره)', 'disto' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => array(),
			)
		);

		$this->add_control(
			'secondary_image',
			array(
				'label'   => esc_html__( 'تصویر دوم (مستطیل)', 'disto' ),
				'type'    => Controls_Manager::MEDIA,
				'default' => array(),
			)
		);

		$this->add_control(
			'about_label',
			array(
				'label'       => esc_html__( 'برچسب کوچک', 'disto' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'About Us', 'disto' ),
				'placeholder' => esc_html__( 'About Us', 'disto' ),
			)
		);

		$this->add_control(
			'heading',
			array(
				'label'       => esc_html__( 'عنوان اصلی', 'disto' ),
				'type'        => Controls_Manager::TEXTAREA,
				'default'     => esc_html__( 'Driven By Passion, Guided By Purpose', 'disto' ),
				'placeholder' => esc_html__( 'Driven By Passion, Guided By Purpose', 'disto' ),
				'rows'        => 2,
			)
		);

		$this->add_control(
			'description',
			array(
				'label'       => esc_html__( 'توضیحات', 'disto' ),
				'type'        => Controls_Manager::TEXTAREA,
				'default'     => esc_html__( 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec laoreet justo non bibendum ultricies, quam enim fermentum orci, sed mollis diam lacus et eros.', 'disto' ),
				'placeholder' => esc_html__( 'متن کوتاه درباره مجموعه شما…', 'disto' ),
				'rows'        => 4,
			)
		);

		// Bullet list (features) with repeater.
		$repeater = new Repeater();

		$repeater->add_control(
			'item_text',
			array(
				'label'       => esc_html__( 'متن آیتم', 'disto' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'Strategic Business Planning', 'disto' ),
				'placeholder' => esc_html__( 'متن ویژگی', 'disto' ),
			)
		);

		$this->add_control(
			'feature_items',
			array(
				'label'       => esc_html__( 'آیتم‌های مزیت', 'disto' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $repeater->get_controls(),
				'default'     => array(
					array(
						'item_text' => esc_html__( 'Strategic Business Planning', 'disto' ),
					),
					array(
						'item_text' => esc_html__( 'Leadership & Mindset Growth', 'disto' ),
					),
					array(
						'item_text' => esc_html__( 'Sales & Marketing Guidance', 'disto' ),
					),
				),
				'title_field' => '{{{ item_text }}}',
			)
		);

		$this->add_control(
			'button_text',
			array(
				'label'       => esc_html__( 'متن دکمه', 'disto' ),
				'type'        => Controls_Manager::TEXT,
				'default'     => esc_html__( 'Read More', 'disto' ),
				'placeholder' => esc_html__( 'Read More', 'disto' ),
			)
		);

		$this->add_control(
			'button_link',
			array(
				'label'         => esc_html__( 'لینک دکمه', 'disto' ),
				'type'          => Controls_Manager::URL,
				'placeholder'   => 'https://example.com',
				'show_external' => true,
				'default'       => array(
					'url'         => '#',
					'is_external' => false,
					'nofollow'    => false,
				),
			)
		);

		$this->end_controls_section();

		// Social links.
		$this->start_controls_section(
			'section_social',
			array(
				'label' => esc_html__( 'شبکه‌های اجتماعی', 'disto' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			)
		);

		$social_repeater = new Repeater();

		$social_repeater->add_control(
			'social_icon',
			array(
				'label'   => esc_html__( 'آیکن', 'disto' ),
				'type'    => Controls_Manager::ICONS,
				'default' => array(
					'value'   => 'fab fa-facebook-f',
					'library' => 'fa-brands',
				),
			)
		);

		$social_repeater->add_control(
			'social_url',
			array(
				'label'       => esc_html__( 'لینک', 'disto' ),
				'type'        => Controls_Manager::URL,
				'placeholder' => 'https://',
				'default'     => array(
					'url'         => '',
					'is_external' => true,
					'nofollow'    => true,
				),
			)
		);

		$this->add_control(
			'social_items',
			array(
				'label'       => esc_html__( 'آیکن‌ها', 'disto' ),
				'type'        => Controls_Manager::REPEATER,
				'fields'      => $social_repeater->get_controls(),
				'default'     => array(),
				'title_field' => '{{{ social_icon.value }}}',
			)
		);

		$this->end_controls_section();

		// Style: layout & colors.
		$this->start_controls_section(
			'section_style_layout',
			array(
				'label' => esc_html__( 'پس‌زمینه و لایه‌بندی', 'disto' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'section_bg_color',
			array(
				'label'     => esc_html__( 'رنگ پس‌زمینه', 'disto' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#f5f7fb',
				'selectors' => array(
					'{{WRAPPER}} .disto-aboutus-wrapper' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			array(
				'name'     => 'section_shadow',
				'label'    => esc_html__( 'سایه بخش', 'disto' ),
				'selector' => '{{WRAPPER}} .disto-aboutus-wrapper',
			)
		);

		$this->add_responsive_control(
			'section_padding',
			array(
				'label'      => esc_html__( 'پدینگ بخش', 'disto' ),
				'type'       => Controls_Manager::DIMENSIONS,
				'size_units' => array( 'px', '%' ),
				'default'    => array(
					'top'      => 48,
					'right'    => 32,
					'bottom'   => 48,
					'left'     => 32,
					'unit'     => 'px',
					'isLinked' => true,
				),
				'selectors'  => array(
					'{{WRAPPER}} .disto-aboutus-wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				),
			)
		);

		$this->end_controls_section();

		// Style: texts & colors.
		$this->start_controls_section(
			'section_style_typography',
			array(
				'label' => esc_html__( 'متن و تایپوگرافی', 'disto' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'stat_color',
			array(
				'label'     => esc_html__( 'رنگ عدد شاخص', 'disto' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#0f4f4f',
				'selectors' => array(
					'{{WRAPPER}} .disto-aboutus-stat' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'stat_sub_color',
			array(
				'label'     => esc_html__( 'رنگ زیرنویس عدد', 'disto' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#4b5563',
				'selectors' => array(
					'{{WRAPPER}} .disto-aboutus-stat-sub' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'label_color',
			array(
				'label'     => esc_html__( 'رنگ برچسب «About Us»', 'disto' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#059669',
				'selectors' => array(
					'{{WRAPPER}} .disto-aboutus-label' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'heading_color',
			array(
				'label'     => esc_html__( 'رنگ عنوان اصلی', 'disto' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#111827',
				'selectors' => array(
					'{{WRAPPER}} .disto-aboutus-heading' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'desc_color',
			array(
				'label'     => esc_html__( 'رنگ توضیحات', 'disto' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#4b5563',
				'selectors' => array(
					'{{WRAPPER}} .disto-aboutus-desc' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'features_card_bg',
			array(
				'label'     => esc_html__( 'پس‌زمینه کارت ویژگی‌ها', 'disto' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#0f4f4f',
				'selectors' => array(
					'{{WRAPPER}} .disto-aboutus-bullets-card' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'features_text_color',
			array(
				'label'     => esc_html__( 'رنگ متن ویژگی‌ها', 'disto' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#e5f9f5',
				'selectors' => array(
					'{{WRAPPER}} .disto-aboutus-bullet' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'features_icon_color',
			array(
				'label'     => esc_html__( 'رنگ آیکن تیک', 'disto' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#22c55e',
				'selectors' => array(
					'{{WRAPPER}} .disto-aboutus-bullet-icon' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'typography_stat',
				'label'    => esc_html__( 'تایپوگرافی عدد شاخص', 'disto' ),
				'selector' => '{{WRAPPER}} .disto-aboutus-stat',
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'typography_label',
				'label'    => esc_html__( 'تایپوگرافی برچسب', 'disto' ),
				'selector' => '{{WRAPPER}} .disto-aboutus-label',
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'typography_heading',
				'label'    => esc_html__( 'تایپوگرافی عنوان اصلی', 'disto' ),
				'selector' => '{{WRAPPER}} .disto-aboutus-heading',
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'typography_desc',
				'label'    => esc_html__( 'تایپوگرافی توضیحات', 'disto' ),
				'selector' => '{{WRAPPER}} .disto-aboutus-desc',
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'typography_features',
				'label'    => esc_html__( 'تایپوگرافی ویژگی‌ها', 'disto' ),
				'selector' => '{{WRAPPER}} .disto-aboutus-bullet',
			)
		);

		$this->end_controls_section();

		// Style: button & socials.
		$this->start_controls_section(
			'section_style_cta',
			array(
				'label' => esc_html__( 'دکمه و شبکه‌های اجتماعی', 'disto' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$this->add_control(
			'button_bg',
			array(
				'label'     => esc_html__( 'رنگ پس‌زمینه دکمه', 'disto' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#111827',
				'selectors' => array(
					'{{WRAPPER}} .disto-aboutus-button' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'button_color',
			array(
				'label'     => esc_html__( 'رنگ متن دکمه', 'disto' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#ffffff',
				'selectors' => array(
					'{{WRAPPER}} .disto-aboutus-button' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'button_bg_hover',
			array(
				'label'     => esc_html__( 'پس‌زمینه هاور دکمه', 'disto' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#000000',
				'selectors' => array(
					'{{WRAPPER}} .disto-aboutus-button:hover' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			array(
				'name'     => 'typography_button',
				'label'    => esc_html__( 'تایپوگرافی دکمه', 'disto' ),
				'selector' => '{{WRAPPER}} .disto-aboutus-button',
			)
		);

		$this->add_control(
			'social_icon_color',
			array(
				'label'     => esc_html__( 'رنگ آیکن شبکه‌های اجتماعی', 'disto' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#0f4f4f',
				'selectors' => array(
					'{{WRAPPER}} .disto-aboutus-socials a' => 'color: {{VALUE}};',
				),
			)
		);

		$this->add_control(
			'social_icon_bg',
			array(
				'label'     => esc_html__( 'پس‌زمینه آیکن شبکه‌های اجتماعی', 'disto' ),
				'type'      => Controls_Manager::COLOR,
				'default'   => '#ffffff',
				'selectors' => array(
					'{{WRAPPER}} .disto-aboutus-socials a' => 'background-color: {{VALUE}};',
				),
			)
		);

		$this->end_controls_section();

		// Animations.
		$this->start_controls_section(
			'section_style_animations',
			array(
				'label' => esc_html__( 'انیمیشن ورودی', 'disto' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

		$animation_options = array(
			'none'       => esc_html__( 'بدون انیمیشن', 'disto' ),
			'fade-up'    => esc_html__( 'محوشدن به بالا', 'disto' ),
			'fade-right' => esc_html__( 'محوشدن از راست', 'disto' ),
			'fade-left'  => esc_html__( 'محوشدن از چپ', 'disto' ),
			'zoom-in'    => esc_html__( 'بزرگ‌نمایی (Zoom In)', 'disto' ),
		);

		$this->add_control(
			'image_animation',
			array(
				'label'   => esc_html__( 'انیمیشن ستون تصویر', 'disto' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'fade-up',
				'options' => $animation_options,
			)
		);

		$this->add_control(
			'content_animation',
			array(
				'label'   => esc_html__( 'انیمیشن ستون متن', 'disto' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'fade-left',
				'options' => $animation_options,
			)
		);

		$this->add_control(
			'features_animation',
			array(
				'label'   => esc_html__( 'انیمیشن کارت مزایا', 'disto' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'fade-up',
				'options' => $animation_options,
			)
		);

		$this->add_control(
			'cta_animation',
			array(
				'label'   => esc_html__( 'انیمیشن دکمه و شبکه‌های اجتماعی', 'disto' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'fade-up',
				'options' => $animation_options,
			)
		);

		$this->end_controls_section();
	}

	protected function render() {
		$settings = $this->get_settings_for_display();

		$button_url    = isset( $settings['button_link']['url'] ) ? $settings['button_link']['url'] : '';
		$button_target = ! empty( $settings['button_link']['is_external'] ) ? ' target="_blank"' : '';
		$button_rel    = ! empty( $settings['button_link']['nofollow'] ) ? ' rel="nofollow"' : '';

		$main_image_url      = ! empty( $settings['main_image']['url'] ) ? $settings['main_image']['url'] : '';
		$secondary_image_url = ! empty( $settings['secondary_image']['url'] ) ? $settings['secondary_image']['url'] : '';

		// Map animation selections to CSS helper classes.
		$image_anim_class    = ( ! empty( $settings['image_animation'] ) && 'none' !== $settings['image_animation'] ) ? ' disto-anim-' . esc_attr( $settings['image_animation'] ) : '';
		$content_anim_class  = ( ! empty( $settings['content_animation'] ) && 'none' !== $settings['content_animation'] ) ? ' disto-anim-' . esc_attr( $settings['content_animation'] ) : '';
		$features_anim_class = ( ! empty( $settings['features_animation'] ) && 'none' !== $settings['features_animation'] ) ? ' disto-anim-' . esc_attr( $settings['features_animation'] ) : '';
		$cta_anim_class      = ( ! empty( $settings['cta_animation'] ) && 'none' !== $settings['cta_animation'] ) ? ' disto-anim-' . esc_attr( $settings['cta_animation'] ) : '';
		?>
		<section class="disto-aboutus-wrapper">
			<div class="disto-aboutus-left<?php echo $image_anim_class; ?>">
				<?php if ( ! empty( $settings['stat_number'] ) ) : ?>
					<div class="disto-aboutus-stat"><?php echo esc_html( $settings['stat_number'] ); ?></div>
				<?php endif; ?>

				<?php if ( ! empty( $settings['stat_subtitle'] ) ) : ?>
					<div class="disto-aboutus-stat-sub"><?php echo esc_html( $settings['stat_subtitle'] ); ?></div>
				<?php endif; ?>

				<div class="disto-aboutus-images">
					<?php if ( $main_image_url ) : ?>
						<div class="disto-aboutus-main-img">
							<img src="<?php echo esc_url( $main_image_url ); ?>" alt="<?php echo esc_attr( $settings['heading'] ); ?>" loading="lazy" decoding="async" />
						</div>
					<?php endif; ?>

					<?php if ( $secondary_image_url ) : ?>
						<div class="disto-aboutus-secondary-img">
							<img src="<?php echo esc_url( $secondary_image_url ); ?>" alt="<?php echo esc_attr( $settings['heading'] ); ?>" loading="lazy" decoding="async" />
						</div>
					<?php endif; ?>
				</div>
			</div>

			<div class="disto-aboutus-right<?php echo $content_anim_class; ?>">
				<?php if ( ! empty( $settings['about_label'] ) ) : ?>
					<div class="disto-aboutus-label"><?php echo esc_html( $settings['about_label'] ); ?></div>
				<?php endif; ?>

				<?php if ( ! empty( $settings['heading'] ) ) : ?>
					<h2 class="disto-aboutus-heading">
						<?php echo wp_kses_post( nl2br( $settings['heading'] ) ); ?>
					</h2>
				<?php endif; ?>

				<?php if ( ! empty( $settings['description'] ) ) : ?>
					<div class="disto-aboutus-desc">
						<?php echo wp_kses_post( $settings['description'] ); ?>
					</div>
				<?php endif; ?>

				<?php if ( ! empty( $settings['feature_items'] ) && is_array( $settings['feature_items'] ) ) : ?>
					<div class="disto-aboutus-bullets-card<?php echo $features_anim_class; ?>">
						<?php foreach ( $settings['feature_items'] as $item ) : ?>
							<?php if ( empty( $item['item_text'] ) ) : ?>
								<?php continue; ?>
							<?php endif; ?>
							<div class="disto-aboutus-bullet">
								<span class="disto-aboutus-bullet-icon" aria-hidden="true">
									<svg viewBox="0 0 20 20" fill="currentColor" xmlns="http://www.w3.org/2000/svg">
										<path d="M8.143 13.314L4.83 10l1.18-1.18 2.133 2.133 5.014-5.014 1.18 1.18-6.194 6.194z" />
									</svg>
								</span>
								<span><?php echo esc_html( $item['item_text'] ); ?></span>
							</div>
						<?php endforeach; ?>
					</div>
				<?php endif; ?>

				<div class="disto-aboutus-cta<?php echo $cta_anim_class; ?>">
					<?php if ( ! empty( $settings['button_text'] ) && $button_url ) : ?>
						<a class="disto-aboutus-button" href="<?php echo esc_url( $button_url ); ?>"<?php echo $button_target . $button_rel; ?>>
							<?php echo esc_html( $settings['button_text'] ); ?>
						</a>
					<?php endif; ?>

					<?php if ( ! empty( $settings['social_items'] ) && is_array( $settings['social_items'] ) ) : ?>
						<div class="disto-aboutus-socials">
							<?php foreach ( $settings['social_items'] as $social ) : ?>
								<?php
								if ( empty( $social['social_url']['url'] ) || empty( $social['social_icon']['value'] ) ) {
									continue;
								}
								$s_url     = $social['social_url']['url'];
								$s_target  = ! empty( $social['social_url']['is_external'] ) ? ' target="_blank"' : '';
								$s_rel_arr = array();
								if ( ! empty( $social['social_url']['nofollow'] ) ) {
									$s_rel_arr[] = 'nofollow';
								}
								$s_rel = ! empty( $s_rel_arr ) ? ' rel="' . esc_attr( implode( ' ', $s_rel_arr ) ) . '"' : '';
								?>
								<a href="<?php echo esc_url( $s_url ); ?>"<?php echo $s_target . $s_rel; ?>>
									<?php \Elementor\Icons_Manager::render_icon( $social['social_icon'], array( 'aria-hidden' => 'true' ) ); ?>
								</a>
							<?php endforeach; ?>
						</div>
					<?php endif; ?>
				</div>
			</div>
		</section>
		<?php
	}
}


