<?php
/**
 * Footer template override for Disto Child.
 *
 * این نسخه فقط بخش ستون‌های فوتر را داینامیک می‌کند تا بتوانیم
 * از طریق داشبورد «تنظیمات قالب دیستو» ناحیه‌های ویجت هر ستون را انتخاب کنیم.
 */
?>
<!-- Start footer -->
<footer id="footer-container" class="<?php if ( get_theme_mod( 'footer_columns' ) == 'footer0col' ) { echo 'no_padding_footer'; } ?> enable_footer_columns_dark">
	<?php if ( get_theme_mod( 'footer_columns' ) == 'footer0col' ) {} else { ?>
		<?php
		// نقشه ناحیه‌های ویجت هر ستون (با fallback به مقادیر پیش‌فرض تم والد).
		$footer_sidebar_col1 = get_theme_mod( 'disto_footer_col1_sidebar', 'footer1-sidebar' );
		$footer_sidebar_col2 = get_theme_mod( 'disto_footer_col2_sidebar', 'footer2-sidebar' );
		$footer_sidebar_col3 = get_theme_mod( 'disto_footer_col3_sidebar', 'footer3-sidebar' );
		$footer_sidebar_col4 = get_theme_mod( 'disto_footer_col4_sidebar', 'footer4-sidebar' );
		?>
		<div class="footer-columns">
			<div class="container">
				<div class="row">
					<?php if ( get_theme_mod( 'footer_columns' ) == 'footer1col' ) { ?>
						<div class="col-md-12">
							<?php if ( is_active_sidebar( $footer_sidebar_col1 ) ) : dynamic_sidebar( $footer_sidebar_col1 ); endif; ?>
						</div>
					<?php } elseif ( get_theme_mod( 'footer_columns' ) == 'footer2col' ) { ?>
						<div class="col-md-6">
							<?php if ( is_active_sidebar( $footer_sidebar_col1 ) ) : dynamic_sidebar( $footer_sidebar_col1 ); endif; ?>
						</div>
						<div class="col-md-6">
							<?php if ( is_active_sidebar( $footer_sidebar_col2 ) ) : dynamic_sidebar( $footer_sidebar_col2 ); endif; ?>
						</div>
					<?php } elseif ( get_theme_mod( 'footer_columns' ) == 'footer4col' ) { ?>
						<div class="col-md-3">
							<?php if ( is_active_sidebar( $footer_sidebar_col1 ) ) : dynamic_sidebar( $footer_sidebar_col1 ); endif; ?>
						</div>
						<div class="col-md-3">
							<?php if ( is_active_sidebar( $footer_sidebar_col2 ) ) : dynamic_sidebar( $footer_sidebar_col2 ); endif; ?>
						</div>
						<div class="col-md-3">
							<?php if ( is_active_sidebar( $footer_sidebar_col3 ) ) : dynamic_sidebar( $footer_sidebar_col3 ); endif; ?>
						</div>
						<div class="col-md-3">
							<?php if ( is_active_sidebar( $footer_sidebar_col4 ) ) : dynamic_sidebar( $footer_sidebar_col4 ); endif; ?>
						</div>
					<?php } else { // footer3col پیش‌فرض. ?>
						<div class="col-md-4">
							<?php if ( is_active_sidebar( $footer_sidebar_col1 ) ) : dynamic_sidebar( $footer_sidebar_col1 ); endif; ?>
						</div>
						<div class="col-md-4">
							<?php if ( is_active_sidebar( $footer_sidebar_col2 ) ) : dynamic_sidebar( $footer_sidebar_col2 ); endif; ?>
						</div>
						<div class="col-md-4">
							<?php if ( is_active_sidebar( $footer_sidebar_col3 ) ) : dynamic_sidebar( $footer_sidebar_col3 ); endif; ?>
						</div>
					<?php } ?>
				</div>
			</div>
		</div>
	<?php } ?>

	<div class="footer-bottom enable_footer_copyright_dark">
		<div class="container">
			<div class="row bottom_footer_menu_text">
				<div class="col-md-6 footer-left-copyright">
					<?php echo esc_attr( get_theme_mod( 'jl_copyright' ) ); ?>
				</div>
				<div class="col-md-6 footer-menu-bottom">
					<?php
					$footer_menu = array(
						'theme_location' => 'Footer_Menu',
						'depth'          => 1,
						'container'      => false,
						'menu_class'     => 'menu-footer',
						'menu_id'        => 'menu-footer-menu',
						'fallback_cb'    => false,
					);
					wp_nav_menu( $footer_menu );
					?>
				</div>
			</div>
		</div>
	</div>
</footer>
<!-- End footer -->
</div>
</div>
<div id="go-top"><a href="#go-top"><i class="fa fa-angle-up"></i></a></div>
<?php wp_footer(); ?>
</body>
</html>

