/**
 * WooCommerce Products Widget JavaScript
 * مدیریت افزودن محصول به سبد خرید
 */

(function($) {
	'use strict';

	$(document).ready(function() {
		// مدیریت کلیک روی دکمه افزودن به سبد خرید
		$(document).on('click', '.dwp-add-to-cart-btn', function(e) {
			e.preventDefault();
			e.stopPropagation();

			var $button = $(this);
			var productId = $button.data('product-id');

			if (!productId) {
				return;
			}

			// غیرفعال کردن دکمه در حین پردازش
			$button.prop('disabled', true);
			var originalText = $button.text();
			$button.text('در حال افزودن...');

			// استفاده از API ووکامرس برای افزودن به سبد خرید
			var data = {
				action: 'dwp_add_to_cart',
				product_id: productId,
				quantity: 1,
				nonce: DWP_AJAX.nonce
			};

			$.ajax({
				url: DWP_AJAX.ajax_url,
				type: 'POST',
				data: data,
				success: function(response) {
					if (response.success) {
						// به‌روزرسانی سبد خرید در صفحه
						$('body').trigger('added_to_cart', [response.fragments, response.cart_hash, $button]);

						// نمایش پیام موفقیت
						$button.text('✓ افزوده شد');
						setTimeout(function() {
							$button.text(originalText);
							$button.prop('disabled', false);
						}, 2000);

						// به‌روزرسانی تعداد محصولات در سبد خرید (اگر عنصری با این کلاس وجود دارد)
						if (response.fragments && response.fragments['div.widget_shopping_cart_content']) {
							$('div.widget_shopping_cart_content').replaceWith(response.fragments['div.widget_shopping_cart_content']);
						}

						// به‌روزرسانی تعداد در آیکون سبد خرید
						if (response.cart_hash) {
							$('body').trigger('wc_fragment_refresh');
						}
					} else {
						// نمایش خطا
						$button.text('خطا در افزودن');
						setTimeout(function() {
							$button.text(originalText);
							$button.prop('disabled', false);
						}, 2000);
					}
				},
				error: function() {
					$button.text('خطا در افزودن');
					setTimeout(function() {
						$button.text(originalText);
						$button.prop('disabled', false);
					}, 2000);
				}
			});
		});
	});

})(jQuery);

