/**
 * ابزارک باکس تیم ما – تعویض اعضا با کلیک روی تامبنیل
 */
(function ($) {
	'use strict';

	function initTeamBox($wrapper) {
		if ( ! $wrapper || ! $wrapper.length ) return;

		var $root = $wrapper.hasClass('dtbw-wrapper') ? $wrapper : $wrapper.find('.dtbw-wrapper');
		if ( ! $root.length ) $root = $wrapper;

		var $slideImgs = $root.find('.dtbw-slide-img');
		var $detailImg = $root.find('.dtbw-detail-image img');
		var $detailName = $root.find('.dtbw-detail-name span');
		var $detailPosition = $root.find('.dtbw-detail-position span');

		if ( ! $slideImgs.length || ! $detailImg.length ) return;

		// جلوگیری از init تکراری
		if ( $root.data('dtbw-inited') ) return;
		$root.data('dtbw-inited', true);

		$slideImgs.on('click.dtbw', function (e) {
			e.preventDefault();
			var $slide = $(this);
			var $img = $slide.find('img');
			var src = $img.attr('src') || $slide.data('src');
			var name = $slide.data('name') || '';
			var position = $slide.data('position') || '';

			$root.find('.dtbw-slide-img img').removeClass('active');
			$img.addClass('active');

			$detailImg.attr('src', src);
			$detailName.text(name);
			$detailPosition.text(position);

			$detailImg.addClass('animate-scale');
			setTimeout(function () {
				$detailImg.removeClass('animate-scale');
			}, 300);
		});

		// مقداردهی اولیه
		var $first = $slideImgs.first();
		var $firstImg = $first.find('img');
		if ( $firstImg.length ) {
			$firstImg.addClass('active');
			$detailImg.attr('src', $firstImg.attr('src') || $first.data('src'));
			$detailName.text($first.data('name') || '');
			$detailPosition.text($first.data('position') || '');
		}
	}

	function initAll() {
		$('.dtbw-wrapper').each(function () {
			initTeamBox($(this));
		});
	}

	$(document).ready(initAll);

	if ( typeof elementorFrontend !== 'undefined' ) {
		elementorFrontend.hooks.addAction('frontend/element_ready/disto_team_box.default', function ($scope) {
			initTeamBox($scope);
		});
	}
})(jQuery);
