/* global jQuery */
(function ($) {
	'use strict';

	function getFaMessages() {
		return {
			errorLoading: function () {
				return 'امکان بارگذاری نتایج وجود ندارد.';
			},
			inputTooLong: function (args) {
				var over = args.input.length - args.maximum;
				return 'لطفاً ' + over + ' کاراکتر را حذف کنید.';
			},
			inputTooShort: function (args) {
				var remaining = args.minimum - args.input.length;
				return 'لطفاً ' + remaining + ' کاراکتر دیگر وارد کنید.';
			},
			loadingMore: function () {
				return 'در حال بارگذاری نتایج بیشتر…';
			},
			maximumSelected: function (args) {
				return 'شما فقط می‌توانید ' + args.maximum + ' مورد را انتخاب کنید.';
			},
			noResults: function () {
				return 'نتیجه‌ای یافت نشد';
			},
			searching: function () {
				return 'در حال جستجو…';
			},
			removeAllItems: function () {
				return 'همه موارد حذف شد.';
			}
		};
	}

	$(function () {
		// WooCommerce uses SelectWoo (a Select2 fork) on frontend.
		var fn = $.fn.selectWoo || $.fn.select2;
		if (!fn || !fn.defaults || typeof fn.defaults.set !== 'function') {
			return;
		}

		fn.defaults.set('dir', 'rtl');
		fn.defaults.set('language', getFaMessages());
	});
})(jQuery);

