/**
 * Pro Portfolio Widget – Swiper, Masonry, meta follow slide, filter
 * RTL-safe, no jQuery required.
 */
(function () {
	'use strict';

	function initAzureSwiper(scope) {
		var swiperEl = scope.querySelector('.ppw-azure-swiper');
		if (!swiperEl || typeof Swiper === 'undefined') return;

		var wrapper = scope.querySelector('.ppw-wrapper');
		var autoplay = wrapper.getAttribute('data-autoplay') === '1';
		var loop = wrapper.getAttribute('data-loop') === '1';
		var arrows = wrapper.getAttribute('data-arrows') === '1';
		var pagination = wrapper.getAttribute('data-pagination') === '1';
		var metaFollow = wrapper.getAttribute('data-meta-follow') !== '0';

		var swiper = new Swiper(swiperEl, {
			loop: loop,
			autoplay: autoplay ? { delay: 4000, disableOnInteraction: false } : false,
			navigation: arrows ? {
				nextEl: swiperEl.querySelector('.swiper-button-next'),
				prevEl: swiperEl.querySelector('.swiper-button-prev'),
			} : false,
			pagination: pagination ? {
				el: swiperEl.querySelector('.swiper-pagination'),
				clickable: true,
			} : false,
			effect: 'slide',
			speed: 500,
			rtl: document.documentElement.getAttribute('dir') === 'rtl' || document.body.getAttribute('dir') === 'rtl',
			on: {
				slideChange: function () {
					if (!metaFollow) return;
					var metaLeft = scope.querySelector('.ppw-azure-left');
					var templates = scope.querySelectorAll('.ppw-meta-template');
					var idx = this.realIndex;
					var t = templates[idx];
					if (!t || !metaLeft) return;
					var titleEl = metaLeft.querySelector('.ppw-azure-title');
					var descEl = metaLeft.querySelector('.ppw-azure-desc');
					var tagsWrap = metaLeft.querySelector('.ppw-tags-wrap');
					if (titleEl && t.querySelector('.ppw-title')) {
						titleEl.textContent = t.querySelector('.ppw-title').textContent;
					}
					if (descEl && t.querySelector('.ppw-desc')) {
						descEl.textContent = t.querySelector('.ppw-desc').textContent;
					}
					if (tagsWrap && t.querySelector('.ppw-tags')) {
						var badge = tagsWrap.querySelector('.ppw-tag-badge');
						if (badge) {
							badge.textContent = t.querySelector('.ppw-tags').textContent;
						}
					}
					var metaRight = scope.querySelector('.ppw-azure-right');
					if (metaRight) {
						var keys = ['category', 'date', 'client', 'author'];
						keys.forEach(function (key) {
							var valEl = t.querySelector('.ppw-' + key);
							var row = metaRight.querySelector('.ppw-meta-row[data-meta-key="' + key + '"]');
							if (valEl && row) {
								var v = row.querySelector('.ppw-meta-value');
								if (v) v.textContent = valEl.textContent;
							}
						});
					}
				},
			},
		});
	}

	function initCategoryFilter(scope) {
		var filterSelect = scope.querySelector('.ppw-category-filter');
		if (!filterSelect) return;

		var wrapper = scope.querySelector('.ppw-wrapper');
		var items = wrapper.querySelectorAll('.ppw-item[data-category]');

		filterSelect.addEventListener('change', function () {
			var val = this.value;
			items.forEach(function (item) {
				var cat = item.getAttribute('data-category') || '';
				if (val === '' || cat === val) {
					item.style.display = '';
				} else {
					item.style.display = 'none';
				}
			});
		});
	}

	function initOne(scope) {
		var wrapper = scope.querySelector('.ppw-wrapper');
		if (!wrapper) return;

		var skin = wrapper.getAttribute('data-skin');

		if (skin === 'azure') {
			initAzureSwiper(scope);
		}

		initCategoryFilter(scope);
	}

	function init() {
		var widgets = document.querySelectorAll('.elementor-widget-disto_pro_portfolio');
		widgets.forEach(function (widget) {
			initOne(widget);
		});
	}

	if (typeof elementorFrontend !== 'undefined' && elementorFrontend.hooks) {
		elementorFrontend.hooks.addAction('frontend/element_ready/disto_pro_portfolio.default', function ($scope) {
			initOne($scope[0]);
		});
	}

	if (document.readyState === 'loading') {
		document.addEventListener('DOMContentLoaded', init);
	} else {
		init();
	}
})();
