/**
 * مدیریت تغییر هدر بر اساس آیتم منو
 * 
 * وقتی کاربر روی یک آیتم منو که هدر خاصی دارد کلیک می‌کند،
 * header_layout به URL اضافه می‌شود تا هدر مناسب نمایش داده شود.
 */
(function() {
	'use strict';

	// بررسی اینکه آیا مرورگر از localStorage پشتیبانی می‌کند
	if (typeof Storage === 'undefined') {
		return;
	}

	// وقتی DOM آماده شد
	if (document.readyState === 'loading') {
		document.addEventListener('DOMContentLoaded', initMenuHeaderHandler);
	} else {
		initMenuHeaderHandler();
	}

	function initMenuHeaderHandler() {
		// پیدا کردن تمام لینک‌های منو که data-header-layout دارند
		var menuLinks = document.querySelectorAll('a[data-header-layout]');
		
		if (menuLinks.length === 0) {
			return;
		}

		// اضافه کردن event listener به هر لینک
		menuLinks.forEach(function(link) {
			link.addEventListener('click', function(e) {
				var headerLayout = this.getAttribute('data-header-layout');
				
				if (!headerLayout || headerLayout === '') {
					return;
				}

				// ذخیره در localStorage برای استفاده بعدی
				try {
					localStorage.setItem('disto_menu_header_layout', headerLayout);
					localStorage.setItem('disto_menu_header_url', this.href);
				} catch (err) {
					console.warn('خطا در ذخیره در localStorage:', err);
				}

				// اضافه کردن header_layout به URL
				var url = new URL(this.href);
				url.searchParams.set('header_layout', headerLayout);
				
				// اگر لینک خارجی است یا target جدید دارد، اجازه رفتن طبیعی را بده
				if (this.target === '_blank' || this.target === '_parent' || this.target === '_top') {
					this.href = url.toString();
					return;
				}

				// جلوگیری از رفتن پیش‌فرض و رفتن با URL جدید
				e.preventDefault();
				window.location.href = url.toString();
			});
		});

		// بررسی localStorage برای بازگشت به صفحه
		// اگر کاربر از طریق منو آمده باشد و header_layout در URL نباشد، اضافه کن
		try {
			var savedLayout = localStorage.getItem('disto_menu_header_layout');
			var savedUrl = localStorage.getItem('disto_menu_header_url');
			var currentUrl = window.location.href;
			
			// حذف query parameters برای مقایسه
			var currentUrlClean = currentUrl.split('?')[0];
			var savedUrlClean = savedUrl ? savedUrl.split('?')[0] : '';
			
			// اگر URL فعلی با URL ذخیره شده مطابقت دارد و header_layout در URL نیست
			if (savedLayout && savedUrlClean && currentUrlClean === savedUrlClean) {
				var url = new URL(window.location.href);
				if (!url.searchParams.has('header_layout')) {
					url.searchParams.set('header_layout', savedLayout);
					// فقط اگر واقعاً نیاز به تغییر است، redirect کن
					if (url.toString() !== window.location.href) {
						window.history.replaceState({}, '', url.toString());
					}
				}
			}
		} catch (err) {
			console.warn('خطا در بررسی localStorage:', err);
		}
	}
})();

