/**
 * ویجت سوالات متداول: آکاردئون + تعویض تصویر با افکت Fade
 */

(function () {
	'use strict';

	function runFaqWidget(container) {
		if (!container || !container.querySelector('.disto-faq-list')) return;

		var list = container.querySelector('.disto-faq-list');
		var items = list.querySelectorAll('.disto-faq-item');
		var imageInner = container.querySelector('.disto-faq-image-inner');
		var images = imageInner ? imageInner.querySelectorAll('.disto-faq-img') : [];

		function setAnswerHeight(item, open) {
			var wrap = item.querySelector('.disto-faq-answer-wrap');
			var content = item.querySelector('.disto-faq-answer');
			if (!wrap || !content) return;
			if (open) {
				wrap.style.maxHeight = content.scrollHeight + 80 + 'px';
			} else {
				wrap.style.maxHeight = '0';
			}
		}

		function switchImage(index) {
			index = parseInt(index, 10);
			images.forEach(function (img) {
				var imgIndex = parseInt(img.getAttribute('data-index'), 10);
				if (imgIndex === index) {
					img.classList.add('disto-faq-img-active');
				} else {
					img.classList.remove('disto-faq-img-active');
				}
			});
		}

		items.forEach(function (item, index) {
			var wrap = item.querySelector('.disto-faq-answer-wrap');
			if (wrap && !item.classList.contains('disto-faq-open')) {
				wrap.style.maxHeight = '0';
			} else if (wrap && item.classList.contains('disto-faq-open')) {
				setAnswerHeight(item, true);
			}

			var header = item.querySelector('.disto-faq-question-wrap');
			if (!header) return;

			header.addEventListener('click', function () {
				var wasOpen = item.classList.contains('disto-faq-open');

				items.forEach(function (other) {
					other.classList.remove('disto-faq-open');
					setAnswerHeight(other, false);
				});

				if (!wasOpen) {
					item.classList.add('disto-faq-open');
					setAnswerHeight(item, true);
					var imgUrl = item.getAttribute('data-image');
					if (imgUrl) {
						switchImage(index);
					}
				}
			});
		});

		// اندازه اولیه برای آیتم باز
		items.forEach(function (item) {
			if (item.classList.contains('disto-faq-open')) {
				setAnswerHeight(item, true);
			}
		});
	}

	function init() {
		var widgets = document.querySelectorAll('.disto-faq-widget');
		widgets.forEach(runFaqWidget);
	}

	if (document.readyState === 'loading') {
		document.addEventListener('DOMContentLoaded', init);
	} else {
		init();
	}

	// Elementor: وقتی المان در فرانت لود شد
	if (window.elementorFrontend) {
		window.elementorFrontend.hooks.addAction('frontend/element_ready/disto_faq.default', function ($scope) {
			var el = $scope[0];
			if (el && el.querySelector('.disto-faq-widget')) {
				runFaqWidget(el.querySelector('.disto-faq-widget'));
			} else if (el && el.classList.contains('disto-faq-widget')) {
				runFaqWidget(el);
			}
		});
	}
})();
