// ساده‌ترین نسخه داشبورد تنظیمات دیستو (بدون React/Redux فعلاً)
// فقط برای این‌که به‌جای متن «در حال بارگذاری...» یک UI واقعی ببینید.

(function () {
  var root = document.getElementById('disto-theme-settings-root');
  if (!root) return;

  root.innerHTML = ''
    + '<div class="disto-admin-shell">'
    + '  <aside class="disto-admin-sidebar">'
    + '    <div class="disto-admin-sidebar-header">'
    + '      <span class="disto-admin-logo">Disto</span>'
    + '      <span class="disto-admin-badge">Theme</span>'
    + '    </div>'
    + '    <nav class="disto-admin-sidebar-nav">'
    + '      <button type="button" class="disto-admin-nav-item is-active" data-section="header">مدیریت هدر</button>'
    + '      <button type="button" class="disto-admin-nav-item" data-section="footer">مدیریت فوتر</button>'
    + '      <button type="button" class="disto-admin-nav-item" data-section="social">شبکه‌های اجتماعی</button>'
    + '      <button type="button" class="disto-admin-nav-item" data-section="sections">بخش‌ها</button>'
    + '      <button type="button" class="disto-admin-nav-item" data-section="blog">وبلاگ</button>'
    + '      <button type="button" class="disto-admin-nav-item" data-section="performance">عملکرد</button>'
    + '      <button type="button" class="disto-admin-nav-item" data-section="presets">پریست‌ها</button>'
    + '    </nav>'
    + '  </aside>'
    + '  <div class="disto-admin-main">'
    + '    <header class="disto-admin-topbar">'
    + '      <div class="disto-admin-topbar-left">'
    + '        <span class="disto-admin-title">داشبورد تنظیمات قالب دیستو</span>'
    + '      </div>'
    + '      <div class="disto-admin-topbar-right">'
    + '        <input type="search" class="disto-admin-search" placeholder="جستجو در تنظیمات..." />'
    + '        <button type="button" class="disto-admin-button disto-admin-button-primary">ذخیره و انتشار</button>'
    + '      </div>'
    + '    </header>'
    + '    <main class="disto-admin-content">'
    + '      <section class="disto-admin-panel is-active" data-section="header">'
    + '        <h2>مدیریت هدر</h2>'
    + '        <p class="disto-admin-panel-intro">طرح هدر، نوار بالا، منوها، دکمه CTA و مگامنو را از اینجا کنترل کنید.</p>'
    + '        <div class="disto-admin-header-cards">'
    + '          <div class="disto-admin-card">'
    + '            <h3 class="disto-admin-card-title">طرح هدر</h3>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-label" for="disto-header-layout">استایل هدر</label>'
    + '              <select id="disto-header-layout" class="disto-admin-select disto-admin-select--wide"></select>'
    + '            </div>'
    + '          </div>'
    + '          <div class="disto-admin-card">'
    + '            <h3 class="disto-admin-card-title">نوار بالا (Top Bar)</h3>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-checkbox-label">'
    + '                <input type="checkbox" id="disto-top-bar-enabled" /> نمایش نوار بالا'
    + '              </label>'
    + '              <label class="disto-admin-label" for="disto-top-bar-left">متن سمت راست نوار</label>'
    + '              <input type="text" id="disto-top-bar-left" class="disto-admin-input" placeholder="متن اختیاری" />'
    + '              <label class="disto-admin-label" for="disto-top-bar-right">متن سمت چپ نوار</label>'
    + '              <input type="text" id="disto-top-bar-right" class="disto-admin-input" placeholder="متن اختیاری" />'
    + '              <label class="disto-admin-label" for="disto-date-title">عنوان تاریخ</label>'
    + '              <input type="text" id="disto-date-title" class="disto-admin-input" placeholder="Current Date:" />'
    + '              <label class="disto-admin-checkbox-label">'
    + '                <input type="checkbox" id="disto-disable-date" /> مخفی کردن تاریخ در نوار بالا'
    + '              </label>'
    + '            </div>'
    + '          </div>'
    + '          <div class="disto-admin-card">'
    + '            <h3 class="disto-admin-card-title">منوها</h3>'
    + '            <div id="disto-header-menu-list" class="disto-admin-menu-list"></div>'
    + '            <p class="disto-admin-help">انتساب منو به هر موقعیت از <a href="#" id="disto-nav-menus-link">نمایش → منوها</a> انجام می‌شود.</p>'
    + '          </div>'
    + '          <div class="disto-admin-card">'
    + '            <h3 class="disto-admin-card-title">دکمه CTA (Call to Action)</h3>'
    + '            <label class="disto-admin-checkbox-label">'
    + '              <input type="checkbox" id="disto-cta-enabled" /> نمایش دکمه CTA در هدر'
    + '            </label>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-label" for="disto-cta-label">متن دکمه</label>'
    + '              <input type="text" id="disto-cta-label" class="disto-admin-input" placeholder="همین حالا شروع کنید" />'
    + '              <label class="disto-admin-label" for="disto-cta-url">لینک</label>'
    + '              <input type="url" id="disto-cta-url" class="disto-admin-input" placeholder="https://" />'
    + '              <label class="disto-admin-label" for="disto-cta-style">استایل</label>'
    + '              <select id="disto-cta-style" class="disto-admin-select">'
    + '                <option value="primary">اصلی (primary)</option>'
    + '                <option value="secondary">ثانویه (secondary)</option>'
    + '                <option value="outline">حاشیه‌دار (outline)</option>'
    + '              </select>'
    + '            </div>'
    + '          </div>'
    + '          <div class="disto-admin-card">'
    + '            <h3 class="disto-admin-card-title">مگامنو و سایر</h3>'
    + '            <label class="disto-admin-checkbox-label">'
    + '              <input type="checkbox" id="disto-mega-menu-enabled" /> فعال‌سازی مگامنو'
    + '            </label>'
    + '            <label class="disto-admin-checkbox-label">'
    + '              <input type="checkbox" id="disto-sticky-menu" /> منوی چسبنده (Sticky)'
    + '            </label>'
    + '            <label class="disto-admin-checkbox-label">'
    + '              <input type="checkbox" id="disto-disable-search" /> مخفی کردن جستجو در هدر'
    + '            </label>'
    + '            <label class="disto-admin-checkbox-label">'
    + '              <input type="checkbox" id="disto-disable-social" /> مخفی کردن آیکن‌های شبکه اجتماعی در هدر'
    + '            </label>'
    + '          </div>'
    + '        </div>'
    + '        <div class="disto-admin-footer-actions">'
    + '          <button type="button" class="disto-admin-button disto-admin-button-primary" id="disto-header-save">ذخیره تنظیمات هدر</button>'
    + '          <span class="disto-admin-status" id="disto-header-status"></span>'
    + '        </div>'
    + '      </section>'
    + '      <section class="disto-admin-panel" data-section="footer">'
    + '        <h2>مدیریت فوتر</h2>'
    + '        <p class="disto-admin-panel-intro">چیدمان ستون‌های فوتر، ناحیه‌های ویجت و متن کپی‌رایت را اینجا تنظیم کنید. خود ویجت‌ها از منوی «نمایش → ابزارک‌ها» مدیریت می‌شوند.</p>'
    + '        <div class="disto-admin-field-group">'
    + '          <label class="disto-admin-label">تعداد ستون‌های فوتر</label>'
    + '          <div class="disto-admin-radio-row">'
    + '            <label><input type="radio" name="disto-footer-columns" value="footer4col"> ۴ ستون (پیشنهادی)</label>'
    + '            <label><input type="radio" name="disto-footer-columns" value="footer3col"> ۳ ستون</label>'
    + '            <label><input type="radio" name="disto-footer-columns" value="footer2col"> ۲ ستون</label>'
    + '            <label><input type="radio" name="disto-footer-columns" value="footer1col"> ۱ ستون</label>'
    + '            <label><input type="radio" name="disto-footer-columns" value="footer0col"> بدون فوتر</label>'
    + '          </div>'
    + '          <p class="disto-admin-help">هر ستون به یکی از ناحیه‌های ابزارک فوتر ۱ تا ۴ متصل است. محتوای هر ستون را از بخش ابزارک‌ها می‌توانید تغییر دهید.</p>'
    + '        </div>'
    + '        <div class="disto-admin-field-group">'
    + '          <label class="disto-admin-label">ناحیه ویجت هر ستون</label>'
    + '          <div class="disto-admin-widget-grid">'
    + '            <div class="disto-admin-widget-col">'
    + '              <span class="disto-admin-widget-col-title">ستون ۱</span>'
    + '              <select id="disto-footer-sidebar-1" class="disto-admin-select"></select>'
    + '            </div>'
    + '            <div class="disto-admin-widget-col">'
    + '              <span class="disto-admin-widget-col-title">ستون ۲</span>'
    + '              <select id="disto-footer-sidebar-2" class="disto-admin-select"></select>'
    + '            </div>'
    + '            <div class="disto-admin-widget-col">'
    + '              <span class="disto-admin-widget-col-title">ستون ۳</span>'
    + '              <select id="disto-footer-sidebar-3" class="disto-admin-select"></select>'
    + '            </div>'
    + '            <div class="disto-admin-widget-col">'
    + '              <span class="disto-admin-widget-col-title">ستون ۴</span>'
    + '              <select id="disto-footer-sidebar-4" class="disto-admin-select"></select>'
    + '            </div>'
    + '          </div>'
    + '          <p class="disto-admin-help">از این بخش تعیین می‌کنید هر ستون فوتر از کدام ناحیه ابزارک (Sidebar) پر شود.</p>'
    + '        </div>'
    + '        <div class="disto-admin-field-group">'
    + '          <label class="disto-admin-label" for="disto-footer-copyright">متن کپی‌رایت</label>'
    + '          <textarea id="disto-footer-copyright" class="disto-admin-textarea" rows="3" placeholder="مثال: © ۱۴۰۳ گروه صالح — تمامی حقوق محفوظ است."></textarea>'
    + '          <p class="disto-admin-help">می‌توانید از HTML ساده مثل &lt;a&gt; برای لینک استفاده کنید.</p>'
    + '        </div>'
    + '        <div class="disto-admin-footer-actions">'
    + '          <button type="button" class="disto-admin-button disto-admin-button-primary" id="disto-footer-save">ذخیره تنظیمات فوتر</button>'
    + '          <span class="disto-admin-status" id="disto-footer-status"></span>'
    + '        </div>'
    + '      </section>'
    + '      <section class="disto-admin-panel" data-section="social">'
    + '        <h2>مدیریت شبکه‌های اجتماعی</h2>'
    + '        <p class="disto-admin-panel-intro">افزودن / ویرایش / حذف پلتفرم‌ها، آیکن و محل نمایش.</p>'
    + '        <div class="disto-admin-social-settings">'
    + '          <div class="disto-admin-card">'
    + '            <h3 class="disto-admin-card-title">عنوان شبکه‌های اجتماعی</h3>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-label" for="disto-social-title">عنوان</label>'
    + '              <input type="text" id="disto-social-title" class="disto-admin-input" placeholder="Follow us" />'
    + '              <p class="disto-admin-help">این عنوان در بالای آیکن‌های شبکه‌های اجتماعی نمایش داده می‌شود.</p>'
    + '            </div>'
    + '          </div>'
    + '          <div class="disto-admin-card">'
    + '            <h3 class="disto-admin-card-title">محل نمایش</h3>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-checkbox-label">'
    + '                <input type="checkbox" id="disto-social-display-header" /> نمایش در هدر'
    + '              </label>'
    + '              <p class="disto-admin-help">نمایش آیکن‌های شبکه‌های اجتماعی در هدر سایت.</p>'
    + '            </div>'
    + '          </div>'
    + '          <div class="disto-admin-card">'
    + '            <h3 class="disto-admin-card-title">پلتفرم‌های شبکه‌های اجتماعی</h3>'
    + '            <p class="disto-admin-help">برای هر پلتفرم، URL صفحه خود را وارد کنید. اگر URL خالی باشد، آن پلتفرم نمایش داده نمی‌شود.</p>'
    + '            <div id="disto-social-platforms-list" class="disto-admin-social-platforms-list"></div>'
    + '          </div>'
    + '        </div>'
    + '        <div class="disto-admin-footer-actions">'
    + '          <button type="button" class="disto-admin-button disto-admin-button-primary" id="disto-social-save">ذخیره تنظیمات شبکه‌های اجتماعی</button>'
    + '          <span class="disto-admin-status" id="disto-social-status"></span>'
    + '        </div>'
    + '      </section>'
    + '      <section class="disto-admin-panel" data-section="sections">'
    + '        <h2>مدیریت بخش‌ها</h2>'
    + '        <p class="disto-admin-panel-intro">فعال / غیرفعال کردن بخش‌ها و ترتیب نمایش.</p>'
    + '        <div class="disto-admin-sections-settings">'
    + '          <div class="disto-admin-card">'
    + '            <h3 class="disto-admin-card-title">بخش‌های سایت</h3>'
    + '            <p class="disto-admin-help">برای تغییر ترتیب، از دکمه‌های بالا/پایین استفاده کنید. برای فعال/غیرفعال کردن، checkbox را تغییر دهید.</p>'
    + '            <div id="disto-sections-list" class="disto-admin-sections-list"></div>'
    + '          </div>'
    + '        </div>'
    + '        <div class="disto-admin-footer-actions">'
    + '          <button type="button" class="disto-admin-button disto-admin-button-primary" id="disto-sections-save">ذخیره تنظیمات بخش‌ها</button>'
    + '          <span class="disto-admin-status" id="disto-sections-status"></span>'
    + '        </div>'
    + '      </section>'
    + '      <section class="disto-admin-panel" data-section="blog">'
    + '        <h2>تنظیمات وبلاگ</h2>'
    + '        <p class="disto-admin-panel-intro">طرح‌بندی، متادیتا، باکس نویسنده و مطالب مرتبط.</p>'
    + '        <div class="disto-admin-header-cards">'
    + '          <div class="disto-admin-card">'
    + '            <h3 class="disto-admin-card-title">طرح‌بندی وبلاگ</h3>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-label" for="disto-blog-layout">استایل نمایش پست‌ها</label>'
    + '              <select id="disto-blog-layout" class="disto-admin-select disto-admin-select--wide">'
    + '                <option value="grid-2">گرید ۲ ستونه</option>'
    + '                <option value="grid-3">گرید ۳ ستونه</option>'
    + '                <option value="grid-4">گرید ۴ ستونه</option>'
    + '                <option value="list">لیست</option>'
    + '                <option value="masonry">ماسونری</option>'
    + '              </select>'
    + '              <p class="disto-admin-help">نحوه نمایش پست‌ها در صفحه بایگانی وبلاگ.</p>'
    + '            </div>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-label" for="disto-blog-posts-per-page">تعداد پست در هر صفحه</label>'
    + '              <input type="number" id="disto-blog-posts-per-page" class="disto-admin-input" min="1" max="50" value="10" />'
    + '              <p class="disto-admin-help">تعداد پست‌هایی که در هر صفحه بایگانی نمایش داده می‌شود.</p>'
    + '            </div>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-label" for="disto-blog-excerpt-length">طول خلاصه پست (کاراکتر)</label>'
    + '              <input type="number" id="disto-blog-excerpt-length" class="disto-admin-input" min="0" max="500" value="150" />'
    + '              <p class="disto-admin-help">تعداد کاراکترهای خلاصه پست در صفحه بایگانی. ۰ به معنای عدم نمایش خلاصه است.</p>'
    + '            </div>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-checkbox-label">'
    + '                <input type="checkbox" id="disto-blog-show-featured-image" /> نمایش تصویر شاخص در صفحه بایگانی'
    + '              </label>'
    + '            </div>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-checkbox-label">'
    + '                <input type="checkbox" id="disto-blog-show-read-more" /> نمایش دکمه «ادامه مطلب»'
    + '              </label>'
    + '            </div>'
    + '          </div>'
    + '          <div class="disto-admin-card">'
    + '            <h3 class="disto-admin-card-title">متادیتا پست</h3>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-checkbox-label">'
    + '                <input type="checkbox" id="disto-blog-show-date" /> نمایش تاریخ انتشار'
    + '              </label>'
    + '            </div>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-checkbox-label">'
    + '                <input type="checkbox" id="disto-blog-show-author" /> نمایش نام نویسنده'
    + '              </label>'
    + '            </div>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-checkbox-label">'
    + '                <input type="checkbox" id="disto-blog-show-categories" /> نمایش دسته‌بندی‌ها'
    + '              </label>'
    + '            </div>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-checkbox-label">'
    + '                <input type="checkbox" id="disto-blog-show-tags" /> نمایش تگ‌ها'
    + '              </label>'
    + '            </div>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-checkbox-label">'
    + '                <input type="checkbox" id="disto-blog-show-comments-count" /> نمایش تعداد نظرات'
    + '              </label>'
    + '            </div>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-checkbox-label">'
    + '                <input type="checkbox" id="disto-blog-show-reading-time" /> نمایش زمان مطالعه'
    + '              </label>'
    + '            </div>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-label" for="disto-blog-date-format">فرمت تاریخ</label>'
    + '              <select id="disto-blog-date-format" class="disto-admin-select disto-admin-select--wide">'
    + '                <option value="default">پیش‌فرض وردپرس</option>'
    + '                <option value="j F Y">۱۵ دی ۱۴۰۳</option>'
    + '                <option value="Y/m/d">۱۴۰۳/۱۰/۱۵</option>'
    + '                <option value="d M Y">۱۵ دی ۱۴۰۳</option>'
    + '                <option value="relative">نسبی (۲ روز پیش)</option>'
    + '              </select>'
    + '            </div>'
    + '          </div>'
    + '          <div class="disto-admin-card">'
    + '            <h3 class="disto-admin-card-title">باکس نویسنده</h3>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-checkbox-label">'
    + '                <input type="checkbox" id="disto-blog-author-box-enabled" /> نمایش باکس نویسنده در انتهای پست'
    + '              </label>'
    + '              <p class="disto-admin-help">نمایش اطلاعات نویسنده در انتهای هر پست.</p>'
    + '            </div>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-label" for="disto-blog-author-box-title">عنوان باکس نویسنده</label>'
    + '              <input type="text" id="disto-blog-author-box-title" class="disto-admin-input" placeholder="درباره نویسنده" />'
    + '            </div>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-checkbox-label">'
    + '                <input type="checkbox" id="disto-blog-author-box-show-avatar" /> نمایش آواتار نویسنده'
    + '              </label>'
    + '            </div>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-checkbox-label">'
    + '                <input type="checkbox" id="disto-blog-author-box-show-bio" /> نمایش بیوگرافی نویسنده'
    + '              </label>'
    + '            </div>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-checkbox-label">'
    + '                <input type="checkbox" id="disto-blog-author-box-show-social" /> نمایش لینک‌های شبکه‌های اجتماعی'
    + '              </label>'
    + '            </div>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-label" for="disto-blog-author-box-layout">طرح‌بندی باکس</label>'
    + '              <select id="disto-blog-author-box-layout" class="disto-admin-select disto-admin-select--wide">'
    + '                <option value="horizontal">افقی (آواتار در کنار متن)</option>'
    + '                <option value="vertical">عمودی (آواتار در بالا)</option>'
    + '              </select>'
    + '            </div>'
    + '          </div>'
    + '          <div class="disto-admin-card">'
    + '            <h3 class="disto-admin-card-title">مطالب مرتبط</h3>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-checkbox-label">'
    + '                <input type="checkbox" id="disto-blog-related-posts-enabled" /> نمایش مطالب مرتبط'
    + '              </label>'
    + '              <p class="disto-admin-help">نمایش پست‌های مرتبط در انتهای هر پست.</p>'
    + '            </div>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-label" for="disto-blog-related-posts-title">عنوان بخش مطالب مرتبط</label>'
    + '              <input type="text" id="disto-blog-related-posts-title" class="disto-admin-input" placeholder="مطالب مرتبط" />'
    + '            </div>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-label" for="disto-blog-related-posts-count">تعداد مطالب مرتبط</label>'
    + '              <input type="number" id="disto-blog-related-posts-count" class="disto-admin-input" min="1" max="12" value="3" />'
    + '              <p class="disto-admin-help">تعداد پست‌های مرتبطی که نمایش داده می‌شود.</p>'
    + '            </div>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-label" for="disto-blog-related-posts-layout">طرح‌بندی مطالب مرتبط</label>'
    + '              <select id="disto-blog-related-posts-layout" class="disto-admin-select disto-admin-select--wide">'
    + '                <option value="grid-2">گرید ۲ ستونه</option>'
    + '                <option value="grid-3">گرید ۳ ستونه</option>'
    + '                <option value="grid-4">گرید ۴ ستونه</option>'
    + '                <option value="list">لیست</option>'
    + '              </select>'
    + '            </div>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-label">مبنای مرتبط بودن</label>'
    + '              <div class="disto-admin-radio-row">'
    + '                <label><input type="radio" name="disto-blog-related-posts-source" value="categories"> دسته‌بندی‌ها</label>'
    + '                <label><input type="radio" name="disto-blog-related-posts-source" value="tags"> تگ‌ها</label>'
    + '                <label><input type="radio" name="disto-blog-related-posts-source" value="both"> هر دو</label>'
    + '              </div>'
    + '              <p class="disto-admin-help">پست‌های مرتبط بر اساس چه معیاری انتخاب شوند.</p>'
    + '            </div>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-checkbox-label">'
    + '                <input type="checkbox" id="disto-blog-related-posts-show-excerpt" /> نمایش خلاصه در مطالب مرتبط'
    + '              </label>'
    + '            </div>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-checkbox-label">'
    + '                <input type="checkbox" id="disto-blog-related-posts-show-date" /> نمایش تاریخ در مطالب مرتبط'
    + '              </label>'
    + '            </div>'
    + '          </div>'
    + '        </div>'
    + '        <div class="disto-admin-footer-actions">'
    + '          <button type="button" class="disto-admin-button disto-admin-button-primary" id="disto-blog-save">ذخیره تنظیمات وبلاگ</button>'
    + '          <span class="disto-admin-status" id="disto-blog-status"></span>'
    + '        </div>'
    + '      </section>'
    + '      <section class="disto-admin-panel" data-section="performance">'
    + '        <h2>عملکرد</h2>'
    + '        <p class="disto-admin-panel-intro">انیمیشن‌ها، حالت سبک، کاهش موشن و سایه‌ها.</p>'
    + '        <div class="disto-admin-header-cards">'
    + '          <div class="disto-admin-card">'
    + '            <h3 class="disto-admin-card-title">انیمیشن‌ها</h3>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-checkbox-label">'
    + '                <input type="checkbox" id="disto-performance-animations-enabled" /> فعال‌سازی انیمیشن‌ها'
    + '              </label>'
    + '              <p class="disto-admin-help">فعال یا غیرفعال کردن انیمیشن‌ها در سایت.</p>'
    + '            </div>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-label" for="disto-performance-animation-speed">سرعت انیمیشن</label>'
    + '              <select id="disto-performance-animation-speed" class="disto-admin-select disto-admin-select--wide">'
    + '                <option value="slow">آهسته</option>'
    + '                <option value="normal">عادی</option>'
    + '                <option value="fast">سریع</option>'
    + '              </select>'
    + '              <p class="disto-admin-help">سرعت اجرای انیمیشن‌ها در سایت.</p>'
    + '            </div>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-checkbox-label">'
    + '                <input type="checkbox" id="disto-performance-page-transitions" /> انیمیشن انتقال صفحه'
    + '              </label>'
    + '              <p class="disto-admin-help">افزودن انیمیشن هنگام تغییر صفحات.</p>'
    + '            </div>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-checkbox-label">'
    + '                <input type="checkbox" id="disto-performance-hover-effects" /> افکت‌های هاور'
    + '              </label>'
    + '              <p class="disto-admin-help">انیمیشن‌های تعاملی هنگام قرار گرفتن ماوس روی المان‌ها.</p>'
    + '            </div>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-checkbox-label">'
    + '                <input type="checkbox" id="disto-performance-scroll-animations" /> انیمیشن‌های اسکرول'
    + '              </label>'
    + '              <p class="disto-admin-help">انیمیشن‌های المان‌ها هنگام اسکرول صفحه.</p>'
    + '            </div>'
    + '          </div>'
    + '          <div class="disto-admin-card">'
    + '            <h3 class="disto-admin-card-title">حالت سبک</h3>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-checkbox-label">'
    + '                <input type="checkbox" id="disto-performance-lazy-loading" /> بارگذاری تنبل (Lazy Loading)'
    + '              </label>'
    + '              <p class="disto-admin-help">تصاویر و محتوا فقط هنگام نیاز بارگذاری می‌شوند.</p>'
    + '            </div>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-checkbox-label">'
    + '                <input type="checkbox" id="disto-performance-minify-css" /> فشرده‌سازی CSS'
    + '              </label>'
    + '              <p class="disto-admin-help">کاهش حجم فایل‌های CSS برای بارگذاری سریع‌تر.</p>'
    + '            </div>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-checkbox-label">'
    + '                <input type="checkbox" id="disto-performance-minify-js" /> فشرده‌سازی JavaScript'
    + '              </label>'
    + '              <p class="disto-admin-help">کاهش حجم فایل‌های JavaScript برای بارگذاری سریع‌تر.</p>'
    + '            </div>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-checkbox-label">'
    + '                <input type="checkbox" id="disto-performance-defer-js" /> بارگذاری تأخیری JS'
    + '              </label>'
    + '              <p class="disto-admin-help">اجرای JavaScript بعد از بارگذاری کامل صفحه.</p>'
    + '            </div>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-checkbox-label">'
    + '                <input type="checkbox" id="disto-performance-preload-critical" /> پیش‌بارگذاری محتوای مهم'
    + '              </label>'
    + '              <p class="disto-admin-help">بارگذاری اولیه محتوای مهم صفحه.</p>'
    + '            </div>'
    + '          </div>'
    + '          <div class="disto-admin-card">'
    + '            <h3 class="disto-admin-card-title">کاهش موشن</h3>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-checkbox-label">'
    + '                <input type="checkbox" id="disto-performance-reduce-motion" /> احترام به تنظیمات کاهش موشن'
    + '              </label>'
    + '              <p class="disto-admin-help">غیرفعال کردن انیمیشن‌ها برای کاربرانی که ترجیح می‌دهند موشن کاهش یابد.</p>'
    + '            </div>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-label" for="disto-performance-motion-preference">ترجیح موشن</label>'
    + '              <select id="disto-performance-motion-preference" class="disto-admin-select disto-admin-select--wide">'
    + '                <option value="auto">خودکار (بر اساس تنظیمات سیستم)</option>'
    + '                <option value="reduce">کاهش موشن</option>'
    + '                <option value="no-preference">بدون ترجیح</option>'
    + '              </select>'
    + '              <p class="disto-admin-help">نحوه مدیریت انیمیشن‌ها برای کاربران.</p>'
    + '            </div>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-checkbox-label">'
    + '                <input type="checkbox" id="disto-performance-disable-parallax" /> غیرفعال کردن پارالاکس'
    + '              </label>'
    + '              <p class="disto-admin-help">غیرفعال کردن افکت پارالاکس برای بهبود عملکرد.</p>'
    + '            </div>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-checkbox-label">'
    + '                <input type="checkbox" id="disto-performance-simplify-animations" /> ساده‌سازی انیمیشن‌ها'
    + '              </label>'
    + '              <p class="disto-admin-help">استفاده از انیمیشن‌های ساده‌تر برای بهبود عملکرد.</p>'
    + '            </div>'
    + '          </div>'
    + '          <div class="disto-admin-card">'
    + '            <h3 class="disto-admin-card-title">سایه‌ها</h3>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-checkbox-label">'
    + '                <input type="checkbox" id="disto-performance-shadows-enabled" /> نمایش سایه‌ها'
    + '              </label>'
    + '              <p class="disto-admin-help">فعال یا غیرفعال کردن سایه‌ها در المان‌های سایت.</p>'
    + '            </div>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-label" for="disto-performance-shadow-intensity">شدت سایه</label>'
    + '              <select id="disto-performance-shadow-intensity" class="disto-admin-select disto-admin-select--wide">'
    + '                <option value="none">بدون سایه</option>'
    + '                <option value="subtle">ملایم</option>'
    + '                <option value="normal">عادی</option>'
    + '                <option value="strong">قوی</option>'
    + '              </select>'
    + '              <p class="disto-admin-help">شدت سایه‌های اعمال شده در المان‌ها.</p>'
    + '            </div>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-checkbox-label">'
    + '                <input type="checkbox" id="disto-performance-card-shadows" /> سایه برای کارت‌ها'
    + '              </label>'
    + '              <p class="disto-admin-help">نمایش سایه برای کارت‌ها و باکس‌ها.</p>'
    + '            </div>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-checkbox-label">'
    + '                <input type="checkbox" id="disto-performance-button-shadows" /> سایه برای دکمه‌ها'
    + '              </label>'
    + '              <p class="disto-admin-help">نمایش سایه برای دکمه‌ها.</p>'
    + '            </div>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-checkbox-label">'
    + '                <input type="checkbox" id="disto-performance-image-shadows" /> سایه برای تصاویر'
    + '              </label>'
    + '              <p class="disto-admin-help">نمایش سایه برای تصاویر.</p>'
    + '            </div>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-checkbox-label">'
    + '                <input type="checkbox" id="disto-performance-hover-shadow" /> سایه هنگام هاور'
    + '              </label>'
    + '              <p class="disto-admin-help">افزایش سایه هنگام قرار گرفتن ماوس روی المان‌ها.</p>'
    + '            </div>'
    + '          </div>'
    + '        </div>'
    + '        <div class="disto-admin-footer-actions">'
    + '          <button type="button" class="disto-admin-button disto-admin-button-primary" id="disto-performance-save">ذخیره تنظیمات عملکرد</button>'
    + '          <span class="disto-admin-status" id="disto-performance-status"></span>'
    + '        </div>'
    + '      </section>'
    + '      <section class="disto-admin-panel" data-section="presets">'
    + '        <h2>سیستم پریست قالب</h2>'
    + '        <p class="disto-admin-panel-intro">ذخیره تنظیمات فعلی قالب، گرفتن خروجی JSON، ورود JSON و بازنشانی به حالت پیش‌فرض.</p>'
    + '        <div class="disto-admin-header-cards">'
    + '          <div class="disto-admin-card">'
    + '            <h3 class="disto-admin-card-title">مدیریت پریست‌ها</h3>'
    + '            <div class="disto-admin-field-group">'
    + '              <button type="button" class="disto-admin-button disto-admin-button-primary" id="disto-presets-save-current">ذخیره تنظیمات فعلی به عنوان پریست</button>'
    + '              <p class="disto-admin-help">تمام تنظیمات اصلی قالب (هدر، فوتر، وبلاگ، عملکرد و ...) به صورت یک پریست ذخیره می‌شود.</p>'
    + '            </div>'
    + '            <div class="disto-admin-field-group">'
    + '              <button type="button" class="disto-admin-button" id="disto-presets-reset">بازنشانی تنظیمات قالب به حالت پیش‌فرض</button>'
    + '              <p class="disto-admin-help">تمام تنظیمات تحت پوشش پریست به مقادیر پیش‌فرض بازگردانده می‌شوند. این عملیات قابل بازگشت نیست.</p>'
    + '            </div>'
    + '          </div>'
    + '          <div class="disto-admin-card">'
    + '            <h3 class="disto-admin-card-title">خروجی / ورود JSON</h3>'
    + '            <div class="disto-admin-field-group">'
    + '              <label class="disto-admin-label" for="disto-presets-json">JSON تنظیمات قالب</label>'
    + '              <textarea id="disto-presets-json" class="disto-admin-textarea" rows="8" placeholder="{ ... }"></textarea>'
    + '              <p class="disto-admin-help">برای گرفتن خروجی، روی دکمه «تولید JSON از تنظیمات فعلی» کلیک کنید و متن را ذخیره نمایید. برای ورود، JSON قبلی را در اینجا قرار دهید و روی «اعمال JSON روی تنظیمات قالب» کلیک کنید.</p>'
    + '            </div>'
    + '            <div class="disto-admin-field-group">'
    + '              <button type="button" class="disto-admin-button" id="disto-presets-export">تولید JSON از تنظیمات فعلی</button>'
    + '              <button type="button" class="disto-admin-button disto-admin-button-primary" id="disto-presets-import">اعمال JSON روی تنظیمات قالب</button>'
    + '            </div>'
    + '          </div>'
    + '        </div>'
    + '        <div class="disto-admin-footer-actions">'
    + '          <span class="disto-admin-status" id="disto-presets-status"></span>'
    + '        </div>'
    + '      </section>'
    + '    </main>'
    + '  </div>'
    + '</div>';

  // سوییچ ساده بین پنل‌ها
  var navButtons = root.querySelectorAll('.disto-admin-nav-item');
  var panels = root.querySelectorAll('.disto-admin-panel');

  function activateSection(section) {
    navButtons.forEach(function (btn) {
      if (btn.getAttribute('data-section') === section) {
        btn.classList.add('is-active');
      } else {
        btn.classList.remove('is-active');
      }
    });
    panels.forEach(function (panel) {
      if (panel.getAttribute('data-section') === section) {
        panel.classList.add('is-active');
      } else {
        panel.classList.remove('is-active');
      }
    });
  }

  navButtons.forEach(function (btn) {
    btn.addEventListener('click', function () {
      var section = btn.getAttribute('data-section');
      if (section) {
        activateSection(section);
      }
    });
  });

  // === مقداردهی اولیه و ذخیرهٔ تنظیمات هدر ===
  var headerSettings = (window.DistoThemeSettings && window.DistoThemeSettings.headerSettings) || {};
  var headerLayoutSelect = root.querySelector('#disto-header-layout');
  if (headerLayoutSelect && headerSettings.headerLayouts) {
    var layouts = headerSettings.headerLayouts;
    for (var layoutKey in layouts) {
      if (layouts.hasOwnProperty(layoutKey)) {
        var opt = document.createElement('option');
        opt.value = layoutKey;
        opt.textContent = layouts[layoutKey];
        headerLayoutSelect.appendChild(opt);
      }
    }
    if (headerSettings.headerLayout) {
      headerLayoutSelect.value = headerSettings.headerLayout;
    }
  }
  if (root.querySelector('#disto-top-bar-enabled')) {
    root.querySelector('#disto-top-bar-enabled').checked = headerSettings.disableTopBar === false;
  }
  if (root.querySelector('#disto-top-bar-left')) root.querySelector('#disto-top-bar-left').value = headerSettings.topBarLeftText || '';
  if (root.querySelector('#disto-top-bar-right')) root.querySelector('#disto-top-bar-right').value = headerSettings.topBarRightText || '';
  if (root.querySelector('#disto-date-title')) root.querySelector('#disto-date-title').value = headerSettings.dateTitle || '';
  if (root.querySelector('#disto-disable-date')) root.querySelector('#disto-disable-date').checked = headerSettings.disableDate === true;
  if (root.querySelector('#disto-cta-enabled')) root.querySelector('#disto-cta-enabled').checked = headerSettings.ctaEnabled === true;
  if (root.querySelector('#disto-cta-label')) root.querySelector('#disto-cta-label').value = headerSettings.ctaLabel || '';
  if (root.querySelector('#disto-cta-url')) root.querySelector('#disto-cta-url').value = headerSettings.ctaUrl || '';
  if (root.querySelector('#disto-cta-style')) root.querySelector('#disto-cta-style').value = headerSettings.ctaStyle || 'primary';
  if (root.querySelector('#disto-mega-menu-enabled')) root.querySelector('#disto-mega-menu-enabled').checked = headerSettings.megaMenuEnabled === true;
  if (root.querySelector('#disto-sticky-menu')) root.querySelector('#disto-sticky-menu').checked = headerSettings.stickyMenu === true;
  if (root.querySelector('#disto-disable-search')) root.querySelector('#disto-disable-search').checked = headerSettings.disableSearch === true;
  if (root.querySelector('#disto-disable-social')) root.querySelector('#disto-disable-social').checked = headerSettings.disableSocial === true;

  var menuListEl = root.querySelector('#disto-header-menu-list');
  if (menuListEl && Array.isArray(headerSettings.menuLocations) && Array.isArray(headerSettings.allMenus)) {
    var allMenus = headerSettings.allMenus;
    
    headerSettings.menuLocations.forEach(function (loc) {
      var row = document.createElement('div');
      row.className = 'disto-admin-menu-row';
      
      var locLabel = document.createElement('span');
      locLabel.className = 'disto-admin-menu-loc';
      locLabel.textContent = loc.label || loc.slug;
      row.appendChild(locLabel);
      
      var selectWrapper = document.createElement('div');
      selectWrapper.className = 'disto-admin-menu-select-wrapper';
      
      var menuSelect = document.createElement('select');
      menuSelect.className = 'disto-admin-select disto-admin-menu-location-select';
      menuSelect.setAttribute('data-location', loc.slug);
      
      // اضافه کردن گزینه‌ها
      allMenus.forEach(function (menu) {
        var opt = document.createElement('option');
        opt.value = menu.id;
        opt.textContent = menu.name;
        if (loc.menuId === menu.id) {
          opt.selected = true;
        }
        menuSelect.appendChild(opt);
      });
      
      selectWrapper.appendChild(menuSelect);
      row.appendChild(selectWrapper);
      
      var editLink = document.createElement('a');
      editLink.href = headerSettings.navMenusUrl || '#';
      editLink.className = 'disto-admin-menu-edit-link';
      editLink.textContent = 'ویرایش منوها';
      editLink.target = '_blank';
      row.appendChild(editLink);
      
      menuListEl.appendChild(row);
    });
  }
  var navMenusLink = root.querySelector('#disto-nav-menus-link');
  if (navMenusLink && headerSettings.navMenusUrl) {
    navMenusLink.href = headerSettings.navMenusUrl;
  }

  // === نمایش و مدیریت هدر برای هر آیتم منو ===
  var menuItemsHeaderContainer = root.querySelector('#disto-menu-items-header-settings');
  if (menuItemsHeaderContainer && Array.isArray(headerSettings.menuItems) && headerSettings.headerLayouts) {
    var layouts = headerSettings.headerLayouts;
    
    headerSettings.menuItems.forEach(function (menuGroup) {
      // ایجاد کارت برای هر منو
      var menuCard = document.createElement('div');
      menuCard.className = 'disto-admin-menu-group-card';
      
      var menuTitle = document.createElement('h4');
      menuTitle.className = 'disto-admin-menu-group-title';
      menuTitle.textContent = menuGroup.locationLabel + ' (' + menuGroup.menuName + ')';
      menuCard.appendChild(menuTitle);

      if (Array.isArray(menuGroup.items) && menuGroup.items.length > 0) {
        var itemsList = document.createElement('div');
        itemsList.className = 'disto-admin-menu-items-list';

        menuGroup.items.forEach(function (item) {
          var itemRow = document.createElement('div');
          itemRow.className = 'disto-admin-menu-item-row';
          itemRow.setAttribute('data-item-id', item.id);

          var itemTitle = document.createElement('span');
          itemTitle.className = 'disto-admin-menu-item-title';
          itemTitle.textContent = item.title;
          itemRow.appendChild(itemTitle);

          var itemUrl = document.createElement('span');
          itemUrl.className = 'disto-admin-menu-item-url';
          itemUrl.textContent = item.url;
          itemRow.appendChild(itemUrl);

          var headerSelect = document.createElement('select');
          headerSelect.className = 'disto-admin-select disto-admin-menu-item-header-select';
          headerSelect.setAttribute('data-item-id', item.id);

          // اضافه کردن گزینه‌ها
          for (var layoutKey in layouts) {
            if (layouts.hasOwnProperty(layoutKey)) {
              var opt = document.createElement('option');
              opt.value = layoutKey;
              opt.textContent = layouts[layoutKey];
              if (item.headerLayout === layoutKey) {
                opt.selected = true;
              }
              headerSelect.appendChild(opt);
            }
          }

          var selectWrapper = document.createElement('div');
          selectWrapper.className = 'disto-admin-menu-item-header-wrapper';
          selectWrapper.appendChild(headerSelect);
          itemRow.appendChild(selectWrapper);

          itemsList.appendChild(itemRow);
        });

        menuCard.appendChild(itemsList);
      } else {
        var emptyMsg = document.createElement('p');
        emptyMsg.className = 'disto-admin-help';
        emptyMsg.textContent = 'این منو آیتمی ندارد.';
        menuCard.appendChild(emptyMsg);
      }

      menuItemsHeaderContainer.appendChild(menuCard);
    });

    if (headerSettings.menuItems.length === 0) {
      var emptyState = document.createElement('p');
      emptyState.className = 'disto-admin-help';
      emptyState.textContent = 'هیچ منویی یافت نشد. لطفاً ابتدا منوها را از بخش "نمایش → منوها" ایجاد کنید.';
      menuItemsHeaderContainer.appendChild(emptyState);
    }
  }

  var headerSaveBtn = root.querySelector('#disto-header-save');
  var headerStatusEl = root.querySelector('#disto-header-status');
  function setHeaderStatus(text, type) {
    if (!headerStatusEl) return;
    headerStatusEl.textContent = text || '';
    headerStatusEl.className = 'disto-admin-status ' + (type ? 'is-' + type : '');
  }
  if (headerSaveBtn) {
    headerSaveBtn.addEventListener('click', function () {
      // جمع‌آوری تنظیمات هدر آیتم‌های منو
      var menuItemsData = [];
      var headerSelects = root.querySelectorAll('.disto-admin-menu-item-header-select');
      headerSelects.forEach(function (select) {
        var itemId = select.getAttribute('data-item-id');
        if (itemId) {
          menuItemsData.push({
            id: parseInt(itemId, 10),
            headerLayout: select.value || ''
          });
        }
      });

      // جمع‌آوری انتساب منو به موقعیت‌ها
      var menuLocationsData = [];
      var locationSelects = root.querySelectorAll('.disto-admin-menu-location-select');
      locationSelects.forEach(function (select) {
        var location = select.getAttribute('data-location');
        if (location) {
          menuLocationsData.push({
            location: location,
            menuId: parseInt(select.value, 10) || 0
          });
        }
      });

      var data = {
        action: 'disto_save_header_settings',
        nonce: window.DistoThemeSettings ? window.DistoThemeSettings.nonce : '',
        header_layout: (root.querySelector('#disto-header-layout') && root.querySelector('#disto-header-layout').value) || 'header_layout_4',
        top_bar_enabled: root.querySelector('#disto-top-bar-enabled') && root.querySelector('#disto-top-bar-enabled').checked ? '1' : '',
        top_bar_left: root.querySelector('#disto-top-bar-left') ? root.querySelector('#disto-top-bar-left').value : '',
        top_bar_right: root.querySelector('#disto-top-bar-right') ? root.querySelector('#disto-top-bar-right').value : '',
        date_title: root.querySelector('#disto-date-title') ? root.querySelector('#disto-date-title').value : '',
        disable_date: root.querySelector('#disto-disable-date') && root.querySelector('#disto-disable-date').checked ? '1' : '',
        sticky_menu: root.querySelector('#disto-sticky-menu') && root.querySelector('#disto-sticky-menu').checked ? '1' : '',
        disable_search: root.querySelector('#disto-disable-search') && root.querySelector('#disto-disable-search').checked ? '1' : '',
        disable_social: root.querySelector('#disto-disable-social') && root.querySelector('#disto-disable-social').checked ? '1' : '',
        cta_enabled: root.querySelector('#disto-cta-enabled') && root.querySelector('#disto-cta-enabled').checked ? '1' : '',
        cta_label: root.querySelector('#disto-cta-label') ? root.querySelector('#disto-cta-label').value : '',
        cta_url: root.querySelector('#disto-cta-url') ? root.querySelector('#disto-cta-url').value : '#',
        cta_style: root.querySelector('#disto-cta-style') ? root.querySelector('#disto-cta-style').value : 'primary',
        mega_menu_enabled: root.querySelector('#disto-mega-menu-enabled') && root.querySelector('#disto-mega-menu-enabled').checked ? '1' : '',
      };
      setHeaderStatus('در حال ذخیره...', 'pending');
      headerSaveBtn.disabled = true;
      
      // ذخیره تنظیمات هدر آیتم‌های منو
      var menuItemsSaveData = {
        action: 'disto_save_menu_items_header_settings',
        nonce: window.DistoThemeSettings ? window.DistoThemeSettings.nonce : '',
        menu_items: JSON.stringify(menuItemsData)
      };

      // ذخیره انتساب منو به موقعیت‌ها
      var menuLocationsSaveData = {
        action: 'disto_save_menu_locations',
        nonce: window.DistoThemeSettings ? window.DistoThemeSettings.nonce : '',
        menu_locations: JSON.stringify(menuLocationsData)
      };

      // ذخیره همه به صورت همزمان
      jQuery.when(
        jQuery.post(window.DistoThemeSettings.ajaxUrl, data),
        jQuery.post(window.DistoThemeSettings.ajaxUrl, menuItemsSaveData),
        jQuery.post(window.DistoThemeSettings.ajaxUrl, menuLocationsSaveData)
      )
        .done(function (headerResp, menuItemsResp, menuLocationsResp) {
          var headerSuccess = headerResp[0] && headerResp[0].success;
          var menuItemsSuccess = menuItemsResp[0] && menuItemsResp[0].success;
          var menuLocationsSuccess = menuLocationsResp[0] && menuLocationsResp[0].success;
          
          if (headerSuccess && menuItemsSuccess && menuLocationsSuccess) {
            setHeaderStatus('تمام تنظیمات هدر و منوها با موفقیت ذخیره شد.', 'success');
          } else if (headerSuccess && menuItemsSuccess) {
            setHeaderStatus('تنظیمات هدر ذخیره شد، اما خطا در ذخیره انتساب منوها.', 'error');
          } else if (headerSuccess) {
            setHeaderStatus('تنظیمات هدر کلی ذخیره شد، اما خطا در ذخیره تنظیمات آیتم‌های منو.', 'error');
          } else {
            setHeaderStatus('خطا در ذخیره.', 'error');
          }
        })
        .fail(function () {
          setHeaderStatus('خطا در ارتباط با سرور.', 'error');
        })
        .always(function () {
          headerSaveBtn.disabled = false;
          setTimeout(function () { setHeaderStatus('', ''); }, 4000);
        });
    });
  }

  // === مقداردهی اولیه تنظیمات فوتر بر اساس سفارشی‌ساز ===
  if (window.DistoThemeSettings && window.DistoThemeSettings.footerSettings) {
    var footer = window.DistoThemeSettings.footerSettings;
    var cols = footer.columns || 'footer3col';
    var radios = root.querySelectorAll('input[name="disto-footer-columns"]');
    Array.prototype.forEach.call(radios, function (r) {
      if (r.value === cols) {
        r.checked = true;
      }
    });
    var cp = root.querySelector('#disto-footer-copyright');
    if (cp && footer.copyright) {
      cp.value = footer.copyright;
    }

    // گزینه‌های ناحیه‌های ویجت
    var areas = Array.isArray(footer.widgetAreas) ? footer.widgetAreas : [];
    var selects = [
      root.querySelector('#disto-footer-sidebar-1'),
      root.querySelector('#disto-footer-sidebar-2'),
      root.querySelector('#disto-footer-sidebar-3'),
      root.querySelector('#disto-footer-sidebar-4'),
    ];

    selects.forEach(function (sel) {
      if (!sel) return;
      sel.innerHTML = '';
      areas.forEach(function (area) {
        var opt = document.createElement('option');
        opt.value = area.id;
        opt.textContent = area.name;
        sel.appendChild(opt);
      });
    });

    // انتخاب مقدار فعلی برای هر ستون
    var map = footer.columnsSidebars || {};
    var defaults = {
      col1: 'footer1-sidebar',
      col2: 'footer2-sidebar',
      col3: 'footer3-sidebar',
      col4: 'footer4-sidebar',
    };
    var values = {
      0: map.col1 || defaults.col1,
      1: map.col2 || defaults.col2,
      2: map.col3 || defaults.col3,
      3: map.col4 || defaults.col4,
    };

    selects.forEach(function (sel, index) {
      if (!sel) return;
      var val = values[index];
      if (val) {
        sel.value = val;
      }
    });
  }

  // === ذخیره تنظیمات فوتر از طریق AJAX و همگام با Customizer ===
  var saveBtn = root.querySelector('#disto-footer-save');
  var statusEl = root.querySelector('#disto-footer-status');

  function setStatus(text, type) {
    if (!statusEl) return;
    statusEl.textContent = text || '';
    statusEl.className = 'disto-admin-status ' + (type ? 'is-' + type : '');
  }

  if (saveBtn) {
    saveBtn.addEventListener('click', function () {
      var selected = root.querySelector('input[name="disto-footer-columns"]:checked');
      var columns = selected ? selected.value : 'footer3col';
      var cp = root.querySelector('#disto-footer-copyright');
      var copyright = cp ? cp.value : '';

      var s1 = root.querySelector('#disto-footer-sidebar-1');
      var s2 = root.querySelector('#disto-footer-sidebar-2');
      var s3 = root.querySelector('#disto-footer-sidebar-3');
      var s4 = root.querySelector('#disto-footer-sidebar-4');

      setStatus('در حال ذخیره...', 'pending');
      saveBtn.disabled = true;

      var data = {
        action: 'disto_save_footer_settings',
        nonce: window.DistoThemeSettings ? window.DistoThemeSettings.nonce : '',
        columns: columns,
        copyright: copyright,
        sidebar_col1: s1 ? s1.value : '',
        sidebar_col2: s2 ? s2.value : '',
        sidebar_col3: s3 ? s3.value : '',
        sidebar_col4: s4 ? s4.value : '',
      };

      jQuery
        .post(window.DistoThemeSettings.ajaxUrl, data)
        .done(function (resp) {
          if (resp && resp.success) {
            setStatus('تنظیمات فوتر با موفقیت ذخیره شد.', 'success');
          } else {
            setStatus('خطا در ذخیره تنظیمات فوتر.', 'error');
          }
        })
        .fail(function () {
          setStatus('خطا در ارتباط با سرور.', 'error');
        })
        .always(function () {
          saveBtn.disabled = false;
          setTimeout(function () {
            setStatus('', '');
          }, 4000);
        });
    });
  }

  // === مدیریت شبکه‌های اجتماعی ===
  var socialSettings = (window.DistoThemeSettings && window.DistoThemeSettings.socialSettings) || {};
  var socialPlatformsList = root.querySelector('#disto-social-platforms-list');
  var socialTitleInput = root.querySelector('#disto-social-title');
  var socialDisplayHeaderCheckbox = root.querySelector('#disto-social-display-header');

  // مقداردهی اولیه
  if (socialTitleInput && socialSettings.socialTitle) {
    socialTitleInput.value = socialSettings.socialTitle;
  }
  if (socialDisplayHeaderCheckbox && socialSettings.displayLocations) {
    socialDisplayHeaderCheckbox.checked = socialSettings.displayLocations.header === true;
  }

  // نمایش لیست پلتفرم‌ها
  if (socialPlatformsList && Array.isArray(socialSettings.platforms)) {
    socialSettings.platforms.forEach(function (platform) {
      var platformRow = document.createElement('div');
      platformRow.className = 'disto-admin-social-platform-row';
      platformRow.setAttribute('data-platform-id', platform.id);

      var platformIcon = document.createElement('span');
      platformIcon.className = 'disto-admin-social-platform-icon';
      platformIcon.innerHTML = '<i class="fa ' + (platform.icon || 'fa-link') + '"></i>';
      platformRow.appendChild(platformIcon);

      var platformName = document.createElement('span');
      platformName.className = 'disto-admin-social-platform-name';
      platformName.textContent = platform.name || platform.id;
      platformRow.appendChild(platformName);

      var platformUrlWrapper = document.createElement('div');
      platformUrlWrapper.className = 'disto-admin-social-platform-url-wrapper';

      var platformUrlInput = document.createElement('input');
      platformUrlInput.type = 'url';
      platformUrlInput.className = 'disto-admin-input disto-admin-social-platform-url';
      platformUrlInput.placeholder = 'https://...';
      platformUrlInput.value = platform.url || '';
      platformUrlInput.setAttribute('data-platform-id', platform.id);
      platformUrlWrapper.appendChild(platformUrlInput);

      var deleteBtn = document.createElement('button');
      deleteBtn.type = 'button';
      deleteBtn.className = 'disto-admin-button disto-admin-social-delete-btn';
      deleteBtn.textContent = 'حذف';
      deleteBtn.setAttribute('data-platform-id', platform.id);
      deleteBtn.addEventListener('click', function () {
        var urlInput = root.querySelector('.disto-admin-social-platform-url[data-platform-id="' + platform.id + '"]');
        if (urlInput) {
          urlInput.value = '';
        }
      });
      platformUrlWrapper.appendChild(deleteBtn);

      platformRow.appendChild(platformUrlWrapper);
      socialPlatformsList.appendChild(platformRow);
    });
  }

  // ذخیره تنظیمات شبکه‌های اجتماعی
  var socialSaveBtn = root.querySelector('#disto-social-save');
  var socialStatusEl = root.querySelector('#disto-social-status');
  function setSocialStatus(text, type) {
    if (!socialStatusEl) return;
    socialStatusEl.textContent = text || '';
    socialStatusEl.className = 'disto-admin-status ' + (type ? 'is-' + type : '');
  }

  if (socialSaveBtn) {
    socialSaveBtn.addEventListener('click', function () {
      var platformsData = [];
      var platformInputs = root.querySelectorAll('.disto-admin-social-platform-url');
      platformInputs.forEach(function (input) {
        var platformId = input.getAttribute('data-platform-id');
        if (platformId) {
          platformsData.push({
            id: platformId,
            url: input.value.trim() || ''
          });
        }
      });

      var data = {
        action: 'disto_save_social_settings',
        nonce: window.DistoThemeSettings ? window.DistoThemeSettings.nonce : '',
        social_title: socialTitleInput ? socialTitleInput.value : '',
        display_header: socialDisplayHeaderCheckbox && socialDisplayHeaderCheckbox.checked ? '1' : '',
        platforms: JSON.stringify(platformsData)
      };

      setSocialStatus('در حال ذخیره...', 'pending');
      socialSaveBtn.disabled = true;

      jQuery.post(window.DistoThemeSettings.ajaxUrl, data)
        .done(function (resp) {
          if (resp && resp.success) {
            setSocialStatus('تنظیمات شبکه‌های اجتماعی با موفقیت ذخیره شد.', 'success');
          } else {
            setSocialStatus('خطا در ذخیره.', 'error');
          }
        })
        .fail(function () {
          setSocialStatus('خطا در ارتباط با سرور.', 'error');
        })
        .always(function () {
          socialSaveBtn.disabled = false;
          setTimeout(function () { setSocialStatus('', ''); }, 4000);
        });
    });
  }

  // === مدیریت بخش‌ها ===
  var sectionsSettings = (window.DistoThemeSettings && window.DistoThemeSettings.sectionsSettings) || {};
  var sectionsList = root.querySelector('#disto-sections-list');
  var sectionsSaveBtn = root.querySelector('#disto-sections-save');
  var sectionsStatusEl = root.querySelector('#disto-sections-status');

  function setSectionsStatus(text, type) {
    if (!sectionsStatusEl) return;
    sectionsStatusEl.textContent = text || '';
    sectionsStatusEl.className = 'disto-admin-status ' + (type ? 'is-' + type : '');
  }

  // نمایش لیست بخش‌ها
  if (sectionsList && Array.isArray(sectionsSettings.sections)) {
    sectionsSettings.sections.forEach(function (section, index) {
      var sectionRow = document.createElement('div');
      sectionRow.className = 'disto-admin-section-row';
      sectionRow.setAttribute('data-section-id', section.id);
      sectionRow.setAttribute('data-section-order', section.order || index + 1);

      // اطلاعات بخش
      var sectionInfo = document.createElement('div');
      sectionInfo.className = 'disto-admin-section-info';

      var sectionName = document.createElement('div');
      sectionName.className = 'disto-admin-section-name';
      sectionName.textContent = section.name || section.id;
      sectionInfo.appendChild(sectionName);

      if (section.description) {
        var sectionDesc = document.createElement('div');
        sectionDesc.className = 'disto-admin-section-description';
        sectionDesc.textContent = section.description;
        sectionInfo.appendChild(sectionDesc);
      }

      sectionRow.appendChild(sectionInfo);

      // Checkbox فعال/غیرفعال
      var sectionToggle = document.createElement('label');
      sectionToggle.className = 'disto-admin-checkbox-label disto-admin-section-toggle';

      var sectionCheckbox = document.createElement('input');
      sectionCheckbox.type = 'checkbox';
      sectionCheckbox.className = 'disto-admin-section-enabled';
      sectionCheckbox.setAttribute('data-section-id', section.id);
      sectionCheckbox.checked = section.enabled !== false;

      sectionToggle.appendChild(sectionCheckbox);
      sectionToggle.appendChild(document.createTextNode(' فعال'));

      sectionRow.appendChild(sectionToggle);

      sectionsList.appendChild(sectionRow);
    });
  }

  // ذخیره تنظیمات بخش‌ها
  if (sectionsSaveBtn) {
    sectionsSaveBtn.addEventListener('click', function () {
      var sectionsData = [];
      var rows = sectionsList.querySelectorAll('.disto-admin-section-row');

      rows.forEach(function (row, index) {
        var sectionId = row.getAttribute('data-section-id');
        var order = parseInt(row.getAttribute('data-section-order'), 10) || index + 1;
        var checkbox = row.querySelector('.disto-admin-section-enabled[data-section-id="' + sectionId + '"]');
        var enabled = checkbox ? checkbox.checked : true;

        sectionsData.push({
          id: sectionId,
          enabled: enabled,
          order: order
        });
      });

      var data = {
        action: 'disto_save_sections_settings',
        nonce: window.DistoThemeSettings ? window.DistoThemeSettings.nonce : '',
        sections: JSON.stringify(sectionsData)
      };

      setSectionsStatus('در حال ذخیره...', 'pending');
      sectionsSaveBtn.disabled = true;

      jQuery.post(window.DistoThemeSettings.ajaxUrl, data)
        .done(function (resp) {
          if (resp && resp.success) {
            setSectionsStatus('تنظیمات بخش‌ها با موفقیت ذخیره شد.', 'success');
          } else {
            setSectionsStatus('خطا در ذخیره.', 'error');
          }
        })
        .fail(function () {
          setSectionsStatus('خطا در ارتباط با سرور.', 'error');
        })
        .always(function () {
          sectionsSaveBtn.disabled = false;
          setTimeout(function () { setSectionsStatus('', ''); }, 4000);
        });
    });
  }

  // === تنظیمات وبلاگ ===
  var blogSettings = (window.DistoThemeSettings && window.DistoThemeSettings.blogSettings) || {};
  var blogSaveBtn = root.querySelector('#disto-blog-save');
  var blogStatusEl = root.querySelector('#disto-blog-status');

  function setBlogStatus(text, type) {
    if (!blogStatusEl) return;
    blogStatusEl.textContent = text || '';
    blogStatusEl.className = 'disto-admin-status ' + (type ? 'is-' + type : '');
  }

  // بارگذاری تنظیمات وبلاگ
  if (blogSettings) {
    // طرح‌بندی
    var blogLayoutSelect = root.querySelector('#disto-blog-layout');
    if (blogLayoutSelect && blogSettings.layout) {
      blogLayoutSelect.value = blogSettings.layout;
    }

    var blogPostsPerPage = root.querySelector('#disto-blog-posts-per-page');
    if (blogPostsPerPage && blogSettings.posts_per_page) {
      blogPostsPerPage.value = blogSettings.posts_per_page;
    }

    var blogExcerptLength = root.querySelector('#disto-blog-excerpt-length');
    if (blogExcerptLength && blogSettings.excerpt_length !== undefined) {
      blogExcerptLength.value = blogSettings.excerpt_length;
    }

    var blogShowFeaturedImage = root.querySelector('#disto-blog-show-featured-image');
    if (blogShowFeaturedImage) {
      blogShowFeaturedImage.checked = blogSettings.show_featured_image !== false;
    }

    var blogShowReadMore = root.querySelector('#disto-blog-show-read-more');
    if (blogShowReadMore) {
      blogShowReadMore.checked = blogSettings.show_read_more !== false;
    }

    // متادیتا
    var blogShowDate = root.querySelector('#disto-blog-show-date');
    if (blogShowDate) {
      blogShowDate.checked = blogSettings.show_date !== false;
    }

    var blogShowAuthor = root.querySelector('#disto-blog-show-author');
    if (blogShowAuthor) {
      blogShowAuthor.checked = blogSettings.show_author !== false;
    }

    var blogShowCategories = root.querySelector('#disto-blog-show-categories');
    if (blogShowCategories) {
      blogShowCategories.checked = blogSettings.show_categories !== false;
    }

    var blogShowTags = root.querySelector('#disto-blog-show-tags');
    if (blogShowTags) {
      blogShowTags.checked = blogSettings.show_tags !== false;
    }

    var blogShowCommentsCount = root.querySelector('#disto-blog-show-comments-count');
    if (blogShowCommentsCount) {
      blogShowCommentsCount.checked = blogSettings.show_comments_count !== false;
    }

    var blogShowReadingTime = root.querySelector('#disto-blog-show-reading-time');
    if (blogShowReadingTime) {
      blogShowReadingTime.checked = blogSettings.show_reading_time === true;
    }

    var blogDateFormat = root.querySelector('#disto-blog-date-format');
    if (blogDateFormat && blogSettings.date_format) {
      blogDateFormat.value = blogSettings.date_format;
    }

    // باکس نویسنده
    var blogAuthorBoxEnabled = root.querySelector('#disto-blog-author-box-enabled');
    if (blogAuthorBoxEnabled) {
      blogAuthorBoxEnabled.checked = blogSettings.author_box_enabled === true;
    }

    var blogAuthorBoxTitle = root.querySelector('#disto-blog-author-box-title');
    if (blogAuthorBoxTitle && blogSettings.author_box_title) {
      blogAuthorBoxTitle.value = blogSettings.author_box_title;
    }

    var blogAuthorBoxShowAvatar = root.querySelector('#disto-blog-author-box-show-avatar');
    if (blogAuthorBoxShowAvatar) {
      blogAuthorBoxShowAvatar.checked = blogSettings.author_box_show_avatar !== false;
    }

    var blogAuthorBoxShowBio = root.querySelector('#disto-blog-author-box-show-bio');
    if (blogAuthorBoxShowBio) {
      blogAuthorBoxShowBio.checked = blogSettings.author_box_show_bio !== false;
    }

    var blogAuthorBoxShowSocial = root.querySelector('#disto-blog-author-box-show-social');
    if (blogAuthorBoxShowSocial) {
      blogAuthorBoxShowSocial.checked = blogSettings.author_box_show_social === true;
    }

    var blogAuthorBoxLayout = root.querySelector('#disto-blog-author-box-layout');
    if (blogAuthorBoxLayout && blogSettings.author_box_layout) {
      blogAuthorBoxLayout.value = blogSettings.author_box_layout;
    }

    // مطالب مرتبط
    var blogRelatedPostsEnabled = root.querySelector('#disto-blog-related-posts-enabled');
    if (blogRelatedPostsEnabled) {
      blogRelatedPostsEnabled.checked = blogSettings.related_posts_enabled === true;
    }

    var blogRelatedPostsTitle = root.querySelector('#disto-blog-related-posts-title');
    if (blogRelatedPostsTitle && blogSettings.related_posts_title) {
      blogRelatedPostsTitle.value = blogSettings.related_posts_title;
    }

    var blogRelatedPostsCount = root.querySelector('#disto-blog-related-posts-count');
    if (blogRelatedPostsCount && blogSettings.related_posts_count) {
      blogRelatedPostsCount.value = blogSettings.related_posts_count;
    }

    var blogRelatedPostsLayout = root.querySelector('#disto-blog-related-posts-layout');
    if (blogRelatedPostsLayout && blogSettings.related_posts_layout) {
      blogRelatedPostsLayout.value = blogSettings.related_posts_layout;
    }

    var blogRelatedPostsSource = root.querySelector('input[name="disto-blog-related-posts-source"]:checked');
    if (!blogRelatedPostsSource && blogSettings.related_posts_source) {
      var sourceRadio = root.querySelector('input[name="disto-blog-related-posts-source"][value="' + blogSettings.related_posts_source + '"]');
      if (sourceRadio) {
        sourceRadio.checked = true;
      }
    } else if (blogRelatedPostsSource && blogSettings.related_posts_source) {
      blogRelatedPostsSource.checked = false;
      var sourceRadio = root.querySelector('input[name="disto-blog-related-posts-source"][value="' + blogSettings.related_posts_source + '"]');
      if (sourceRadio) {
        sourceRadio.checked = true;
      }
    }

    var blogRelatedPostsShowExcerpt = root.querySelector('#disto-blog-related-posts-show-excerpt');
    if (blogRelatedPostsShowExcerpt) {
      blogRelatedPostsShowExcerpt.checked = blogSettings.related_posts_show_excerpt === true;
    }

    var blogRelatedPostsShowDate = root.querySelector('#disto-blog-related-posts-show-date');
    if (blogRelatedPostsShowDate) {
      blogRelatedPostsShowDate.checked = blogSettings.related_posts_show_date === true;
    }
  }

  // ذخیره تنظیمات وبلاگ
  if (blogSaveBtn) {
    blogSaveBtn.addEventListener('click', function () {
      var blogLayoutSelect = root.querySelector('#disto-blog-layout');
      var blogPostsPerPage = root.querySelector('#disto-blog-posts-per-page');
      var blogExcerptLength = root.querySelector('#disto-blog-excerpt-length');
      var blogShowFeaturedImage = root.querySelector('#disto-blog-show-featured-image');
      var blogShowReadMore = root.querySelector('#disto-blog-show-read-more');
      var blogShowDate = root.querySelector('#disto-blog-show-date');
      var blogShowAuthor = root.querySelector('#disto-blog-show-author');
      var blogShowCategories = root.querySelector('#disto-blog-show-categories');
      var blogShowTags = root.querySelector('#disto-blog-show-tags');
      var blogShowCommentsCount = root.querySelector('#disto-blog-show-comments-count');
      var blogShowReadingTime = root.querySelector('#disto-blog-show-reading-time');
      var blogDateFormat = root.querySelector('#disto-blog-date-format');
      var blogAuthorBoxEnabled = root.querySelector('#disto-blog-author-box-enabled');
      var blogAuthorBoxTitle = root.querySelector('#disto-blog-author-box-title');
      var blogAuthorBoxShowAvatar = root.querySelector('#disto-blog-author-box-show-avatar');
      var blogAuthorBoxShowBio = root.querySelector('#disto-blog-author-box-show-bio');
      var blogAuthorBoxShowSocial = root.querySelector('#disto-blog-author-box-show-social');
      var blogAuthorBoxLayout = root.querySelector('#disto-blog-author-box-layout');
      var blogRelatedPostsEnabled = root.querySelector('#disto-blog-related-posts-enabled');
      var blogRelatedPostsTitle = root.querySelector('#disto-blog-related-posts-title');
      var blogRelatedPostsCount = root.querySelector('#disto-blog-related-posts-count');
      var blogRelatedPostsLayout = root.querySelector('#disto-blog-related-posts-layout');
      var blogRelatedPostsSource = root.querySelector('input[name="disto-blog-related-posts-source"]:checked');
      var blogRelatedPostsShowExcerpt = root.querySelector('#disto-blog-related-posts-show-excerpt');
      var blogRelatedPostsShowDate = root.querySelector('#disto-blog-related-posts-show-date');

      var data = {
        action: 'disto_save_blog_settings',
        nonce: window.DistoThemeSettings ? window.DistoThemeSettings.nonce : '',
        blog_layout: blogLayoutSelect ? blogLayoutSelect.value : 'grid-3',
        blog_posts_per_page: blogPostsPerPage ? parseInt(blogPostsPerPage.value, 10) || 10 : 10,
        blog_excerpt_length: blogExcerptLength ? parseInt(blogExcerptLength.value, 10) || 150 : 150,
        blog_show_featured_image: blogShowFeaturedImage && blogShowFeaturedImage.checked ? '1' : '',
        blog_show_read_more: blogShowReadMore && blogShowReadMore.checked ? '1' : '',
        blog_show_date: blogShowDate && blogShowDate.checked ? '1' : '',
        blog_show_author: blogShowAuthor && blogShowAuthor.checked ? '1' : '',
        blog_show_categories: blogShowCategories && blogShowCategories.checked ? '1' : '',
        blog_show_tags: blogShowTags && blogShowTags.checked ? '1' : '',
        blog_show_comments_count: blogShowCommentsCount && blogShowCommentsCount.checked ? '1' : '',
        blog_show_reading_time: blogShowReadingTime && blogShowReadingTime.checked ? '1' : '',
        blog_date_format: blogDateFormat ? blogDateFormat.value : 'default',
        blog_author_box_enabled: blogAuthorBoxEnabled && blogAuthorBoxEnabled.checked ? '1' : '',
        blog_author_box_title: blogAuthorBoxTitle ? blogAuthorBoxTitle.value : '',
        blog_author_box_show_avatar: blogAuthorBoxShowAvatar && blogAuthorBoxShowAvatar.checked ? '1' : '',
        blog_author_box_show_bio: blogAuthorBoxShowBio && blogAuthorBoxShowBio.checked ? '1' : '',
        blog_author_box_show_social: blogAuthorBoxShowSocial && blogAuthorBoxShowSocial.checked ? '1' : '',
        blog_author_box_layout: blogAuthorBoxLayout ? blogAuthorBoxLayout.value : 'horizontal',
        blog_related_posts_enabled: blogRelatedPostsEnabled && blogRelatedPostsEnabled.checked ? '1' : '',
        blog_related_posts_title: blogRelatedPostsTitle ? blogRelatedPostsTitle.value : '',
        blog_related_posts_count: blogRelatedPostsCount ? parseInt(blogRelatedPostsCount.value, 10) || 3 : 3,
        blog_related_posts_layout: blogRelatedPostsLayout ? blogRelatedPostsLayout.value : 'grid-3',
        blog_related_posts_source: blogRelatedPostsSource ? blogRelatedPostsSource.value : 'categories',
        blog_related_posts_show_excerpt: blogRelatedPostsShowExcerpt && blogRelatedPostsShowExcerpt.checked ? '1' : '',
        blog_related_posts_show_date: blogRelatedPostsShowDate && blogRelatedPostsShowDate.checked ? '1' : ''
      };

      setBlogStatus('در حال ذخیره...', 'pending');
      blogSaveBtn.disabled = true;

      jQuery.post(window.DistoThemeSettings.ajaxUrl, data)
        .done(function (resp) {
          if (resp && resp.success) {
            setBlogStatus('تنظیمات وبلاگ با موفقیت ذخیره شد.', 'success');
          } else {
            setBlogStatus('خطا در ذخیره.', 'error');
          }
        })
        .fail(function () {
          setBlogStatus('خطا در ارتباط با سرور.', 'error');
        })
        .always(function () {
          blogSaveBtn.disabled = false;
          setTimeout(function () { setBlogStatus('', ''); }, 4000);
        });
    });
  }

  // === تنظیمات عملکرد ===
  var performanceSettings = (window.DistoThemeSettings && window.DistoThemeSettings.performanceSettings) || {};
  var performanceSaveBtn = root.querySelector('#disto-performance-save');
  var performanceStatusEl = root.querySelector('#disto-performance-status');

  function setPerformanceStatus(text, type) {
    if (!performanceStatusEl) return;
    performanceStatusEl.textContent = text || '';
    performanceStatusEl.className = 'disto-admin-status ' + (type ? 'is-' + type : '');
  }

  // بارگذاری تنظیمات عملکرد
  if (performanceSettings) {
    // انیمیشن‌ها
    var performanceAnimationsEnabled = root.querySelector('#disto-performance-animations-enabled');
    if (performanceAnimationsEnabled) {
      performanceAnimationsEnabled.checked = performanceSettings.animations_enabled !== false;
    }

    var performanceAnimationSpeed = root.querySelector('#disto-performance-animation-speed');
    if (performanceAnimationSpeed && performanceSettings.animation_speed) {
      performanceAnimationSpeed.value = performanceSettings.animation_speed;
    }

    var performancePageTransitions = root.querySelector('#disto-performance-page-transitions');
    if (performancePageTransitions) {
      performancePageTransitions.checked = performanceSettings.page_transitions === true;
    }

    var performanceHoverEffects = root.querySelector('#disto-performance-hover-effects');
    if (performanceHoverEffects) {
      performanceHoverEffects.checked = performanceSettings.hover_effects !== false;
    }

    var performanceScrollAnimations = root.querySelector('#disto-performance-scroll-animations');
    if (performanceScrollAnimations) {
      performanceScrollAnimations.checked = performanceSettings.scroll_animations === true;
    }

    // حالت سبک
    var performanceLazyLoading = root.querySelector('#disto-performance-lazy-loading');
    if (performanceLazyLoading) {
      performanceLazyLoading.checked = performanceSettings.lazy_loading === true;
    }

    var performanceMinifyCss = root.querySelector('#disto-performance-minify-css');
    if (performanceMinifyCss) {
      performanceMinifyCss.checked = performanceSettings.minify_css === true;
    }

    var performanceMinifyJs = root.querySelector('#disto-performance-minify-js');
    if (performanceMinifyJs) {
      performanceMinifyJs.checked = performanceSettings.minify_js === true;
    }

    var performanceDeferJs = root.querySelector('#disto-performance-defer-js');
    if (performanceDeferJs) {
      performanceDeferJs.checked = performanceSettings.defer_js === true;
    }

    var performancePreloadCritical = root.querySelector('#disto-performance-preload-critical');
    if (performancePreloadCritical) {
      performancePreloadCritical.checked = performanceSettings.preload_critical === true;
    }

    // کاهش موشن
    var performanceReduceMotion = root.querySelector('#disto-performance-reduce-motion');
    if (performanceReduceMotion) {
      performanceReduceMotion.checked = performanceSettings.reduce_motion === true;
    }

    var performanceMotionPreference = root.querySelector('#disto-performance-motion-preference');
    if (performanceMotionPreference && performanceSettings.motion_preference) {
      performanceMotionPreference.value = performanceSettings.motion_preference;
    }

    var performanceDisableParallax = root.querySelector('#disto-performance-disable-parallax');
    if (performanceDisableParallax) {
      performanceDisableParallax.checked = performanceSettings.disable_parallax === true;
    }

    var performanceSimplifyAnimations = root.querySelector('#disto-performance-simplify-animations');
    if (performanceSimplifyAnimations) {
      performanceSimplifyAnimations.checked = performanceSettings.simplify_animations === true;
    }

    // سایه‌ها
    var performanceShadowsEnabled = root.querySelector('#disto-performance-shadows-enabled');
    if (performanceShadowsEnabled) {
      performanceShadowsEnabled.checked = performanceSettings.shadows_enabled !== false;
    }

    var performanceShadowIntensity = root.querySelector('#disto-performance-shadow-intensity');
    if (performanceShadowIntensity && performanceSettings.shadow_intensity) {
      performanceShadowIntensity.value = performanceSettings.shadow_intensity;
    }

    var performanceCardShadows = root.querySelector('#disto-performance-card-shadows');
    if (performanceCardShadows) {
      performanceCardShadows.checked = performanceSettings.card_shadows !== false;
    }

    var performanceButtonShadows = root.querySelector('#disto-performance-button-shadows');
    if (performanceButtonShadows) {
      performanceButtonShadows.checked = performanceSettings.button_shadows !== false;
    }

    var performanceImageShadows = root.querySelector('#disto-performance-image-shadows');
    if (performanceImageShadows) {
      performanceImageShadows.checked = performanceSettings.image_shadows === true;
    }

    var performanceHoverShadow = root.querySelector('#disto-performance-hover-shadow');
    if (performanceHoverShadow) {
      performanceHoverShadow.checked = performanceSettings.hover_shadow === true;
    }
  }

  // ذخیره تنظیمات عملکرد
  if (performanceSaveBtn) {
    performanceSaveBtn.addEventListener('click', function () {
      var performanceAnimationsEnabled = root.querySelector('#disto-performance-animations-enabled');
      var performanceAnimationSpeed = root.querySelector('#disto-performance-animation-speed');
      var performancePageTransitions = root.querySelector('#disto-performance-page-transitions');
      var performanceHoverEffects = root.querySelector('#disto-performance-hover-effects');
      var performanceScrollAnimations = root.querySelector('#disto-performance-scroll-animations');
      var performanceLazyLoading = root.querySelector('#disto-performance-lazy-loading');
      var performanceMinifyCss = root.querySelector('#disto-performance-minify-css');
      var performanceMinifyJs = root.querySelector('#disto-performance-minify-js');
      var performanceDeferJs = root.querySelector('#disto-performance-defer-js');
      var performancePreloadCritical = root.querySelector('#disto-performance-preload-critical');
      var performanceReduceMotion = root.querySelector('#disto-performance-reduce-motion');
      var performanceMotionPreference = root.querySelector('#disto-performance-motion-preference');
      var performanceDisableParallax = root.querySelector('#disto-performance-disable-parallax');
      var performanceSimplifyAnimations = root.querySelector('#disto-performance-simplify-animations');
      var performanceShadowsEnabled = root.querySelector('#disto-performance-shadows-enabled');
      var performanceShadowIntensity = root.querySelector('#disto-performance-shadow-intensity');
      var performanceCardShadows = root.querySelector('#disto-performance-card-shadows');
      var performanceButtonShadows = root.querySelector('#disto-performance-button-shadows');
      var performanceImageShadows = root.querySelector('#disto-performance-image-shadows');
      var performanceHoverShadow = root.querySelector('#disto-performance-hover-shadow');

      var data = {
        action: 'disto_save_performance_settings',
        nonce: window.DistoThemeSettings ? window.DistoThemeSettings.nonce : '',
        performance_animations_enabled: performanceAnimationsEnabled && performanceAnimationsEnabled.checked ? '1' : '',
        performance_animation_speed: performanceAnimationSpeed ? performanceAnimationSpeed.value : 'normal',
        performance_page_transitions: performancePageTransitions && performancePageTransitions.checked ? '1' : '',
        performance_hover_effects: performanceHoverEffects && performanceHoverEffects.checked ? '1' : '',
        performance_scroll_animations: performanceScrollAnimations && performanceScrollAnimations.checked ? '1' : '',
        performance_lazy_loading: performanceLazyLoading && performanceLazyLoading.checked ? '1' : '',
        performance_minify_css: performanceMinifyCss && performanceMinifyCss.checked ? '1' : '',
        performance_minify_js: performanceMinifyJs && performanceMinifyJs.checked ? '1' : '',
        performance_defer_js: performanceDeferJs && performanceDeferJs.checked ? '1' : '',
        performance_preload_critical: performancePreloadCritical && performancePreloadCritical.checked ? '1' : '',
        performance_reduce_motion: performanceReduceMotion && performanceReduceMotion.checked ? '1' : '',
        performance_motion_preference: performanceMotionPreference ? performanceMotionPreference.value : 'auto',
        performance_disable_parallax: performanceDisableParallax && performanceDisableParallax.checked ? '1' : '',
        performance_simplify_animations: performanceSimplifyAnimations && performanceSimplifyAnimations.checked ? '1' : '',
        performance_shadows_enabled: performanceShadowsEnabled && performanceShadowsEnabled.checked ? '1' : '',
        performance_shadow_intensity: performanceShadowIntensity ? performanceShadowIntensity.value : 'normal',
        performance_card_shadows: performanceCardShadows && performanceCardShadows.checked ? '1' : '',
        performance_button_shadows: performanceButtonShadows && performanceButtonShadows.checked ? '1' : '',
        performance_image_shadows: performanceImageShadows && performanceImageShadows.checked ? '1' : '',
        performance_hover_shadow: performanceHoverShadow && performanceHoverShadow.checked ? '1' : ''
      };

      setPerformanceStatus('در حال ذخیره...', 'pending');
      performanceSaveBtn.disabled = true;

      jQuery.post(window.DistoThemeSettings.ajaxUrl, data)
        .done(function (resp) {
          if (resp && resp.success) {
            setPerformanceStatus('تنظیمات عملکرد با موفقیت ذخیره شد.', 'success');
          } else {
            setPerformanceStatus('خطا در ذخیره.', 'error');
          }
        })
        .fail(function () {
          setPerformanceStatus('خطا در ارتباط با سرور.', 'error');
        })
        .always(function () {
          performanceSaveBtn.disabled = false;
          setTimeout(function () { setPerformanceStatus('', ''); }, 4000);
        });
    });
  }

  // === سیستم پریست قالب ===
  var presetsSettings = (window.DistoThemeSettings && window.DistoThemeSettings.presetsSettings) || {};
  var presetsJsonTextarea = root.querySelector('#disto-presets-json');
  var presetsExportBtn = root.querySelector('#disto-presets-export');
  var presetsImportBtn = root.querySelector('#disto-presets-import');
  var presetsSaveCurrentBtn = root.querySelector('#disto-presets-save-current');
  var presetsResetBtn = root.querySelector('#disto-presets-reset');
  var presetsStatusEl = root.querySelector('#disto-presets-status');

  function setPresetsStatus(text, type) {
    if (!presetsStatusEl) return;
    presetsStatusEl.textContent = text || '';
    presetsStatusEl.className = 'disto-admin-status ' + (type ? 'is-' + type : '');
  }

  // اگر پریست ذخیره‌شده‌ای وجود دارد، می‌توان آن را به صورت JSON اولیه نمایش داد (اختیاری).
  if (presetsJsonTextarea && presetsSettings && presetsSettings.saved && Object.keys(presetsSettings.saved).length) {
    try {
      presetsJsonTextarea.value = JSON.stringify(presetsSettings.saved, null, 2);
    } catch (e) {
      // نادیده بگیر.
    }
  }

  if (presetsExportBtn) {
    presetsExportBtn.addEventListener('click', function () {
      if (!presetsJsonTextarea) return;

      var source = {};
      if (presetsSettings && presetsSettings.saved && Object.keys(presetsSettings.saved).length) {
        source = presetsSettings.saved;
      } else if (presetsSettings && presetsSettings.current) {
        source = presetsSettings.current;
      }

      try {
        presetsJsonTextarea.value = JSON.stringify(source, null, 2);
        setPresetsStatus('JSON تنظیمات فعلی تولید شد. آن را کپی و در جایی امن ذخیره کنید.', 'success');
      } catch (e) {
        setPresetsStatus('خطا در تولید JSON.', 'error');
      }
    });
  }

  if (presetsSaveCurrentBtn) {
    presetsSaveCurrentBtn.addEventListener('click', function () {
      if (!window.DistoThemeSettings) return;

      setPresetsStatus('در حال ذخیره پریست...', 'pending');
      presetsSaveCurrentBtn.disabled = true;

      var data = {
        action: 'disto_save_theme_preset',
        nonce: window.DistoThemeSettings ? window.DistoThemeSettings.nonce : ''
      };

      jQuery.post(window.DistoThemeSettings.ajaxUrl, data)
        .done(function (resp) {
          if (resp && resp.success) {
            setPresetsStatus('پریست تنظیمات قالب با موفقیت ذخیره شد.', 'success');
          } else {
            setPresetsStatus('خطا در ذخیره پریست.', 'error');
          }
        })
        .fail(function () {
          setPresetsStatus('خطا در ارتباط با سرور.', 'error');
        })
        .always(function () {
          presetsSaveCurrentBtn.disabled = false;
          setTimeout(function () { setPresetsStatus('', ''); }, 4000);
        });
    });
  }

  if (presetsImportBtn) {
    presetsImportBtn.addEventListener('click', function () {
      if (!window.DistoThemeSettings || !presetsJsonTextarea) return;

      var raw = presetsJsonTextarea.value.trim();
      if (!raw) {
        setPresetsStatus('لطفاً JSON تنظیمات را در فیلد بالا قرار دهید.', 'error');
        return;
      }

      try {
        JSON.parse(raw);
      } catch (e) {
        setPresetsStatus('فرمت JSON نامعتبر است.', 'error');
        return;
      }

      setPresetsStatus('در حال اعمال پریست از JSON...', 'pending');
      presetsImportBtn.disabled = true;

      var data = {
        action: 'disto_import_theme_preset',
        nonce: window.DistoThemeSettings ? window.DistoThemeSettings.nonce : '',
        preset_json: raw
      };

      jQuery.post(window.DistoThemeSettings.ajaxUrl, data)
        .done(function (resp) {
          if (resp && resp.success) {
            setPresetsStatus('پریست از JSON اعمال شد. لطفاً صفحه را رفرش کنید.', 'success');
          } else {
            setPresetsStatus('خطا در اعمال پریست از JSON.', 'error');
          }
        })
        .fail(function () {
          setPresetsStatus('خطا در ارتباط با سرور.', 'error');
        })
        .always(function () {
          presetsImportBtn.disabled = false;
          setTimeout(function () { setPresetsStatus('', ''); }, 5000);
        });
    });
  }

  if (presetsResetBtn) {
    presetsResetBtn.addEventListener('click', function () {
      if (!window.DistoThemeSettings) return;

      if (!window.confirm('آیا از بازنشانی تمام تنظیمات قالب به حالت پیش‌فرض مطمئن هستید؟ این عملیات قابل بازگشت نیست.')) {
        return;
      }

      setPresetsStatus('در حال بازنشانی تنظیمات قالب...', 'pending');
      presetsResetBtn.disabled = true;

      var data = {
        action: 'disto_reset_theme_settings',
        nonce: window.DistoThemeSettings ? window.DistoThemeSettings.nonce : ''
      };

      jQuery.post(window.DistoThemeSettings.ajaxUrl, data)
        .done(function (resp) {
          if (resp && resp.success) {
            setPresetsStatus('تنظیمات قالب به حالت پیش‌فرض بازنشانی شد. لطفاً صفحه را رفرش کنید.', 'success');
          } else {
            setPresetsStatus('خطا در بازنشانی تنظیمات.', 'error');
          }
        })
        .fail(function () {
          setPresetsStatus('خطا در ارتباط با سرور.', 'error');
        })
        .always(function () {
          presetsResetBtn.disabled = false;
          setTimeout(function () { setPresetsStatus('', ''); }, 5000);
        });
    });
  }

  /**
   * قفل کردن داشبورد تنظیمات وقتی لایسنس فعال نیست
   */
  function distoCreateLicenseStyles() {
    if (document.getElementById('disto-license-overlay-style')) {
      return;
    }
    var style = document.createElement('style');
    style.id = 'disto-license-overlay-style';
    style.textContent =
      '.disto-license-overlay{position:absolute;inset:0;z-index:9999;display:flex;align-items:center;justify-content:center;background:rgba(15,23,42,.85);backdrop-filter:blur(6px);}' +
      '.disto-license-modal{max-width:520px;width:90%;background:#ffffff;border-radius:18px;box-shadow:0 20px 45px rgba(15,23,42,.45);padding:28px 26px;direction:rtl;font-family:inherit;text-align:right;}' +
      '.disto-license-badge{display:inline-flex;align-items:center;gap:6px;padding:4px 10px;border-radius:999px;background:#f97316;position:relative;color:#fff;font-size:11px;font-weight:600;margin-bottom:10px;}' +
      '.disto-license-badge-dot{width:8px;height:8px;border-radius:999px;background:#fed7aa;box-shadow:0 0 0 6px rgba(248,250,252,.2);}' +
      '.disto-license-title{margin:0 0 8px;font-size:19px;font-weight:700;color:#0f172a;}' +
      '.disto-license-subtitle{margin:0 0 18px;font-size:13px;line-height:1.9;color:#475569;}' +
      '.disto-license-list{margin:0 0 18px;padding:0;list-style:none;font-size:12px;color:#4b5563;}' +
      '.disto-license-list li{margin-bottom:6px;padding-right:18px;position:relative;}' +
      '.disto-license-list li::before{content:"•";position:absolute;right:0;top:0;color:#0ea5e9;font-size:16px;line-height:1;}' +
      '.disto-license-actions{display:flex;flex-wrap:wrap;gap:10px;align-items:center;margin-top:4px;}' +
      '.disto-license-primary{border:0;border-radius:999px;padding:8px 18px;font-size:13px;font-weight:600;cursor:pointer;background:linear-gradient(135deg,#0ea5e9,#6366f1);color:#fff;display:inline-flex;align-items:center;gap:6px;}' +
      '.disto-license-primary:hover{opacity:.96;}' +
      '.disto-license-secondary{background:transparent;border:0;color:#64748b;font-size:12px;cursor:pointer;text-decoration:underline;text-underline-offset:3px;padding:0;}' +
      '.disto-license-hint{margin-top:10px;font-size:11px;color:#94a3b8;}' +
      '.disto-admin-shell{position:relative;}' +
      '@media (max-width:600px){.disto-license-modal{padding:22px 18px;border-radius:14px;}.disto-license-title{font-size:17px;}.disto-license-actions{flex-direction:column;align-items:stretch;}.disto-license-primary{justify-content:center;width:100%;}}';
    document.head.appendChild(style);
  }

  function distoLockDashboardIfLicenseInactive() {
    if (typeof window.DistoThemeSettings === 'undefined') return;
    var lic = window.DistoThemeSettings.license || null;
    if (!lic || lic.active) return;

    distoCreateLicenseStyles();

    var shell = root.querySelector('.disto-admin-shell');
    if (!shell) return;

    var overlay = document.createElement('div');
    overlay.className = 'disto-license-overlay';

    var modal = document.createElement('div');
    modal.className = 'disto-license-modal';
    modal.innerHTML =
      '<div class="disto-license-badge">' +
      '  <span class="disto-license-badge-dot"></span>' +
      '  <span>لایسنس فعال نشده</span>' +
      '</div>' +
      '<h2 class="disto-license-title">برای استفاده از تنظیمات حرفه‌ای، لایسنس دیستو را فعال کنید</h2>' +
      '<p class="disto-license-subtitle">این داشبورد برای خریداران قانونی قالب دیستو فعال است. برای ادامه، لطفاً لایسنس خرید خود را روی این دامنه فعال کنید.</p>' +
      '<ul class="disto-license-list">' +
      '  <li>نمایش کامل داشبورد تنظیمات قالب دیستو</li>' +
      '  <li>دسترسی به تنظیمات حرفه‌ای هدر، فوتر و بخش‌ها</li>' +
      '  <li>دریافت به‌روزرسانی‌ها و پشتیبانی رسمی</li>' +
      '</ul>' +
      '<div class="disto-license-actions">' +
      '  <button type="button" class="disto-license-primary" id="disto-license-go-activate">' +
      '    فعال‌سازی لایسنس' +
      '  </button>' +
      '  <button type="button" class="disto-license-secondary" id="disto-license-later">' +
      '    بعداً فعال می‌کنم (بازگشت به پیشخوان وردپرس)' +
      '  </button>' +
      '</div>' +
      '<div class="disto-license-hint">پس از فعال‌سازی لایسنس، دوباره به این صفحه برگردید تا تمام تنظیمات قالب در دسترس شما باشد.</div>';

    overlay.appendChild(modal);
    shell.appendChild(overlay);

    var activateBtn = modal.querySelector('#disto-license-go-activate');
    if (activateBtn) {
      activateBtn.addEventListener('click', function () {
        if (lic.activationUrl) {
          window.location.href = lic.activationUrl;
        } else if (window.ajaxurl) {
          window.location.href = window.ajaxurl.replace('admin-ajax.php', 'index.php');
        }
      });
    }

    var laterBtn = modal.querySelector('#disto-license-later');
    if (laterBtn) {
      laterBtn.addEventListener('click', function () {
        if (window.ajaxurl) {
          window.location.href = window.ajaxurl.replace('admin-ajax.php', 'index.php');
        }
      });
    }
  }

  // اگر لایسنس غیر فعال است، داشبورد را قفل و پاپ‌آپ را نشان بده
  distoLockDashboardIfLicenseInactive();
})();

