<?php
/**
 * 404 Page Template
 * If a custom 404 page is set in Customizer, displays that page (Elementor-supported).
 * Otherwise shows the default design.
 *
 * @package Disto_Child
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

$custom_404_page_id = function_exists( 'disto_child_get_custom_404_page_id' ) ? disto_child_get_custom_404_page_id() : 0;

if ( $custom_404_page_id ) {
	// نمایش محتوای برگهٔ سفارشی (طراحی Elementor)
	global $post;
	$post = get_post( $custom_404_page_id ); // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
	if ( $post ) {
		setup_postdata( $post );
		get_header();
		?>
		<section id="content_main" class="clearfix">
			<div class="container">
				<div class="row main_content">
					<div class="col-md-12">
						<?php the_content(); ?>
					</div>
				</div>
			</div>
		</section>
		<?php
		wp_reset_postdata();
		get_footer();
		exit;
	}
}

// طراحی پیش‌فرض
get_header();
?>

<section id="content_main" class="clearfix jl-404-section">
	<div class="container">
		<div class="row main_content">
			<div class="col-md-12">
				<div class="jl-404-wrap">
					<div class="jl-404-visual">
						<?php
						$custom_404_img = get_stylesheet_directory_uri() . '/assets/images/404.png';
						$custom_404_path = get_stylesheet_directory() . '/assets/images/404.png';
						if ( file_exists( $custom_404_path ) ) :
							?>
							<img src="<?php echo esc_url( $custom_404_img ); ?>" alt="<?php esc_attr_e( 'صفحه یافت نشد', 'disto' ); ?>" class="jl-404-img" loading="eager" width="320" height="240">
						<?php else : ?>
							<!-- تصویر پیش‌فرض SVG - ایرانی پسند -->
							<svg class="jl-404-svg" viewBox="0 0 400 280" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" role="img">
								<defs>
									<linearGradient id="jl404Grad" x1="0%" y1="0%" x2="100%" y2="100%">
										<stop offset="0%" style="stop-color:#e8d5b7"/>
										<stop offset="100%" style="stop-color:#d4a574"/>
									</linearGradient>
									<linearGradient id="jl404Sky" x1="0%" y1="0%" x2="0%" y2="100%">
										<stop offset="0%" style="stop-color:#f5f0e8"/>
										<stop offset="100%" style="stop-color:#ebe4d8"/>
									</linearGradient>
								</defs>
								<rect width="400" height="280" fill="url(#jl404Sky)"/>
								<!-- نقش‌ونگار / گلدان ساده -->
								<ellipse cx="200" cy="220" rx="100" ry="18" fill="url(#jl404Grad)" opacity="0.9"/>
								<path d="M140 220 L140 140 Q200 100 260 140 L260 220 Z" fill="url(#jl404Grad)" stroke="#c49a6c" stroke-width="2"/>
								<text x="200" y="175" text-anchor="middle" font-family="Tahoma, Arial, sans-serif" font-size="48" font-weight="bold" fill="#8b6914">۴۰۴</text>
								<!-- برگ/گل ساده -->
								<circle cx="200" cy="115" r="12" fill="#c49a6c"/>
								<path d="M200 95 Q185 85 175 95 Q185 105 200 115" fill="none" stroke="#8b6914" stroke-width="3" stroke-linecap="round"/>
								<path d="M200 95 Q215 85 225 95 Q215 105 200 115" fill="none" stroke="#8b6914" stroke-width="3" stroke-linecap="round"/>
							</svg>
						<?php endif; ?>
					</div>
					<h1 class="jl-404-title"><?php esc_html_e( 'اوپس! آدرس مورد نظر یافت نشد', 'disto' ); ?></h1>
					<p class="jl-404-desc"><?php esc_html_e( 'متأسفانه صفحه‌ای که به دنبال آن هستید وجود ندارد یا آدرس آن تغییر کرده است. می‌توانید از جستجو استفاده کنید یا به صفحهٔ اصلی بازگردید.', 'disto' ); ?></p>
					<div class="jl-404-actions">
						<a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="jl-404-btn jl-404-btn-primary"><?php esc_html_e( 'بازگشت به صفحهٔ نخست', 'disto' ); ?></a>
						<?php if ( function_exists( 'get_search_form' ) ) : ?>
							<button type="button" class="jl-404-btn jl-404-btn-secondary jl-404-toggle-search" aria-expanded="false"><?php esc_html_e( 'جستجو در سایت', 'disto' ); ?></button>
						<?php endif; ?>
					</div>
					<div class="jl-404-search-box" id="jl-404-search-box" hidden>
						<?php get_search_form(); ?>
					</div>
				</div>
			</div>
		</div>
	</div>
</section>

<?php if ( function_exists( 'get_search_form' ) ) : ?>
<script>
(function() {
	var btn = document.querySelector('.jl-404-toggle-search');
	var box = document.getElementById('jl-404-search-box');
	if (btn && box) {
		btn.addEventListener('click', function() {
			var open = !box.hidden;
			box.hidden = open;
			btn.setAttribute('aria-expanded', !open);
			if (!open) { box.querySelector('input[type="search"]') && box.querySelector('input[type="search"]').focus(); }
		});
	}
})();
</script>
<?php endif; ?>

<?php get_footer();
